/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_3_5.lang3.tuple;

import java.io.Serializable;
import macromedia.externals.org.apache.commons_3_5.lang3.ObjectUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.builder.CompareToBuilder;
import macromedia.externals.org.apache.commons_3_5.lang3.tuple.ImmutableTriple;

public abstract class Triple<L, M, R>
implements Serializable,
Comparable<Triple<L, M, R>> {
    private static final long serialVersionUID = 1L;

    public static <L, M, R> Triple<L, M, R> of(L l2, M m2, R r2) {
        return new ImmutableTriple(l2, m2, r2);
    }

    public abstract L getLeft();

    public abstract M getMiddle();

    public abstract R getRight();

    @Override
    public int compareTo(Triple<L, M, R> triple) {
        return new CompareToBuilder().append(this.getLeft(), triple.getLeft()).append(this.getMiddle(), triple.getMiddle()).append(this.getRight(), triple.getRight()).toComparison();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Triple) {
            Triple triple = (Triple)object;
            return ObjectUtils.equals((Object)this.getLeft(), (Object)triple.getLeft()) && ObjectUtils.equals((Object)this.getMiddle(), (Object)triple.getMiddle()) && ObjectUtils.equals((Object)this.getRight(), (Object)triple.getRight());
        }
        return false;
    }

    public int hashCode() {
        return (this.getLeft() == null ? 0 : this.getLeft().hashCode()) ^ (this.getMiddle() == null ? 0 : this.getMiddle().hashCode()) ^ (this.getRight() == null ? 0 : this.getRight().hashCode());
    }

    public String toString() {
        return "(" + this.getLeft() + "," + this.getMiddle() + "," + this.getRight() + ")";
    }

    public String toString(String string) {
        return String.format(string, this.getLeft(), this.getMiddle(), this.getRight());
    }
}

