/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_3_5.lang3.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import macromedia.externals.org.apache.commons_3_5.lang3.ArrayUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.text.StrBuilder;
import macromedia.externals.org.apache.commons_3_5.lang3.text.StrMatcher;

/*
 * Exception performing whole class analysis ignored.
 */
public class StrTokenizer
implements Cloneable,
ListIterator<String> {
    private static final StrTokenizer CSV_TOKENIZER_PROTOTYPE = new StrTokenizer();
    private static final StrTokenizer TSV_TOKENIZER_PROTOTYPE;
    private char[] chars;
    private String[] tokens;
    private int tokenPos;
    private StrMatcher delimMatcher = StrMatcher.splitMatcher();
    private StrMatcher quoteMatcher = StrMatcher.noneMatcher();
    private StrMatcher ignoredMatcher = StrMatcher.noneMatcher();
    private StrMatcher trimmerMatcher = StrMatcher.noneMatcher();
    private boolean emptyAsNull = false;
    private boolean ignoreEmptyTokens = true;

    private static StrTokenizer getCSVClone() {
        return (StrTokenizer)CSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StrTokenizer getCSVInstance() {
        return StrTokenizer.getCSVClone();
    }

    public static StrTokenizer getCSVInstance(String string) {
        StrTokenizer strTokenizer = StrTokenizer.getCSVClone();
        strTokenizer.reset(string);
        return strTokenizer;
    }

    public static StrTokenizer getCSVInstance(char[] cArray) {
        StrTokenizer strTokenizer = StrTokenizer.getCSVClone();
        strTokenizer.reset(cArray);
        return strTokenizer;
    }

    private static StrTokenizer getTSVClone() {
        return (StrTokenizer)TSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StrTokenizer getTSVInstance() {
        return StrTokenizer.getTSVClone();
    }

    public static StrTokenizer getTSVInstance(String string) {
        StrTokenizer strTokenizer = StrTokenizer.getTSVClone();
        strTokenizer.reset(string);
        return strTokenizer;
    }

    public static StrTokenizer getTSVInstance(char[] cArray) {
        StrTokenizer strTokenizer = StrTokenizer.getTSVClone();
        strTokenizer.reset(cArray);
        return strTokenizer;
    }

    public StrTokenizer() {
        this.chars = null;
    }

    public StrTokenizer(String string) {
        this.chars = (char[])(string != null ? string.toCharArray() : null);
    }

    public StrTokenizer(String string, char c2) {
        this(string);
        this.setDelimiterChar(c2);
    }

    public StrTokenizer(String string, String string2) {
        this(string);
        this.setDelimiterString(string2);
    }

    public StrTokenizer(String string, StrMatcher strMatcher) {
        this(string);
        this.setDelimiterMatcher(strMatcher);
    }

    public StrTokenizer(String string, char c2, char c3) {
        this(string, c2);
        this.setQuoteChar(c3);
    }

    public StrTokenizer(String string, StrMatcher strMatcher, StrMatcher strMatcher2) {
        this(string, strMatcher);
        this.setQuoteMatcher(strMatcher2);
    }

    public StrTokenizer(char[] cArray) {
        this.chars = ArrayUtils.clone((char[])cArray);
    }

    public StrTokenizer(char[] cArray, char c2) {
        this(cArray);
        this.setDelimiterChar(c2);
    }

    public StrTokenizer(char[] cArray, String string) {
        this(cArray);
        this.setDelimiterString(string);
    }

    public StrTokenizer(char[] cArray, StrMatcher strMatcher) {
        this(cArray);
        this.setDelimiterMatcher(strMatcher);
    }

    public StrTokenizer(char[] cArray, char c2, char c3) {
        this(cArray, c2);
        this.setQuoteChar(c3);
    }

    public StrTokenizer(char[] cArray, StrMatcher strMatcher, StrMatcher strMatcher2) {
        this(cArray, strMatcher);
        this.setQuoteMatcher(strMatcher2);
    }

    public int size() {
        this.checkTokenized();
        return this.tokens.length;
    }

    public String nextToken() {
        if (this.hasNext()) {
            return this.tokens[this.tokenPos++];
        }
        return null;
    }

    public String previousToken() {
        if (this.hasPrevious()) {
            return this.tokens[--this.tokenPos];
        }
        return null;
    }

    public String[] getTokenArray() {
        this.checkTokenized();
        return (String[])this.tokens.clone();
    }

    public List<String> getTokenList() {
        this.checkTokenized();
        ArrayList<String> arrayList = new ArrayList<String>(this.tokens.length);
        for (String string : this.tokens) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public StrTokenizer reset() {
        this.tokenPos = 0;
        this.tokens = null;
        return this;
    }

    public StrTokenizer reset(String string) {
        this.reset();
        this.chars = (char[])(string != null ? string.toCharArray() : null);
        return this;
    }

    public StrTokenizer reset(char[] cArray) {
        this.reset();
        this.chars = ArrayUtils.clone((char[])cArray);
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkTokenized();
        return this.tokenPos < this.tokens.length;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            return this.tokens[this.tokenPos++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.tokenPos;
    }

    @Override
    public boolean hasPrevious() {
        this.checkTokenized();
        return this.tokenPos > 0;
    }

    @Override
    public String previous() {
        if (this.hasPrevious()) {
            return this.tokens[--this.tokenPos];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previousIndex() {
        return this.tokenPos - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is unsupported");
    }

    @Override
    public void set(String string) {
        throw new UnsupportedOperationException("set() is unsupported");
    }

    @Override
    public void add(String string) {
        throw new UnsupportedOperationException("add() is unsupported");
    }

    private void checkTokenized() {
        if (this.tokens == null) {
            if (this.chars == null) {
                List list = this.tokenize(null, 0, 0);
                this.tokens = list.toArray(new String[list.size()]);
            } else {
                List list = this.tokenize(this.chars, 0, this.chars.length);
                this.tokens = list.toArray(new String[list.size()]);
            }
        }
    }

    protected List<String> tokenize(char[] cArray, int n2, int n3) {
        if (cArray == null || n3 == 0) {
            return Collections.emptyList();
        }
        StrBuilder strBuilder = new StrBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = n2;
        while (n4 >= 0 && n4 < n3) {
            if ((n4 = this.readNextToken(cArray, n4, n3, strBuilder, arrayList)) < n3) continue;
            this.addToken(arrayList, "");
        }
        return arrayList;
    }

    private void addToken(List<String> list, String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            if (this.isIgnoreEmptyTokens()) {
                return;
            }
            if (this.isEmptyTokenAsNull()) {
                string = null;
            }
        }
        list.add(string);
    }

    private int readNextToken(char[] cArray, int n2, int n3, StrBuilder strBuilder, List<String> list) {
        int n4;
        while (n2 < n3 && (n4 = Math.max(this.getIgnoredMatcher().isMatch(cArray, n2, n2, n3), this.getTrimmerMatcher().isMatch(cArray, n2, n2, n3))) != 0 && this.getDelimiterMatcher().isMatch(cArray, n2, n2, n3) <= 0 && this.getQuoteMatcher().isMatch(cArray, n2, n2, n3) <= 0) {
            n2 += n4;
        }
        if (n2 >= n3) {
            this.addToken(list, "");
            return -1;
        }
        n4 = this.getDelimiterMatcher().isMatch(cArray, n2, n2, n3);
        if (n4 > 0) {
            this.addToken(list, "");
            return n2 + n4;
        }
        int n5 = this.getQuoteMatcher().isMatch(cArray, n2, n2, n3);
        if (n5 > 0) {
            return this.readWithQuotes(cArray, n2 + n5, n3, strBuilder, list, n2, n5);
        }
        return this.readWithQuotes(cArray, n2, n3, strBuilder, list, 0, 0);
    }

    private int readWithQuotes(char[] cArray, int n2, int n3, StrBuilder strBuilder, List<String> list, int n4, int n5) {
        strBuilder.clear();
        int n6 = n2;
        boolean bl2 = n5 > 0;
        int n7 = 0;
        while (n6 < n3) {
            if (bl2) {
                if (this.isQuote(cArray, n6, n3, n4, n5)) {
                    if (this.isQuote(cArray, n6 + n5, n3, n4, n5)) {
                        strBuilder.append(cArray, n6, n5);
                        n6 += n5 * 2;
                        n7 = strBuilder.size();
                        continue;
                    }
                    bl2 = false;
                    n6 += n5;
                    continue;
                }
                strBuilder.append(cArray[n6++]);
                n7 = strBuilder.size();
                continue;
            }
            int n8 = this.getDelimiterMatcher().isMatch(cArray, n6, n2, n3);
            if (n8 > 0) {
                this.addToken(list, strBuilder.substring(0, n7));
                return n6 + n8;
            }
            if (n5 > 0 && this.isQuote(cArray, n6, n3, n4, n5)) {
                bl2 = true;
                n6 += n5;
                continue;
            }
            int n9 = this.getIgnoredMatcher().isMatch(cArray, n6, n2, n3);
            if (n9 > 0) {
                n6 += n9;
                continue;
            }
            int n10 = this.getTrimmerMatcher().isMatch(cArray, n6, n2, n3);
            if (n10 > 0) {
                strBuilder.append(cArray, n6, n10);
                n6 += n10;
                continue;
            }
            strBuilder.append(cArray[n6++]);
            n7 = strBuilder.size();
        }
        this.addToken(list, strBuilder.substring(0, n7));
        return -1;
    }

    private boolean isQuote(char[] cArray, int n2, int n3, int n4, int n5) {
        for (int i2 = 0; i2 < n5; ++i2) {
            if (n2 + i2 < n3 && cArray[n2 + i2] == cArray[n4 + i2]) continue;
            return false;
        }
        return true;
    }

    public StrMatcher getDelimiterMatcher() {
        return this.delimMatcher;
    }

    public StrTokenizer setDelimiterMatcher(StrMatcher strMatcher) {
        this.delimMatcher = strMatcher == null ? StrMatcher.noneMatcher() : strMatcher;
        return this;
    }

    public StrTokenizer setDelimiterChar(char c2) {
        return this.setDelimiterMatcher(StrMatcher.charMatcher((char)c2));
    }

    public StrTokenizer setDelimiterString(String string) {
        return this.setDelimiterMatcher(StrMatcher.stringMatcher((String)string));
    }

    public StrMatcher getQuoteMatcher() {
        return this.quoteMatcher;
    }

    public StrTokenizer setQuoteMatcher(StrMatcher strMatcher) {
        if (strMatcher != null) {
            this.quoteMatcher = strMatcher;
        }
        return this;
    }

    public StrTokenizer setQuoteChar(char c2) {
        return this.setQuoteMatcher(StrMatcher.charMatcher((char)c2));
    }

    public StrMatcher getIgnoredMatcher() {
        return this.ignoredMatcher;
    }

    public StrTokenizer setIgnoredMatcher(StrMatcher strMatcher) {
        if (strMatcher != null) {
            this.ignoredMatcher = strMatcher;
        }
        return this;
    }

    public StrTokenizer setIgnoredChar(char c2) {
        return this.setIgnoredMatcher(StrMatcher.charMatcher((char)c2));
    }

    public StrMatcher getTrimmerMatcher() {
        return this.trimmerMatcher;
    }

    public StrTokenizer setTrimmerMatcher(StrMatcher strMatcher) {
        if (strMatcher != null) {
            this.trimmerMatcher = strMatcher;
        }
        return this;
    }

    public boolean isEmptyTokenAsNull() {
        return this.emptyAsNull;
    }

    public StrTokenizer setEmptyTokenAsNull(boolean bl2) {
        this.emptyAsNull = bl2;
        return this;
    }

    public boolean isIgnoreEmptyTokens() {
        return this.ignoreEmptyTokens;
    }

    public StrTokenizer setIgnoreEmptyTokens(boolean bl2) {
        this.ignoreEmptyTokens = bl2;
        return this;
    }

    public String getContent() {
        if (this.chars == null) {
            return null;
        }
        return new String(this.chars);
    }

    public Object clone() {
        try {
            return this.cloneReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    Object cloneReset() throws CloneNotSupportedException {
        StrTokenizer strTokenizer = (StrTokenizer)super.clone();
        if (strTokenizer.chars != null) {
            strTokenizer.chars = (char[])strTokenizer.chars.clone();
        }
        strTokenizer.reset();
        return strTokenizer;
    }

    public String toString() {
        if (this.tokens == null) {
            return "StrTokenizer[not tokenized yet]";
        }
        return "StrTokenizer" + this.getTokenList();
    }

    static {
        CSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(StrMatcher.commaMatcher());
        CSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        CSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(StrMatcher.noneMatcher());
        CSV_TOKENIZER_PROTOTYPE.setTrimmerMatcher(StrMatcher.trimMatcher());
        CSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        CSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
        TSV_TOKENIZER_PROTOTYPE = new StrTokenizer();
        TSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(StrMatcher.tabMatcher());
        TSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        TSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(StrMatcher.noneMatcher());
        TSV_TOKENIZER_PROTOTYPE.setTrimmerMatcher(StrMatcher.trimMatcher());
        TSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        TSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
    }
}

