/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_3_5.lang3.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import macromedia.externals.org.apache.commons_3_5.lang3.ArrayUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.ClassUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.SystemUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExceptionUtils {
    static final String WRAPPED_MARKER = " [wrapped] ";
    private static final String[] CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};

    @Deprecated
    public static String[] getDefaultCauseMethodNames() {
        return (String[])ArrayUtils.clone((Object[])CAUSE_METHOD_NAMES);
    }

    @Deprecated
    public static Throwable getCause(Throwable throwable) {
        return ExceptionUtils.getCause((Throwable)throwable, null);
    }

    @Deprecated
    public static Throwable getCause(Throwable throwable, String[] stringArray) {
        if (throwable == null) {
            return null;
        }
        if (stringArray == null) {
            Throwable object = throwable.getCause();
            if (object != null) {
                return object;
            }
            stringArray = CAUSE_METHOD_NAMES;
        }
        for (String string : stringArray) {
            Throwable throwable2;
            if (string == null || (throwable2 = ExceptionUtils.getCauseUsingMethodName((Throwable)throwable, (String)string)) == null) continue;
            return throwable2;
        }
        return null;
    }

    public static Throwable getRootCause(Throwable throwable) {
        List list = ExceptionUtils.getThrowableList((Throwable)throwable);
        return list.size() < 2 ? null : (Throwable)list.get(list.size() - 1);
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String string) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getThrowableCount(Throwable throwable) {
        return ExceptionUtils.getThrowableList((Throwable)throwable).size();
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        List list = ExceptionUtils.getThrowableList((Throwable)throwable);
        return list.toArray(new Throwable[list.size()]);
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        while (throwable != null && !arrayList.contains(throwable)) {
            arrayList.add(throwable);
            throwable = ExceptionUtils.getCause((Throwable)throwable);
        }
        return arrayList;
    }

    public static int indexOfThrowable(Throwable throwable, Class<?> clazz) {
        return ExceptionUtils.indexOf((Throwable)throwable, clazz, (int)0, (boolean)false);
    }

    public static int indexOfThrowable(Throwable throwable, Class<?> clazz, int n2) {
        return ExceptionUtils.indexOf((Throwable)throwable, clazz, (int)n2, (boolean)false);
    }

    public static int indexOfType(Throwable throwable, Class<?> clazz) {
        return ExceptionUtils.indexOf((Throwable)throwable, clazz, (int)0, (boolean)true);
    }

    public static int indexOfType(Throwable throwable, Class<?> clazz, int n2) {
        return ExceptionUtils.indexOf((Throwable)throwable, clazz, (int)n2, (boolean)true);
    }

    private static int indexOf(Throwable throwable, Class<?> clazz, int n2, boolean bl2) {
        Throwable[] throwableArray;
        if (throwable == null || clazz == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= (throwableArray = ExceptionUtils.getThrowables((Throwable)throwable)).length) {
            return -1;
        }
        if (bl2) {
            for (int i2 = n2; i2 < throwableArray.length; ++i2) {
                if (!clazz.isAssignableFrom(throwableArray[i2].getClass())) continue;
                return i2;
            }
        } else {
            for (int i3 = n2; i3 < throwableArray.length; ++i3) {
                if (!clazz.equals(throwableArray[i3].getClass())) continue;
                return i3;
            }
        }
        return -1;
    }

    public static void printRootCauseStackTrace(Throwable throwable) {
        ExceptionUtils.printRootCauseStackTrace((Throwable)throwable, (PrintStream)System.err);
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintStream printStream) {
        String[] stringArray;
        if (throwable == null) {
            return;
        }
        if (printStream == null) {
            throw new IllegalArgumentException("The PrintStream must not be null");
        }
        for (String string : stringArray = ExceptionUtils.getRootCauseStackTrace((Throwable)throwable)) {
            printStream.println(string);
        }
        printStream.flush();
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintWriter printWriter) {
        String[] stringArray;
        if (throwable == null) {
            return;
        }
        if (printWriter == null) {
            throw new IllegalArgumentException("The PrintWriter must not be null");
        }
        for (String string : stringArray = ExceptionUtils.getRootCauseStackTrace((Throwable)throwable)) {
            printWriter.println(string);
        }
        printWriter.flush();
    }

    public static String[] getRootCauseStackTrace(Throwable throwable) {
        if (throwable == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Throwable[] throwableArray = ExceptionUtils.getThrowables((Throwable)throwable);
        int n2 = throwableArray.length;
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = ExceptionUtils.getStackFrameList((Throwable)throwableArray[n2 - 1]);
        int n3 = n2;
        while (--n3 >= 0) {
            List list2 = list;
            if (n3 != 0) {
                list = ExceptionUtils.getStackFrameList((Throwable)throwableArray[n3 - 1]);
                ExceptionUtils.removeCommonFrames((List)list2, (List)list);
            }
            if (n3 == n2 - 1) {
                arrayList.add(throwableArray[n3].toString());
            } else {
                arrayList.add(" [wrapped] " + throwableArray[n3].toString());
            }
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                arrayList.add((String)list2.get(i2));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void removeCommonFrames(List<String> list, List<String> list2) {
        if (list == null || list2 == null) {
            throw new IllegalArgumentException("The List must not be null");
        }
        int n2 = list.size() - 1;
        for (int i2 = list2.size() - 1; n2 >= 0 && i2 >= 0; --n2, --i2) {
            String string;
            String string2 = list.get(n2);
            if (!string2.equals(string = list2.get(i2))) continue;
            list.remove(n2);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    public static String[] getStackFrames(Throwable throwable) {
        if (throwable == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return ExceptionUtils.getStackFrames((String)ExceptionUtils.getStackTrace((Throwable)throwable));
    }

    static String[] getStackFrames(String string) {
        String string2 = SystemUtils.LINE_SEPARATOR;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static List<String> getStackFrameList(Throwable throwable) {
        String string = ExceptionUtils.getStackTrace((Throwable)throwable);
        String string2 = SystemUtils.LINE_SEPARATOR;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n2 = string3.indexOf("at");
            if (n2 != -1 && string3.substring(0, n2).trim().isEmpty()) {
                bl2 = true;
                arrayList.add(string3);
                continue;
            }
            if (!bl2) continue;
            break;
        }
        return arrayList;
    }

    public static String getMessage(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        String string = ClassUtils.getShortClassName((Object)throwable, null);
        String string2 = throwable.getMessage();
        return string + ": " + StringUtils.defaultString((String)string2);
    }

    public static String getRootCauseMessage(Throwable throwable) {
        Throwable throwable2 = ExceptionUtils.getRootCause((Throwable)throwable);
        throwable2 = throwable2 == null ? throwable : throwable2;
        return ExceptionUtils.getMessage((Throwable)throwable2);
    }

    public static <R> R rethrow(Throwable throwable) {
        return (R)ExceptionUtils.typeErasure((Throwable)throwable);
    }

    private static <R, T extends Throwable> R typeErasure(Throwable throwable) throws T {
        throw throwable;
    }

    public static <R> R wrapAndThrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable);
    }

    public static boolean hasCause(Throwable throwable, Class<? extends Throwable> clazz) {
        if (throwable instanceof UndeclaredThrowableException) {
            throwable = throwable.getCause();
        }
        return clazz.isInstance(throwable);
    }
}

