/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_3_5.lang3.concurrent;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import macromedia.externals.org.apache.commons_3_5.lang3.Validate;
import macromedia.externals.org.apache.commons_3_5.lang3.concurrent.ConcurrentException;
import macromedia.externals.org.apache.commons_3_5.lang3.concurrent.ConcurrentInitializer;
import macromedia.externals.org.apache.commons_3_5.lang3.concurrent.ConcurrentRuntimeException;
import macromedia.externals.org.apache.commons_3_5.lang3.concurrent.ConcurrentUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConcurrentUtils {
    private ConcurrentUtils() {
    }

    public static ConcurrentException extractCause(ExecutionException executionException) {
        if (executionException == null || executionException.getCause() == null) {
            return null;
        }
        ConcurrentUtils.throwCause((ExecutionException)executionException);
        return new ConcurrentException(executionException.getMessage(), executionException.getCause());
    }

    public static ConcurrentRuntimeException extractCauseUnchecked(ExecutionException executionException) {
        if (executionException == null || executionException.getCause() == null) {
            return null;
        }
        ConcurrentUtils.throwCause((ExecutionException)executionException);
        return new ConcurrentRuntimeException(executionException.getMessage(), executionException.getCause());
    }

    public static void handleCause(ExecutionException executionException) throws ConcurrentException {
        ConcurrentException concurrentException = ConcurrentUtils.extractCause((ExecutionException)executionException);
        if (concurrentException != null) {
            throw concurrentException;
        }
    }

    public static void handleCauseUnchecked(ExecutionException executionException) {
        ConcurrentRuntimeException concurrentRuntimeException = ConcurrentUtils.extractCauseUnchecked((ExecutionException)executionException);
        if (concurrentRuntimeException != null) {
            throw concurrentRuntimeException;
        }
    }

    static Throwable checkedException(Throwable throwable) {
        Validate.isTrue((throwable != null && !(throwable instanceof RuntimeException) && !(throwable instanceof Error) ? 1 : 0) != 0, (String)("Not a checked exception: " + throwable), (Object[])new Object[0]);
        return throwable;
    }

    private static void throwCause(ExecutionException executionException) {
        if (executionException.getCause() instanceof RuntimeException) {
            throw (RuntimeException)executionException.getCause();
        }
        if (executionException.getCause() instanceof Error) {
            throw (Error)executionException.getCause();
        }
    }

    public static <T> T initialize(ConcurrentInitializer<T> concurrentInitializer) throws ConcurrentException {
        return (T)(concurrentInitializer != null ? concurrentInitializer.get() : null);
    }

    public static <T> T initializeUnchecked(ConcurrentInitializer<T> concurrentInitializer) {
        try {
            return (T)ConcurrentUtils.initialize(concurrentInitializer);
        }
        catch (ConcurrentException concurrentException) {
            throw new ConcurrentRuntimeException(concurrentException.getCause());
        }
    }

    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> concurrentMap, K k2, V v2) {
        if (concurrentMap == null) {
            return null;
        }
        V v3 = concurrentMap.putIfAbsent(k2, v2);
        return v3 != null ? v3 : v2;
    }

    public static <K, V> V createIfAbsent(ConcurrentMap<K, V> concurrentMap, K k2, ConcurrentInitializer<V> concurrentInitializer) throws ConcurrentException {
        if (concurrentMap == null || concurrentInitializer == null) {
            return null;
        }
        Object v2 = concurrentMap.get(k2);
        if (v2 == null) {
            return (V)ConcurrentUtils.putIfAbsent(concurrentMap, k2, (Object)concurrentInitializer.get());
        }
        return v2;
    }

    public static <K, V> V createIfAbsentUnchecked(ConcurrentMap<K, V> concurrentMap, K k2, ConcurrentInitializer<V> concurrentInitializer) {
        try {
            return (V)ConcurrentUtils.createIfAbsent(concurrentMap, k2, concurrentInitializer);
        }
        catch (ConcurrentException concurrentException) {
            throw new ConcurrentRuntimeException(concurrentException.getCause());
        }
    }

    public static <T> Future<T> constantFuture(T t2) {
        return new ConstantFuture(t2);
    }
}

