/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_3_5.lang3.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import macromedia.externals.org.apache.commons_3_5.lang3.concurrent.BackgroundInitializer;
import macromedia.externals.org.apache.commons_3_5.lang3.concurrent.ConcurrentException;
import macromedia.externals.org.apache.commons_3_5.lang3.concurrent.ConcurrentInitializer;
import macromedia.externals.org.apache.commons_3_5.lang3.concurrent.ConcurrentUtils;

public abstract class BackgroundInitializer<T>
implements ConcurrentInitializer<T> {
    private ExecutorService externalExecutor;
    private ExecutorService executor;
    private Future<T> future;

    protected BackgroundInitializer() {
        this(null);
    }

    protected BackgroundInitializer(ExecutorService executorService) {
        this.setExternalExecutor(executorService);
    }

    public final synchronized ExecutorService getExternalExecutor() {
        return this.externalExecutor;
    }

    public synchronized boolean isStarted() {
        return this.future != null;
    }

    public final synchronized void setExternalExecutor(ExecutorService executorService) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot set ExecutorService after start()!");
        }
        this.externalExecutor = executorService;
    }

    public synchronized boolean start() {
        if (!this.isStarted()) {
            ExecutorService executorService;
            this.executor = this.getExternalExecutor();
            if (this.executor == null) {
                this.executor = executorService = this.createExecutor();
            } else {
                executorService = null;
            }
            this.future = this.executor.submit(this.createTask(executorService));
            return true;
        }
        return false;
    }

    public T get() throws ConcurrentException {
        try {
            return (T)this.getFuture().get();
        }
        catch (ExecutionException executionException) {
            ConcurrentUtils.handleCause((ExecutionException)executionException);
            return null;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new ConcurrentException((Throwable)interruptedException);
        }
    }

    public synchronized Future<T> getFuture() {
        if (this.future == null) {
            throw new IllegalStateException("start() must be called first!");
        }
        return this.future;
    }

    protected final synchronized ExecutorService getActiveExecutor() {
        return this.executor;
    }

    protected int getTaskCount() {
        return 1;
    }

    protected abstract T initialize() throws Exception;

    private Callable<T> createTask(ExecutorService executorService) {
        return new InitializationTask(this, executorService);
    }

    private ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(this.getTaskCount());
    }
}

