/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.apache.commons_1_10.codec.language.bm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import macromedia.externals.org.apache.commons_1_10.codec.language.bm.Lang;
import macromedia.externals.org.apache.commons_1_10.codec.language.bm.Languages;
import macromedia.externals.org.apache.commons_1_10.codec.language.bm.NameType;
import macromedia.externals.org.apache.commons_1_10.codec.language.bm.PhoneticEngine;
import macromedia.externals.org.apache.commons_1_10.codec.language.bm.Rule;
import macromedia.externals.org.apache.commons_1_10.codec.language.bm.RuleType;

/*
 * Exception performing whole class analysis ignored.
 */
public class PhoneticEngine {
    private static final Map<NameType, Set<String>> NAME_PREFIXES = new EnumMap(NameType.class);
    private static final int DEFAULT_MAX_PHONEMES = 20;
    private final Lang lang;
    private final NameType nameType;
    private final RuleType ruleType;
    private final boolean concat;
    private final int maxPhonemes;

    private static String join(Iterable<String> iterable, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuilder.append(string).append(iterator.next());
        }
        return stringBuilder.toString();
    }

    public PhoneticEngine(NameType nameType, RuleType ruleType, boolean bl2) {
        this(nameType, ruleType, bl2, 20);
    }

    public PhoneticEngine(NameType nameType, RuleType ruleType, boolean bl2, int n2) {
        if (ruleType == RuleType.RULES) {
            throw new IllegalArgumentException("ruleType must not be " + RuleType.RULES);
        }
        this.nameType = nameType;
        this.ruleType = ruleType;
        this.concat = bl2;
        this.lang = Lang.instance((NameType)nameType);
        this.maxPhonemes = n2;
    }

    private PhonemeBuilder applyFinalRules(PhonemeBuilder phonemeBuilder, Map<String, List<Rule>> map) {
        if (map == null) {
            throw new NullPointerException("finalRules can not be null");
        }
        if (map.isEmpty()) {
            return phonemeBuilder;
        }
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(Rule.Phoneme.COMPARATOR);
        for (Rule.Phoneme phoneme : phonemeBuilder.getPhonemes()) {
            PhonemeBuilder phonemeBuilder2 = PhonemeBuilder.empty((Languages.LanguageSet)phoneme.getLanguages());
            String string = phoneme.getPhonemeText().toString();
            int n2 = 0;
            while (n2 < string.length()) {
                RulesApplication rulesApplication = new RulesApplication(map, (CharSequence)string, phonemeBuilder2, n2, this.maxPhonemes).invoke();
                boolean bl2 = rulesApplication.isFound();
                phonemeBuilder2 = rulesApplication.getPhonemeBuilder();
                if (!bl2) {
                    phonemeBuilder2.append(string.subSequence(n2, n2 + 1));
                }
                n2 = rulesApplication.getI();
            }
            for (RulesApplication rulesApplication : phonemeBuilder2.getPhonemes()) {
                if (treeMap.containsKey(rulesApplication)) {
                    Rule.Phoneme phoneme2 = (Rule.Phoneme)treeMap.remove(rulesApplication);
                    Rule.Phoneme phoneme3 = phoneme2.mergeWithLanguage(rulesApplication.getLanguages());
                    treeMap.put(phoneme3, phoneme3);
                    continue;
                }
                treeMap.put(rulesApplication, rulesApplication);
            }
        }
        return new PhonemeBuilder(treeMap.keySet(), null);
    }

    public String encode(String string) {
        Languages.LanguageSet languageSet = this.lang.guessLanguages(string);
        return this.encode(string, languageSet);
    }

    public String encode(String string, Languages.LanguageSet languageSet) {
        RulesApplication rulesApplication;
        Object object;
        Object object2;
        Object object32;
        Map map = Rule.getInstanceMap((NameType)this.nameType, (RuleType)RuleType.RULES, (Languages.LanguageSet)languageSet);
        Map map2 = Rule.getInstanceMap((NameType)this.nameType, (RuleType)this.ruleType, (String)"common");
        Map map3 = Rule.getInstanceMap((NameType)this.nameType, (RuleType)this.ruleType, (Languages.LanguageSet)languageSet);
        string = string.toLowerCase(Locale.ENGLISH).replace('-', ' ').trim();
        if (this.nameType == NameType.GENERIC) {
            if (string.length() >= 2 && string.substring(0, 2).equals("d'")) {
                String string2 = string.substring(2);
                String string3 = "d" + string2;
                return "(" + this.encode(string2) + ")-(" + this.encode(string3) + ")";
            }
            for (Object object32 : (Set)NAME_PREFIXES.get(this.nameType)) {
                if (!string.startsWith((String)object32 + " ")) continue;
                String string4 = string.substring(((String)object32).length() + 1);
                String string5 = (String)object32 + string4;
                return "(" + this.encode(string4) + ")-(" + this.encode(string5) + ")";
            }
        }
        List<String> list = Arrays.asList(string.split("\\s+"));
        object32 = new ArrayList();
        switch (1.$SwitchMap$org$apache$commons$codec$language$bm$NameType[this.nameType.ordinal()]) {
            case 1: {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    rulesApplication = ((String)object).split("'");
                    String string6 = rulesApplication[((String[])rulesApplication).length - 1];
                    object32.add(string6);
                }
                object32.removeAll((Collection)NAME_PREFIXES.get(this.nameType));
                break;
            }
            case 2: {
                object32.addAll(list);
                object32.removeAll((Collection)NAME_PREFIXES.get(this.nameType));
                break;
            }
            case 3: {
                object32.addAll(list);
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable case: " + this.nameType);
            }
        }
        if (this.concat) {
            string = PhoneticEngine.join((Iterable)object32, (String)" ");
        } else if (object32.size() == 1) {
            string = (String)list.iterator().next();
        } else {
            object2 = new StringBuilder();
            object = object32.iterator();
            while (object.hasNext()) {
                rulesApplication = (String)object.next();
                ((StringBuilder)object2).append("-").append(this.encode((String)rulesApplication));
            }
            return ((StringBuilder)object2).substring(1);
        }
        object2 = PhonemeBuilder.empty((Languages.LanguageSet)languageSet);
        int n2 = 0;
        while (n2 < string.length()) {
            rulesApplication = new RulesApplication(map, (CharSequence)string, (PhonemeBuilder)object2, n2, this.maxPhonemes).invoke();
            n2 = rulesApplication.getI();
            object2 = rulesApplication.getPhonemeBuilder();
        }
        object2 = this.applyFinalRules((PhonemeBuilder)object2, map2);
        object2 = this.applyFinalRules((PhonemeBuilder)object2, map3);
        return object2.makeString();
    }

    public Lang getLang() {
        return this.lang;
    }

    public NameType getNameType() {
        return this.nameType;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public boolean isConcat() {
        return this.concat;
    }

    public int getMaxPhonemes() {
        return this.maxPhonemes;
    }

    static {
        NAME_PREFIXES.put(NameType.ASHKENAZI, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("bar", "ben", "da", "de", "van", "von"))));
        NAME_PREFIXES.put(NameType.SEPHARDIC, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("al", "el", "da", "dal", "de", "del", "dela", "de la", "della", "des", "di", "do", "dos", "du", "van", "von"))));
        NAME_PREFIXES.put(NameType.GENERIC, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("da", "dal", "de", "del", "dela", "de la", "della", "des", "di", "do", "dos", "du", "van", "von"))));
    }
}

