/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.net.minidev.json_1_3_1.parser;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import macromedia.externals.net.minidev.json_1_3_1.parser.ContainerFactory;
import macromedia.externals.net.minidev.json_1_3_1.parser.ContentHandler;
import macromedia.externals.net.minidev.json_1_3_1.parser.JSONParserBase;
import macromedia.externals.net.minidev.json_1_3_1.parser.ParseException;

abstract class JSONParserBase {
    protected char c;
    public static final byte EOI = 26;
    protected static final char MAX_STOP = '~';
    protected static boolean[] stopAll = new boolean[126];
    protected static boolean[] stopArray = new boolean[126];
    protected static boolean[] stopKey = new boolean[126];
    protected static boolean[] stopValue = new boolean[126];
    protected static boolean[] stopX = new boolean[126];
    protected ContainerFactory containerFactory;
    protected ContentHandler handler;
    protected final MSB sb = new MSB(15);
    protected Object xo;
    protected String xs;
    protected int pos;
    protected final boolean acceptLeadinZero;
    protected final boolean acceptNaN;
    protected final boolean acceptNonQuote;
    protected final boolean acceptSimpleQuote;
    protected final boolean acceptUselessComma;
    protected final boolean checkTaillingData;
    protected final boolean checkTaillingSpace;
    protected final boolean ignoreControlChar;
    protected final boolean useHiPrecisionFloat;
    protected final boolean useIntegerStorage;

    public JSONParserBase(int n2) {
        this.acceptNaN = (n2 & 4) > 0;
        this.acceptNonQuote = (n2 & 2) > 0;
        this.acceptSimpleQuote = (n2 & 1) > 0;
        this.ignoreControlChar = (n2 & 8) > 0;
        this.useIntegerStorage = (n2 & 0x10) > 0;
        this.acceptLeadinZero = (n2 & 0x20) > 0;
        this.acceptUselessComma = (n2 & 0x40) > 0;
        this.useHiPrecisionFloat = (n2 & 0x80) > 0;
        this.checkTaillingData = (n2 & 0x300) == 0;
        this.checkTaillingSpace = (n2 & 0x200) == 0;
    }

    public void checkControleChar() throws ParseException {
        if (this.ignoreControlChar) {
            return;
        }
        int n2 = this.xs.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = this.xs.charAt(i2);
            if (c2 < '\u0000') continue;
            if (c2 <= '\u001f') {
                throw new ParseException(this.pos + i2, 0, (Object)Character.valueOf(c2));
            }
            if (c2 != '\u007f') continue;
            throw new ParseException(this.pos + i2, 0, (Object)Character.valueOf(c2));
        }
    }

    public void checkLeadinZero() throws ParseException {
        int n2 = this.xs.length();
        if (n2 == 1) {
            return;
        }
        if (n2 == 2) {
            if (this.xs.equals("00")) {
                throw new ParseException(this.pos, 6, (Object)this.xs);
            }
            return;
        }
        char c2 = this.xs.charAt(0);
        char c3 = this.xs.charAt(1);
        if (c2 == '-') {
            char c4 = this.xs.charAt(2);
            if (c3 == '0' && c4 >= '0' && c4 <= '9') {
                throw new ParseException(this.pos, 6, (Object)this.xs);
            }
            return;
        }
        if (c2 == '0' && c3 >= '0' && c3 <= '9') {
            throw new ParseException(this.pos, 6, (Object)this.xs);
        }
    }

    protected Number extractFloat() throws ParseException {
        if (!this.acceptLeadinZero) {
            this.checkLeadinZero();
        }
        if (!this.useHiPrecisionFloat) {
            return Float.valueOf(Float.parseFloat(this.xs));
        }
        if (this.xs.length() > 18) {
            return new BigDecimal(this.xs);
        }
        return Double.parseDouble(this.xs);
    }

    protected Object parse(ContainerFactory containerFactory, ContentHandler contentHandler) throws ParseException {
        Object object;
        this.containerFactory = containerFactory;
        this.handler = contentHandler;
        try {
            this.read();
            contentHandler.startJSON();
            object = this.readMain(stopX);
            contentHandler.endJSON();
            if (this.checkTaillingData) {
                if (!this.checkTaillingSpace) {
                    this.skipSpace();
                }
                if (this.c != '\u001a') {
                    throw new ParseException(this.pos - 1, 1, (Object)Character.valueOf(this.c));
                }
            }
        }
        catch (IOException iOException) {
            throw new ParseException(this.pos, (Throwable)iOException);
        }
        this.xs = null;
        this.xo = null;
        return object;
    }

    protected Number parseNumber(String string) throws ParseException {
        boolean bl2;
        boolean bl3;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 19;
        if (string.charAt(0) == '-') {
            ++n2;
            ++n4;
            bl3 = true;
            if (!this.acceptLeadinZero && n3 >= 3 && string.charAt(1) == '0') {
                throw new ParseException(this.pos, 6, (Object)string);
            }
        } else {
            bl3 = false;
            if (!this.acceptLeadinZero && n3 >= 2 && string.charAt(0) == '0') {
                throw new ParseException(this.pos, 6, (Object)string);
            }
        }
        if (n3 < n4) {
            n4 = n3;
            bl2 = false;
        } else {
            if (n3 > n4) {
                return new BigInteger(string, 10);
            }
            n4 = n3 - 1;
            bl2 = true;
        }
        long l2 = 0L;
        while (n2 < n4) {
            l2 = l2 * 10L + (long)(48 - string.charAt(n2++));
        }
        if (bl2) {
            boolean bl4;
            if (l2 > -922337203685477580L) {
                bl4 = false;
            } else if (l2 < -922337203685477580L) {
                bl4 = true;
            } else if (bl3) {
                bl4 = string.charAt(n2) > '8';
            } else {
                boolean bl5 = bl4 = string.charAt(n2) > '7';
            }
            if (bl4) {
                return new BigInteger(string, 10);
            }
            l2 = l2 * 10L + (long)(48 - string.charAt(n2));
        }
        if (bl3) {
            if (this.useIntegerStorage && l2 >= Integer.MIN_VALUE) {
                return (int)l2;
            }
            return l2;
        }
        l2 = -l2;
        if (this.useIntegerStorage && l2 <= Integer.MAX_VALUE) {
            return (int)l2;
        }
        return l2;
    }

    protected abstract void read() throws IOException;

    protected List<Object> readArray() throws ParseException, IOException {
        List list = this.containerFactory.createArrayContainer();
        if (this.c != '[') {
            throw new RuntimeException("Internal Error");
        }
        this.read();
        boolean bl2 = false;
        this.handler.startArray();
        block7: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block7;
                }
                case ']': {
                    if (bl2 && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, (Object)Character.valueOf(this.c));
                    }
                    this.read();
                    this.handler.endArray();
                    return list;
                }
                case ':': 
                case '}': {
                    throw new ParseException(this.pos, 0, (Object)Character.valueOf(this.c));
                }
                case ',': {
                    if (bl2 && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, (Object)Character.valueOf(this.c));
                    }
                    this.read();
                    bl2 = true;
                    continue block7;
                }
                case '\u001a': {
                    throw new ParseException(this.pos - 1, 3, (Object)"EOF");
                }
            }
            list.add(this.readMain(stopArray));
            bl2 = false;
        }
    }

    protected Object readMain(boolean[] blArray) throws ParseException, IOException {
        block12: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block12;
                }
                case ':': 
                case ']': 
                case '}': {
                    throw new ParseException(this.pos, 0, (Object)Character.valueOf(this.c));
                }
                case '{': {
                    return this.readObject();
                }
                case '[': {
                    return this.readArray();
                }
                case '\"': 
                case '\'': {
                    this.readString();
                    this.handler.primitive((Object)this.xs);
                    return this.xs;
                }
                case 'n': {
                    this.readNQString(blArray);
                    if ("null".equals(this.xs)) {
                        this.handler.primitive(null);
                        return null;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, (Object)this.xs);
                    }
                    this.handler.primitive((Object)this.xs);
                    return this.xs;
                }
                case 'f': {
                    this.readNQString(blArray);
                    if ("false".equals(this.xs)) {
                        this.handler.primitive((Object)Boolean.FALSE);
                        return Boolean.FALSE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, (Object)this.xs);
                    }
                    this.handler.primitive((Object)this.xs);
                    return this.xs;
                }
                case 't': {
                    this.readNQString(blArray);
                    if ("true".equals(this.xs)) {
                        this.handler.primitive((Object)Boolean.TRUE);
                        return Boolean.TRUE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, (Object)this.xs);
                    }
                    this.handler.primitive((Object)this.xs);
                    return this.xs;
                }
                case 'N': {
                    this.readNQString(blArray);
                    if (!this.acceptNaN) {
                        throw new ParseException(this.pos, 1, (Object)this.xs);
                    }
                    if ("NaN".equals(this.xs)) {
                        this.handler.primitive((Object)Float.valueOf(Float.NaN));
                        return Float.valueOf(Float.NaN);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, (Object)this.xs);
                    }
                    this.handler.primitive((Object)this.xs);
                    return this.xs;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.xo = this.readNumber(blArray);
                    this.handler.primitive(this.xo);
                    return this.xo;
                }
            }
            break;
        }
        this.readNQString(blArray);
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, (Object)this.xs);
        }
        this.handler.primitive((Object)this.xs);
        return this.xs;
    }

    protected abstract void readNoEnd() throws ParseException, IOException;

    protected abstract void readNQString(boolean[] var1) throws IOException;

    protected abstract Object readNumber(boolean[] var1) throws ParseException, IOException;

    protected Map<String, Object> readObject() throws ParseException, IOException {
        Map map = this.containerFactory.createObjectContainer();
        if (this.c != '{') {
            throw new RuntimeException("Internal Error");
        }
        this.handler.startObject();
        boolean bl2 = false;
        boolean bl3 = true;
        block6: while (true) {
            this.read();
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block6;
                }
                case ':': 
                case '[': 
                case ']': 
                case '{': {
                    throw new ParseException(this.pos, 0, (Object)Character.valueOf(this.c));
                }
                case '}': {
                    if (bl2 && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, (Object)Character.valueOf(this.c));
                    }
                    this.read();
                    this.handler.endObject();
                    return map;
                }
                case ',': {
                    if (bl2 && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, (Object)Character.valueOf(this.c));
                    }
                    bl2 = true;
                    bl3 = true;
                    continue block6;
                }
            }
            int n2 = this.pos;
            if (this.c == '\"' || this.c == '\'') {
                this.readString();
            } else {
                this.readNQString(stopKey);
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, (Object)this.xs);
                }
            }
            String string = this.xs;
            if (!bl3) {
                throw new ParseException(this.pos, 1, (Object)string);
            }
            this.handler.startObjectEntry(string);
            this.skipSpace();
            if (this.c != ':') {
                if (this.c == '\u001a') {
                    throw new ParseException(this.pos - 1, 3, null);
                }
                throw new ParseException(this.pos - 1, 0, (Object)Character.valueOf(this.c));
            }
            this.readNoEnd();
            Object object = map.put(string, this.readMain(stopValue));
            if (object != null) {
                throw new ParseException(n2, 5, (Object)string);
            }
            this.handler.endObjectEntry();
            if (this.c == '}') {
                this.read();
                this.handler.endObject();
                return map;
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos - 1, 3, null);
            }
            if (this.c == ',') {
                bl2 = true;
                bl3 = true;
                continue;
            }
            bl2 = false;
            bl3 = false;
        }
    }

    abstract void readS() throws IOException;

    protected abstract void readString() throws ParseException, IOException;

    protected void readString2() throws ParseException, IOException {
        char c2 = this.c;
        block19: while (true) {
            this.read();
            switch (this.c) {
                case '\u001a': {
                    throw new ParseException(this.pos - 1, 3, null);
                }
                case '\"': 
                case '\'': {
                    if (c2 == this.c) {
                        this.read();
                        this.xs = this.sb.toString();
                        return;
                    }
                    this.sb.append(this.c);
                    continue block19;
                }
                case '\\': {
                    this.read();
                    switch (this.c) {
                        case 't': {
                            this.sb.append('\t');
                            break;
                        }
                        case 'n': {
                            this.sb.append('\n');
                            break;
                        }
                        case 'r': {
                            this.sb.append('\r');
                            break;
                        }
                        case 'f': {
                            this.sb.append('\f');
                            break;
                        }
                        case 'b': {
                            this.sb.append('\b');
                            break;
                        }
                        case '\\': {
                            this.sb.append('\\');
                            break;
                        }
                        case '/': {
                            this.sb.append('/');
                            break;
                        }
                        case '\'': {
                            this.sb.append('\'');
                            break;
                        }
                        case '\"': {
                            this.sb.append('\"');
                            break;
                        }
                        case 'u': {
                            this.sb.append(this.readUnicode(4));
                            break;
                        }
                        case 'x': {
                            this.sb.append(this.readUnicode(2));
                        }
                    }
                    continue block19;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    if (this.ignoreControlChar) continue block19;
                    throw new ParseException(this.pos, 0, (Object)Character.valueOf(this.c));
                }
            }
            this.sb.append(this.c);
        }
    }

    protected char readUnicode(int n2) throws ParseException, IOException {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 *= 16;
            this.read();
            if (this.c <= '9' && this.c >= '0') {
                n3 += this.c - 48;
                continue;
            }
            if (this.c <= 'F' && this.c >= 'A') {
                n3 += this.c - 65 + 10;
                continue;
            }
            if (this.c >= 'a' && this.c <= 'f') {
                n3 += this.c - 97 + 10;
                continue;
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos, 3, (Object)"EOF");
            }
            throw new ParseException(this.pos, 4, (Object)Character.valueOf(this.c));
        }
        return (char)n3;
    }

    protected void skipDigits() throws IOException {
        while (this.c >= '0' && this.c <= '9') {
            this.readS();
        }
        return;
    }

    protected void skipNQString(boolean[] blArray) throws IOException {
        while (!(this.c == '\u001a' || this.c >= '\u0000' && this.c < '~' && blArray[this.c])) {
            this.readS();
        }
        return;
    }

    protected void skipSpace() throws IOException {
        while (this.c <= ' ' && this.c != '\u001a') {
            this.readS();
        }
        return;
    }

    static {
        JSONParserBase.stopKey[26] = true;
        JSONParserBase.stopKey[58] = true;
        JSONParserBase.stopValue[26] = true;
        JSONParserBase.stopValue[125] = true;
        JSONParserBase.stopValue[44] = true;
        JSONParserBase.stopArray[26] = true;
        JSONParserBase.stopArray[93] = true;
        JSONParserBase.stopArray[44] = true;
        JSONParserBase.stopX[26] = true;
        JSONParserBase.stopAll[58] = true;
        JSONParserBase.stopAll[44] = true;
        JSONParserBase.stopAll[26] = true;
        JSONParserBase.stopAll[125] = true;
        JSONParserBase.stopAll[93] = true;
    }
}

