/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.net.minidev.json_1_3_1.parser;

import java.io.IOException;
import macromedia.externals.net.minidev.json_1_3_1.JSONStyle;
import macromedia.externals.net.minidev.json_1_3_1.JSONValue;
import macromedia.externals.net.minidev.json_1_3_1.parser.ContentHandler;
import macromedia.externals.net.minidev.json_1_3_1.parser.ParseException;

public class ContentHandlerCompressor
implements ContentHandler {
    Appendable out;
    JSONStyle compression;
    int[] stack = new int[10];
    int pos;

    private void push(int n2) {
        this.pos += 2;
        if (this.pos >= this.stack.length) {
            int[] nArray = new int[this.stack.length * 2];
            System.arraycopy(this.stack, 0, nArray, 0, this.stack.length);
            this.stack = nArray;
        }
        this.stack[this.pos] = n2;
        this.stack[this.pos + 1] = 0;
    }

    private boolean isInObject() {
        return this.stack[this.pos] == 0;
    }

    private boolean isInArray() {
        return this.stack[this.pos] == 1;
    }

    public ContentHandlerCompressor(Appendable appendable, JSONStyle jSONStyle) {
        this.out = appendable;
        this.compression = jSONStyle;
    }

    public void startJSON() throws ParseException, IOException {
    }

    public void endJSON() throws ParseException, IOException {
    }

    public boolean startObject() throws ParseException, IOException {
        if (this.isInArray()) {
            int n2 = this.pos + 1;
            int n3 = this.stack[n2];
            this.stack[n2] = n3 + 1;
            if (n3 > 0) {
                this.out.append(',');
            }
        }
        this.out.append('{');
        this.push(0);
        return false;
    }

    public boolean endObject() throws ParseException, IOException {
        this.out.append('}');
        this.pos -= 2;
        return false;
    }

    public boolean startObjectEntry(String string) throws ParseException, IOException {
        int n2 = this.pos + 1;
        int n3 = this.stack[n2];
        this.stack[n2] = n3 + 1;
        if (n3 > 0) {
            this.out.append(',');
        }
        if (string == null) {
            this.out.append("null");
        } else if (!this.compression.mustProtectKey(string)) {
            this.out.append(string);
        } else {
            this.out.append('\"');
            JSONValue.escape((String)string, (Appendable)this.out, (JSONStyle)this.compression);
            this.out.append('\"');
        }
        this.out.append(':');
        return false;
    }

    public boolean endObjectEntry() throws ParseException, IOException {
        return false;
    }

    public boolean startArray() throws ParseException, IOException {
        if (this.isInArray()) {
            int n2 = this.pos + 1;
            int n3 = this.stack[n2];
            this.stack[n2] = n3 + 1;
            if (n3 > 0) {
                this.out.append(',');
            }
        }
        this.out.append('[');
        this.push(1);
        return false;
    }

    public boolean endArray() throws ParseException, IOException {
        this.out.append(']');
        this.pos -= 2;
        return false;
    }

    public boolean primitive(Object object) throws ParseException, IOException {
        if (!this.isInObject()) {
            int n2 = this.pos + 1;
            int n3 = this.stack[n2];
            this.stack[n2] = n3 + 1;
            if (n3 > 0) {
                this.out.append(',');
            }
        }
        if (object instanceof String) {
            this.compression.writeString(this.out, (String)object);
        } else {
            JSONValue.writeJSONString((Object)object, (Appendable)this.out, (JSONStyle)this.compression);
        }
        return false;
    }
}

