/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.net.minidev.json_1_3_1;

import java.io.IOException;
import macromedia.externals.net.minidev.json_1_3_1.JSONValue;
import macromedia.externals.net.minidev.json_1_3_1.JStylerObj;

public class JSONStyle {
    public static final int FLAG_PROTECT_KEYS = 1;
    public static final int FLAG_PROTECT_4WEB = 2;
    public static final int FLAG_PROTECT_VALUES = 4;
    public static final int FLAG_AGRESSIVE = 8;
    public static final int FLAG_IGNORE_NULL = 16;
    public static final JSONStyle NO_COMPRESS = new JSONStyle();
    public static final JSONStyle MAX_COMPRESS = new JSONStyle(-1);
    public static final JSONStyle LT_COMPRESS = new JSONStyle(2);
    private boolean _protectKeys;
    private boolean _protect4Web;
    private boolean _protectValues;
    private boolean _ignore_null;
    private JStylerObj.MustProtect mpKey;
    private JStylerObj.MustProtect mpValue;
    private JStylerObj.StringProtector esc;

    public JSONStyle(int n2) {
        this._protectKeys = (n2 & 1) == 0;
        this._protectValues = (n2 & 4) == 0;
        this._protect4Web = (n2 & 2) == 0;
        this._ignore_null = (n2 & 0x10) > 0;
        Object object = (n2 & 8) > 0 ? JStylerObj.MP_AGGRESIVE : JStylerObj.MP_SIMPLE;
        this.mpValue = this._protectValues ? JStylerObj.MP_TRUE : object;
        this.mpKey = this._protectKeys ? JStylerObj.MP_TRUE : object;
        this.esc = this._protect4Web ? JStylerObj.ESCAPE4Web : JStylerObj.ESCAPE_LT;
    }

    public JSONStyle() {
        this(0);
    }

    public boolean protectKeys() {
        return this._protectKeys;
    }

    public boolean protectValues() {
        return this._protectValues;
    }

    public boolean protect4Web() {
        return this._protect4Web;
    }

    public boolean ignoreNull() {
        return this._ignore_null;
    }

    public boolean indent() {
        return false;
    }

    public boolean mustProtectKey(String string) {
        return this.mpKey.mustBeProtect(string);
    }

    public boolean mustProtectValue(String string) {
        return this.mpValue.mustBeProtect(string);
    }

    public void writeString(Appendable appendable, String string) throws IOException {
        if (!this.mustProtectValue(string)) {
            appendable.append(string);
        } else {
            appendable.append('\"');
            JSONValue.escape((String)string, (Appendable)appendable, (JSONStyle)this);
            appendable.append('\"');
        }
    }

    public void escape(String string, Appendable appendable) {
        this.esc.escape(string, appendable);
    }

    public void objectStart(Appendable appendable) throws IOException {
        appendable.append('{');
    }

    public void objectStop(Appendable appendable) throws IOException {
        appendable.append('}');
    }

    public void objectFirstStart(Appendable appendable) throws IOException {
    }

    public void objectNext(Appendable appendable) throws IOException {
        appendable.append(',');
    }

    public void objectElmStop(Appendable appendable) throws IOException {
    }

    public void objectEndOfKey(Appendable appendable) throws IOException {
        appendable.append(':');
    }

    public void arrayStart(Appendable appendable) throws IOException {
        appendable.append('[');
    }

    public void arrayStop(Appendable appendable) throws IOException {
        appendable.append(']');
    }

    public void arrayfirstObject(Appendable appendable) throws IOException {
    }

    public void arrayNextElm(Appendable appendable) throws IOException {
        appendable.append(',');
    }

    public void arrayObjectEnd(Appendable appendable) throws IOException {
    }
}

