/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.javax.mail_1_4_7.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import macromedia.externals.javax.mail_1_4_7.internet.ContentType;
import macromedia.externals.javax.mail_1_4_7.internet.MimeUtility;
import macromedia.externals.javax.mail_1_4_7.internet.ParseException;
import macromedia.externals.javax.mail_1_4_7.util.ByteArrayDataSource;
import macromedia.externals.javax.mail_1_4_7.util.SharedByteArrayInputStream;

public class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private int len = -1;
    private String type;
    private String name = "";

    public ByteArrayDataSource(InputStream inputStream, String string) throws IOException {
        int n2;
        DSByteArrayOutputStream dSByteArrayOutputStream = new DSByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n2 = inputStream.read(byArray)) > 0) {
            dSByteArrayOutputStream.write(byArray, 0, n2);
        }
        this.data = dSByteArrayOutputStream.getBuf();
        this.len = dSByteArrayOutputStream.getCount();
        if (this.data.length - this.len > 262144) {
            this.data = dSByteArrayOutputStream.toByteArray();
            this.len = this.data.length;
        }
        this.type = string;
    }

    public ByteArrayDataSource(byte[] byArray, String string) {
        this.data = byArray;
        this.type = string;
    }

    public ByteArrayDataSource(String string, String string2) throws IOException {
        String string3 = null;
        try {
            ContentType contentType = new ContentType(string2);
            string3 = contentType.getParameter("charset");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        string3 = MimeUtility.javaCharset(string3);
        if (string3 == null) {
            string3 = MimeUtility.getDefaultJavaCharset();
        }
        this.data = string.getBytes(string3);
        this.type = string2;
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        if (this.len < 0) {
            this.len = this.data.length;
        }
        return new SharedByteArrayInputStream(this.data, 0, this.len);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("cannot do this");
    }

    public String getContentType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

