/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.javax.mail_1_4_7.internet;

import java.text.ParseException;

class MailDateParser {
    int index = 0;
    char[] orig = null;

    public MailDateParser(char[] cArray, int n2) {
        this.orig = cArray;
        this.index = n2;
    }

    public void skipUntilNumber() throws ParseException {
        try {
            while (true) {
                switch (this.orig[this.index]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        return;
                    }
                }
                ++this.index;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParseException("No Number Found", this.index);
        }
    }

    public void skipWhiteSpace() {
        int n2 = this.orig.length;
        block3: while (this.index < n2) {
            switch (this.orig[this.index]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this.index;
                    continue block3;
                }
            }
            return;
        }
    }

    public int peekChar() throws ParseException {
        if (this.index < this.orig.length) {
            return this.orig[this.index];
        }
        throw new ParseException("No more characters", this.index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void skipChar(char c2) throws ParseException {
        if (this.index >= this.orig.length) throw new ParseException("No more characters", this.index);
        if (this.orig[this.index] != c2) throw new ParseException("Wrong char", this.index);
        ++this.index;
    }

    public boolean skipIfChar(char c2) throws ParseException {
        if (this.index < this.orig.length) {
            if (this.orig[this.index] == c2) {
                ++this.index;
                return true;
            }
            return false;
        }
        throw new ParseException("No more characters", this.index);
    }

    public int parseNumber() throws ParseException {
        int n2 = this.orig.length;
        boolean bl2 = false;
        int n3 = 0;
        while (this.index < n2) {
            switch (this.orig[this.index]) {
                case '0': {
                    n3 *= 10;
                    bl2 = true;
                    break;
                }
                case '1': {
                    n3 = n3 * 10 + 1;
                    bl2 = true;
                    break;
                }
                case '2': {
                    n3 = n3 * 10 + 2;
                    bl2 = true;
                    break;
                }
                case '3': {
                    n3 = n3 * 10 + 3;
                    bl2 = true;
                    break;
                }
                case '4': {
                    n3 = n3 * 10 + 4;
                    bl2 = true;
                    break;
                }
                case '5': {
                    n3 = n3 * 10 + 5;
                    bl2 = true;
                    break;
                }
                case '6': {
                    n3 = n3 * 10 + 6;
                    bl2 = true;
                    break;
                }
                case '7': {
                    n3 = n3 * 10 + 7;
                    bl2 = true;
                    break;
                }
                case '8': {
                    n3 = n3 * 10 + 8;
                    bl2 = true;
                    break;
                }
                case '9': {
                    n3 = n3 * 10 + 9;
                    bl2 = true;
                    break;
                }
                default: {
                    if (bl2) {
                        return n3;
                    }
                    throw new ParseException("No Number found", this.index);
                }
            }
            ++this.index;
        }
        if (bl2) {
            return n3;
        }
        throw new ParseException("No Number found", this.index);
    }

    public int parseMonth() throws ParseException {
        try {
            switch (this.orig[this.index++]) {
                case 'J': 
                case 'j': {
                    switch (this.orig[this.index++]) {
                        case 'A': 
                        case 'a': {
                            char c2 = this.orig[this.index++];
                            if (c2 != 'N' && c2 != 'n') break;
                            return 0;
                        }
                        case 'U': 
                        case 'u': {
                            char c3 = this.orig[this.index++];
                            if (c3 == 'N' || c3 == 'n') {
                                return 5;
                            }
                            if (c3 != 'L' && c3 != 'l') break;
                            return 6;
                        }
                    }
                    break;
                }
                case 'F': 
                case 'f': {
                    char c4 = this.orig[this.index++];
                    if (c4 != 'E' && c4 != 'e' || (c4 = this.orig[this.index++]) != 'B' && c4 != 'b') break;
                    return 1;
                }
                case 'M': 
                case 'm': {
                    char c5 = this.orig[this.index++];
                    if (c5 != 'A' && c5 != 'a') break;
                    if ((c5 = this.orig[this.index++]) == 'R' || c5 == 'r') {
                        return 2;
                    }
                    if (c5 != 'Y' && c5 != 'y') break;
                    return 4;
                }
                case 'A': 
                case 'a': {
                    char c6 = this.orig[this.index++];
                    if (c6 == 'P' || c6 == 'p') {
                        if ((c6 = this.orig[this.index++]) != 'R' && c6 != 'r') break;
                        return 3;
                    }
                    if (c6 != 'U' && c6 != 'u' || (c6 = this.orig[this.index++]) != 'G' && c6 != 'g') break;
                    return 7;
                }
                case 'S': 
                case 's': {
                    char c7 = this.orig[this.index++];
                    if (c7 != 'E' && c7 != 'e' || (c7 = this.orig[this.index++]) != 'P' && c7 != 'p') break;
                    return 8;
                }
                case 'O': 
                case 'o': {
                    char c8 = this.orig[this.index++];
                    if (c8 != 'C' && c8 != 'c' || (c8 = this.orig[this.index++]) != 'T' && c8 != 't') break;
                    return 9;
                }
                case 'N': 
                case 'n': {
                    char c9 = this.orig[this.index++];
                    if (c9 != 'O' && c9 != 'o' || (c9 = this.orig[this.index++]) != 'V' && c9 != 'v') break;
                    return 10;
                }
                case 'D': 
                case 'd': {
                    char c10 = this.orig[this.index++];
                    if (c10 != 'E' && c10 != 'e' || (c10 = this.orig[this.index++]) != 'C' && c10 != 'c') break;
                    return 11;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new ParseException("Bad Month", this.index);
    }

    public int parseTimeZone() throws ParseException {
        if (this.index >= this.orig.length) {
            throw new ParseException("No more characters", this.index);
        }
        char c2 = this.orig[this.index];
        if (c2 == '+' || c2 == '-') {
            return this.parseNumericTimeZone();
        }
        return this.parseAlphaTimeZone();
    }

    public int parseNumericTimeZone() throws ParseException {
        char c2;
        boolean bl2 = false;
        if ((c2 = this.orig[this.index++]) == '+') {
            bl2 = true;
        } else if (c2 != '-') {
            throw new ParseException("Bad Numeric TimeZone", this.index);
        }
        int n2 = this.index;
        int n3 = this.parseNumber();
        if (n3 >= 2400) {
            throw new ParseException("Numeric TimeZone out of range", n2);
        }
        int n4 = n3 / 100 * 60 + n3 % 100;
        if (bl2) {
            return -n4;
        }
        return n4;
    }

    public int parseAlphaTimeZone() throws ParseException {
        char c2;
        int n2 = 0;
        boolean bl2 = false;
        try {
            switch (this.orig[this.index++]) {
                case 'U': 
                case 'u': {
                    c2 = this.orig[this.index++];
                    if (c2 == 'T' || c2 == 't') {
                        n2 = 0;
                        break;
                    }
                    throw new ParseException("Bad Alpha TimeZone", this.index);
                }
                case 'G': 
                case 'g': {
                    c2 = this.orig[this.index++];
                    if (!(c2 != 'M' && c2 != 'm' || (c2 = this.orig[this.index++]) != 'T' && c2 != 't')) {
                        n2 = 0;
                        break;
                    }
                    throw new ParseException("Bad Alpha TimeZone", this.index);
                }
                case 'E': 
                case 'e': {
                    n2 = 300;
                    bl2 = true;
                    break;
                }
                case 'C': 
                case 'c': {
                    n2 = 360;
                    bl2 = true;
                    break;
                }
                case 'M': 
                case 'm': {
                    n2 = 420;
                    bl2 = true;
                    break;
                }
                case 'P': 
                case 'p': {
                    n2 = 480;
                    bl2 = true;
                    break;
                }
                default: {
                    throw new ParseException("Bad Alpha TimeZone", this.index);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParseException("Bad Alpha TimeZone", this.index);
        }
        if (bl2) {
            if ((c2 = this.orig[this.index++]) == 'S' || c2 == 's') {
                if ((c2 = this.orig[this.index++]) != 'T' && c2 != 't') {
                    throw new ParseException("Bad Alpha TimeZone", this.index);
                }
            } else if (c2 == 'D' || c2 == 'd') {
                if ((c2 = this.orig[this.index++]) == 'T' || c2 != 't') {
                    n2 -= 60;
                } else {
                    throw new ParseException("Bad Alpha TimeZone", this.index);
                }
            }
        }
        return n2;
    }

    int getIndex() {
        return this.index;
    }
}

