/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.javax.mail_1_4_7.internet;

import macromedia.externals.javax.mail_1_4_7.internet.HeaderTokenizer;
import macromedia.externals.javax.mail_1_4_7.internet.ParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class HeaderTokenizer {
    private String string;
    private boolean skipComments;
    private String delimiters;
    private int currentPos;
    private int maxPos;
    private int nextPos;
    private int peekPos;
    public static final String RFC822 = "()<>@,;:\\\"\t .[]";
    public static final String MIME = "()<>@,;:\\\"\t []/?=";
    private static final Token EOFToken = new Token(-4, null);

    public HeaderTokenizer(String string, String string2, boolean bl2) {
        this.string = string == null ? "" : string;
        this.skipComments = bl2;
        this.delimiters = string2;
        this.peekPos = 0;
        this.nextPos = 0;
        this.currentPos = 0;
        this.maxPos = this.string.length();
    }

    public HeaderTokenizer(String string, String string2) {
        this(string, string2, true);
    }

    public HeaderTokenizer(String string) {
        this(string, "()<>@,;:\\\"\t .[]");
    }

    public Token next() throws ParseException {
        return this.next('\u0000', false);
    }

    Token next(char c2) throws ParseException {
        return this.next(c2, false);
    }

    Token next(char c2, boolean bl2) throws ParseException {
        this.currentPos = this.nextPos;
        Token token = this.getNext(c2, bl2);
        this.nextPos = this.peekPos = this.currentPos;
        return token;
    }

    public Token peek() throws ParseException {
        this.currentPos = this.peekPos;
        Token token = this.getNext('\u0000', false);
        this.peekPos = this.currentPos;
        return token;
    }

    public String getRemainder() {
        return this.string.substring(this.nextPos);
    }

    private Token getNext(char c2, boolean bl2) throws ParseException {
        int n2;
        if (this.currentPos >= this.maxPos) {
            return EOFToken;
        }
        if (this.skipWhiteSpace() == -4) {
            return EOFToken;
        }
        boolean bl3 = false;
        char c3 = this.string.charAt(this.currentPos);
        while (c3 == '(') {
            n2 = ++this.currentPos;
            int n3 = 1;
            while (n3 > 0 && this.currentPos < this.maxPos) {
                c3 = this.string.charAt(this.currentPos);
                if (c3 == '\\') {
                    ++this.currentPos;
                    bl3 = true;
                } else if (c3 == '\r') {
                    bl3 = true;
                } else if (c3 == '(') {
                    ++n3;
                } else if (c3 == ')') {
                    --n3;
                }
                ++this.currentPos;
            }
            if (n3 != 0) {
                throw new ParseException("Unbalanced comments");
            }
            if (!this.skipComments) {
                String string = bl3 ? HeaderTokenizer.filterToken((String)this.string, (int)n2, (int)(this.currentPos - 1), (boolean)bl2) : this.string.substring(n2, this.currentPos - 1);
                return new Token(-3, string);
            }
            if (this.skipWhiteSpace() == -4) {
                return EOFToken;
            }
            c3 = this.string.charAt(this.currentPos);
        }
        if (c3 == '\"') {
            ++this.currentPos;
            return this.collectString('\"', bl2);
        }
        if (c3 < ' ' || c3 >= '\u007f' || this.delimiters.indexOf(c3) >= 0) {
            if (c2 > '\u0000' && c3 != c2) {
                return this.collectString(c2, bl2);
            }
            ++this.currentPos;
            char[] cArray = new char[]{c3};
            return new Token((int)c3, new String(cArray));
        }
        n2 = this.currentPos;
        while (this.currentPos < this.maxPos) {
            c3 = this.string.charAt(this.currentPos);
            if (c3 < ' ' || c3 >= '\u007f' || c3 == '(' || c3 == ' ' || c3 == '\"' || this.delimiters.indexOf(c3) >= 0) {
                if (c2 <= '\u0000' || c3 == c2) break;
                this.currentPos = n2;
                return this.collectString(c2, bl2);
            }
            ++this.currentPos;
        }
        return new Token(-1, this.string.substring(n2, this.currentPos));
    }

    private Token collectString(char c2, boolean bl2) throws ParseException {
        boolean bl3 = false;
        int n2 = this.currentPos;
        while (this.currentPos < this.maxPos) {
            char c3 = this.string.charAt(this.currentPos);
            if (c3 == '\\') {
                ++this.currentPos;
                bl3 = true;
            } else if (c3 == '\r') {
                bl3 = true;
            } else if (c3 == c2) {
                ++this.currentPos;
                String string = bl3 ? HeaderTokenizer.filterToken((String)this.string, (int)n2, (int)(this.currentPos - 1), (boolean)bl2) : this.string.substring(n2, this.currentPos - 1);
                if (c3 != '\"') {
                    string = HeaderTokenizer.trimWhiteSpace((String)string);
                    --this.currentPos;
                }
                return new Token(-2, string);
            }
            ++this.currentPos;
        }
        if (c2 == '\"') {
            throw new ParseException("Unbalanced quoted string");
        }
        String string = bl3 ? HeaderTokenizer.filterToken((String)this.string, (int)n2, (int)this.currentPos, (boolean)bl2) : this.string.substring(n2, this.currentPos);
        string = HeaderTokenizer.trimWhiteSpace((String)string);
        return new Token(-2, string);
    }

    private int skipWhiteSpace() {
        while (this.currentPos < this.maxPos) {
            char c2 = this.string.charAt(this.currentPos);
            if (c2 != ' ' && c2 != '\t' && c2 != '\r' && c2 != '\n') {
                return this.currentPos;
            }
            ++this.currentPos;
        }
        return -4;
    }

    private static String trimWhiteSpace(String string) {
        char c2;
        int n2;
        for (n2 = string.length() - 1; n2 >= 0 && ((c2 = string.charAt(n2)) == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n'); --n2) {
        }
        if (n2 <= 0) {
            return "";
        }
        return string.substring(0, n2 + 1);
    }

    private static String filterToken(String string, int n2, int n3, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\n' && bl4) {
                bl4 = false;
                continue;
            }
            bl4 = false;
            if (!bl3) {
                if (c2 == '\\') {
                    bl3 = true;
                    continue;
                }
                if (c2 == '\r') {
                    bl4 = true;
                    continue;
                }
                stringBuffer.append(c2);
                continue;
            }
            if (bl2) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c2);
            bl3 = false;
        }
        return stringBuffer.toString();
    }
}

