/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.javax.mail_1_4_7;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.Locale;

/*
 * Exception performing whole class analysis ignored.
 */
public class URLName {
    protected String fullURL;
    private String protocol;
    private String username;
    private String password;
    private String host;
    private InetAddress hostAddress;
    private boolean hostAddressKnown = false;
    private int port = -1;
    private String file;
    private String ref;
    private int hashCode = 0;
    private static boolean doEncode;
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;

    public URLName(String string, String string2, int n2, String string3, String string4, String string5) {
        int n3;
        this.protocol = string;
        this.host = string2;
        this.port = n2;
        if (string3 != null && (n3 = string3.indexOf(35)) != -1) {
            this.file = string3.substring(0, n3);
            this.ref = string3.substring(n3 + 1);
        } else {
            this.file = string3;
            this.ref = null;
        }
        this.username = doEncode ? URLName.encode((String)string4) : string4;
        this.password = doEncode ? URLName.encode((String)string5) : string5;
    }

    public URLName(URL uRL) {
        this(uRL.toString());
    }

    public URLName(String string) {
        this.parseString(string);
    }

    public String toString() {
        if (this.fullURL == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.protocol != null) {
                stringBuffer.append(this.protocol);
                stringBuffer.append(":");
            }
            if (this.username != null || this.host != null) {
                stringBuffer.append("//");
                if (this.username != null) {
                    stringBuffer.append(this.username);
                    if (this.password != null) {
                        stringBuffer.append(":");
                        stringBuffer.append(this.password);
                    }
                    stringBuffer.append("@");
                }
                if (this.host != null) {
                    stringBuffer.append(this.host);
                }
                if (this.port != -1) {
                    stringBuffer.append(":");
                    stringBuffer.append(Integer.toString(this.port));
                }
                if (this.file != null) {
                    stringBuffer.append("/");
                }
            }
            if (this.file != null) {
                stringBuffer.append(this.file);
            }
            if (this.ref != null) {
                stringBuffer.append("#");
                stringBuffer.append(this.ref);
            }
            this.fullURL = stringBuffer.toString();
        }
        return this.fullURL;
    }

    protected void parseString(String string) {
        int n2;
        this.password = null;
        this.username = null;
        this.host = null;
        this.ref = null;
        this.file = null;
        this.protocol = null;
        this.port = -1;
        int n3 = string.length();
        int n4 = string.indexOf(58);
        if (n4 != -1) {
            this.protocol = string.substring(0, n4);
        }
        if (string.regionMatches(n4 + 1, "//", 0, 2)) {
            int n5;
            String string2 = null;
            int n6 = string.indexOf(47, n4 + 3);
            if (n6 != -1) {
                string2 = string.substring(n4 + 3, n6);
                this.file = n6 + 1 < n3 ? string.substring(n6 + 1) : "";
            } else {
                string2 = string.substring(n4 + 3);
            }
            int n7 = string2.indexOf(64);
            if (n7 != -1) {
                String string3 = string2.substring(0, n7);
                string2 = string2.substring(n7 + 1);
                int n8 = string3.indexOf(58);
                if (n8 != -1) {
                    this.username = string3.substring(0, n8);
                    this.password = string3.substring(n8 + 1);
                } else {
                    this.username = string3;
                }
            }
            if ((n5 = string2.length() > 0 && string2.charAt(0) == '[' ? string2.indexOf(58, string2.indexOf(93)) : string2.indexOf(58)) != -1) {
                String string4 = string2.substring(n5 + 1);
                if (string4.length() > 0) {
                    try {
                        this.port = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.port = -1;
                    }
                }
                this.host = string2.substring(0, n5);
            } else {
                this.host = string2;
            }
        } else if (n4 + 1 < n3) {
            this.file = string.substring(n4 + 1);
        }
        if (this.file != null && (n2 = this.file.indexOf(35)) != -1) {
            this.ref = this.file.substring(n2 + 1);
            this.file = this.file.substring(0, n2);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getFile() {
        return this.file;
    }

    public String getRef() {
        return this.ref;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return doEncode ? URLName.decode((String)this.username) : this.username;
    }

    public String getPassword() {
        return doEncode ? URLName.decode((String)this.password) : this.password;
    }

    public URL getURL() throws MalformedURLException {
        return new URL(this.getProtocol(), this.getHost(), this.getPort(), this.getFile());
    }

    public boolean equals(Object object) {
        String string;
        if (!(object instanceof URLName)) {
            return false;
        }
        URLName uRLName = (URLName)object;
        if (uRLName.protocol == null || !uRLName.protocol.equals(this.protocol)) {
            return false;
        }
        InetAddress inetAddress = this.getHostAddress();
        InetAddress inetAddress2 = uRLName.getHostAddress();
        if (inetAddress != null && inetAddress2 != null ? !inetAddress.equals(inetAddress2) : (this.host != null && uRLName.host != null ? !this.host.equalsIgnoreCase(uRLName.host) : this.host != uRLName.host)) {
            return false;
        }
        if (!(this.username == uRLName.username || this.username != null && this.username.equals(uRLName.username))) {
            return false;
        }
        String string2 = this.file == null ? "" : this.file;
        String string3 = string = uRLName.file == null ? "" : uRLName.file;
        if (!string2.equals(string)) {
            return false;
        }
        return this.port == uRLName.port;
    }

    public int hashCode() {
        InetAddress inetAddress;
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        if (this.protocol != null) {
            this.hashCode += this.protocol.hashCode();
        }
        if ((inetAddress = this.getHostAddress()) != null) {
            this.hashCode += inetAddress.hashCode();
        } else if (this.host != null) {
            this.hashCode += this.host.toLowerCase(Locale.ENGLISH).hashCode();
        }
        if (this.username != null) {
            this.hashCode += this.username.hashCode();
        }
        if (this.file != null) {
            this.hashCode += this.file.hashCode();
        }
        this.hashCode += this.port;
        return this.hashCode;
    }

    private synchronized InetAddress getHostAddress() {
        if (this.hostAddressKnown) {
            return this.hostAddress;
        }
        if (this.host == null) {
            return null;
        }
        try {
            this.hostAddress = InetAddress.getByName(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            this.hostAddress = null;
        }
        this.hostAddressKnown = true;
        return this.hostAddress;
    }

    static String encode(String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != ' ' && dontNeedEncoding.get(c2)) continue;
            return URLName._encode((String)string);
        }
        return string;
    }

    private static String _encode(String string) {
        int n2 = 10;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n3 = string.charAt(i2);
            if (dontNeedEncoding.get(n3)) {
                if (n3 == 32) {
                    n3 = 43;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            try {
                outputStreamWriter.write(n3);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                stringBuffer.append('%');
                char c2 = Character.forDigit(byArray[i3] >> 4 & 0xF, 16);
                if (Character.isLetter(c2)) {
                    c2 = (char)(c2 - 32);
                }
                stringBuffer.append(c2);
                c2 = Character.forDigit(byArray[i3] & 0xF, 16);
                if (Character.isLetter(c2)) {
                    c2 = (char)(c2 - 32);
                }
                stringBuffer.append(c2);
            }
            byteArrayOutputStream.reset();
        }
        return stringBuffer.toString();
    }

    static String decode(String string) {
        if (string == null) {
            return null;
        }
        if (URLName.indexOfAny((String)string, (String)"+%") == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '+': {
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(i2 + 1, i2 + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(new StringBuffer().append("Illegal URL encoded value: ").append(string.substring(i2, i2 + 3)).toString());
                    }
                    i2 += 2;
                    continue block8;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        String string2 = stringBuffer.toString();
        try {
            byte[] byArray = string2.getBytes("8859_1");
            string2 = new String(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    private static int indexOfAny(String string, String string2) {
        return URLName.indexOfAny((String)string, (String)string2, (int)0);
    }

    private static int indexOfAny(String string, String string2, int n2) {
        try {
            int n3 = string.length();
            for (int i2 = n2; i2 < n3; ++i2) {
                if (string2.indexOf(string.charAt(i2)) < 0) continue;
                return i2;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return -1;
        }
    }

    static {
        int n2;
        doEncode = true;
        try {
            doEncode = !Boolean.getBoolean("mail.URLName.dontencode");
        }
        catch (Exception exception) {
            // empty catch block
        }
        dontNeedEncoding = new BitSet(256);
        for (n2 = 97; n2 <= 122; ++n2) {
            dontNeedEncoding.set(n2);
        }
        for (n2 = 65; n2 <= 90; ++n2) {
            dontNeedEncoding.set(n2);
        }
        for (n2 = 48; n2 <= 57; ++n2) {
            dontNeedEncoding.set(n2);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

