/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.javax.mail_1_4_7;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import macromedia.externals.com.sun.mail_1_4_7.util.LineInputStream;
import macromedia.externals.com.sun.mail_1_4_7.util.MailLogger;
import macromedia.externals.javax.mail_1_4_7.Address;
import macromedia.externals.javax.mail_1_4_7.Authenticator;
import macromedia.externals.javax.mail_1_4_7.Folder;
import macromedia.externals.javax.mail_1_4_7.MessagingException;
import macromedia.externals.javax.mail_1_4_7.NoSuchProviderException;
import macromedia.externals.javax.mail_1_4_7.PasswordAuthentication;
import macromedia.externals.javax.mail_1_4_7.Provider;
import macromedia.externals.javax.mail_1_4_7.Session;
import macromedia.externals.javax.mail_1_4_7.Store;
import macromedia.externals.javax.mail_1_4_7.StreamLoader;
import macromedia.externals.javax.mail_1_4_7.Transport;
import macromedia.externals.javax.mail_1_4_7.URLName;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Session {
    private final Properties props;
    private final Authenticator authenticator;
    private final Hashtable authTable = new Hashtable();
    private boolean debug = false;
    private PrintStream out;
    private MailLogger logger;
    private final Vector providers = new Vector();
    private final Hashtable providersByProtocol = new Hashtable();
    private final Hashtable providersByClassName = new Hashtable();
    private final Properties addressMap = new Properties();
    private static Session defaultSession = null;
    static /* synthetic */ Class class$javax$mail$Session;
    static /* synthetic */ Class class$javax$mail$URLName;

    private Session(Properties properties, Authenticator authenticator) {
        this.props = properties;
        this.authenticator = authenticator;
        if (Boolean.valueOf(properties.getProperty("mail.debug")).booleanValue()) {
            this.debug = true;
        }
        this.initLogger();
        this.logger.log(Level.CONFIG, "JavaMail version {0}", (Object)"1.4.7");
        Class<?> clazz = authenticator != null ? authenticator.getClass() : this.getClass();
        this.loadProviders(clazz);
        this.loadAddressMap(clazz);
    }

    private final void initLogger() {
        this.logger = new MailLogger(this.getClass(), "DEBUG", this.debug, this.getDebugOut());
    }

    public static Session getInstance(Properties properties, Authenticator authenticator) {
        return new Session(properties, authenticator);
    }

    public static Session getInstance(Properties properties) {
        return new Session(properties, null);
    }

    public static synchronized Session getDefaultInstance(Properties properties, Authenticator authenticator) {
        if (defaultSession == null) {
            defaultSession = new Session(properties, authenticator);
        } else if (Session.defaultSession.authenticator != authenticator && (Session.defaultSession.authenticator == null || authenticator == null || Session.defaultSession.authenticator.getClass().getClassLoader() != authenticator.getClass().getClassLoader())) {
            throw new SecurityException("Access to default session denied");
        }
        return defaultSession;
    }

    public static Session getDefaultInstance(Properties properties) {
        return Session.getDefaultInstance((Properties)properties, null);
    }

    public synchronized void setDebug(boolean bl2) {
        this.debug = bl2;
        this.initLogger();
        this.logger.log(Level.CONFIG, "setDebug: JavaMail version {0}", (Object)"1.4.7");
    }

    public synchronized boolean getDebug() {
        return this.debug;
    }

    public synchronized void setDebugOut(PrintStream printStream) {
        this.out = printStream;
        this.initLogger();
    }

    public synchronized PrintStream getDebugOut() {
        if (this.out == null) {
            return System.out;
        }
        return this.out;
    }

    public synchronized Provider[] getProviders() {
        Object[] objectArray = new Provider[this.providers.size()];
        this.providers.copyInto(objectArray);
        return objectArray;
    }

    public synchronized Provider getProvider(String string) throws NoSuchProviderException {
        if (string == null || string.length() <= 0) {
            throw new NoSuchProviderException("Invalid protocol: null");
        }
        Provider provider = null;
        String string2 = this.props.getProperty(new StringBuffer().append("mail.").append(string).append(".class").toString());
        if (string2 != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(new StringBuffer().append("mail.").append(string).append(".class property exists and points to ").append(string2).toString());
            }
            provider = (Provider)this.providersByClassName.get(string2);
        }
        if (provider != null) {
            return provider;
        }
        provider = (Provider)this.providersByProtocol.get(string);
        if (provider == null) {
            throw new NoSuchProviderException(new StringBuffer().append("No provider for ").append(string).toString());
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(new StringBuffer().append("getProvider() returning ").append(provider.toString()).toString());
        }
        return provider;
    }

    public synchronized void setProvider(Provider provider) throws NoSuchProviderException {
        if (provider == null) {
            throw new NoSuchProviderException("Can't set null provider");
        }
        this.providersByProtocol.put(provider.getProtocol(), provider);
        this.props.put(new StringBuffer().append("mail.").append(provider.getProtocol()).append(".class").toString(), provider.getClassName());
    }

    public Store getStore() throws NoSuchProviderException {
        return this.getStore(this.getProperty("mail.store.protocol"));
    }

    public Store getStore(String string) throws NoSuchProviderException {
        return this.getStore(new URLName(string, null, -1, null, null, null));
    }

    public Store getStore(URLName uRLName) throws NoSuchProviderException {
        String string = uRLName.getProtocol();
        Provider provider = this.getProvider(string);
        return this.getStore(provider, uRLName);
    }

    public Store getStore(Provider provider) throws NoSuchProviderException {
        return this.getStore(provider, null);
    }

    private Store getStore(Provider provider, URLName uRLName) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.STORE) {
            throw new NoSuchProviderException("invalid provider");
        }
        try {
            return (Store)this.getService(provider, uRLName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchProviderException("incorrect class");
        }
    }

    public Folder getFolder(URLName uRLName) throws MessagingException {
        Store store = this.getStore(uRLName);
        store.connect();
        return store.getFolder(uRLName);
    }

    public Transport getTransport() throws NoSuchProviderException {
        return this.getTransport(this.getProperty("mail.transport.protocol"));
    }

    public Transport getTransport(String string) throws NoSuchProviderException {
        return this.getTransport(new URLName(string, null, -1, null, null, null));
    }

    public Transport getTransport(URLName uRLName) throws NoSuchProviderException {
        String string = uRLName.getProtocol();
        Provider provider = this.getProvider(string);
        return this.getTransport(provider, uRLName);
    }

    public Transport getTransport(Provider provider) throws NoSuchProviderException {
        return this.getTransport(provider, null);
    }

    public Transport getTransport(Address address) throws NoSuchProviderException {
        String string = this.getProperty(new StringBuffer().append("mail.transport.protocol.").append(address.getType()).toString());
        if (string != null) {
            return this.getTransport(string);
        }
        string = (String)this.addressMap.get(address.getType());
        if (string != null) {
            return this.getTransport(string);
        }
        throw new NoSuchProviderException(new StringBuffer().append("No provider for Address type: ").append(address.getType()).toString());
    }

    private Transport getTransport(Provider provider, URLName uRLName) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.TRANSPORT) {
            throw new NoSuchProviderException("invalid provider");
        }
        try {
            return (Transport)this.getService(provider, uRLName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchProviderException("incorrect class");
        }
    }

    private Object getService(Provider provider, URLName uRLName) throws NoSuchProviderException {
        Class[] classArray;
        if (provider == null) {
            throw new NoSuchProviderException("null");
        }
        if (uRLName == null) {
            uRLName = new URLName(provider.getProtocol(), null, -1, null, null, null);
        }
        Object var3_3 = null;
        ClassLoader classLoader = this.authenticator != null ? this.authenticator.getClass().getClassLoader() : this.getClass().getClassLoader();
        Class<?> clazz = null;
        try {
            classArray = Session.getContextClassLoader();
            if (classArray != null) {
                try {
                    clazz = Class.forName(provider.getClassName(), false, (ClassLoader)classArray);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = Class.forName(provider.getClassName(), false, classLoader);
            }
        }
        catch (Exception exception) {
            try {
                clazz = Class.forName(provider.getClassName());
            }
            catch (Exception exception2) {
                this.logger.log(Level.FINE, "Exception loading provider", (Throwable)exception2);
                throw new NoSuchProviderException(provider.getProtocol());
            }
        }
        try {
            classArray = new Class[]{class$javax$mail$Session == null ? (class$javax$mail$Session = Session.class$((String)"macromedia.externals.javax.mail_1_4_7.Session")) : class$javax$mail$Session, class$javax$mail$URLName == null ? (class$javax$mail$URLName = Session.class$((String)"macromedia.externals.javax.mail_1_4_7.URLName")) : class$javax$mail$URLName};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this, uRLName};
            var3_3 = constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            this.logger.log(Level.FINE, "Exception loading provider", (Throwable)exception);
            throw new NoSuchProviderException(provider.getProtocol());
        }
        return var3_3;
    }

    public void setPasswordAuthentication(URLName uRLName, PasswordAuthentication passwordAuthentication) {
        if (passwordAuthentication == null) {
            this.authTable.remove(uRLName);
        } else {
            this.authTable.put(uRLName, passwordAuthentication);
        }
    }

    public PasswordAuthentication getPasswordAuthentication(URLName uRLName) {
        return (PasswordAuthentication)this.authTable.get(uRLName);
    }

    public PasswordAuthentication requestPasswordAuthentication(InetAddress inetAddress, int n2, String string, String string2, String string3) {
        if (this.authenticator != null) {
            return this.authenticator.requestPasswordAuthentication(inetAddress, n2, string, string2, string3);
        }
        return null;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    private void loadProviders(Class clazz) {
        1 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        try {
            String string = new StringBuffer().append(System.getProperty("java.home")).append(File.separator).append("lib").append(File.separator).append("javamail.providers").toString();
            this.loadFile(string, (StreamLoader)var2_2);
        }
        catch (SecurityException securityException) {
            this.logger.log(Level.CONFIG, "can't get java.home", (Throwable)securityException);
        }
        this.loadAllResources("META-INF/javamail.providers", clazz, (StreamLoader)var2_2);
        this.loadResource("/META-INF/javamail.default.providers", clazz, (StreamLoader)var2_2);
        if (this.providers.size() == 0) {
            this.logger.config("failed to load any providers, using defaults");
            this.addProvider(new Provider(Provider.Type.STORE, "imap", "macromedia.externals.com.sun.mail_1_4_7.imap.IMAPStore", "Sun Microsystems, Inc.", "1.4.7"));
            this.addProvider(new Provider(Provider.Type.STORE, "imaps", "macromedia.externals.com.sun.mail_1_4_7.imap.IMAPSSLStore", "Sun Microsystems, Inc.", "1.4.7"));
            this.addProvider(new Provider(Provider.Type.STORE, "pop3", "macromedia.externals.com.sun.mail_1_4_7.pop3.POP3Store", "Sun Microsystems, Inc.", "1.4.7"));
            this.addProvider(new Provider(Provider.Type.STORE, "pop3s", "macromedia.externals.com.sun.mail_1_4_7.pop3.POP3SSLStore", "Sun Microsystems, Inc.", "1.4.7"));
            this.addProvider(new Provider(Provider.Type.TRANSPORT, "smtp", "macromedia.externals.com.sun.mail_1_4_7.smtp.SMTPTransport", "Sun Microsystems, Inc.", "1.4.7"));
            this.addProvider(new Provider(Provider.Type.TRANSPORT, "smtps", "macromedia.externals.com.sun.mail_1_4_7.smtp.SMTPSSLTransport", "Sun Microsystems, Inc.", "1.4.7"));
        }
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Tables of loaded providers");
            this.logger.config(new StringBuffer().append("Providers Listed By Class Name: ").append(this.providersByClassName.toString()).toString());
            this.logger.config(new StringBuffer().append("Providers Listed By Protocol: ").append(this.providersByProtocol.toString()).toString());
        }
    }

    private void loadProvidersFromStream(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            String string;
            LineInputStream lineInputStream = new LineInputStream(inputStream);
            while ((string = lineInputStream.readLine()) != null) {
                String string2;
                if (string.startsWith("#")) continue;
                Provider.Type type = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken().trim();
                    int n2 = string2.indexOf("=");
                    if (string2.startsWith("protocol=")) {
                        string3 = string2.substring(n2 + 1);
                        continue;
                    }
                    if (string2.startsWith("type=")) {
                        String string7 = string2.substring(n2 + 1);
                        if (string7.equalsIgnoreCase("store")) {
                            type = Provider.Type.STORE;
                            continue;
                        }
                        if (!string7.equalsIgnoreCase("transport")) continue;
                        type = Provider.Type.TRANSPORT;
                        continue;
                    }
                    if (string2.startsWith("class=")) {
                        string4 = string2.substring(n2 + 1);
                        continue;
                    }
                    if (string2.startsWith("vendor=")) {
                        string5 = string2.substring(n2 + 1);
                        continue;
                    }
                    if (!string2.startsWith("version=")) continue;
                    string6 = string2.substring(n2 + 1);
                }
                if (type == null || string3 == null || string4 == null || string3.length() <= 0 || string4.length() <= 0) {
                    this.logger.log(Level.CONFIG, "Bad provider entry: {0}", (Object)string);
                    continue;
                }
                string2 = new Provider(type, string3, string4, string5, string6);
                this.addProvider((Provider)string2);
            }
        }
    }

    public synchronized void addProvider(Provider provider) {
        this.providers.addElement(provider);
        this.providersByClassName.put(provider.getClassName(), provider);
        if (!this.providersByProtocol.containsKey(provider.getProtocol())) {
            this.providersByProtocol.put(provider.getProtocol(), provider);
        }
    }

    private void loadAddressMap(Class clazz) {
        2 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        this.loadResource("/META-INF/javamail.default.address.map", clazz, (StreamLoader)var2_2);
        this.loadAllResources("META-INF/javamail.address.map", clazz, (StreamLoader)var2_2);
        try {
            String string = new StringBuffer().append(System.getProperty("java.home")).append(File.separator).append("lib").append(File.separator).append("javamail.address.map").toString();
            this.loadFile(string, (StreamLoader)var2_2);
        }
        catch (SecurityException securityException) {
            this.logger.log(Level.CONFIG, "can't get java.home", (Throwable)securityException);
        }
        if (this.addressMap.isEmpty()) {
            this.logger.config("failed to load address map, using defaults");
            this.addressMap.put("rfc822", "smtp");
        }
    }

    public synchronized void setProtocolForAddress(String string, String string2) {
        if (string2 == null) {
            this.addressMap.remove(string);
        } else {
            this.addressMap.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(String string, StreamLoader streamLoader) {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(string));
            streamLoader.load(inputStream);
            this.logger.log(Level.CONFIG, "successfully loaded file: {0}", (Object)string);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            if (this.logger.isLoggable(Level.CONFIG)) {
                this.logger.log(Level.CONFIG, new StringBuffer().append("not loading file: ").append(string).toString(), (Throwable)iOException);
            }
        }
        catch (SecurityException securityException) {
            if (this.logger.isLoggable(Level.CONFIG)) {
                this.logger.log(Level.CONFIG, new StringBuffer().append("not loading file: ").append(string).toString(), (Throwable)securityException);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResource(String string, Class clazz, StreamLoader streamLoader) {
        InputStream inputStream = null;
        try {
            inputStream = Session.getResourceAsStream((Class)clazz, (String)string);
            if (inputStream != null) {
                streamLoader.load(inputStream);
                this.logger.log(Level.CONFIG, "successfully loaded resource: {0}", (Object)string);
            }
        }
        catch (IOException iOException) {
            this.logger.log(Level.CONFIG, "Exception loading resource", (Throwable)iOException);
        }
        catch (SecurityException securityException) {
            this.logger.log(Level.CONFIG, "Exception loading resource", (Throwable)securityException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllResources(String string, Class clazz, StreamLoader streamLoader) {
        boolean bl2;
        block26: {
            bl2 = false;
            try {
                URL[] uRLArray;
                ClassLoader classLoader = null;
                classLoader = Session.getContextClassLoader();
                if (classLoader == null) {
                    classLoader = clazz.getClassLoader();
                }
                if ((uRLArray = classLoader != null ? Session.getResources((ClassLoader)classLoader, (String)string) : Session.getSystemResources((String)string)) == null) break block26;
                for (int i2 = 0; i2 < uRLArray.length; ++i2) {
                    URL uRL = uRLArray[i2];
                    InputStream inputStream = null;
                    this.logger.log(Level.CONFIG, "URL {0}", (Object)uRL);
                    try {
                        inputStream = Session.openStream((URL)uRL);
                        if (inputStream != null) {
                            streamLoader.load(inputStream);
                            bl2 = true;
                            this.logger.log(Level.CONFIG, "successfully loaded resource: {0}", (Object)uRL);
                            continue;
                        }
                        this.logger.log(Level.CONFIG, "not loading resource: {0}", (Object)uRL);
                        continue;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        continue;
                    }
                    catch (IOException iOException) {
                        this.logger.log(Level.CONFIG, "Exception loading resource", (Throwable)iOException);
                        continue;
                    }
                    catch (SecurityException securityException) {
                        this.logger.log(Level.CONFIG, "Exception loading resource", (Throwable)securityException);
                        continue;
                    }
                    finally {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.CONFIG, "Exception loading resource", (Throwable)exception);
            }
        }
        if (!bl2) {
            this.loadResource(new StringBuffer().append("/").append(string).toString(), clazz, streamLoader);
        }
    }

    private static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    private static InputStream getResourceAsStream(Class clazz, String string) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private static URL[] getResources(ClassLoader classLoader, String string) {
        return (URL[])AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    private static URL[] getSystemResources(String string) {
        return (URL[])AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    private static InputStream openStream(URL uRL) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static /* synthetic */ void access$000(Session session, InputStream inputStream) throws IOException {
        session.loadProvidersFromStream(inputStream);
    }

    static /* synthetic */ Properties access$100(Session session) {
        return session.addressMap;
    }
}

