/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.javax.mail_1_4_7;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import macromedia.externals.javax.mail_1_4_7.BodyPart;
import macromedia.externals.javax.mail_1_4_7.MessagingException;
import macromedia.externals.javax.mail_1_4_7.MultipartDataSource;
import macromedia.externals.javax.mail_1_4_7.Part;

public abstract class Multipart {
    protected Vector parts = new Vector();
    protected String contentType = "multipart/mixed";
    protected Part parent;

    protected Multipart() {
    }

    protected synchronized void setMultipartDataSource(MultipartDataSource multipartDataSource) throws MessagingException {
        this.contentType = multipartDataSource.getContentType();
        int n2 = multipartDataSource.getCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addBodyPart(multipartDataSource.getBodyPart(i2));
        }
    }

    public synchronized String getContentType() {
        return this.contentType;
    }

    public synchronized int getCount() throws MessagingException {
        if (this.parts == null) {
            return 0;
        }
        return this.parts.size();
    }

    public synchronized BodyPart getBodyPart(int n2) throws MessagingException {
        if (this.parts == null) {
            throw new IndexOutOfBoundsException("No such BodyPart");
        }
        return (BodyPart)this.parts.elementAt(n2);
    }

    public synchronized boolean removeBodyPart(BodyPart bodyPart) throws MessagingException {
        if (this.parts == null) {
            throw new MessagingException("No such body part");
        }
        boolean bl2 = this.parts.removeElement(bodyPart);
        bodyPart.setParent(null);
        return bl2;
    }

    public synchronized void removeBodyPart(int n2) throws MessagingException {
        if (this.parts == null) {
            throw new IndexOutOfBoundsException("No such BodyPart");
        }
        BodyPart bodyPart = (BodyPart)this.parts.elementAt(n2);
        this.parts.removeElementAt(n2);
        bodyPart.setParent(null);
    }

    public synchronized void addBodyPart(BodyPart bodyPart) throws MessagingException {
        if (this.parts == null) {
            this.parts = new Vector();
        }
        this.parts.addElement(bodyPart);
        bodyPart.setParent(this);
    }

    public synchronized void addBodyPart(BodyPart bodyPart, int n2) throws MessagingException {
        if (this.parts == null) {
            this.parts = new Vector();
        }
        this.parts.insertElementAt(bodyPart, n2);
        bodyPart.setParent(this);
    }

    public abstract void writeTo(OutputStream var1) throws IOException, MessagingException;

    public synchronized Part getParent() {
        return this.parent;
    }

    public synchronized void setParent(Part part) {
        this.parent = part;
    }
}

