/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.javax.mail_1_4_7;

import java.util.Vector;
import macromedia.externals.javax.mail_1_4_7.EventQueue;
import macromedia.externals.javax.mail_1_4_7.FetchProfile;
import macromedia.externals.javax.mail_1_4_7.Flags;
import macromedia.externals.javax.mail_1_4_7.Folder;
import macromedia.externals.javax.mail_1_4_7.FolderNotFoundException;
import macromedia.externals.javax.mail_1_4_7.Message;
import macromedia.externals.javax.mail_1_4_7.MessageRemovedException;
import macromedia.externals.javax.mail_1_4_7.MessagingException;
import macromedia.externals.javax.mail_1_4_7.MethodNotSupportedException;
import macromedia.externals.javax.mail_1_4_7.Store;
import macromedia.externals.javax.mail_1_4_7.URLName;
import macromedia.externals.javax.mail_1_4_7.event.ConnectionEvent;
import macromedia.externals.javax.mail_1_4_7.event.ConnectionListener;
import macromedia.externals.javax.mail_1_4_7.event.FolderEvent;
import macromedia.externals.javax.mail_1_4_7.event.FolderListener;
import macromedia.externals.javax.mail_1_4_7.event.MailEvent;
import macromedia.externals.javax.mail_1_4_7.event.MessageChangedEvent;
import macromedia.externals.javax.mail_1_4_7.event.MessageChangedListener;
import macromedia.externals.javax.mail_1_4_7.event.MessageCountEvent;
import macromedia.externals.javax.mail_1_4_7.event.MessageCountListener;
import macromedia.externals.javax.mail_1_4_7.search.SearchTerm;

public abstract class Folder {
    protected Store store;
    protected int mode = -1;
    public static final int HOLDS_MESSAGES = 1;
    public static final int HOLDS_FOLDERS = 2;
    public static final int READ_ONLY = 1;
    public static final int READ_WRITE = 2;
    private volatile Vector connectionListeners = null;
    private volatile Vector folderListeners = null;
    private volatile Vector messageCountListeners = null;
    private volatile Vector messageChangedListeners = null;
    private EventQueue q;
    private Object qLock = new Object();

    protected Folder(Store store) {
        this.store = store;
    }

    public abstract String getName();

    public abstract String getFullName();

    public URLName getURLName() throws MessagingException {
        URLName uRLName = this.getStore().getURLName();
        String string = this.getFullName();
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        }
        return new URLName(uRLName.getProtocol(), uRLName.getHost(), uRLName.getPort(), stringBuffer.toString(), uRLName.getUsername(), null);
    }

    public Store getStore() {
        return this.store;
    }

    public abstract Folder getParent() throws MessagingException;

    public abstract boolean exists() throws MessagingException;

    public abstract Folder[] list(String var1) throws MessagingException;

    public Folder[] listSubscribed(String string) throws MessagingException {
        return this.list(string);
    }

    public Folder[] list() throws MessagingException {
        return this.list("%");
    }

    public Folder[] listSubscribed() throws MessagingException {
        return this.listSubscribed("%");
    }

    public abstract char getSeparator() throws MessagingException;

    public abstract int getType() throws MessagingException;

    public abstract boolean create(int var1) throws MessagingException;

    public boolean isSubscribed() {
        return true;
    }

    public void setSubscribed(boolean bl2) throws MessagingException {
        throw new MethodNotSupportedException();
    }

    public abstract boolean hasNewMessages() throws MessagingException;

    public abstract Folder getFolder(String var1) throws MessagingException;

    public abstract boolean delete(boolean var1) throws MessagingException;

    public abstract boolean renameTo(Folder var1) throws MessagingException;

    public abstract void open(int var1) throws MessagingException;

    public abstract void close(boolean var1) throws MessagingException;

    public abstract boolean isOpen();

    public synchronized int getMode() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Folder not open");
        }
        return this.mode;
    }

    public abstract Flags getPermanentFlags();

    public abstract int getMessageCount() throws MessagingException;

    public synchronized int getNewMessageCount() throws MessagingException {
        if (!this.isOpen()) {
            return -1;
        }
        int n2 = 0;
        int n3 = this.getMessageCount();
        for (int i2 = 1; i2 <= n3; ++i2) {
            try {
                if (!this.getMessage(i2).isSet(Flags.Flag.RECENT)) continue;
                ++n2;
                continue;
            }
            catch (MessageRemovedException messageRemovedException) {
                // empty catch block
            }
        }
        return n2;
    }

    public synchronized int getUnreadMessageCount() throws MessagingException {
        if (!this.isOpen()) {
            return -1;
        }
        int n2 = 0;
        int n3 = this.getMessageCount();
        for (int i2 = 1; i2 <= n3; ++i2) {
            try {
                if (this.getMessage(i2).isSet(Flags.Flag.SEEN)) continue;
                ++n2;
                continue;
            }
            catch (MessageRemovedException messageRemovedException) {
                // empty catch block
            }
        }
        return n2;
    }

    public synchronized int getDeletedMessageCount() throws MessagingException {
        if (!this.isOpen()) {
            return -1;
        }
        int n2 = 0;
        int n3 = this.getMessageCount();
        for (int i2 = 1; i2 <= n3; ++i2) {
            try {
                if (!this.getMessage(i2).isSet(Flags.Flag.DELETED)) continue;
                ++n2;
                continue;
            }
            catch (MessageRemovedException messageRemovedException) {
                // empty catch block
            }
        }
        return n2;
    }

    public abstract Message getMessage(int var1) throws MessagingException;

    public synchronized Message[] getMessages(int n2, int n3) throws MessagingException {
        Message[] messageArray = new Message[n3 - n2 + 1];
        for (int i2 = n2; i2 <= n3; ++i2) {
            messageArray[i2 - n2] = this.getMessage(i2);
        }
        return messageArray;
    }

    public synchronized Message[] getMessages(int[] nArray) throws MessagingException {
        int n2 = nArray.length;
        Message[] messageArray = new Message[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            messageArray[i2] = this.getMessage(nArray[i2]);
        }
        return messageArray;
    }

    public synchronized Message[] getMessages() throws MessagingException {
        if (!this.isOpen()) {
            throw new IllegalStateException("Folder not open");
        }
        int n2 = this.getMessageCount();
        Message[] messageArray = new Message[n2];
        for (int i2 = 1; i2 <= n2; ++i2) {
            messageArray[i2 - 1] = this.getMessage(i2);
        }
        return messageArray;
    }

    public abstract void appendMessages(Message[] var1) throws MessagingException;

    public void fetch(Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
    }

    public synchronized void setFlags(Message[] messageArray, Flags flags, boolean bl2) throws MessagingException {
        for (int i2 = 0; i2 < messageArray.length; ++i2) {
            try {
                messageArray[i2].setFlags(flags, bl2);
                continue;
            }
            catch (MessageRemovedException messageRemovedException) {
                // empty catch block
            }
        }
    }

    public synchronized void setFlags(int n2, int n3, Flags flags, boolean bl2) throws MessagingException {
        for (int i2 = n2; i2 <= n3; ++i2) {
            try {
                Message message = this.getMessage(i2);
                message.setFlags(flags, bl2);
                continue;
            }
            catch (MessageRemovedException messageRemovedException) {
                // empty catch block
            }
        }
    }

    public synchronized void setFlags(int[] nArray, Flags flags, boolean bl2) throws MessagingException {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            try {
                Message message = this.getMessage(nArray[i2]);
                message.setFlags(flags, bl2);
                continue;
            }
            catch (MessageRemovedException messageRemovedException) {
                // empty catch block
            }
        }
    }

    public void copyMessages(Message[] messageArray, Folder folder) throws MessagingException {
        if (!folder.exists()) {
            throw new FolderNotFoundException(new StringBuffer().append(folder.getFullName()).append(" does not exist").toString(), folder);
        }
        folder.appendMessages(messageArray);
    }

    public abstract Message[] expunge() throws MessagingException;

    public Message[] search(SearchTerm searchTerm) throws MessagingException {
        return this.search(searchTerm, this.getMessages());
    }

    public Message[] search(SearchTerm searchTerm, Message[] messageArray) throws MessagingException {
        Vector<Message> vector = new Vector<Message>();
        for (int i2 = 0; i2 < messageArray.length; ++i2) {
            try {
                if (!messageArray[i2].match(searchTerm)) continue;
                vector.addElement(messageArray[i2]);
                continue;
            }
            catch (MessageRemovedException messageRemovedException) {
                // empty catch block
            }
        }
        Object[] objectArray = new Message[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized void addConnectionListener(ConnectionListener connectionListener) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new Vector();
        }
        this.connectionListeners.addElement(connectionListener);
    }

    public synchronized void removeConnectionListener(ConnectionListener connectionListener) {
        if (this.connectionListeners != null) {
            this.connectionListeners.removeElement(connectionListener);
        }
    }

    protected void notifyConnectionListeners(int n2) {
        if (this.connectionListeners != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent((Object)this, n2);
            this.queueEvent((MailEvent)connectionEvent, this.connectionListeners);
        }
        if (n2 == 3) {
            this.terminateQueue();
        }
    }

    public synchronized void addFolderListener(FolderListener folderListener) {
        if (this.folderListeners == null) {
            this.folderListeners = new Vector();
        }
        this.folderListeners.addElement(folderListener);
    }

    public synchronized void removeFolderListener(FolderListener folderListener) {
        if (this.folderListeners != null) {
            this.folderListeners.removeElement(folderListener);
        }
    }

    protected void notifyFolderListeners(int n2) {
        if (this.folderListeners != null) {
            FolderEvent folderEvent = new FolderEvent((Object)this, this, n2);
            this.queueEvent((MailEvent)folderEvent, this.folderListeners);
        }
        this.store.notifyFolderListeners(n2, this);
    }

    protected void notifyFolderRenamedListeners(Folder folder) {
        if (this.folderListeners != null) {
            FolderEvent folderEvent = new FolderEvent((Object)this, this, folder, 3);
            this.queueEvent((MailEvent)folderEvent, this.folderListeners);
        }
        this.store.notifyFolderRenamedListeners(this, folder);
    }

    public synchronized void addMessageCountListener(MessageCountListener messageCountListener) {
        if (this.messageCountListeners == null) {
            this.messageCountListeners = new Vector();
        }
        this.messageCountListeners.addElement(messageCountListener);
    }

    public synchronized void removeMessageCountListener(MessageCountListener messageCountListener) {
        if (this.messageCountListeners != null) {
            this.messageCountListeners.removeElement(messageCountListener);
        }
    }

    protected void notifyMessageAddedListeners(Message[] messageArray) {
        if (this.messageCountListeners == null) {
            return;
        }
        MessageCountEvent messageCountEvent = new MessageCountEvent(this, 1, false, messageArray);
        this.queueEvent((MailEvent)messageCountEvent, this.messageCountListeners);
    }

    protected void notifyMessageRemovedListeners(boolean bl2, Message[] messageArray) {
        if (this.messageCountListeners == null) {
            return;
        }
        MessageCountEvent messageCountEvent = new MessageCountEvent(this, 2, bl2, messageArray);
        this.queueEvent((MailEvent)messageCountEvent, this.messageCountListeners);
    }

    public synchronized void addMessageChangedListener(MessageChangedListener messageChangedListener) {
        if (this.messageChangedListeners == null) {
            this.messageChangedListeners = new Vector();
        }
        this.messageChangedListeners.addElement(messageChangedListener);
    }

    public synchronized void removeMessageChangedListener(MessageChangedListener messageChangedListener) {
        if (this.messageChangedListeners != null) {
            this.messageChangedListeners.removeElement(messageChangedListener);
        }
    }

    protected void notifyMessageChangedListeners(int n2, Message message) {
        if (this.messageChangedListeners == null) {
            return;
        }
        MessageChangedEvent messageChangedEvent = new MessageChangedEvent((Object)this, n2, message);
        this.queueEvent((MailEvent)messageChangedEvent, this.messageChangedListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEvent(MailEvent mailEvent, Vector vector) {
        Object object = this.qLock;
        synchronized (object) {
            if (this.q == null) {
                this.q = new EventQueue();
            }
        }
        object = (Vector)vector.clone();
        this.q.enqueue(mailEvent, (Vector)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateQueue() {
        Object object = this.qLock;
        synchronized (object) {
            if (this.q != null) {
                Vector vector = new Vector();
                vector.setSize(1);
                this.q.enqueue((MailEvent)new TerminatorEvent(), vector);
                this.q = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.terminateQueue();
    }

    public String toString() {
        String string = this.getFullName();
        if (string != null) {
            return string;
        }
        return super.toString();
    }
}

