/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.javax.mail_1_4_7;

import java.util.Vector;
import macromedia.externals.javax.mail_1_4_7.EventQueue;
import macromedia.externals.javax.mail_1_4_7.event.MailEvent;

class EventQueue
implements Runnable {
    private QueueElement head = null;
    private QueueElement tail = null;
    private Thread qThread = new Thread((Runnable)this, "JavaMail-EventQueue");

    public EventQueue() {
        this.qThread.setDaemon(true);
        this.qThread.start();
    }

    public synchronized void enqueue(MailEvent mailEvent, Vector vector) {
        QueueElement queueElement = new QueueElement(mailEvent, vector);
        if (this.head == null) {
            this.head = queueElement;
            this.tail = queueElement;
        } else {
            queueElement.next = this.head;
            this.head.prev = queueElement;
            this.head = queueElement;
        }
        this.notifyAll();
    }

    private synchronized QueueElement dequeue() throws InterruptedException {
        while (this.tail == null) {
            this.wait();
        }
        QueueElement queueElement = this.tail;
        this.tail = queueElement.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        queueElement.next = null;
        queueElement.prev = null;
        return queueElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (true) {
                QueueElement queueElement = this.dequeue();
                MailEvent mailEvent = queueElement.event;
                Vector vector = queueElement.vector;
                for (int i2 = 0; i2 < vector.size(); ++i2) {
                    try {
                        mailEvent.dispatch(vector.elementAt(i2));
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof InterruptedException) return;
                    }
                }
                queueElement = null;
                mailEvent = null;
                vector = null;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void stop() {
        if (this.qThread != null) {
            this.qThread.interrupt();
            this.qThread = null;
        }
    }
}

