/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.util.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import macromedia.externals.com.sun.mail_1_4_7.smtp.SMTPTransport;
import macromedia.externals.com.sun.mail_1_4_7.util.logging.LogManagerProperties;
import macromedia.externals.com.sun.mail_1_4_7.util.logging.MailHandler;
import macromedia.externals.javax.mail_1_4_7.Address;
import macromedia.externals.javax.mail_1_4_7.Authenticator;
import macromedia.externals.javax.mail_1_4_7.BodyPart;
import macromedia.externals.javax.mail_1_4_7.Message;
import macromedia.externals.javax.mail_1_4_7.MessageContext;
import macromedia.externals.javax.mail_1_4_7.MessagingException;
import macromedia.externals.javax.mail_1_4_7.Multipart;
import macromedia.externals.javax.mail_1_4_7.Part;
import macromedia.externals.javax.mail_1_4_7.SendFailedException;
import macromedia.externals.javax.mail_1_4_7.Session;
import macromedia.externals.javax.mail_1_4_7.Transport;
import macromedia.externals.javax.mail_1_4_7.internet.AddressException;
import macromedia.externals.javax.mail_1_4_7.internet.ContentType;
import macromedia.externals.javax.mail_1_4_7.internet.InternetAddress;
import macromedia.externals.javax.mail_1_4_7.internet.MimeBodyPart;
import macromedia.externals.javax.mail_1_4_7.internet.MimeMessage;
import macromedia.externals.javax.mail_1_4_7.internet.MimeMultipart;
import macromedia.externals.javax.mail_1_4_7.internet.MimePart;
import macromedia.externals.javax.mail_1_4_7.internet.MimeUtility;
import macromedia.externals.javax.mail_1_4_7.util.ByteArrayDataSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class MailHandler
extends Handler {
    private static final Filter[] EMPTY_FILTERS;
    private static final Formatter[] EMPTY_FORMATTERS;
    private static final int MIN_HEADER_SIZE = 1024;
    private static final int offValue;
    private static final GetAndSetContext GET_AND_SET_CCL;
    private static final ThreadLocal MUTEX;
    private static final Object MUTEX_PUBLISH;
    private static final Object MUTEX_REPORT;
    private static final Method REMOVE;
    private volatile boolean sealed;
    private boolean isWriting;
    private Properties mailProps;
    private Authenticator auth;
    private Session session;
    private LogRecord[] data;
    private int size;
    private int capacity;
    private Comparator comparator;
    private Formatter subjectFormatter;
    private Level pushLevel;
    private Filter pushFilter;
    private Filter[] attachmentFilters;
    private Formatter[] attachmentFormatters;
    private Formatter[] attachmentNames;
    private FileTypeMap contentTypes;
    static /* synthetic */ Class class$com$sun$mail$util$logging$MailHandler;
    static /* synthetic */ Class class$java$lang$ThreadLocal;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class array$Ljava$util$logging$Filter;
    static /* synthetic */ Class array$Ljava$util$logging$Formatter;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$String;

    public MailHandler() {
        this.init(true);
        this.sealed = true;
    }

    public MailHandler(int n2) {
        this.init(true);
        this.sealed = true;
        this.setCapacity0(n2);
    }

    public MailHandler(Properties properties) {
        this.init(false);
        this.sealed = true;
        this.setMailProperties0(properties);
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        int n2 = this.getLevel().intValue();
        if (logRecord.getLevel().intValue() < n2 || n2 == offValue) {
            return false;
        }
        Filter filter = this.getFilter();
        if (filter == null || filter.isLoggable(logRecord)) {
            return true;
        }
        return this.isAttachmentLoggable(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void publish(LogRecord logRecord) {
        if (this.tryMutex()) {
            try {
                if (!this.isLoggable(logRecord)) return;
                logRecord.getSourceMethodName();
                this.publish0(logRecord);
                return;
            }
            finally {
                this.releaseMutex();
            }
        } else {
            this.reportUnPublishedError(logRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish0(LogRecord logRecord) {
        Object object;
        boolean bl2;
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.size == this.data.length && this.size < this.capacity) {
                this.grow();
            }
            if (this.size < this.data.length) {
                this.data[this.size] = logRecord;
                ++this.size;
                bl2 = this.isPushable(logRecord);
                object = bl2 || this.size >= this.capacity ? this.writeLogRecords(1) : null;
            } else {
                bl2 = false;
                object = null;
            }
        }
        if (object != null) {
            this.send(object, bl2, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportUnPublishedError(LogRecord logRecord) {
        if (MUTEX_PUBLISH.equals(MUTEX.get())) {
            MUTEX.set(MUTEX_REPORT);
            try {
                String string;
                Object object;
                if (logRecord != null) {
                    object = new SimpleFormatter();
                    string = new StringBuffer().append("Log record ").append(logRecord.getSequenceNumber()).append(" was not published. ").append(this.head((Formatter)object)).append(this.format((Formatter)object, logRecord)).append(this.tail((Formatter)object, "")).toString();
                } else {
                    string = null;
                }
                object = new IllegalStateException(new StringBuffer().append("Recursive publish detected by thread ").append(Thread.currentThread()).toString());
                this.reportError(string, (Exception)object, 1);
            }
            finally {
                MUTEX.set(MUTEX_PUBLISH);
            }
        }
    }

    private boolean tryMutex() {
        if (MUTEX.get() == null) {
            MUTEX.set(MUTEX_PUBLISH);
            return true;
        }
        return false;
    }

    private void releaseMutex() {
        if (REMOVE != null) {
            try {
                REMOVE.invoke((Object)MUTEX, (Object[])null);
            }
            catch (RuntimeException runtimeException) {
                MUTEX.set(null);
            }
            catch (Exception exception) {
                MUTEX.set(null);
            }
        } else {
            MUTEX.set(null);
        }
    }

    public void push() {
        this.push(true, 2);
    }

    @Override
    public void flush() {
        this.push(false, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.getAndSetContextClassLoader();
        try {
            MessageContext messageContext = null;
            MailHandler mailHandler = this;
            synchronized (mailHandler) {
                super.setLevel(Level.OFF);
                try {
                    messageContext = this.writeLogRecords(3);
                }
                finally {
                    if (this.capacity > 0) {
                        this.capacity = -this.capacity;
                    }
                    if (this.size == 0 && this.data.length != 1) {
                        this.data = new LogRecord[1];
                    }
                }
            }
            if (messageContext != null) {
                this.send(messageContext, false, 3);
            }
        }
        finally {
            this.setContextClassLoader(object);
        }
    }

    @Override
    public synchronized void setLevel(Level level) {
        if (this.capacity > 0) {
            super.setLevel(level);
        } else {
            if (level == null) {
                throw new NullPointerException();
            }
            this.checkAccess();
        }
    }

    public final synchronized Level getPushLevel() {
        return this.pushLevel;
    }

    public final synchronized void setPushLevel(Level level) {
        this.checkAccess();
        if (level == null) {
            throw new NullPointerException();
        }
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.pushLevel = level;
    }

    public final synchronized Filter getPushFilter() {
        return this.pushFilter;
    }

    public final synchronized void setPushFilter(Filter filter) {
        this.checkAccess();
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.pushFilter = filter;
    }

    public final synchronized Comparator getComparator() {
        return this.comparator;
    }

    public final synchronized void setComparator(Comparator comparator) {
        this.checkAccess();
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.comparator = comparator;
    }

    public final synchronized int getCapacity() {
        if (!($assertionsDisabled || this.capacity != Integer.MIN_VALUE && this.capacity != 0)) {
            throw new AssertionError(this.capacity);
        }
        return Math.abs(this.capacity);
    }

    public final synchronized Authenticator getAuthenticator() {
        this.checkAccess();
        return this.auth;
    }

    public final void setAuthenticator(Authenticator authenticator) {
        this.setAuthenticator0(authenticator);
    }

    public final void setAuthenticator(char[] cArray) {
        if (cArray == null) {
            this.setAuthenticator0((Authenticator)null);
        } else {
            this.setAuthenticator0((Authenticator)new DefaultAuthenticator(new String(cArray)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAuthenticator0(Authenticator authenticator) {
        Session session;
        this.checkAccess();
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.auth = authenticator;
            session = this.fixUpSession();
        }
        this.verifySettings(session);
    }

    public final void setMailProperties(Properties properties) {
        this.setMailProperties0(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMailProperties0(Properties properties) {
        Session session;
        this.checkAccess();
        properties = (Properties)properties.clone();
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.mailProps = properties;
            session = this.fixUpSession();
        }
        this.verifySettings(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Properties getMailProperties() {
        Properties properties;
        this.checkAccess();
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            properties = this.mailProps;
        }
        return (Properties)properties.clone();
    }

    public final Filter[] getAttachmentFilters() {
        return (Filter[])this.readOnlyAttachmentFilters().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttachmentFilters(Filter[] filterArray) {
        this.checkAccess();
        filterArray = (Filter[])MailHandler.copyOf((Object[])filterArray, (int)filterArray.length, (Class)(array$Ljava$util$logging$Filter == null ? (array$Ljava$util$logging$Filter = MailHandler.class$((String)"[Ljava.util.logging.Filter;")) : array$Ljava$util$logging$Filter));
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.attachmentFormatters.length != filterArray.length) {
                throw MailHandler.attachmentMismatch((int)this.attachmentFormatters.length, (int)filterArray.length);
            }
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.attachmentFilters = filterArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Formatter[] getAttachmentFormatters() {
        Formatter[] formatterArray;
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            formatterArray = this.attachmentFormatters;
        }
        return (Formatter[])formatterArray.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttachmentFormatters(Formatter[] formatterArray) {
        this.checkAccess();
        if (formatterArray.length == 0) {
            formatterArray = MailHandler.emptyFormatterArray();
        } else {
            formatterArray = (Formatter[])MailHandler.copyOf((Object[])formatterArray, (int)formatterArray.length, (Class)(array$Ljava$util$logging$Formatter == null ? (array$Ljava$util$logging$Formatter = MailHandler.class$((String)"[Ljava.util.logging.Formatter;")) : array$Ljava$util$logging$Formatter));
            for (int i2 = 0; i2 < formatterArray.length; ++i2) {
                if (formatterArray[i2] != null) continue;
                throw new NullPointerException(MailHandler.atIndexMsg((int)i2));
            }
        }
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.attachmentFormatters = formatterArray;
            this.fixUpAttachmentFilters();
            this.fixUpAttachmentNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Formatter[] getAttachmentNames() {
        Formatter[] formatterArray;
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            formatterArray = this.attachmentNames;
        }
        return (Formatter[])formatterArray.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttachmentNames(String[] stringArray) {
        this.checkAccess();
        Formatter[] formatterArray = stringArray.length == 0 ? MailHandler.emptyFormatterArray() : new Formatter[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (string != null) {
                if (string.length() <= 0) {
                    throw new IllegalArgumentException(MailHandler.atIndexMsg((int)i2));
                }
            } else {
                throw new NullPointerException(MailHandler.atIndexMsg((int)i2));
            }
            formatterArray[i2] = new TailNameFormatter(string);
        }
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.attachmentFormatters.length != stringArray.length) {
                throw MailHandler.attachmentMismatch((int)this.attachmentFormatters.length, (int)stringArray.length);
            }
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.attachmentNames = formatterArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttachmentNames(Formatter[] formatterArray) {
        this.checkAccess();
        formatterArray = (Formatter[])MailHandler.copyOf((Object[])formatterArray, (int)formatterArray.length, (Class)(array$Ljava$util$logging$Formatter == null ? (array$Ljava$util$logging$Formatter = MailHandler.class$((String)"[Ljava.util.logging.Formatter;")) : array$Ljava$util$logging$Formatter));
        for (int i2 = 0; i2 < formatterArray.length; ++i2) {
            if (formatterArray[i2] != null) continue;
            throw new NullPointerException(MailHandler.atIndexMsg((int)i2));
        }
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.attachmentFormatters.length != formatterArray.length) {
                throw MailHandler.attachmentMismatch((int)this.attachmentFormatters.length, (int)formatterArray.length);
            }
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.attachmentNames = formatterArray;
        }
    }

    public final synchronized Formatter getSubject() {
        return this.subjectFormatter;
    }

    public final void setSubject(String string) {
        if (string == null) {
            this.checkAccess();
            throw new NullPointerException();
        }
        this.setSubject((Formatter)new TailNameFormatter(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSubject(Formatter formatter) {
        this.checkAccess();
        if (formatter == null) {
            throw new NullPointerException();
        }
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.subjectFormatter = formatter;
        }
    }

    protected void reportError(String string, Exception exception, int n2) {
        if (string != null) {
            super.reportError(new StringBuffer().append(Level.SEVERE.getName()).append(": ").append(string).toString(), exception, n2);
        } else {
            super.reportError(null, exception, n2);
        }
    }

    final void checkAccess() {
        if (this.sealed) {
            LogManagerProperties.getLogManager().checkAccess();
        }
    }

    final String contentTypeOf(String string) {
        if (string != null && string.length() > 0) {
            int n2 = 25;
            if (string.length() > 25) {
                string = string.substring(0, 25);
            }
            try {
                String string2 = this.getEncodingName();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(string2));
                if (!$assertionsDisabled && !byteArrayInputStream.markSupported()) {
                    throw new AssertionError((Object)byteArrayInputStream.getClass().getName());
                }
                return URLConnection.guessContentTypeFromStream(byteArrayInputStream);
            }
            catch (IOException iOException) {
                this.reportError(iOException.getMessage(), (Exception)iOException, 5);
            }
        }
        return null;
    }

    final boolean isMissingContent(Message message, Throwable throwable) {
        block4: {
            for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
                throwable = throwable2;
            }
            try {
                message.writeTo((OutputStream)new ByteArrayOutputStream(1024));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                if (MailHandler.isEmpty((String)string) || exception.getClass() != throwable.getClass()) break block4;
                return string.equals(throwable.getMessage());
            }
        }
        return false;
    }

    private void reportError(Message message, Exception exception, int n2) {
        try {
            super.reportError(this.toRawString(message), exception, n2);
        }
        catch (MessagingException messagingException) {
            this.reportError(this.toMsgString((Throwable)messagingException), exception, n2);
        }
        catch (IOException iOException) {
            this.reportError(this.toMsgString((Throwable)iOException), exception, n2);
        }
    }

    private String getContentType(String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String string2 = this.contentTypes.getContentType(string);
        if ("application/octet-stream".equalsIgnoreCase(string2)) {
            return null;
        }
        return string2;
    }

    private String getEncodingName() {
        String string = this.getEncoding();
        if (string == null) {
            string = MimeUtility.getDefaultJavaCharset();
        }
        return string;
    }

    private void setContent(MimeBodyPart mimeBodyPart, CharSequence charSequence, String string) throws MessagingException {
        String string2 = this.getEncodingName();
        if (string != null && !"text/plain".equalsIgnoreCase(string)) {
            string = this.contentWithEncoding(string, string2);
            try {
                ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(charSequence.toString(), string);
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
            }
            catch (IOException iOException) {
                this.reportError(iOException.getMessage(), (Exception)iOException, 5);
                mimeBodyPart.setText(charSequence.toString(), string2);
            }
        } else {
            mimeBodyPart.setText(charSequence.toString(), MimeUtility.mimeCharset((String)string2));
        }
    }

    private String contentWithEncoding(String string, String string2) {
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        try {
            ContentType contentType = new ContentType(string);
            contentType.setParameter("charset", MimeUtility.mimeCharset((String)string2));
            string2 = contentType.toString();
            if (!MailHandler.isEmpty((String)string2)) {
                string = string2;
            }
        }
        catch (MessagingException messagingException) {
            this.reportError(string, (Exception)((Object)messagingException), 5);
        }
        return string;
    }

    private synchronized void setCapacity0(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Capacity must be greater than zero.");
        }
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.capacity = this.capacity < 0 ? -n2 : n2;
    }

    private synchronized Filter[] readOnlyAttachmentFilters() {
        return this.attachmentFilters;
    }

    private static Formatter[] emptyFormatterArray() {
        return EMPTY_FORMATTERS;
    }

    private static Filter[] emptyFilterArray() {
        return EMPTY_FILTERS;
    }

    private boolean fixUpAttachmentNames() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        boolean bl2 = false;
        int n2 = this.attachmentNames.length;
        int n3 = this.attachmentFormatters.length;
        if (n2 != n3) {
            this.attachmentNames = (Formatter[])MailHandler.copyOf((Object[])this.attachmentNames, (int)n3);
            boolean bl3 = bl2 = n2 != 0;
        }
        if (n3 == 0) {
            this.attachmentNames = MailHandler.emptyFormatterArray();
            if (!$assertionsDisabled && this.attachmentNames.length != 0) {
                throw new AssertionError();
            }
        } else {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (this.attachmentNames[i2] != null) continue;
                this.attachmentNames[i2] = new TailNameFormatter(this.toString(this.attachmentFormatters[i2]));
            }
        }
        return bl2;
    }

    private boolean fixUpAttachmentFilters() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        boolean bl2 = false;
        int n2 = this.attachmentFilters.length;
        int n3 = this.attachmentFormatters.length;
        if (n2 != n3) {
            this.attachmentFilters = (Filter[])MailHandler.copyOf((Object[])this.attachmentFilters, (int)n3);
            boolean bl3 = bl2 = n2 != 0;
        }
        if (n3 == 0) {
            this.attachmentFilters = MailHandler.emptyFilterArray();
            if (!$assertionsDisabled && this.attachmentFilters.length != 0) {
                throw new AssertionError();
            }
        }
        return bl2;
    }

    private static Object[] copyOf(Object[] objectArray, int n2) {
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
        System.arraycopy(objectArray, 0, objectArray2, 0, Math.min(objectArray.length, n2));
        return objectArray2;
    }

    private static Object[] copyOf(Object[] objectArray, int n2, Class clazz) {
        if (clazz == objectArray.getClass()) {
            return (Object[])objectArray.clone();
        }
        Object[] objectArray2 = (Object[])Array.newInstance(clazz.getComponentType(), n2);
        System.arraycopy(objectArray, 0, objectArray2, 0, Math.min(n2, objectArray.length));
        return objectArray2;
    }

    private void reset() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.size < this.data.length) {
            Arrays.fill(this.data, 0, this.size, null);
        } else {
            Arrays.fill(this.data, null);
        }
        this.size = 0;
    }

    private void grow() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        int n2 = this.data.length;
        int n3 = n2 + (n2 >> 1) + 1;
        if (n3 > this.capacity || n3 < n2) {
            n3 = this.capacity;
        }
        if (!$assertionsDisabled && n2 == this.capacity) {
            throw new AssertionError(n2);
        }
        this.data = (LogRecord[])MailHandler.copyOf((Object[])this.data, (int)n3);
    }

    private synchronized void init(boolean bl2) {
        LogManager logManager = LogManagerProperties.getLogManager();
        String string = this.getClass().getName();
        this.mailProps = new Properties();
        this.contentTypes = FileTypeMap.getDefaultFileTypeMap();
        this.initErrorManager(logManager, string);
        this.initLevel(logManager, string);
        this.initFilter(logManager, string);
        this.initCapacity(logManager, string);
        this.initAuthenticator(logManager, string);
        this.initEncoding(logManager, string);
        this.initFormatter(logManager, string);
        this.initComparator(logManager, string);
        this.initPushLevel(logManager, string);
        this.initPushFilter(logManager, string);
        this.initSubject(logManager, string);
        this.initAttachmentFormaters(logManager, string);
        this.initAttachmentFilters(logManager, string);
        this.initAttachmentNames(logManager, string);
        if (bl2 && logManager.getProperty(string.concat(".verify")) != null) {
            this.verifySettings(this.initSession());
        }
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private static boolean hasValue(String string) {
        return !MailHandler.isEmpty((String)string) && !"null".equalsIgnoreCase(string);
    }

    private void initAttachmentFilters(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.attachmentFormatters == null) {
            throw new AssertionError();
        }
        String string2 = logManager.getProperty(string.concat(".attachment.filters"));
        if (string2 != null && string2.length() > 0) {
            String[] stringArray = string2.split(",");
            Filter[] filterArray = new Filter[stringArray.length];
            for (int i2 = 0; i2 < filterArray.length; ++i2) {
                stringArray[i2] = stringArray[i2].trim();
                if ("null".equalsIgnoreCase(stringArray[i2])) continue;
                try {
                    filterArray[i2] = LogManagerProperties.newFilter((String)stringArray[i2]);
                    continue;
                }
                catch (SecurityException securityException) {
                    throw securityException;
                }
                catch (Exception exception) {
                    this.reportError(exception.getMessage(), exception, 4);
                }
            }
            this.attachmentFilters = filterArray;
            if (this.fixUpAttachmentFilters()) {
                this.reportError("Attachment filters.", (Exception)MailHandler.attachmentMismatch((String)"Length mismatch."), 4);
            }
        } else {
            this.attachmentFilters = MailHandler.emptyFilterArray();
            this.fixUpAttachmentFilters();
        }
    }

    private void initAttachmentFormaters(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String string2 = logManager.getProperty(string.concat(".attachment.formatters"));
        if (string2 != null && string2.length() > 0) {
            String[] stringArray = string2.split(",");
            Formatter[] formatterArray = stringArray.length == 0 ? MailHandler.emptyFormatterArray() : new Formatter[stringArray.length];
            for (int i2 = 0; i2 < formatterArray.length; ++i2) {
                Exception exception;
                stringArray[i2] = stringArray[i2].trim();
                if (!"null".equalsIgnoreCase(stringArray[i2])) {
                    try {
                        formatterArray[i2] = LogManagerProperties.newFormatter((String)stringArray[i2]);
                        if (!(formatterArray[i2] instanceof TailNameFormatter)) continue;
                        formatterArray[i2] = new SimpleFormatter();
                        exception = new ClassNotFoundException(formatterArray[i2].toString());
                        this.reportError("Attachment formatter.", exception, 4);
                        continue;
                    }
                    catch (SecurityException securityException) {
                        throw securityException;
                    }
                    catch (Exception exception2) {
                        formatterArray[i2] = new SimpleFormatter();
                        this.reportError(exception2.getMessage(), exception2, 4);
                        continue;
                    }
                }
                formatterArray[i2] = new SimpleFormatter();
                exception = new NullPointerException(MailHandler.atIndexMsg((int)i2));
                this.reportError("Attachment formatter.", exception, 4);
            }
            this.attachmentFormatters = formatterArray;
        } else {
            this.attachmentFormatters = MailHandler.emptyFormatterArray();
        }
    }

    private void initAttachmentNames(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.attachmentFormatters == null) {
            throw new AssertionError();
        }
        String string2 = logManager.getProperty(string.concat(".attachment.names"));
        if (string2 != null && string2.length() > 0) {
            String[] stringArray = string2.split(",");
            Formatter[] formatterArray = new Formatter[stringArray.length];
            for (int i2 = 0; i2 < formatterArray.length; ++i2) {
                stringArray[i2] = stringArray[i2].trim();
                if (!"null".equalsIgnoreCase(stringArray[i2])) {
                    try {
                        try {
                            formatterArray[i2] = LogManagerProperties.newFormatter((String)stringArray[i2]);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            formatterArray[i2] = new TailNameFormatter(stringArray[i2]);
                        }
                        catch (ClassCastException classCastException) {
                            formatterArray[i2] = new TailNameFormatter(stringArray[i2]);
                        }
                        continue;
                    }
                    catch (SecurityException securityException) {
                        throw securityException;
                    }
                    catch (Exception exception) {
                        this.reportError(exception.getMessage(), exception, 4);
                        continue;
                    }
                }
                NullPointerException nullPointerException = new NullPointerException(MailHandler.atIndexMsg((int)i2));
                this.reportError("Attachment names.", (Exception)nullPointerException, 4);
            }
            this.attachmentNames = formatterArray;
            if (this.fixUpAttachmentNames()) {
                this.reportError("Attachment names.", (Exception)MailHandler.attachmentMismatch((String)"Length mismatch."), 4);
            }
        } else {
            this.attachmentNames = MailHandler.emptyFormatterArray();
            this.fixUpAttachmentNames();
        }
    }

    private void initAuthenticator(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String string2 = logManager.getProperty(string.concat(".authenticator"));
        if (MailHandler.hasValue((String)string2)) {
            try {
                this.auth = LogManagerProperties.newAuthenticator((String)string2);
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.auth = new DefaultAuthenticator(string2);
            }
            catch (ClassCastException classCastException) {
                this.auth = new DefaultAuthenticator(string2);
            }
            catch (Exception exception) {
                this.reportError(exception.getMessage(), exception, 4);
            }
        }
    }

    private void initLevel(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            String string2 = logManager.getProperty(string.concat(".level"));
            if (string2 != null) {
                super.setLevel(Level.parse(string2));
            } else {
                super.setLevel(Level.WARNING);
            }
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RuntimeException runtimeException) {
            this.reportError(runtimeException.getMessage(), (Exception)runtimeException, 4);
            try {
                super.setLevel(Level.WARNING);
            }
            catch (RuntimeException runtimeException2) {
                this.reportError(runtimeException2.getMessage(), (Exception)runtimeException2, 4);
            }
        }
    }

    private void initFilter(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            String string2 = logManager.getProperty(string.concat(".filter"));
            if (MailHandler.hasValue((String)string2)) {
                super.setFilter(LogManagerProperties.newFilter((String)string2));
            }
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            this.reportError(exception.getMessage(), exception, 4);
        }
    }

    private void initCapacity(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        int n2 = 1000;
        try {
            String string2 = logManager.getProperty(string.concat(".capacity"));
            if (string2 != null) {
                this.setCapacity0(Integer.parseInt(string2));
            } else {
                this.setCapacity0(1000);
            }
        }
        catch (RuntimeException runtimeException) {
            this.reportError(runtimeException.getMessage(), (Exception)runtimeException, 4);
        }
        if (this.capacity <= 0) {
            this.capacity = 1000;
        }
        this.data = new LogRecord[1];
    }

    private void initEncoding(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            super.setEncoding(logManager.getProperty(string.concat(".encoding")));
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.reportError(unsupportedEncodingException.getMessage(), (Exception)unsupportedEncodingException, 4);
        }
        catch (RuntimeException runtimeException) {
            this.reportError(runtimeException.getMessage(), (Exception)runtimeException, 4);
        }
    }

    private void initErrorManager(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String string2 = logManager.getProperty(string.concat(".errorManager"));
        if (string2 != null) {
            try {
                ErrorManager errorManager = LogManagerProperties.newErrorManager((String)string2);
                super.setErrorManager(errorManager);
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (Exception exception) {
                this.reportError(exception.getMessage(), exception, 4);
            }
        }
    }

    private void initFormatter(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String string2 = logManager.getProperty(string.concat(".formatter"));
        if (MailHandler.hasValue((String)string2)) {
            try {
                Formatter formatter = LogManagerProperties.newFormatter((String)string2);
                if (!$assertionsDisabled && formatter == null) {
                    throw new AssertionError();
                }
                if (!(formatter instanceof TailNameFormatter)) {
                    super.setFormatter(formatter);
                }
                super.setFormatter(new SimpleFormatter());
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (Exception exception) {
                this.reportError(exception.getMessage(), exception, 4);
                try {
                    super.setFormatter(new SimpleFormatter());
                }
                catch (RuntimeException runtimeException) {
                    this.reportError(runtimeException.getMessage(), (Exception)runtimeException, 4);
                }
            }
        } else {
            super.setFormatter(new SimpleFormatter());
        }
    }

    private void initComparator(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String string2 = logManager.getProperty(string.concat(".comparator"));
        if (MailHandler.hasValue((String)string2)) {
            try {
                this.comparator = LogManagerProperties.newComparator((String)string2);
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (Exception exception) {
                this.reportError(exception.getMessage(), exception, 4);
            }
        }
    }

    private void initPushLevel(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            String string2 = logManager.getProperty(string.concat(".pushLevel"));
            if (string2 != null) {
                this.pushLevel = Level.parse(string2);
            }
        }
        catch (RuntimeException runtimeException) {
            this.reportError(runtimeException.getMessage(), (Exception)runtimeException, 4);
        }
        if (this.pushLevel == null) {
            this.pushLevel = Level.OFF;
        }
    }

    private void initPushFilter(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String string2 = logManager.getProperty(string.concat(".pushFilter"));
        if (MailHandler.hasValue((String)string2)) {
            try {
                this.pushFilter = LogManagerProperties.newFilter((String)string2);
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (Exception exception) {
                this.reportError(exception.getMessage(), exception, 4);
            }
        }
    }

    private void initSubject(LogManager logManager, String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String string2 = logManager.getProperty(string.concat(".subject"));
        if (MailHandler.hasValue((String)string2)) {
            try {
                this.subjectFormatter = LogManagerProperties.newFormatter((String)string2);
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.subjectFormatter = new TailNameFormatter(string2);
            }
            catch (ClassCastException classCastException) {
                this.subjectFormatter = new TailNameFormatter(string2);
            }
            catch (Exception exception) {
                this.subjectFormatter = new TailNameFormatter(string2);
                this.reportError(exception.getMessage(), exception, 4);
            }
        }
        if (this.subjectFormatter == null) {
            this.subjectFormatter = new TailNameFormatter("");
        }
    }

    private boolean isAttachmentLoggable(LogRecord logRecord) {
        Filter[] filterArray = this.readOnlyAttachmentFilters();
        for (int i2 = 0; i2 < filterArray.length; ++i2) {
            Filter filter = filterArray[i2];
            if (filter != null && !filter.isLoggable(logRecord)) continue;
            return true;
        }
        return false;
    }

    private boolean isPushable(LogRecord logRecord) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        int n2 = this.getPushLevel().intValue();
        if (n2 == offValue || logRecord.getLevel().intValue() < n2) {
            return false;
        }
        Filter filter = this.getPushFilter();
        return filter == null || filter.isLoggable(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void push(boolean bl2, int n2) {
        if (this.tryMutex()) {
            try {
                MessageContext messageContext = this.writeLogRecords(n2);
                if (messageContext == null) return;
                this.send(messageContext, bl2, n2);
                return;
            }
            finally {
                this.releaseMutex();
            }
        } else {
            this.reportUnPublishedError(null);
        }
    }

    private void send(MessageContext messageContext, boolean bl2, int n2) {
        Message message = messageContext.getMessage();
        try {
            this.envelopeFor(messageContext, bl2);
            Transport.send((Message)message);
        }
        catch (Exception exception) {
            this.reportError(message, exception, n2);
        }
    }

    private void sort() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.comparator != null) {
            try {
                if (this.size != 1) {
                    Arrays.sort(this.data, 0, this.size, this.comparator);
                } else {
                    this.comparator.compare(this.data[0], this.data[0]);
                }
            }
            catch (RuntimeException runtimeException) {
                this.reportError(runtimeException.getMessage(), (Exception)runtimeException, 5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MessageContext writeLogRecords(int n2) {
        if (this.size == 0 || this.isWriting) {
            return null;
        }
        this.isWriting = true;
        try {
            int n3;
            this.sort();
            if (this.session == null) {
                this.initSession();
            }
            MimeMessage mimeMessage = new MimeMessage(this.session);
            mimeMessage.setDescription(this.descriptionFrom(this.comparator, this.pushLevel, this.pushFilter));
            MimeBodyPart[] mimeBodyPartArray = new MimeBodyPart[this.attachmentFormatters.length];
            StringBuffer[] stringBufferArray = new StringBuffer[mimeBodyPartArray.length];
            String string = null;
            StringBuffer stringBuffer = null;
            this.appendSubject((Message)mimeMessage, this.head(this.subjectFormatter));
            MimeBodyPart mimeBodyPart = this.createBodyPart();
            Formatter formatter = this.getFormatter();
            Filter filter = this.getFilter();
            Locale locale = null;
            for (n3 = 0; n3 < this.size; ++n3) {
                boolean bl2 = false;
                LogRecord logRecord = this.data[n3];
                this.data[n3] = null;
                Locale locale2 = this.localeFor(logRecord);
                this.appendSubject((Message)mimeMessage, this.format(this.subjectFormatter, logRecord));
                if (filter == null || filter.isLoggable(logRecord)) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        String string2 = this.head(formatter);
                        stringBuffer.append(string2);
                        string = this.contentTypeOf(string2);
                    }
                    bl2 = true;
                    stringBuffer.append(this.format(formatter, logRecord));
                    if (locale2 != null && !locale2.equals(locale)) {
                        this.appendContentLang((MimePart)mimeBodyPart, locale2);
                    }
                }
                for (int i2 = 0; i2 < mimeBodyPartArray.length; ++i2) {
                    Filter filter2 = this.attachmentFilters[i2];
                    if (filter2 != null && !filter2.isLoggable(logRecord)) continue;
                    if (mimeBodyPartArray[i2] == null) {
                        mimeBodyPartArray[i2] = this.createBodyPart(i2);
                        stringBufferArray[i2] = new StringBuffer();
                        stringBufferArray[i2].append(this.head(this.attachmentFormatters[i2]));
                        this.appendFileName((Part)mimeBodyPartArray[i2], this.head(this.attachmentNames[i2]));
                    }
                    bl2 = true;
                    this.appendFileName((Part)mimeBodyPartArray[i2], this.format(this.attachmentNames[i2], logRecord));
                    stringBufferArray[i2].append(this.format(this.attachmentFormatters[i2], logRecord));
                    if (locale2 == null || locale2.equals(locale)) continue;
                    this.appendContentLang((MimePart)mimeBodyPartArray[i2], locale2);
                }
                if (bl2) {
                    if (locale2 != null && !locale2.equals(locale)) {
                        this.appendContentLang((MimePart)mimeMessage, locale2);
                    }
                } else {
                    this.reportFilterError(logRecord);
                }
                locale = locale2;
            }
            this.size = 0;
            for (n3 = mimeBodyPartArray.length - 1; n3 >= 0; --n3) {
                if (mimeBodyPartArray[n3] == null) continue;
                this.appendFileName((Part)mimeBodyPartArray[n3], this.tail(this.attachmentNames[n3], "err"));
                stringBufferArray[n3].append(this.tail(this.attachmentFormatters[n3], ""));
                if (stringBufferArray[n3].length() > 0) {
                    String string3 = mimeBodyPartArray[n3].getFileName();
                    if (MailHandler.isEmpty((String)string3)) {
                        string3 = this.toString(this.attachmentFormatters[n3]);
                        mimeBodyPartArray[n3].setFileName(string3);
                    }
                    this.setContent(mimeBodyPartArray[n3], (CharSequence)stringBufferArray[n3], this.getContentType(string3));
                } else {
                    this.setIncompleteCopy((Message)mimeMessage);
                    mimeBodyPartArray[n3] = null;
                }
                stringBufferArray[n3] = null;
            }
            stringBufferArray = null;
            if (stringBuffer != null) {
                stringBuffer.append(this.tail(formatter, ""));
            } else {
                stringBuffer = new StringBuffer(0);
            }
            this.appendSubject((Message)mimeMessage, this.tail(this.subjectFormatter, ""));
            MimeMultipart mimeMultipart = new MimeMultipart();
            String string4 = this.getContentType(formatter.getClass().getName());
            this.setContent(mimeBodyPart, (CharSequence)stringBuffer, string4 == null ? string : string4);
            stringBuffer = null;
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            for (int i3 = 0; i3 < mimeBodyPartArray.length; ++i3) {
                if (mimeBodyPartArray[i3] == null) continue;
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPartArray[i3]);
            }
            mimeBodyPartArray = null;
            mimeMessage.setContent((Multipart)mimeMultipart);
            MessageContext messageContext = new MessageContext((Part)mimeMessage);
            return messageContext;
        }
        catch (RuntimeException runtimeException) {
            this.reportError(runtimeException.getMessage(), (Exception)runtimeException, n2);
        }
        catch (Exception exception) {
            this.reportError(exception.getMessage(), exception, n2);
        }
        finally {
            this.isWriting = false;
            if (this.size > 0) {
                this.reset();
            }
        }
        return null;
    }

    private void verifySettings(Session session) {
        if (session != null) {
            Properties properties = session.getProperties();
            Object object = properties.put("verify", "");
            if (object instanceof String) {
                String string = (String)object;
                if (MailHandler.hasValue((String)string)) {
                    this.verifySettings0(session, string);
                }
            } else if (object != null) {
                this.verifySettings0(session, object.getClass().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySettings0(Session session, String string) {
        Address[] addressArray;
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError((Object)null);
        }
        if (!"local".equals(string) && !"remote".equals(string)) {
            this.reportError("Verify must be 'local' or 'remote'.", (Exception)new IllegalArgumentException(string), 4);
            return;
        }
        String string2 = new StringBuffer().append("Local address is ").append(InternetAddress.getLocalAddress((Session)session)).append('.').toString();
        try {
            Charset.forName(this.getEncodingName());
        }
        catch (RuntimeException runtimeException) {
            addressArray = new UnsupportedEncodingException(runtimeException.toString());
            addressArray.initCause(runtimeException);
            this.reportError(string2, (Exception)addressArray, 5);
        }
        MimeMessage mimeMessage = new MimeMessage(session);
        addressArray = this;
        synchronized (addressArray) {
            this.appendSubject((Message)mimeMessage, this.head(this.subjectFormatter));
            this.appendSubject((Message)mimeMessage, this.tail(this.subjectFormatter, ""));
        }
        this.setIncompleteCopy((Message)mimeMessage);
        this.envelopeFor(new MessageContext((Part)mimeMessage), true);
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            this.reportError(string2, (Exception)((Object)messagingException), 5);
        }
        try {
            MessagingException messagingException;
            Object object;
            Address[] addressArray2;
            Transport transport;
            Object object2;
            addressArray = mimeMessage.getAllRecipients();
            if (addressArray == null) {
                addressArray = new InternetAddress[]{};
            }
            try {
                Address[] addressArray3 = object2 = addressArray.length != 0 ? addressArray : mimeMessage.getFrom();
                if (object2 == null || ((Address[])object2).length == 0) {
                    MessagingException messagingException2 = new MessagingException("No recipient or from address.");
                    this.reportError(string2, (Exception)((Object)messagingException2), 4);
                    throw messagingException2;
                }
                transport = session.getTransport(object2[0]);
                session.getProperty("mail.transport.protocol");
            }
            catch (MessagingException messagingException3) {
                try {
                    transport = session.getTransport();
                }
                catch (MessagingException messagingException4) {
                    throw MailHandler.attach((MessagingException)messagingException3, (Exception)((Object)messagingException4));
                }
            }
            object2 = null;
            if ("remote".equals(string)) {
                block52: {
                    addressArray2 = null;
                    transport.connect();
                    try {
                        try {
                            if (transport instanceof SMTPTransport) {
                                object2 = ((SMTPTransport)transport).getLocalHost();
                            }
                            transport.sendMessage((Message)mimeMessage, addressArray);
                        }
                        finally {
                            try {
                                transport.close();
                            }
                            catch (MessagingException messagingException5) {
                                addressArray2 = messagingException5;
                            }
                        }
                        this.reportUnexpectedSend(mimeMessage, string, null);
                    }
                    catch (SendFailedException sendFailedException) {
                        object = sendFailedException.getInvalidAddresses();
                        if (object != null && ((Address[])object).length != 0) {
                            this.fixUpContent(mimeMessage, string, (Throwable)sendFailedException);
                            this.reportError((Message)mimeMessage, (Exception)((Object)sendFailedException), 4);
                        }
                        if ((object = sendFailedException.getValidSentAddresses()) != null && ((Address[])object).length != 0) {
                            this.reportUnexpectedSend(mimeMessage, string, (Exception)((Object)sendFailedException));
                        }
                    }
                    catch (MessagingException messagingException6) {
                        if (this.isMissingContent((Message)mimeMessage, (Throwable)messagingException6)) break block52;
                        this.fixUpContent(mimeMessage, string, (Throwable)messagingException6);
                        this.reportError((Message)mimeMessage, (Exception)((Object)messagingException6), 4);
                    }
                }
                if (addressArray2 != null) {
                    this.fixUpContent(mimeMessage, string, (Throwable)addressArray2);
                    this.reportError((Message)mimeMessage, (Exception)addressArray2, 3);
                }
            } else {
                addressArray2 = transport.getURLName().getProtocol();
                session.getProperty("mail.host");
                session.getProperty("mail.user");
                session.getProperty(new StringBuffer().append("mail.").append((String)addressArray2).append(".host").toString());
                session.getProperty(new StringBuffer().append("mail.").append((String)addressArray2).append(".port").toString());
                session.getProperty(new StringBuffer().append("mail.").append((String)addressArray2).append(".user").toString());
                if (transport instanceof SMTPTransport) {
                    object2 = ((SMTPTransport)transport).getLocalHost();
                } else {
                    object2 = session.getProperty(new StringBuffer().append("mail.").append((String)addressArray2).append(".localhost").toString());
                    if (MailHandler.isEmpty((String)object2)) {
                        object2 = session.getProperty(new StringBuffer().append("mail.").append((String)addressArray2).append(".localaddress").toString());
                    }
                }
            }
            try {
                if (MailHandler.isEmpty((String)object2)) {
                    if (InetAddress.getLocalHost().getCanonicalHostName().length() == 0) {
                        throw new UnknownHostException();
                    }
                } else if (InetAddress.getByName((String)object2).getCanonicalHostName().length() == 0) {
                    throw new UnknownHostException((String)object2);
                }
            }
            catch (IOException iOException) {
                messagingException = new MessagingException(string2, (Exception)iOException);
                this.fixUpContent(mimeMessage, string, (Throwable)messagingException);
                this.reportError((Message)mimeMessage, (Exception)((Object)messagingException), 4);
            }
            try {
                addressArray2 = new MimeMultipart();
                messagingException = new MimeBodyPart();
                messagingException.setDisposition("inline");
                messagingException.setDescription(string);
                this.setAcceptLang((Part)messagingException);
                this.setContent((MimeBodyPart)messagingException, (CharSequence)"", "text/plain");
                addressArray2.addBodyPart((BodyPart)messagingException);
                mimeMessage.setContent((Multipart)addressArray2);
                mimeMessage.saveChanges();
                mimeMessage.writeTo((OutputStream)new ByteArrayOutputStream(1024));
            }
            catch (IOException iOException) {
                messagingException = new MessagingException(string2, (Exception)iOException);
                this.fixUpContent(mimeMessage, string, (Throwable)messagingException);
                this.reportError((Message)mimeMessage, (Exception)((Object)messagingException), 5);
            }
            if (addressArray.length == 0) {
                throw new MessagingException("No recipient addresses.");
            }
            MailHandler.verifyAddresses((Address[])addressArray);
            addressArray2 = mimeMessage.getFrom();
            messagingException = mimeMessage.getSender();
            if (messagingException instanceof InternetAddress) {
                ((InternetAddress)messagingException).validate();
            }
            if (mimeMessage.getHeader("From", ",") != null && addressArray2.length != 0) {
                MailHandler.verifyAddresses((Address[])addressArray2);
                for (int i2 = 0; i2 < addressArray2.length; ++i2) {
                    if (!addressArray2[i2].equals((Object)messagingException)) continue;
                    MessagingException messagingException7 = new MessagingException(new StringBuffer().append("Sender address '").append((Object)messagingException).append("' equals from address.").toString());
                    throw new MessagingException(string2, (Exception)((Object)messagingException7));
                }
            } else if (messagingException == null) {
                object = new MessagingException("No from or sender address.");
                throw new MessagingException(string2, (Exception)object);
            }
            MailHandler.verifyAddresses((Address[])mimeMessage.getReplyTo());
        }
        catch (MessagingException messagingException) {
            this.fixUpContent(mimeMessage, string, (Throwable)messagingException);
            this.reportError((Message)mimeMessage, (Exception)((Object)messagingException), 4);
        }
        catch (RuntimeException runtimeException) {
            this.fixUpContent(mimeMessage, string, (Throwable)runtimeException);
            this.reportError((Message)mimeMessage, (Exception)runtimeException, 4);
        }
    }

    private static void verifyAddresses(Address[] addressArray) throws AddressException {
        if (addressArray != null) {
            for (int i2 = 0; i2 < addressArray.length; ++i2) {
                Address address = addressArray[i2];
                if (!(address instanceof InternetAddress)) continue;
                ((InternetAddress)address).validate();
            }
        }
    }

    private void reportUnexpectedSend(MimeMessage mimeMessage, String string, Exception exception) {
        MessagingException messagingException = new MessagingException("An empty message was sent.", exception);
        this.fixUpContent(mimeMessage, string, (Throwable)messagingException);
        this.reportError((Message)mimeMessage, (Exception)((Object)messagingException), 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixUpContent(MimeMessage mimeMessage, String string, Throwable throwable) {
        try {
            String string2;
            String string3;
            MimeBodyPart mimeBodyPart;
            MailHandler mailHandler = this;
            synchronized (mailHandler) {
                mimeBodyPart = this.createBodyPart();
                string3 = this.descriptionFrom(this.comparator, this.pushLevel, this.pushFilter);
                string2 = this.getClassId(this.subjectFormatter);
            }
            mimeBodyPart.setDescription(new StringBuffer().append("Formatted using ").append(throwable == null ? (class$java$lang$Throwable == null ? (class$java$lang$Throwable = MailHandler.class$((String)"java.lang.Throwable")) : class$java$lang$Throwable).getName() : throwable.getClass().getName()).append(", filtered with ").append(string).append(", and named by ").append(string2).append('.').toString());
            this.setContent(mimeBodyPart, (CharSequence)this.toMsgString(throwable), "text/plain");
            mailHandler = new MimeMultipart();
            mailHandler.addBodyPart((BodyPart)mimeBodyPart);
            mimeMessage.setContent((Multipart)mailHandler);
            mimeMessage.setDescription(string3);
            this.setAcceptLang((Part)mimeMessage);
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            this.reportError("Unable to create body.", (Exception)((Object)messagingException), 4);
        }
        catch (RuntimeException runtimeException) {
            this.reportError("Unable to create body.", (Exception)runtimeException, 4);
        }
    }

    private Session fixUpSession() {
        Session session;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.mailProps.getProperty("verify") != null) {
            session = this.initSession();
            if (!$assertionsDisabled && session != this.session) {
                throw new AssertionError();
            }
        } else {
            this.session = null;
            session = null;
        }
        return session;
    }

    private Session initSession() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String string = this.getClass().getName();
        LogManagerProperties logManagerProperties = new LogManagerProperties(this.mailProps, string);
        this.session = Session.getInstance((Properties)logManagerProperties, (Authenticator)this.auth);
        return this.session;
    }

    private void envelopeFor(MessageContext messageContext, boolean bl2) {
        Message message = messageContext.getMessage();
        Properties properties = messageContext.getSession().getProperties();
        this.setAcceptLang((Part)message);
        this.setFrom(message, properties);
        this.setRecipient(message, properties, "mail.to", Message.RecipientType.TO);
        this.setRecipient(message, properties, "mail.cc", Message.RecipientType.CC);
        this.setRecipient(message, properties, "mail.bcc", Message.RecipientType.BCC);
        this.setReplyTo(message, properties);
        this.setSender(message, properties);
        this.setMailer(message);
        this.setAutoSubmitted(message);
        if (bl2) {
            this.setPriority(message);
        }
        try {
            message.setSentDate(new Date());
        }
        catch (MessagingException messagingException) {
            this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
        }
    }

    private MimeBodyPart createBodyPart() throws MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDisposition("inline");
        mimeBodyPart.setDescription(this.descriptionFrom(this.getFormatter(), this.getFilter(), this.subjectFormatter));
        this.setAcceptLang((Part)mimeBodyPart);
        return mimeBodyPart;
    }

    private MimeBodyPart createBodyPart(int n2) throws MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDisposition("attachment");
        mimeBodyPart.setDescription(this.descriptionFrom(this.attachmentFormatters[n2], this.attachmentFilters[n2], this.attachmentNames[n2]));
        this.setAcceptLang((Part)mimeBodyPart);
        return mimeBodyPart;
    }

    private String descriptionFrom(Comparator comparator, Level level, Filter filter) {
        return new StringBuffer().append("Sorted using ").append(comparator == null ? "no comparator" : comparator.getClass().getName()).append(", pushed when ").append(level.getName()).append(", and ").append(filter == null ? "no push filter" : filter.getClass().getName()).append('.').toString();
    }

    private String descriptionFrom(Formatter formatter, Filter filter, Formatter formatter2) {
        return new StringBuffer().append("Formatted using ").append(this.getClassId(formatter)).append(", filtered with ").append(filter == null ? "no filter" : filter.getClass().getName()).append(", and named by ").append(this.getClassId(formatter2)).append('.').toString();
    }

    private String getClassId(Formatter formatter) {
        if (formatter instanceof TailNameFormatter) {
            return (class$java$lang$String == null ? (class$java$lang$String = MailHandler.class$((String)"java.lang.String")) : class$java$lang$String).getName();
        }
        return formatter.getClass().getName();
    }

    private String toString(Formatter formatter) {
        String string = formatter.toString();
        if (!MailHandler.isEmpty((String)string)) {
            return string;
        }
        return this.getClassId(formatter);
    }

    private void appendFileName(Part part, String string) {
        if (string != null) {
            if (string.length() > 0) {
                this.appendFileName0(part, string);
            }
        } else {
            this.reportNullError(5);
        }
    }

    private void appendFileName0(Part part, String string) {
        try {
            String string2 = part.getFileName();
            part.setFileName(string2 != null ? string2.concat(string) : string);
        }
        catch (MessagingException messagingException) {
            this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
        }
    }

    private void appendSubject(Message message, String string) {
        if (string != null) {
            if (string.length() > 0) {
                this.appendSubject0(message, string);
            }
        } else {
            this.reportNullError(5);
        }
    }

    private void appendSubject0(Message message, String string) {
        try {
            String string2 = this.getEncodingName();
            String string3 = message.getSubject();
            if (!$assertionsDisabled && !(message instanceof MimeMessage)) {
                throw new AssertionError();
            }
            ((MimeMessage)message).setSubject(string3 != null ? string3.concat(string) : string, MimeUtility.mimeCharset((String)string2));
        }
        catch (MessagingException messagingException) {
            this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
        }
    }

    private Locale localeFor(LogRecord logRecord) {
        Locale locale;
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        if (resourceBundle != null) {
            locale = resourceBundle.getLocale();
            if (locale == null || MailHandler.isEmpty((String)locale.getLanguage())) {
                locale = Locale.getDefault();
            }
        } else {
            locale = null;
        }
        return locale;
    }

    private void appendContentLang(MimePart mimePart, Locale locale) {
        try {
            String string = LogManagerProperties.toLanguageTag((Locale)locale);
            if (string.length() != 0) {
                String string2 = mimePart.getHeader("Content-Language", null);
                if (MailHandler.isEmpty((String)string2)) {
                    mimePart.setHeader("Content-Language", string);
                } else if (!string2.equalsIgnoreCase(string)) {
                    string = ",".concat(string);
                    int n2 = 0;
                    while ((n2 = string2.indexOf(string, n2)) > -1 && (n2 += string.length()) != string2.length() && string2.charAt(n2) != ',') {
                    }
                    if (n2 < 0) {
                        int n3 = string2.lastIndexOf("\r\n\t");
                        n3 = n3 < 0 ? 20 + string2.length() : string2.length() - n3 + 8;
                        string2 = n3 + string.length() > 76 ? string2.concat("\r\n\t".concat(string)) : string2.concat(string);
                        mimePart.setHeader("Content-Language", string2);
                    }
                }
            }
        }
        catch (MessagingException messagingException) {
            this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
        }
    }

    private void setAcceptLang(Part part) {
        try {
            String string = LogManagerProperties.toLanguageTag((Locale)Locale.getDefault());
            if (string.length() != 0) {
                part.setHeader("Accept-Language", string);
            }
        }
        catch (MessagingException messagingException) {
            this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
        }
    }

    private void reportFilterError(LogRecord logRecord) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        SimpleFormatter simpleFormatter = new SimpleFormatter();
        String string = new StringBuffer().append("Log record ").append(logRecord.getSequenceNumber()).append(" was filtered from all message parts.  ").append(this.head((Formatter)simpleFormatter)).append(this.format((Formatter)simpleFormatter, logRecord)).append(this.tail((Formatter)simpleFormatter, "")).toString();
        String string2 = new StringBuffer().append(this.getFilter()).append(", ").append(Arrays.asList(this.readOnlyAttachmentFilters())).toString();
        this.reportError(string, (Exception)new IllegalArgumentException(string2), 5);
    }

    private void reportNullError(int n2) {
        this.reportError("null", (Exception)new NullPointerException(), n2);
    }

    private String head(Formatter formatter) {
        try {
            return formatter.getHead((Handler)this);
        }
        catch (RuntimeException runtimeException) {
            this.reportError(runtimeException.getMessage(), (Exception)runtimeException, 5);
            return "";
        }
    }

    private String format(Formatter formatter, LogRecord logRecord) {
        try {
            return formatter.format(logRecord);
        }
        catch (RuntimeException runtimeException) {
            this.reportError(runtimeException.getMessage(), (Exception)runtimeException, 5);
            return "";
        }
    }

    private String tail(Formatter formatter, String string) {
        try {
            return formatter.getTail((Handler)this);
        }
        catch (RuntimeException runtimeException) {
            this.reportError(runtimeException.getMessage(), (Exception)runtimeException, 5);
            return string;
        }
    }

    private void setMailer(Message message) {
        try {
            String string;
            Class clazz = class$com$sun$mail$util$logging$MailHandler == null ? (class$com$sun$mail$util$logging$MailHandler = MailHandler.class$((String)"macromedia.externals.com.sun.mail_1_4_7.util.logging.MailHandler")) : class$com$sun$mail$util$logging$MailHandler;
            Class<?> clazz2 = this.getClass();
            if (clazz2 == clazz) {
                string = clazz.getName();
            } else {
                try {
                    string = MimeUtility.encodeText((String)clazz2.getName());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.reportError(unsupportedEncodingException.getMessage(), (Exception)unsupportedEncodingException, 5);
                    string = clazz2.getName().replaceAll("[^\\x00-\\x7F]", "\u001a");
                }
                string = MimeUtility.fold((int)10, (String)new StringBuffer().append(clazz.getName()).append(" using the ").append(string).append(" extension.").toString());
            }
            message.setHeader("X-Mailer", string);
        }
        catch (MessagingException messagingException) {
            this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
        }
    }

    private void setPriority(Message message) {
        try {
            message.setHeader("Importance", "High");
            message.setHeader("Priority", "urgent");
            message.setHeader("X-Priority", "2");
        }
        catch (MessagingException messagingException) {
            this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
        }
    }

    private void setIncompleteCopy(Message message) {
        try {
            message.setHeader("Incomplete-Copy", "");
        }
        catch (MessagingException messagingException) {
            this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
        }
    }

    private void setAutoSubmitted(Message message) {
        try {
            message.setHeader("auto-submitted", "auto-generated");
        }
        catch (MessagingException messagingException) {
            this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
        }
    }

    private void setFrom(Message message, Properties properties) {
        block6: {
            String string = properties.getProperty("mail.from");
            if (string != null && string.length() > 0) {
                try {
                    InternetAddress[] internetAddressArray = InternetAddress.parse((String)string, (boolean)false);
                    if (internetAddressArray == null || internetAddressArray.length == 0) {
                        this.setDefaultFrom(message);
                        break block6;
                    }
                    if (internetAddressArray.length == 1) {
                        message.setFrom((Address)internetAddressArray[0]);
                        break block6;
                    }
                    message.addFrom((Address[])internetAddressArray);
                }
                catch (MessagingException messagingException) {
                    this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
                    this.setDefaultFrom(message);
                }
            } else {
                this.setDefaultFrom(message);
            }
        }
    }

    private void setDefaultFrom(Message message) {
        try {
            message.setFrom();
        }
        catch (MessagingException messagingException) {
            this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
        }
    }

    private void setReplyTo(Message message, Properties properties) {
        String string = properties.getProperty("mail.reply.to");
        if (string != null && string.length() > 0) {
            try {
                InternetAddress[] internetAddressArray = InternetAddress.parse((String)string, (boolean)false);
                if (internetAddressArray != null && internetAddressArray.length > 0) {
                    message.setReplyTo((Address[])internetAddressArray);
                }
            }
            catch (MessagingException messagingException) {
                this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
            }
        }
    }

    private void setSender(Message message, Properties properties) {
        if (!$assertionsDisabled && !(message instanceof MimeMessage)) {
            throw new AssertionError(message);
        }
        String string = properties.getProperty("mail.sender");
        if (string != null && string.length() > 0) {
            try {
                InternetAddress[] internetAddressArray = InternetAddress.parse((String)string, (boolean)false);
                if (internetAddressArray != null && internetAddressArray.length > 0) {
                    ((MimeMessage)message).setSender((Address)internetAddressArray[0]);
                    if (internetAddressArray.length > 1) {
                        this.reportError("Ignoring other senders.", (Exception)((Object)MailHandler.tooManyAddresses((Address[])internetAddressArray, (int)1)), 5);
                    }
                }
            }
            catch (MessagingException messagingException) {
                this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
            }
        }
    }

    private static AddressException tooManyAddresses(Address[] addressArray, int n2) {
        String string = Arrays.asList(addressArray).subList(n2, addressArray.length).toString();
        return new AddressException(string);
    }

    private void setRecipient(Message message, Properties properties, String string, Message.RecipientType recipientType) {
        String string2 = properties.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            try {
                InternetAddress[] internetAddressArray = InternetAddress.parse((String)string2, (boolean)false);
                if (internetAddressArray != null && internetAddressArray.length > 0) {
                    message.setRecipients(recipientType, (Address[])internetAddressArray);
                }
            }
            catch (MessagingException messagingException) {
                this.reportError(messagingException.getMessage(), (Exception)((Object)messagingException), 5);
            }
        }
    }

    private String toRawString(Message message) throws MessagingException, IOException {
        if (message != null) {
            int n2 = Math.max(message.getSize() + 1024, 1024);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
            message.writeTo((OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toString("US-ASCII");
        }
        return null;
    }

    private String toMsgString(Throwable throwable) {
        if (throwable == null) {
            return "null";
        }
        String string = this.getEncodingName();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, string));
            printWriter.println(throwable.getMessage());
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            return byteArrayOutputStream.toString(string);
        }
        catch (IOException iOException) {
            return new StringBuffer().append(throwable.toString()).append(' ').append(iOException.toString()).toString();
        }
    }

    private Object getAndSetContextClassLoader() {
        try {
            return AccessController.doPrivileged(GET_AND_SET_CCL);
        }
        catch (SecurityException securityException) {
            return GET_AND_SET_CCL;
        }
    }

    private void setContextClassLoader(Object object) {
        if (object == null || object instanceof ClassLoader) {
            AccessController.doPrivileged(new GetAndSetContext(object));
        }
    }

    private static RuntimeException attachmentMismatch(String string) {
        return new IndexOutOfBoundsException(string);
    }

    private static RuntimeException attachmentMismatch(int n2, int n3) {
        return MailHandler.attachmentMismatch((String)new StringBuffer().append("Attachments mismatched, expected ").append(n2).append(" but given ").append(n3).append('.').toString());
    }

    private static MessagingException attach(MessagingException messagingException, Exception exception) {
        MessagingException messagingException2;
        if (exception != null && !messagingException.setNextException(exception) && exception instanceof MessagingException && (messagingException2 = (MessagingException)((Object)exception)).setNextException((Exception)((Object)messagingException))) {
            return messagingException2;
        }
        return messagingException;
    }

    private static String atIndexMsg(int n2) {
        return new StringBuffer().append("At index: ").append(n2).append('.').toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Method method;
        $assertionsDisabled = !(class$com$sun$mail$util$logging$MailHandler == null ? (class$com$sun$mail$util$logging$MailHandler = MailHandler.class$((String)"macromedia.externals.com.sun.mail_1_4_7.util.logging.MailHandler")) : class$com$sun$mail$util$logging$MailHandler).desiredAssertionStatus();
        EMPTY_FILTERS = new Filter[0];
        EMPTY_FORMATTERS = new Formatter[0];
        offValue = Level.OFF.intValue();
        GET_AND_SET_CCL = new GetAndSetContext((Object)(class$com$sun$mail$util$logging$MailHandler == null ? (class$com$sun$mail$util$logging$MailHandler = MailHandler.class$((String)"macromedia.externals.com.sun.mail_1_4_7.util.logging.MailHandler")) : class$com$sun$mail$util$logging$MailHandler));
        MUTEX = new ThreadLocal();
        MUTEX_PUBLISH = Level.ALL;
        MUTEX_REPORT = Level.OFF;
        try {
            method = (class$java$lang$ThreadLocal == null ? (class$java$lang$ThreadLocal = MailHandler.class$((String)"java.lang.ThreadLocal")) : class$java$lang$ThreadLocal).getMethod("remove", null);
        }
        catch (RuntimeException runtimeException) {
            method = null;
        }
        catch (Exception exception) {
            method = null;
        }
        REMOVE = method;
    }
}

