/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class UUEncoderStream
extends FilterOutputStream {
    private byte[] buffer;
    private int bufsize = 0;
    private boolean wrotePrefix = false;
    protected String name;
    protected int mode;

    public UUEncoderStream(OutputStream outputStream) {
        this(outputStream, "encoder.buf", 644);
    }

    public UUEncoderStream(OutputStream outputStream, String string) {
        this(outputStream, string, 644);
    }

    public UUEncoderStream(OutputStream outputStream, String string, int n2) {
        super(outputStream);
        this.name = string;
        this.mode = n2;
        this.buffer = new byte[45];
    }

    public void setNameMode(String string, int n2) {
        this.name = string;
        this.mode = n2;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write((int)byArray[n2 + i2]);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) throws IOException {
        this.buffer[this.bufsize++] = (byte)n2;
        if (this.bufsize == 45) {
            this.writePrefix();
            this.encode();
            this.bufsize = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.bufsize > 0) {
            this.writePrefix();
            this.encode();
        }
        this.writeSuffix();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void writePrefix() throws IOException {
        if (!this.wrotePrefix) {
            PrintStream printStream = new PrintStream(this.out, false, "utf-8");
            printStream.println(new StringBuffer().append("begin ").append(this.mode).append(" ").append(this.name).toString());
            printStream.flush();
            this.wrotePrefix = true;
        }
    }

    private void writeSuffix() throws IOException {
        PrintStream printStream = new PrintStream(this.out, false, "us-ascii");
        printStream.println(" \nend");
        printStream.flush();
    }

    private void encode() throws IOException {
        int n2 = 0;
        this.out.write((this.bufsize & 0x3F) + 32);
        while (n2 < this.bufsize) {
            byte by2;
            byte by3;
            byte by4 = this.buffer[n2++];
            if (n2 < this.bufsize) {
                by3 = this.buffer[n2++];
                by2 = n2 < this.bufsize ? this.buffer[n2++] : (byte)1;
            } else {
                by3 = 1;
                by2 = 1;
            }
            int n3 = by4 >>> 2 & 0x3F;
            int n4 = by4 << 4 & 0x30 | by3 >>> 4 & 0xF;
            int n5 = by3 << 2 & 0x3C | by2 >>> 6 & 3;
            int n6 = by2 & 0x3F;
            this.out.write(n3 + 32);
            this.out.write(n4 + 32);
            this.out.write(n5 + 32);
            this.out.write(n6 + 32);
        }
        this.out.write(10);
    }
}

