/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class QPEncoderStream
extends FilterOutputStream {
    private int count = 0;
    private int bytesPerLine;
    private boolean gotSpace = false;
    private boolean gotCR = false;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public QPEncoderStream(OutputStream outputStream, int n2) {
        super(outputStream);
        this.bytesPerLine = n2 - 1;
    }

    public QPEncoderStream(OutputStream outputStream) {
        this(outputStream, 76);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write((int)byArray[n2 + i2]);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) throws IOException {
        n2 &= 0xFF;
        if (this.gotSpace) {
            if (n2 == 13 || n2 == 10) {
                this.output(32, true);
            } else {
                this.output(32, false);
            }
            this.gotSpace = false;
        }
        if (n2 == 13) {
            this.gotCR = true;
            this.outputCRLF();
        } else {
            if (n2 == 10) {
                if (!this.gotCR) {
                    this.outputCRLF();
                }
            } else if (n2 == 32) {
                this.gotSpace = true;
            } else if (n2 < 32 || n2 >= 127 || n2 == 61) {
                this.output(n2, true);
            } else {
                this.output(n2, false);
            }
            this.gotCR = false;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.gotSpace) {
            this.output(32, true);
            this.gotSpace = false;
        }
        this.out.close();
    }

    private void outputCRLF() throws IOException {
        this.out.write(13);
        this.out.write(10);
        this.count = 0;
    }

    protected void output(int n2, boolean bl2) throws IOException {
        if (bl2) {
            if ((this.count += 3) > this.bytesPerLine) {
                this.out.write(61);
                this.out.write(13);
                this.out.write(10);
                this.count = 3;
            }
            this.out.write(61);
            this.out.write(hex[n2 >> 4]);
            this.out.write(hex[n2 & 0xF]);
        } else {
            if (++this.count > this.bytesPerLine) {
                this.out.write(61);
                this.out.write(13);
                this.out.write(10);
                this.count = 1;
            }
            this.out.write(n2);
        }
    }
}

