/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import macromedia.externals.com.sun.mail_1_4_7.util.MailSSLSocketFactory;

public class MailSSLSocketFactory
extends SSLSocketFactory {
    private boolean trustAllHosts = false;
    private String[] trustedHosts = null;
    private SSLContext sslcontext;
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private SecureRandom secureRandom;
    private SSLSocketFactory adapteeFactory = null;

    public MailSSLSocketFactory() throws GeneralSecurityException {
        this("TLS");
    }

    public MailSSLSocketFactory(String string) throws GeneralSecurityException {
        this.sslcontext = SSLContext.getInstance(string);
        this.keyManagers = null;
        this.trustManagers = new TrustManager[]{new MailTrustManager(this, null)};
        this.secureRandom = null;
        this.newAdapteeFactory();
    }

    private synchronized void newAdapteeFactory() throws KeyManagementException {
        this.sslcontext.init(this.keyManagers, this.trustManagers, this.secureRandom);
        this.adapteeFactory = this.sslcontext.getSocketFactory();
    }

    public synchronized KeyManager[] getKeyManagers() {
        return (KeyManager[])this.keyManagers.clone();
    }

    public synchronized void setKeyManagers(KeyManager[] keyManagerArray) throws GeneralSecurityException {
        this.keyManagers = (KeyManager[])keyManagerArray.clone();
        this.newAdapteeFactory();
    }

    public synchronized SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public synchronized void setSecureRandom(SecureRandom secureRandom) throws GeneralSecurityException {
        this.secureRandom = secureRandom;
        this.newAdapteeFactory();
    }

    public synchronized TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    public synchronized void setTrustManagers(TrustManager[] trustManagerArray) throws GeneralSecurityException {
        this.trustManagers = trustManagerArray;
        this.newAdapteeFactory();
    }

    public synchronized boolean isTrustAllHosts() {
        return this.trustAllHosts;
    }

    public synchronized void setTrustAllHosts(boolean bl2) {
        this.trustAllHosts = bl2;
    }

    public synchronized String[] getTrustedHosts() {
        return (String[])this.trustedHosts.clone();
    }

    public synchronized void setTrustedHosts(String[] stringArray) {
        this.trustedHosts = (String[])stringArray.clone();
    }

    public synchronized boolean isServerTrusted(String string, SSLSocket sSLSocket) {
        if (this.trustAllHosts) {
            return true;
        }
        if (this.trustedHosts != null) {
            return Arrays.asList(this.trustedHosts).contains(string);
        }
        return true;
    }

    @Override
    public synchronized Socket createSocket(Socket socket, String string, int n2, boolean bl2) throws IOException {
        return this.adapteeFactory.createSocket(socket, string, n2, bl2);
    }

    @Override
    public synchronized String[] getDefaultCipherSuites() {
        return this.adapteeFactory.getDefaultCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.adapteeFactory.getSupportedCipherSuites();
    }

    @Override
    public synchronized Socket createSocket() throws IOException {
        return this.adapteeFactory.createSocket();
    }

    @Override
    public synchronized Socket createSocket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        return this.adapteeFactory.createSocket(inetAddress, n2, inetAddress2, n3);
    }

    @Override
    public synchronized Socket createSocket(InetAddress inetAddress, int n2) throws IOException {
        return this.adapteeFactory.createSocket(inetAddress, n2);
    }

    @Override
    public synchronized Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException, UnknownHostException {
        return this.adapteeFactory.createSocket(string, n2, inetAddress, n3);
    }

    @Override
    public synchronized Socket createSocket(String string, int n2) throws IOException, UnknownHostException {
        return this.adapteeFactory.createSocket(string, n2);
    }
}

