/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import macromedia.externals.com.sun.mail_1_4_7.util.MailLogger;

public class LogOutputStream
extends OutputStream {
    protected MailLogger logger;
    protected Level level;
    private int lastb = -1;
    private byte[] buf = new byte[80];
    private int pos = 0;

    public LogOutputStream(MailLogger mailLogger) {
        this.logger = mailLogger;
        this.level = Level.FINEST;
    }

    @Override
    public void write(int n2) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        if (n2 == 13) {
            this.logBuf();
        } else if (n2 == 10) {
            if (this.lastb != 13) {
                this.logBuf();
            }
        } else {
            this.expandCapacity(1);
            this.buf[this.pos++] = (byte)n2;
        }
        this.lastb = n2;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n2;
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        n3 += n2;
        for (int i2 = n4; i2 < n3; ++i2) {
            if (byArray[i2] == 13) {
                this.expandCapacity(i2 - n4);
                System.arraycopy(byArray, n4, this.buf, this.pos, i2 - n4);
                this.pos += i2 - n4;
                this.logBuf();
                n4 = i2 + 1;
            } else if (byArray[i2] == 10) {
                if (this.lastb != 13) {
                    this.expandCapacity(i2 - n4);
                    System.arraycopy(byArray, n4, this.buf, this.pos, i2 - n4);
                    this.pos += i2 - n4;
                    this.logBuf();
                }
                n4 = i2 + 1;
            }
            this.lastb = byArray[i2];
        }
        if (n3 - n4 > 0) {
            this.expandCapacity(n3 - n4);
            System.arraycopy(byArray, n4, this.buf, this.pos, n3 - n4);
            this.pos += n3 - n4;
        }
    }

    protected void log(String string) {
        this.logger.log(this.level, string);
    }

    private void logBuf() {
        String string = new String(this.buf, 0, this.pos);
        this.pos = 0;
        this.log(string);
    }

    private void expandCapacity(int n2) {
        while (this.pos + n2 > this.buf.length) {
            byte[] byArray = new byte[this.buf.length * 2];
            System.arraycopy(this.buf, 0, byArray, 0, this.pos);
            this.buf = byArray;
        }
    }
}

