/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.smtp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import macromedia.externals.com.sun.mail_1_4_7.smtp.SMTPAddressFailedException;
import macromedia.externals.com.sun.mail_1_4_7.smtp.SMTPAddressSucceededException;
import macromedia.externals.com.sun.mail_1_4_7.smtp.SMTPMessage;
import macromedia.externals.com.sun.mail_1_4_7.smtp.SMTPOutputStream;
import macromedia.externals.com.sun.mail_1_4_7.smtp.SMTPSendFailedException;
import macromedia.externals.com.sun.mail_1_4_7.smtp.SMTPSenderFailedException;
import macromedia.externals.com.sun.mail_1_4_7.smtp.SMTPTransport;
import macromedia.externals.com.sun.mail_1_4_7.smtp.SaslAuthenticator;
import macromedia.externals.com.sun.mail_1_4_7.util.ASCIIUtility;
import macromedia.externals.com.sun.mail_1_4_7.util.LineInputStream;
import macromedia.externals.com.sun.mail_1_4_7.util.MailLogger;
import macromedia.externals.com.sun.mail_1_4_7.util.PropUtil;
import macromedia.externals.com.sun.mail_1_4_7.util.SocketFetcher;
import macromedia.externals.com.sun.mail_1_4_7.util.TraceInputStream;
import macromedia.externals.com.sun.mail_1_4_7.util.TraceOutputStream;
import macromedia.externals.javax.mail_1_4_7.Address;
import macromedia.externals.javax.mail_1_4_7.AuthenticationFailedException;
import macromedia.externals.javax.mail_1_4_7.Message;
import macromedia.externals.javax.mail_1_4_7.MessagingException;
import macromedia.externals.javax.mail_1_4_7.SendFailedException;
import macromedia.externals.javax.mail_1_4_7.Session;
import macromedia.externals.javax.mail_1_4_7.Transport;
import macromedia.externals.javax.mail_1_4_7.URLName;
import macromedia.externals.javax.mail_1_4_7.internet.AddressException;
import macromedia.externals.javax.mail_1_4_7.internet.InternetAddress;
import macromedia.externals.javax.mail_1_4_7.internet.MimeMessage;
import macromedia.externals.javax.mail_1_4_7.internet.MimeMultipart;
import macromedia.externals.javax.mail_1_4_7.internet.MimePart;
import macromedia.externals.javax.mail_1_4_7.internet.ParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SMTPTransport
extends Transport {
    private String name = "smtp";
    private int defaultPort = 25;
    private boolean isSSL = false;
    private String host;
    private MimeMessage message;
    private Address[] addresses;
    private Address[] validSentAddr;
    private Address[] validUnsentAddr;
    private Address[] invalidAddr;
    private boolean sendPartiallyFailed = false;
    private MessagingException exception;
    private SMTPOutputStream dataStream;
    private Hashtable extMap;
    private Map authenticators = new HashMap();
    private String defaultAuthenticationMechanisms;
    private boolean quitWait = false;
    private String saslRealm = "UNKNOWN";
    private String authorizationID = "UNKNOWN";
    private boolean enableSASL = false;
    private String[] saslMechanisms = UNKNOWN_SA;
    private String ntlmDomain = "UNKNOWN";
    private boolean reportSuccess;
    private boolean useStartTLS;
    private boolean requireStartTLS;
    private boolean useRset;
    private boolean noopStrict = true;
    private MailLogger logger;
    private MailLogger traceLogger;
    private String localHostName;
    private String lastServerResponse;
    private int lastReturnCode;
    private boolean notificationDone;
    private SaslAuthenticator saslAuthenticator;
    private boolean noauthdebug = true;
    private static final String[] ignoreList;
    private static final byte[] CRLF;
    private static final String UNKNOWN = "UNKNOWN";
    private static final String[] UNKNOWN_SA;
    private BufferedInputStream serverInput;
    private LineInputStream lineInputStream;
    private OutputStream serverOutput;
    private Socket serverSocket;
    private TraceInputStream traceInput;
    private TraceOutputStream traceOutput;
    private static char[] hexchar;
    static /* synthetic */ Class class$com$sun$mail$smtp$SMTPTransport;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$com$sun$mail$util$MailLogger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SMTPTransport(Session session, URLName uRLName) {
        this(session, uRLName, "smtp", false);
    }

    protected SMTPTransport(Session session, URLName uRLName, String string, boolean bl2) {
        super(session, uRLName);
        this.logger = new MailLogger(this.getClass(), "DEBUG SMTP", session);
        this.traceLogger = this.logger.getSubLogger("protocol", null);
        boolean bl3 = this.noauthdebug = !PropUtil.getBooleanSessionProperty((Session)session, (String)"mail.debug.auth", (boolean)false);
        if (uRLName != null) {
            string = uRLName.getProtocol();
        }
        this.name = string;
        if (!bl2) {
            bl2 = PropUtil.getBooleanSessionProperty((Session)session, (String)new StringBuffer().append("mail.").append(string).append(".ssl.enable").toString(), (boolean)false);
        }
        this.defaultPort = bl2 ? 465 : 25;
        this.isSSL = bl2;
        this.quitWait = PropUtil.getBooleanSessionProperty((Session)session, (String)new StringBuffer().append("mail.").append(string).append(".quitwait").toString(), (boolean)true);
        this.reportSuccess = PropUtil.getBooleanSessionProperty((Session)session, (String)new StringBuffer().append("mail.").append(string).append(".reportsuccess").toString(), (boolean)false);
        this.useStartTLS = PropUtil.getBooleanSessionProperty((Session)session, (String)new StringBuffer().append("mail.").append(string).append(".starttls.enable").toString(), (boolean)false);
        this.requireStartTLS = PropUtil.getBooleanSessionProperty((Session)session, (String)new StringBuffer().append("mail.").append(string).append(".starttls.required").toString(), (boolean)false);
        this.useRset = PropUtil.getBooleanSessionProperty((Session)session, (String)new StringBuffer().append("mail.").append(string).append(".userset").toString(), (boolean)false);
        this.noopStrict = PropUtil.getBooleanSessionProperty((Session)session, (String)new StringBuffer().append("mail.").append(string).append(".noop.strict").toString(), (boolean)true);
        this.enableSASL = PropUtil.getBooleanSessionProperty((Session)session, (String)new StringBuffer().append("mail.").append(string).append(".sasl.enable").toString(), (boolean)false);
        if (this.enableSASL) {
            this.logger.config("enable SASL");
        }
        Authenticator[] authenticatorArray = new Authenticator[]{new LoginAuthenticator(this), new PlainAuthenticator(this), new DigestMD5Authenticator(this), new NtlmAuthenticator(this)};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < authenticatorArray.length; ++i2) {
            this.authenticators.put(authenticatorArray[i2].getMechanism(), authenticatorArray[i2]);
            stringBuffer.append(authenticatorArray[i2].getMechanism()).append(' ');
        }
        this.defaultAuthenticationMechanisms = stringBuffer.toString();
    }

    public synchronized String getLocalHost() {
        InetAddress inetAddress;
        if (this.localHostName == null || this.localHostName.length() <= 0) {
            this.localHostName = this.session.getProperty(new StringBuffer().append("mail.").append(this.name).append(".localhost").toString());
        }
        if (this.localHostName == null || this.localHostName.length() <= 0) {
            this.localHostName = this.session.getProperty(new StringBuffer().append("mail.").append(this.name).append(".localaddress").toString());
        }
        try {
            if (this.localHostName == null || this.localHostName.length() <= 0) {
                inetAddress = InetAddress.getLocalHost();
                this.localHostName = inetAddress.getCanonicalHostName();
                if (this.localHostName == null) {
                    this.localHostName = new StringBuffer().append("[").append(inetAddress.getHostAddress()).append("]").toString();
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if ((this.localHostName == null || this.localHostName.length() <= 0) && this.serverSocket != null && this.serverSocket.isBound()) {
            inetAddress = this.serverSocket.getLocalAddress();
            this.localHostName = inetAddress.getCanonicalHostName();
            if (this.localHostName == null) {
                this.localHostName = new StringBuffer().append("[").append(inetAddress.getHostAddress()).append("]").toString();
            }
        }
        return this.localHostName;
    }

    public synchronized void setLocalHost(String string) {
        this.localHostName = string;
    }

    public synchronized void connect(Socket socket) throws MessagingException {
        this.serverSocket = socket;
        super.connect();
    }

    public synchronized String getAuthorizationId() {
        if (this.authorizationID == "UNKNOWN") {
            this.authorizationID = this.session.getProperty(new StringBuffer().append("mail.").append(this.name).append(".sasl.authorizationid").toString());
        }
        return this.authorizationID;
    }

    public synchronized void setAuthorizationID(String string) {
        this.authorizationID = string;
    }

    public synchronized boolean getSASLEnabled() {
        return this.enableSASL;
    }

    public synchronized void setSASLEnabled(boolean bl2) {
        this.enableSASL = bl2;
    }

    public synchronized String getSASLRealm() {
        if (this.saslRealm == "UNKNOWN") {
            this.saslRealm = this.session.getProperty(new StringBuffer().append("mail.").append(this.name).append(".sasl.realm").toString());
            if (this.saslRealm == null) {
                this.saslRealm = this.session.getProperty(new StringBuffer().append("mail.").append(this.name).append(".saslrealm").toString());
            }
        }
        return this.saslRealm;
    }

    public synchronized void setSASLRealm(String string) {
        this.saslRealm = string;
    }

    public synchronized String[] getSASLMechanisms() {
        if (this.saslMechanisms == UNKNOWN_SA) {
            ArrayList<String> arrayList = new ArrayList<String>(5);
            String string = this.session.getProperty(new StringBuffer().append("mail.").append(this.name).append(".sasl.mechanisms").toString());
            if (string != null && string.length() > 0) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(new StringBuffer().append("SASL mechanisms allowed: ").append(string).toString());
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.length() <= 0) continue;
                    arrayList.add(string2);
                }
            }
            this.saslMechanisms = new String[arrayList.size()];
            arrayList.toArray(this.saslMechanisms);
        }
        if (this.saslMechanisms == null) {
            return null;
        }
        return (String[])this.saslMechanisms.clone();
    }

    public synchronized void setSASLMechanisms(String[] stringArray) {
        if (stringArray != null) {
            stringArray = (String[])stringArray.clone();
        }
        this.saslMechanisms = stringArray;
    }

    public synchronized String getNTLMDomain() {
        if (this.ntlmDomain == "UNKNOWN") {
            this.ntlmDomain = this.session.getProperty(new StringBuffer().append("mail.").append(this.name).append(".auth.ntlm.domain").toString());
        }
        return this.ntlmDomain;
    }

    public synchronized void setNTLMDomain(String string) {
        this.ntlmDomain = string;
    }

    public synchronized boolean getReportSuccess() {
        return this.reportSuccess;
    }

    public synchronized void setReportSuccess(boolean bl2) {
        this.reportSuccess = bl2;
    }

    public synchronized boolean getStartTLS() {
        return this.useStartTLS;
    }

    public synchronized void setStartTLS(boolean bl2) {
        this.useStartTLS = bl2;
    }

    public synchronized boolean getRequireStartTLS() {
        return this.requireStartTLS;
    }

    public synchronized void setRequireStartTLS(boolean bl2) {
        this.requireStartTLS = bl2;
    }

    public boolean isSSL() {
        return this.serverSocket instanceof SSLSocket;
    }

    public synchronized boolean getUseRset() {
        return this.useRset;
    }

    public synchronized void setUseRset(boolean bl2) {
        this.useRset = bl2;
    }

    public synchronized boolean getNoopStrict() {
        return this.noopStrict;
    }

    public synchronized void setNoopStrict(boolean bl2) {
        this.noopStrict = bl2;
    }

    public synchronized String getLastServerResponse() {
        return this.lastServerResponse;
    }

    public synchronized int getLastReturnCode() {
        return this.lastReturnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean protocolConnect(String string, int n2, String string2, String string3) throws MessagingException {
        boolean bl2 = PropUtil.getBooleanSessionProperty((Session)this.session, (String)new StringBuffer().append("mail.").append(this.name).append(".ehlo").toString(), (boolean)true);
        boolean bl3 = PropUtil.getBooleanSessionProperty((Session)this.session, (String)new StringBuffer().append("mail.").append(this.name).append(".auth").toString(), (boolean)false);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(new StringBuffer().append("useEhlo ").append(bl2).append(", useAuth ").append(bl3).toString());
        }
        if (bl3 && (string2 == null || string3 == null)) {
            return false;
        }
        if (n2 == -1) {
            n2 = PropUtil.getIntSessionProperty((Session)this.session, (String)new StringBuffer().append("mail.").append(this.name).append(".port").toString(), (int)-1);
        }
        if (n2 == -1) {
            n2 = this.defaultPort;
        }
        if (string == null || string.length() == 0) {
            string = "localhost";
        }
        boolean bl4 = false;
        try {
            if (this.serverSocket != null) {
                this.openServer();
            } else {
                this.openServer(string, n2);
            }
            boolean bl5 = false;
            if (bl2) {
                bl5 = this.ehlo(this.getLocalHost());
            }
            if (!bl5) {
                this.helo(this.getLocalHost());
            }
            if (this.useStartTLS || this.requireStartTLS) {
                if (this.serverSocket instanceof SSLSocket) {
                    this.logger.fine("STARTTLS requested but already using SSL");
                } else if (this.supportsExtension("STARTTLS")) {
                    this.startTLS();
                    this.ehlo(this.getLocalHost());
                } else if (this.requireStartTLS) {
                    this.logger.fine("STARTTLS required but not supported");
                    throw new MessagingException("STARTTLS is required but host does not support STARTTLS");
                }
            }
            if ((bl3 || string2 != null && string3 != null) && (this.supportsExtension("AUTH") || this.supportsExtension("AUTH=LOGIN"))) {
                boolean bl6 = bl4 = this.authenticate(string2, string3);
                return bl6;
            }
            bl4 = true;
            boolean bl7 = true;
            return bl7;
        }
        finally {
            if (!bl4) {
                try {
                    this.closeConnection();
                }
                catch (MessagingException messagingException) {}
            }
        }
    }

    private boolean authenticate(String string, String string2) throws MessagingException {
        String string3;
        String string4 = this.session.getProperty(new StringBuffer().append("mail.").append(this.name).append(".auth.mechanisms").toString());
        if (string4 == null) {
            string4 = this.defaultAuthenticationMechanisms;
        }
        if ((string3 = this.getAuthorizationId()) == null) {
            string3 = string;
        }
        if (this.enableSASL) {
            this.logger.fine("Authenticate with SASL");
            if (this.sasllogin(this.getSASLMechanisms(), this.getSASLRealm(), string3, string, string2)) {
                return true;
            }
            this.logger.fine("SASL authentication failed");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(new StringBuffer().append("Attempt to authenticate using mechanisms: ").append(string4).toString());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4);
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            String string6 = new StringBuffer().append("mail.").append(this.name).append(".auth.").append(string5.toLowerCase(Locale.ENGLISH)).append(".disable").toString();
            boolean bl2 = PropUtil.getBooleanSessionProperty((Session)this.session, (String)string6, (boolean)false);
            if (bl2) {
                if (!this.logger.isLoggable(Level.FINE)) continue;
                this.logger.fine(new StringBuffer().append("mechanism ").append(string5).append(" disabled by property: ").append(string6).toString());
                continue;
            }
            if (!this.supportsAuthentication(string5 = string5.toUpperCase(Locale.ENGLISH))) {
                this.logger.log(Level.FINE, "mechanism {0} not supported by server", (Object)string5);
                continue;
            }
            Authenticator authenticator = (Authenticator)this.authenticators.get(string5);
            if (authenticator == null) {
                this.logger.log(Level.FINE, "no authenticator for mechanism {0}", (Object)string5);
                continue;
            }
            return authenticator.authenticate(this.host, string3, string, string2);
        }
        throw new AuthenticationFailedException("No authentication mechansims supported by both server and client");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sasllogin(String[] stringArray, String string, String string2, String string3, String string4) throws MessagingException {
        Object object;
        Serializable serializable;
        if (this.saslAuthenticator == null) {
            try {
                serializable = Class.forName("macromedia.externals.com.sun.mail_1_4_7.smtp.SMTPSaslAuthenticator");
                object = ((Class)serializable).getConstructor(class$com$sun$mail$smtp$SMTPTransport == null ? (class$com$sun$mail$smtp$SMTPTransport = SMTPTransport.class$((String)"macromedia.externals.com.sun.mail_1_4_7.smtp.SMTPTransport")) : class$com$sun$mail$smtp$SMTPTransport, class$java$lang$String == null ? (class$java$lang$String = SMTPTransport.class$((String)"java.lang.String")) : class$java$lang$String, class$java$util$Properties == null ? (class$java$util$Properties = SMTPTransport.class$((String)"java.util.Properties")) : class$java$util$Properties, class$com$sun$mail$util$MailLogger == null ? (class$com$sun$mail$util$MailLogger = SMTPTransport.class$((String)"macromedia.externals.com.sun.mail_1_4_7.util.MailLogger")) : class$com$sun$mail$util$MailLogger, class$java$lang$String == null ? (class$java$lang$String = SMTPTransport.class$((String)"java.lang.String")) : class$java$lang$String);
                this.saslAuthenticator = (SaslAuthenticator)((Constructor)object).newInstance(this, this.name, this.session.getProperties(), this.logger, this.host);
            }
            catch (Exception exception) {
                this.logger.log(Level.FINE, "Can't load SASL authenticator", (Throwable)exception);
                return false;
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            serializable = new ArrayList(stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!this.supportsAuthentication(stringArray[i2])) continue;
                serializable.add(stringArray[i2]);
            }
        } else {
            serializable = new ArrayList();
            if (this.extMap != null && (object = (String)this.extMap.get("AUTH")) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                while (stringTokenizer.hasMoreTokens()) {
                    serializable.add(stringTokenizer.nextToken());
                }
            }
        }
        String[] stringArray2 = serializable.toArray((String[])new String[serializable.size()]);
        try {
            if (this.noauthdebug && this.isTracing()) {
                this.logger.fine("SASL AUTH command trace suppressed");
                this.suspendTracing();
            }
            boolean bl2 = this.saslAuthenticator.authenticate(stringArray2, string, string2, string3, string4);
            return bl2;
        }
        finally {
            this.resumeTracing();
        }
    }

    public synchronized void sendMessage(Message message, Address[] addressArray) throws MessagingException, SendFailedException {
        boolean bl2;
        this.sendMessageStart(message != null ? message.getSubject() : "");
        this.checkConnected();
        if (!(message instanceof MimeMessage)) {
            this.logger.fine("Can only send RFC822 msgs");
            throw new MessagingException("SMTP can only send RFC822 messages");
        }
        for (bl2 = false; bl2 < addressArray.length; bl2 += 1) {
            if (addressArray[bl2] instanceof InternetAddress) continue;
            throw new MessagingException(new StringBuffer().append(addressArray[bl2]).append(" is not an InternetAddress").toString());
        }
        if (addressArray.length == 0) {
            throw new SendFailedException("No recipient addresses");
        }
        this.message = (MimeMessage)message;
        this.addresses = addressArray;
        this.validUnsentAddr = addressArray;
        this.expandGroups();
        bl2 = false;
        if (message instanceof SMTPMessage) {
            bl2 = ((SMTPMessage)message).getAllow8bitMIME();
        }
        if (!bl2) {
            bl2 = PropUtil.getBooleanSessionProperty((Session)this.session, (String)new StringBuffer().append("mail.").append(this.name).append(".allow8bitmime").toString(), (boolean)false);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(new StringBuffer().append("use8bit ").append(bl2).toString());
        }
        if (bl2 && this.supportsExtension("8BITMIME") && this.convertTo8Bit((MimePart)this.message)) {
            try {
                this.message.saveChanges();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        try {
            this.mailFrom();
            this.rcptTo();
            this.message.writeTo(this.data(), ignoreList);
            this.finishData();
            if (this.sendPartiallyFailed) {
                this.logger.fine("Sending partially failed because of invalid destination addresses");
                this.notifyTransportListeners(3, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, (Message)this.message);
                throw new SMTPSendFailedException(".", this.lastReturnCode, this.lastServerResponse, (Exception)((Object)this.exception), this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
            }
            this.notifyTransportListeners(1, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, (Message)this.message);
        }
        catch (MessagingException messagingException) {
            this.logger.log(Level.FINE, "MessagingException while sending", (Throwable)messagingException);
            if (messagingException.getNextException() instanceof IOException) {
                this.logger.fine("nested IOException, closing");
                try {
                    this.closeConnection();
                }
                catch (MessagingException messagingException2) {
                    // empty catch block
                }
            }
            this.addressesFailed();
            this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, (Message)this.message);
            throw messagingException;
        }
        catch (IOException iOException) {
            this.logger.log(Level.FINE, "IOException while sending, closing", (Throwable)iOException);
            try {
                this.closeConnection();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            this.addressesFailed();
            this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, (Message)this.message);
            throw new MessagingException("IOException while sending message", (Exception)iOException);
        }
        finally {
            this.invalidAddr = null;
            this.validUnsentAddr = null;
            this.validSentAddr = null;
            this.addresses = null;
            this.message = null;
            this.exception = null;
            this.sendPartiallyFailed = false;
            this.notificationDone = false;
        }
        this.sendMessageEnd();
    }

    private void addressesFailed() {
        if (this.validSentAddr != null) {
            if (this.validUnsentAddr != null) {
                Address[] addressArray = new Address[this.validSentAddr.length + this.validUnsentAddr.length];
                System.arraycopy(this.validSentAddr, 0, addressArray, 0, this.validSentAddr.length);
                System.arraycopy(this.validUnsentAddr, 0, addressArray, this.validSentAddr.length, this.validUnsentAddr.length);
                this.validSentAddr = null;
                this.validUnsentAddr = addressArray;
            } else {
                this.validUnsentAddr = this.validSentAddr;
                this.validSentAddr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws MessagingException {
        if (!super.isConnected()) {
            return;
        }
        try {
            if (this.serverSocket != null) {
                int n2;
                this.sendCommand("QUIT");
                if (this.quitWait && (n2 = this.readServerResponse()) != 221 && n2 != -1 && this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(new StringBuffer().append("QUIT failed with ").append(n2).toString());
                }
            }
        }
        finally {
            this.closeConnection();
        }
    }

    private void closeConnection() throws MessagingException {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            throw new MessagingException("Server Close Failed", (Exception)iOException);
        }
        finally {
            this.serverSocket = null;
            this.serverOutput = null;
            this.serverInput = null;
            this.lineInputStream = null;
            if (super.isConnected()) {
                super.close();
            }
        }
    }

    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        try {
            if (this.useRset) {
                this.sendCommand("RSET");
            } else {
                this.sendCommand("NOOP");
            }
            int n2 = this.readServerResponse();
            if (n2 >= 0 && (this.noopStrict ? n2 == 250 : n2 != 421)) {
                return true;
            }
            try {
                this.closeConnection();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            return false;
        }
        catch (Exception exception) {
            try {
                this.closeConnection();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            return false;
        }
    }

    protected void notifyTransportListeners(int n2, Address[] addressArray, Address[] addressArray2, Address[] addressArray3, Message message) {
        if (!this.notificationDone) {
            super.notifyTransportListeners(n2, addressArray, addressArray2, addressArray3, message);
            this.notificationDone = true;
        }
    }

    private void expandGroups() {
        Vector<InternetAddress> vector = null;
        for (int i2 = 0; i2 < this.addresses.length; ++i2) {
            InternetAddress internetAddress = (InternetAddress)this.addresses[i2];
            if (internetAddress.isGroup()) {
                if (vector == null) {
                    vector = new Vector<InternetAddress>();
                    for (int i3 = 0; i3 < i2; ++i3) {
                        vector.addElement((InternetAddress)this.addresses[i3]);
                    }
                }
                try {
                    InternetAddress[] internetAddressArray = internetAddress.getGroup(true);
                    if (internetAddressArray != null) {
                        for (int i4 = 0; i4 < internetAddressArray.length; ++i4) {
                            vector.addElement(internetAddressArray[i4]);
                        }
                        continue;
                    }
                    vector.addElement(internetAddress);
                }
                catch (ParseException parseException) {
                    vector.addElement(internetAddress);
                }
                continue;
            }
            if (vector == null) continue;
            vector.addElement(internetAddress);
        }
        if (vector != null) {
            Object[] objectArray = new InternetAddress[vector.size()];
            vector.copyInto(objectArray);
            this.addresses = objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean convertTo8Bit(MimePart mimePart) {
        boolean bl2;
        block15: {
            bl2 = false;
            try {
                if (mimePart.isMimeType("text/*")) {
                    String string = mimePart.getEncoding();
                    if (string == null || !string.equalsIgnoreCase("quoted-printable") && !string.equalsIgnoreCase("base64")) break block15;
                    InputStream inputStream = null;
                    try {
                        inputStream = mimePart.getInputStream();
                        if (this.is8Bit(inputStream)) {
                            mimePart.setContent(mimePart.getContent(), mimePart.getContentType());
                            mimePart.setHeader("Content-Transfer-Encoding", "8bit");
                            bl2 = true;
                        }
                        break block15;
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (mimePart.isMimeType("multipart/*")) {
                    MimeMultipart mimeMultipart = (MimeMultipart)mimePart.getContent();
                    int n2 = mimeMultipart.getCount();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (!this.convertTo8Bit((MimePart)mimeMultipart.getBodyPart(i2))) continue;
                        bl2 = true;
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        return bl2;
    }

    private boolean is8Bit(InputStream inputStream) {
        int n2 = 0;
        boolean bl2 = false;
        try {
            int n3;
            while ((n3 = inputStream.read()) >= 0) {
                if ((n3 &= 0xFF) == 13 || n3 == 10) {
                    n2 = 0;
                } else {
                    if (n3 == 0) {
                        return false;
                    }
                    if (++n2 > 998) {
                        return false;
                    }
                }
                if (n3 <= 127) continue;
                bl2 = true;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        if (bl2) {
            this.logger.fine("found an 8bit part");
        }
        return bl2;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.closeConnection();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    protected void helo(String string) throws MessagingException {
        if (string != null) {
            this.issueCommand(new StringBuffer().append("HELO ").append(string).toString(), 250);
        } else {
            this.issueCommand("HELO", 250);
        }
    }

    protected boolean ehlo(String string) throws MessagingException {
        String string2 = string != null ? new StringBuffer().append("EHLO ").append(string).toString() : "EHLO";
        this.sendCommand(string2);
        int n2 = this.readServerResponse();
        if (n2 == 250) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(this.lastServerResponse));
            this.extMap = new Hashtable();
            try {
                String string3;
                boolean bl2 = true;
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (bl2) {
                        bl2 = false;
                        continue;
                    }
                    if (string3.length() < 5) continue;
                    string3 = string3.substring(4);
                    int n3 = string3.indexOf(32);
                    String string4 = "";
                    if (n3 > 0) {
                        string4 = string3.substring(n3 + 1);
                        string3 = string3.substring(0, n3);
                    }
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(new StringBuffer().append("Found extension \"").append(string3).append("\", arg \"").append(string4).append("\"").toString());
                    }
                    this.extMap.put(string3.toUpperCase(Locale.ENGLISH), string4);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n2 == 250;
    }

    protected void mailFrom() throws MessagingException {
        Object object;
        Object object2;
        String string;
        block25: {
            string = null;
            if (this.message instanceof SMTPMessage) {
                string = ((SMTPMessage)this.message).getEnvelopeFrom();
            }
            if (string == null || string.length() <= 0) {
                string = this.session.getProperty(new StringBuffer().append("mail.").append(this.name).append(".from").toString());
            }
            if (string == null || string.length() <= 0) {
                object = this.message != null && (object2 = this.message.getFrom()) != null && ((Address[])object2).length > 0 ? object2[0] : InternetAddress.getLocalAddress((Session)this.session);
                if (object != null) {
                    string = object.getAddress();
                } else {
                    throw new MessagingException("can't determine local email address");
                }
            }
            object2 = new StringBuffer().append("MAIL FROM:").append(this.normalizeAddress(string)).toString();
            if (this.supportsExtension("DSN")) {
                object = null;
                if (this.message instanceof SMTPMessage) {
                    object = ((SMTPMessage)this.message).getDSNRet();
                }
                if (object == null) {
                    object = this.session.getProperty(new StringBuffer().append("mail.").append(this.name).append(".dsn.ret").toString());
                }
                if (object != null) {
                    object2 = new StringBuffer().append((String)object2).append(" RET=").append((String)object).toString();
                }
            }
            if (this.supportsExtension("AUTH")) {
                object = null;
                if (this.message instanceof SMTPMessage) {
                    object = ((SMTPMessage)this.message).getSubmitter();
                }
                if (object == null) {
                    object = this.session.getProperty(new StringBuffer().append("mail.").append(this.name).append(".submitter").toString());
                }
                if (object != null) {
                    try {
                        String string2 = SMTPTransport.xtext((String)object);
                        object2 = new StringBuffer().append((String)object2).append(" AUTH=").append(string2).toString();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!this.logger.isLoggable(Level.FINE)) break block25;
                        this.logger.log(Level.FINE, new StringBuffer().append("ignoring invalid submitter: ").append((String)object).toString(), (Throwable)illegalArgumentException);
                    }
                }
            }
        }
        object = null;
        if (this.message instanceof SMTPMessage) {
            object = ((SMTPMessage)this.message).getMailExtension();
        }
        if (object == null) {
            object = this.session.getProperty(new StringBuffer().append("mail.").append(this.name).append(".mailextension").toString());
        }
        if (object != null && ((String)object).length() > 0) {
            object2 = new StringBuffer().append((String)object2).append(" ").append((String)object).toString();
        }
        try {
            this.issueSendCommand((String)object2, 250);
        }
        catch (SMTPSendFailedException sMTPSendFailedException) {
            int n2 = sMTPSendFailedException.getReturnCode();
            switch (n2) {
                case 501: 
                case 503: 
                case 550: 
                case 551: 
                case 553: {
                    try {
                        sMTPSendFailedException.setNextException((Exception)new SMTPSenderFailedException(new InternetAddress(string), (String)object2, n2, sMTPSendFailedException.getMessage()));
                        break;
                    }
                    catch (AddressException addressException) {
                        // empty catch block
                    }
                }
            }
            throw sMTPSendFailedException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rcptTo() throws MessagingException {
        int n2;
        Vector<InternetAddress> vector = new Vector<InternetAddress>();
        Vector<InternetAddress> vector2 = new Vector<InternetAddress>();
        Vector<InternetAddress> vector3 = new Vector<InternetAddress>();
        int n3 = -1;
        SMTPAddressFailedException sMTPAddressFailedException = null;
        boolean bl2 = false;
        SMTPAddressFailedException sMTPAddressFailedException2 = null;
        this.invalidAddr = null;
        this.validUnsentAddr = null;
        this.validSentAddr = null;
        boolean bl3 = false;
        if (this.message instanceof SMTPMessage) {
            bl3 = ((SMTPMessage)this.message).getSendPartial();
        }
        if (!bl3) {
            bl3 = PropUtil.getBooleanSessionProperty((Session)this.session, (String)new StringBuffer().append("mail.").append(this.name).append(".sendpartial").toString(), (boolean)false);
        }
        if (bl3) {
            this.logger.fine("sendPartial set");
        }
        boolean bl4 = false;
        String string = null;
        if (this.supportsExtension("DSN")) {
            if (this.message instanceof SMTPMessage) {
                string = ((SMTPMessage)this.message).getDSNNotify();
            }
            if (string == null) {
                string = this.session.getProperty(new StringBuffer().append("mail.").append(this.name).append(".dsn.notify").toString());
            }
            if (string != null) {
                bl4 = true;
            }
        }
        block12: for (n2 = 0; n2 < this.addresses.length; ++n2) {
            sMTPAddressFailedException2 = null;
            InternetAddress internetAddress = (InternetAddress)this.addresses[n2];
            String string2 = new StringBuffer().append("RCPT TO:").append(this.normalizeAddress(internetAddress.getAddress())).toString();
            if (bl4) {
                string2 = new StringBuffer().append(string2).append(" NOTIFY=").append(string).toString();
            }
            this.sendCommand(string2);
            n3 = this.readServerResponse();
            switch (n3) {
                case 250: 
                case 251: {
                    vector.addElement(internetAddress);
                    if (!this.reportSuccess) continue block12;
                    sMTPAddressFailedException2 = new SMTPAddressSucceededException(internetAddress, string2, n3, this.lastServerResponse);
                    if (sMTPAddressFailedException == null) {
                        sMTPAddressFailedException = sMTPAddressFailedException2;
                        continue block12;
                    }
                    sMTPAddressFailedException.setNextException((Exception)sMTPAddressFailedException2);
                    continue block12;
                }
                case 501: 
                case 503: 
                case 550: 
                case 551: 
                case 553: {
                    if (!bl3) {
                        bl2 = true;
                    }
                    vector3.addElement(internetAddress);
                    sMTPAddressFailedException2 = new SMTPAddressFailedException(internetAddress, string2, n3, this.lastServerResponse);
                    if (sMTPAddressFailedException == null) {
                        sMTPAddressFailedException = sMTPAddressFailedException2;
                        continue block12;
                    }
                    sMTPAddressFailedException.setNextException((Exception)sMTPAddressFailedException2);
                    continue block12;
                }
                case 450: 
                case 451: 
                case 452: 
                case 552: {
                    if (!bl3) {
                        bl2 = true;
                    }
                    vector2.addElement(internetAddress);
                    sMTPAddressFailedException2 = new SMTPAddressFailedException(internetAddress, string2, n3, this.lastServerResponse);
                    if (sMTPAddressFailedException == null) {
                        sMTPAddressFailedException = sMTPAddressFailedException2;
                        continue block12;
                    }
                    sMTPAddressFailedException.setNextException((Exception)sMTPAddressFailedException2);
                    continue block12;
                }
                default: {
                    if (n3 >= 400 && n3 <= 499) {
                        vector2.addElement(internetAddress);
                    } else if (n3 >= 500 && n3 <= 599) {
                        vector3.addElement(internetAddress);
                    } else {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine(new StringBuffer().append("got response code ").append(n3).append(", with response: ").append(this.lastServerResponse).toString());
                        }
                        String string3 = this.lastServerResponse;
                        int n4 = this.lastReturnCode;
                        if (this.serverSocket != null) {
                            this.issueCommand("RSET", -1);
                        }
                        this.lastServerResponse = string3;
                        this.lastReturnCode = n4;
                        throw new SMTPAddressFailedException(internetAddress, string2, n3, string3);
                    }
                    if (!bl3) {
                        bl2 = true;
                    }
                    sMTPAddressFailedException2 = new SMTPAddressFailedException(internetAddress, string2, n3, this.lastServerResponse);
                    if (sMTPAddressFailedException == null) {
                        sMTPAddressFailedException = sMTPAddressFailedException2;
                        continue block12;
                    }
                    sMTPAddressFailedException.setNextException((Exception)sMTPAddressFailedException2);
                }
            }
        }
        if (bl3 && vector.size() == 0) {
            bl2 = true;
        }
        if (bl2) {
            int n5;
            this.invalidAddr = new Address[vector3.size()];
            vector3.copyInto(this.invalidAddr);
            this.validUnsentAddr = new Address[vector.size() + vector2.size()];
            n2 = 0;
            for (n5 = 0; n5 < vector.size(); ++n5) {
                this.validUnsentAddr[n2++] = (Address)vector.elementAt(n5);
            }
            for (n5 = 0; n5 < vector2.size(); ++n5) {
                this.validUnsentAddr[n2++] = (Address)vector2.elementAt(n5);
            }
        } else if (this.reportSuccess || bl3 && (vector3.size() > 0 || vector2.size() > 0)) {
            this.sendPartiallyFailed = true;
            this.exception = sMTPAddressFailedException;
            this.invalidAddr = new Address[vector3.size()];
            vector3.copyInto(this.invalidAddr);
            this.validUnsentAddr = new Address[vector2.size()];
            vector2.copyInto(this.validUnsentAddr);
            this.validSentAddr = new Address[vector.size()];
            vector.copyInto(this.validSentAddr);
        } else {
            this.validSentAddr = this.addresses;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            if (this.validSentAddr != null && this.validSentAddr.length > 0) {
                this.logger.fine("Verified Addresses");
                for (n2 = 0; n2 < this.validSentAddr.length; ++n2) {
                    this.logger.fine(new StringBuffer().append("  ").append(this.validSentAddr[n2]).toString());
                }
            }
            if (this.validUnsentAddr != null && this.validUnsentAddr.length > 0) {
                this.logger.fine("Valid Unsent Addresses");
                for (n2 = 0; n2 < this.validUnsentAddr.length; ++n2) {
                    this.logger.fine(new StringBuffer().append("  ").append(this.validUnsentAddr[n2]).toString());
                }
            }
            if (this.invalidAddr != null && this.invalidAddr.length > 0) {
                this.logger.fine("Invalid Addresses");
                for (n2 = 0; n2 < this.invalidAddr.length; ++n2) {
                    this.logger.fine(new StringBuffer().append("  ").append(this.invalidAddr[n2]).toString());
                }
            }
        }
        if (bl2) {
            this.logger.fine("Sending failed because of invalid destination addresses");
            this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, (Message)this.message);
            String string4 = this.lastServerResponse;
            int n6 = this.lastReturnCode;
            try {
                if (this.serverSocket != null) {
                    this.issueCommand("RSET", -1);
                }
            }
            catch (MessagingException messagingException) {
                try {
                    this.close();
                }
                catch (MessagingException messagingException2) {
                    this.logger.log(Level.FINE, "close failed", (Throwable)messagingException2);
                }
            }
            finally {
                this.lastServerResponse = string4;
                this.lastReturnCode = n6;
            }
            throw new SendFailedException("Invalid Addresses", (Exception)sMTPAddressFailedException, this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
        }
    }

    protected OutputStream data() throws MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.issueSendCommand("DATA", 354);
        this.dataStream = new SMTPOutputStream(this.serverOutput);
        return this.dataStream;
    }

    protected void finishData() throws IOException, MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.dataStream.ensureAtBOL();
        this.issueSendCommand(".", 250);
    }

    protected void startTLS() throws MessagingException {
        this.issueCommand("STARTTLS", 220);
        try {
            this.serverSocket = SocketFetcher.startTLS((Socket)this.serverSocket, (String)this.host, (Properties)this.session.getProperties(), (String)new StringBuffer().append("mail.").append(this.name).toString());
            this.initStreams();
        }
        catch (IOException iOException) {
            this.closeConnection();
            throw new MessagingException("Could not convert socket to TLS", (Exception)iOException);
        }
    }

    private void openServer(String string, int n2) throws MessagingException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(new StringBuffer().append("trying to connect to host \"").append(string).append("\", port ").append(n2).append(", isSSL ").append(this.isSSL).toString());
        }
        try {
            Properties properties = this.session.getProperties();
            this.serverSocket = SocketFetcher.getSocket((String)string, (int)n2, (Properties)properties, (String)new StringBuffer().append("mail.").append(this.name).toString(), (boolean)this.isSSL);
            n2 = this.serverSocket.getPort();
            this.host = string;
            this.initStreams();
            int n3 = -1;
            n3 = this.readServerResponse();
            if (n3 != 220) {
                this.serverSocket.close();
                this.serverSocket = null;
                this.serverOutput = null;
                this.serverInput = null;
                this.lineInputStream = null;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(new StringBuffer().append("could not connect to host \"").append(string).append("\", port: ").append(n2).append(", response: ").append(n3).append("\n").toString());
                }
                throw new MessagingException(new StringBuffer().append("Could not connect to SMTP host: ").append(string).append(", port: ").append(n2).append(", response: ").append(n3).toString());
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(new StringBuffer().append("connected to host \"").append(string).append("\", port: ").append(n2).append("\n").toString());
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new MessagingException(new StringBuffer().append("Unknown SMTP host: ").append(string).toString(), (Exception)unknownHostException);
        }
        catch (IOException iOException) {
            throw new MessagingException(new StringBuffer().append("Could not connect to SMTP host: ").append(string).append(", port: ").append(n2).toString(), (Exception)iOException);
        }
    }

    private void openServer() throws MessagingException {
        int n2 = -1;
        this.host = "UNKNOWN";
        try {
            n2 = this.serverSocket.getPort();
            this.host = this.serverSocket.getInetAddress().getHostName();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(new StringBuffer().append("starting protocol to host \"").append(this.host).append("\", port ").append(n2).toString());
            }
            this.initStreams();
            int n3 = -1;
            n3 = this.readServerResponse();
            if (n3 != 220) {
                this.serverSocket.close();
                this.serverSocket = null;
                this.serverOutput = null;
                this.serverInput = null;
                this.lineInputStream = null;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(new StringBuffer().append("got bad greeting from host \"").append(this.host).append("\", port: ").append(n2).append(", response: ").append(n3).append("\n").toString());
                }
                throw new MessagingException(new StringBuffer().append("Got bad greeting from SMTP host: ").append(this.host).append(", port: ").append(n2).append(", response: ").append(n3).toString());
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(new StringBuffer().append("protocol started to host \"").append(this.host).append("\", port: ").append(n2).append("\n").toString());
            }
        }
        catch (IOException iOException) {
            throw new MessagingException(new StringBuffer().append("Could not start protocol to SMTP host: ").append(this.host).append(", port: ").append(n2).toString(), (Exception)iOException);
        }
    }

    private void initStreams() throws IOException {
        boolean bl2 = PropUtil.getBooleanSessionProperty((Session)this.session, (String)"mail.debug.quote", (boolean)false);
        this.traceInput = new TraceInputStream(this.serverSocket.getInputStream(), this.traceLogger);
        this.traceInput.setQuote(bl2);
        this.traceOutput = new TraceOutputStream(this.serverSocket.getOutputStream(), this.traceLogger);
        this.traceOutput.setQuote(bl2);
        this.serverOutput = new BufferedOutputStream((OutputStream)this.traceOutput);
        this.serverInput = new BufferedInputStream((InputStream)this.traceInput);
        this.lineInputStream = new LineInputStream((InputStream)this.serverInput);
    }

    private boolean isTracing() {
        return this.traceLogger.isLoggable(Level.FINEST);
    }

    private void suspendTracing() {
        if (this.traceLogger.isLoggable(Level.FINEST)) {
            this.traceInput.setTrace(false);
            this.traceOutput.setTrace(false);
        }
    }

    private void resumeTracing() {
        if (this.traceLogger.isLoggable(Level.FINEST)) {
            this.traceInput.setTrace(true);
            this.traceOutput.setTrace(true);
        }
    }

    public synchronized void issueCommand(String string, int n2) throws MessagingException {
        this.sendCommand(string);
        int n3 = this.readServerResponse();
        if (n2 != -1 && n3 != n2) {
            throw new MessagingException(this.lastServerResponse);
        }
    }

    private void issueSendCommand(String string, int n2) throws MessagingException {
        this.sendCommand(string);
        int n3 = this.readServerResponse();
        if (n3 != n2) {
            int n4 = this.validSentAddr == null ? 0 : this.validSentAddr.length;
            int n5 = this.validUnsentAddr == null ? 0 : this.validUnsentAddr.length;
            Address[] addressArray = new Address[n4 + n5];
            if (n4 > 0) {
                System.arraycopy(this.validSentAddr, 0, addressArray, 0, n4);
            }
            if (n5 > 0) {
                System.arraycopy(this.validUnsentAddr, 0, addressArray, n4, n5);
            }
            this.validSentAddr = null;
            this.validUnsentAddr = addressArray;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(new StringBuffer().append("got response code ").append(n3).append(", with response: ").append(this.lastServerResponse).toString());
            }
            String string2 = this.lastServerResponse;
            int n6 = this.lastReturnCode;
            if (this.serverSocket != null) {
                this.issueCommand("RSET", -1);
            }
            this.lastServerResponse = string2;
            this.lastReturnCode = n6;
            throw new SMTPSendFailedException(string, n3, this.lastServerResponse, (Exception)((Object)this.exception), this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
        }
    }

    public synchronized int simpleCommand(String string) throws MessagingException {
        this.sendCommand(string);
        return this.readServerResponse();
    }

    protected int simpleCommand(byte[] byArray) throws MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.sendCommand(byArray);
        return this.readServerResponse();
    }

    protected void sendCommand(String string) throws MessagingException {
        this.sendCommand(ASCIIUtility.getBytes((String)string));
    }

    private void sendCommand(byte[] byArray) throws MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            this.serverOutput.write(byArray);
            this.serverOutput.write(CRLF);
            this.serverOutput.flush();
        }
        catch (IOException iOException) {
            throw new MessagingException("Can't send command to SMTP host", (Exception)iOException);
        }
    }

    protected int readServerResponse() throws MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String string = "";
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(100);
        try {
            String string2 = null;
            do {
                if ((string2 = this.lineInputStream.readLine()) == null) {
                    string = stringBuffer.toString();
                    if (string.length() == 0) {
                        string = "[EOF]";
                    }
                    this.lastServerResponse = string;
                    this.lastReturnCode = -1;
                    this.logger.log(Level.FINE, "EOF: {0}", (Object)string);
                    return -1;
                }
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            } while (this.isNotLastLine(string2));
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            this.logger.log(Level.FINE, "exception reading response", (Throwable)iOException);
            this.lastServerResponse = "";
            this.lastReturnCode = 0;
            throw new MessagingException("Exception reading response", (Exception)iOException);
        }
        if (string.length() >= 3) {
            try {
                n2 = Integer.parseInt(string.substring(0, 3));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.close();
                }
                catch (MessagingException messagingException) {
                    this.logger.log(Level.FINE, "close failed", (Throwable)messagingException);
                }
                n2 = -1;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                try {
                    this.close();
                }
                catch (MessagingException messagingException) {
                    this.logger.log(Level.FINE, "close failed", (Throwable)messagingException);
                }
                n2 = -1;
            }
        } else {
            n2 = -1;
        }
        if (n2 == -1) {
            this.logger.log(Level.FINE, "bad server response: {0}", (Object)string);
        }
        this.lastServerResponse = string;
        this.lastReturnCode = n2;
        return n2;
    }

    protected void checkConnected() {
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    private boolean isNotLastLine(String string) {
        return string != null && string.length() >= 4 && string.charAt(3) == '-';
    }

    private String normalizeAddress(String string) {
        if (!string.startsWith("<") && !string.endsWith(">")) {
            return new StringBuffer().append("<").append(string).append(">").toString();
        }
        return string;
    }

    public boolean supportsExtension(String string) {
        return this.extMap != null && this.extMap.get(string.toUpperCase(Locale.ENGLISH)) != null;
    }

    public String getExtensionParameter(String string) {
        return this.extMap == null ? null : (String)this.extMap.get(string.toUpperCase(Locale.ENGLISH));
    }

    protected boolean supportsAuthentication(String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.extMap == null) {
            return false;
        }
        String string2 = (String)this.extMap.get("AUTH");
        if (string2 == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.equalsIgnoreCase(string)) continue;
            return true;
        }
        if (string.equalsIgnoreCase("LOGIN") && this.supportsExtension("AUTH=LOGIN")) {
            this.logger.fine("use AUTH=LOGIN hack");
            return true;
        }
        return false;
    }

    protected static String xtext(String string) {
        StringBuffer stringBuffer = null;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '\u0080') {
                throw new IllegalArgumentException(new StringBuffer().append("Non-ASCII character in SMTP submitter: ").append(string).toString());
            }
            if (c2 < '!' || c2 > '~' || c2 == '+' || c2 == '=') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.length() + 4);
                    stringBuffer.append(string.substring(0, i2));
                }
                stringBuffer.append('+');
                stringBuffer.append(hexchar[(c2 & 0xF0) >> 4]);
                stringBuffer.append(hexchar[c2 & 0xF]);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer != null ? stringBuffer.toString() : string;
    }

    private void sendMessageStart(String string) {
    }

    private void sendMessageEnd() {
    }

    static /* synthetic */ boolean access$000(SMTPTransport sMTPTransport) {
        return sMTPTransport.noauthdebug;
    }

    static /* synthetic */ boolean access$100(SMTPTransport sMTPTransport) {
        return sMTPTransport.isTracing();
    }

    static /* synthetic */ MailLogger access$200(SMTPTransport sMTPTransport) {
        return sMTPTransport.logger;
    }

    static /* synthetic */ void access$300(SMTPTransport sMTPTransport) {
        sMTPTransport.suspendTracing();
    }

    static /* synthetic */ void access$400(SMTPTransport sMTPTransport) {
        sMTPTransport.resumeTracing();
    }

    static /* synthetic */ void access$500(SMTPTransport sMTPTransport) throws MessagingException {
        sMTPTransport.closeConnection();
    }

    static /* synthetic */ Session access$600(SMTPTransport sMTPTransport) {
        return sMTPTransport.session;
    }

    static /* synthetic */ String access$700(SMTPTransport sMTPTransport) {
        return sMTPTransport.name;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$mail$smtp$SMTPTransport == null ? (class$com$sun$mail$smtp$SMTPTransport = SMTPTransport.class$((String)"macromedia.externals.com.sun.mail_1_4_7.smtp.SMTPTransport")) : class$com$sun$mail$smtp$SMTPTransport).desiredAssertionStatus();
        ignoreList = new String[]{"Bcc", "Content-Length"};
        CRLF = new byte[]{13, 10};
        UNKNOWN_SA = new String[0];
        hexchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

