/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.imap.protocol;

import java.io.IOException;
import java.util.Vector;
import macromedia.externals.com.sun.mail_1_4_7.iap.Protocol;
import macromedia.externals.com.sun.mail_1_4_7.iap.ProtocolException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Response;
import macromedia.externals.com.sun.mail_1_4_7.util.ASCIIUtility;

public class IMAPResponse
extends Response {
    private String key;
    private int number;

    public IMAPResponse(Protocol protocol) throws IOException, ProtocolException {
        super(protocol);
        this.init();
    }

    private void init() throws IOException, ProtocolException {
        if (!(!this.isUnTagged() || this.isOK() || this.isNO() || this.isBAD() || this.isBYE())) {
            this.key = this.readAtom();
            try {
                this.number = Integer.parseInt(this.key);
                this.key = this.readAtom();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public IMAPResponse(IMAPResponse iMAPResponse) {
        super((Response)iMAPResponse);
        this.key = iMAPResponse.key;
        this.number = iMAPResponse.number;
    }

    public IMAPResponse(String string) throws IOException, ProtocolException {
        super(string);
        this.init();
    }

    public String[] readSimpleList() {
        this.skipSpaces();
        if (this.buffer[this.index] != 40) {
            return null;
        }
        ++this.index;
        Vector<String> vector = new Vector<String>();
        int n2 = this.index;
        while (this.buffer[this.index] != 41) {
            if (this.buffer[this.index] == 32) {
                vector.addElement(ASCIIUtility.toString((byte[])this.buffer, (int)n2, (int)this.index));
                n2 = this.index + 1;
            }
            ++this.index;
        }
        if (this.index > n2) {
            vector.addElement(ASCIIUtility.toString((byte[])this.buffer, (int)n2, (int)this.index));
        }
        ++this.index;
        int n3 = vector.size();
        if (n3 > 0) {
            Object[] objectArray = new String[n3];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public boolean keyEquals(String string) {
        return this.key != null && this.key.equalsIgnoreCase(string);
    }

    public int getNumber() {
        return this.number;
    }
}

