/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.imap.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import macromedia.externals.com.sun.mail_1_4_7.auth.Ntlm;
import macromedia.externals.com.sun.mail_1_4_7.iap.Argument;
import macromedia.externals.com.sun.mail_1_4_7.iap.BadCommandException;
import macromedia.externals.com.sun.mail_1_4_7.iap.ByteArray;
import macromedia.externals.com.sun.mail_1_4_7.iap.CommandFailedException;
import macromedia.externals.com.sun.mail_1_4_7.iap.ConnectionException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Literal;
import macromedia.externals.com.sun.mail_1_4_7.iap.LiteralException;
import macromedia.externals.com.sun.mail_1_4_7.iap.ParsingException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Protocol;
import macromedia.externals.com.sun.mail_1_4_7.iap.ProtocolException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Response;
import macromedia.externals.com.sun.mail_1_4_7.imap.ACL;
import macromedia.externals.com.sun.mail_1_4_7.imap.AppendUID;
import macromedia.externals.com.sun.mail_1_4_7.imap.Rights;
import macromedia.externals.com.sun.mail_1_4_7.imap.SortTerm;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.BASE64MailboxEncoder;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.BODY;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.BODYSTRUCTURE;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.FetchItem;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.FetchResponse;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.IMAPResponse;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.INTERNALDATE;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.ListInfo;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.MailboxInfo;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.MessageSet;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.Namespaces;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.RFC822DATA;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.SaslAuthenticator;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.SearchSequence;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.Status;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.UID;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.UIDSet;
import macromedia.externals.com.sun.mail_1_4_7.util.ASCIIUtility;
import macromedia.externals.com.sun.mail_1_4_7.util.BASE64EncoderStream;
import macromedia.externals.com.sun.mail_1_4_7.util.MailLogger;
import macromedia.externals.com.sun.mail_1_4_7.util.PropUtil;
import macromedia.externals.javax.mail_1_4_7.Flags;
import macromedia.externals.javax.mail_1_4_7.Quota;
import macromedia.externals.javax.mail_1_4_7.internet.MimeUtility;
import macromedia.externals.javax.mail_1_4_7.search.SearchException;
import macromedia.externals.javax.mail_1_4_7.search.SearchTerm;

/*
 * Exception performing whole class analysis ignored.
 */
public class IMAPProtocol
extends Protocol {
    private boolean connected = false;
    private boolean rev1 = false;
    private boolean noauthdebug = true;
    private boolean authenticated;
    private Map capabilities;
    private List authmechs;
    protected SearchSequence searchSequence;
    protected String[] searchCharsets;
    private String name;
    private SaslAuthenticator saslAuthenticator;
    private ByteArray ba;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final FetchItem[] fetchItems = new FetchItem[0];
    private volatile String idleTag;
    private static final byte[] DONE = new byte[]{68, 79, 78, 69, 13, 10};
    static /* synthetic */ Class class$com$sun$mail$imap$protocol$IMAPProtocol;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$com$sun$mail$util$MailLogger;
    static /* synthetic */ Class class$com$sun$mail$imap$protocol$BODYSTRUCTURE;
    static /* synthetic */ Class class$com$sun$mail$imap$protocol$BODY;
    static /* synthetic */ Class class$com$sun$mail$imap$protocol$RFC822DATA;
    static /* synthetic */ Class class$javax$mail$Flags;
    static /* synthetic */ Class class$com$sun$mail$imap$protocol$UID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMAPProtocol(String string, String string2, int n2, Properties properties, boolean bl2, MailLogger mailLogger) throws IOException, ProtocolException {
        super(string2, n2, properties, new StringBuffer().append("mail.").append(string).toString(), bl2, mailLogger);
        try {
            this.name = string;
            boolean bl3 = this.noauthdebug = !PropUtil.getBooleanProperty((Properties)properties, (String)"mail.debug.auth", (boolean)false);
            if (this.capabilities == null) {
                this.capability();
            }
            if (this.hasCapability("IMAP4rev1")) {
                this.rev1 = true;
            }
            this.searchCharsets = new String[2];
            this.searchCharsets[0] = "UTF-8";
            this.searchCharsets[1] = MimeUtility.mimeCharset((String)MimeUtility.getDefaultJavaCharset());
            this.connected = true;
        }
        finally {
            if (!this.connected) {
                this.disconnect();
            }
        }
    }

    public FetchItem[] getFetchItems() {
        return fetchItems;
    }

    public void capability() throws ProtocolException {
        Response[] responseArray = this.command("CAPABILITY", null);
        if (!responseArray[responseArray.length - 1].isOK()) {
            throw new ProtocolException(responseArray[responseArray.length - 1].toString());
        }
        this.capabilities = new HashMap(10);
        this.authmechs = new ArrayList(5);
        int n2 = responseArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            IMAPResponse iMAPResponse;
            if (!(responseArray[i2] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i2]).keyEquals("CAPABILITY")) continue;
            this.parseCapabilities((Response)iMAPResponse);
        }
    }

    protected void setCapabilities(Response response) {
        byte by2;
        while ((by2 = response.readByte()) > 0 && by2 != 91) {
        }
        if (by2 == 0) {
            return;
        }
        String string = response.readAtom();
        if (!string.equalsIgnoreCase("CAPABILITY")) {
            return;
        }
        this.capabilities = new HashMap(10);
        this.authmechs = new ArrayList(5);
        this.parseCapabilities(response);
    }

    protected void parseCapabilities(Response response) {
        String string;
        while ((string = response.readAtom(']')) != null) {
            if (string.length() == 0) {
                if (response.peekByte() == 93) break;
                response.skipToken();
                continue;
            }
            this.capabilities.put(string.toUpperCase(Locale.ENGLISH), string);
            if (!string.regionMatches(true, 0, "AUTH=", 0, 5)) continue;
            this.authmechs.add(string.substring(5));
            if (!this.logger.isLoggable(Level.FINE)) continue;
            this.logger.fine(new StringBuffer().append("AUTH: ").append(string.substring(5)).toString());
        }
    }

    protected void processGreeting(Response response) throws ProtocolException {
        super.processGreeting(response);
        if (response.isOK()) {
            this.setCapabilities(response);
            return;
        }
        IMAPResponse iMAPResponse = (IMAPResponse)response;
        if (!iMAPResponse.keyEquals("PREAUTH")) {
            throw new ConnectionException((Protocol)this, response);
        }
        this.authenticated = true;
        this.setCapabilities(response);
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isREV1() {
        return this.rev1;
    }

    protected boolean supportsNonSyncLiterals() {
        return this.hasCapability("LITERAL+");
    }

    public Response readResponse() throws IOException, ProtocolException {
        IMAPResponse iMAPResponse = new IMAPResponse((Protocol)this);
        if (iMAPResponse.keyEquals("FETCH")) {
            iMAPResponse = new FetchResponse(iMAPResponse, this.getFetchItems());
        }
        return iMAPResponse;
    }

    public boolean hasCapability(String string) {
        if (string.endsWith("*")) {
            string = string.substring(0, string.length() - 1).toUpperCase(Locale.ENGLISH);
            Iterator iterator = this.capabilities.keySet().iterator();
            while (iterator.hasNext()) {
                if (!((String)iterator.next()).startsWith(string)) continue;
                return true;
            }
            return false;
        }
        return this.capabilities.containsKey(string.toUpperCase(Locale.ENGLISH));
    }

    public Map getCapabilities() {
        return this.capabilities;
    }

    public void disconnect() {
        super.disconnect();
        this.authenticated = false;
    }

    public void noop() throws ProtocolException {
        this.logger.fine("IMAPProtocol noop");
        this.simpleCommand("NOOP", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws ProtocolException {
        try {
            Response[] responseArray = this.command("LOGOUT", null);
            this.authenticated = false;
            this.notifyResponseHandlers(responseArray);
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String string, String string2) throws ProtocolException {
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(string2);
        Response[] responseArray = null;
        try {
            if (this.noauthdebug && this.isTracing()) {
                this.logger.fine("LOGIN command trace suppressed");
                this.suspendTracing();
            }
            responseArray = this.command("LOGIN", argument);
        }
        finally {
            this.resumeTracing();
        }
        this.notifyResponseHandlers(responseArray);
        if (this.noauthdebug && this.isTracing()) {
            this.logger.fine(new StringBuffer().append("LOGIN command result: ").append(responseArray[responseArray.length - 1]).toString());
        }
        this.handleResult(responseArray[responseArray.length - 1]);
        this.setCapabilities(responseArray[responseArray.length - 1]);
        this.authenticated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void authlogin(String string, String string2) throws ProtocolException {
        Object[] objectArray;
        Vector<Response> vector = new Vector<Response>();
        String string3 = null;
        Response response = null;
        boolean bl2 = false;
        try {
            if (this.noauthdebug && this.isTracing()) {
                this.logger.fine("AUTHENTICATE LOGIN command trace suppressed");
                this.suspendTracing();
            }
            try {
                string3 = this.writeCommand("AUTHENTICATE LOGIN", null);
            }
            catch (Exception exception) {
                response = Response.byeResponse((Exception)exception);
                bl2 = true;
            }
            objectArray = this.getOutputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BASE64EncoderStream bASE64EncoderStream = new BASE64EncoderStream((OutputStream)byteArrayOutputStream, Integer.MAX_VALUE);
            boolean bl3 = true;
            while (!bl2) {
                try {
                    response = this.readResponse();
                    if (response.isContinuation()) {
                        String string4;
                        if (bl3) {
                            string4 = string;
                            bl3 = false;
                        } else {
                            string4 = string2;
                        }
                        bASE64EncoderStream.write(ASCIIUtility.getBytes((String)string4));
                        bASE64EncoderStream.flush();
                        byteArrayOutputStream.write(CRLF);
                        objectArray.write(byteArrayOutputStream.toByteArray());
                        objectArray.flush();
                        byteArrayOutputStream.reset();
                        continue;
                    }
                    if (response.isTagged() && response.getTag().equals(string3)) {
                        bl2 = true;
                        continue;
                    }
                    if (response.isBYE()) {
                        bl2 = true;
                        continue;
                    }
                    vector.addElement(response);
                }
                catch (Exception exception) {
                    response = Response.byeResponse((Exception)exception);
                    bl2 = true;
                }
            }
        }
        finally {
            this.resumeTracing();
        }
        objectArray = new Response[vector.size()];
        vector.copyInto(objectArray);
        this.notifyResponseHandlers((Response[])objectArray);
        if (this.noauthdebug && this.isTracing()) {
            this.logger.fine(new StringBuffer().append("AUTHENTICATE LOGIN command result: ").append(response).toString());
        }
        this.handleResult(response);
        this.setCapabilities(response);
        this.authenticated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void authplain(String string, String string2, String string3) throws ProtocolException {
        Object[] objectArray;
        Vector<Response> vector = new Vector<Response>();
        String string4 = null;
        Response response = null;
        boolean bl2 = false;
        try {
            if (this.noauthdebug && this.isTracing()) {
                this.logger.fine("AUTHENTICATE PLAIN command trace suppressed");
                this.suspendTracing();
            }
            try {
                string4 = this.writeCommand("AUTHENTICATE PLAIN", null);
            }
            catch (Exception exception) {
                response = Response.byeResponse((Exception)exception);
                bl2 = true;
            }
            objectArray = this.getOutputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BASE64EncoderStream bASE64EncoderStream = new BASE64EncoderStream((OutputStream)byteArrayOutputStream, Integer.MAX_VALUE);
            while (!bl2) {
                try {
                    response = this.readResponse();
                    if (response.isContinuation()) {
                        String string5 = "\u0000";
                        String string6 = new StringBuffer().append(string == null ? "" : string).append("\u0000").append(string2).append("\u0000").append(string3).toString();
                        bASE64EncoderStream.write(ASCIIUtility.getBytes((String)string6));
                        bASE64EncoderStream.flush();
                        byteArrayOutputStream.write(CRLF);
                        objectArray.write(byteArrayOutputStream.toByteArray());
                        objectArray.flush();
                        byteArrayOutputStream.reset();
                        continue;
                    }
                    if (response.isTagged() && response.getTag().equals(string4)) {
                        bl2 = true;
                        continue;
                    }
                    if (response.isBYE()) {
                        bl2 = true;
                        continue;
                    }
                    vector.addElement(response);
                }
                catch (Exception exception) {
                    response = Response.byeResponse((Exception)exception);
                    bl2 = true;
                }
            }
        }
        finally {
            this.resumeTracing();
        }
        objectArray = new Response[vector.size()];
        vector.copyInto(objectArray);
        this.notifyResponseHandlers((Response[])objectArray);
        if (this.noauthdebug && this.isTracing()) {
            this.logger.fine(new StringBuffer().append("AUTHENTICATE PLAIN command result: ").append(response).toString());
        }
        this.handleResult(response);
        this.setCapabilities(response);
        this.authenticated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void authntlm(String string, String string2, String string3) throws ProtocolException {
        Object[] objectArray;
        Vector<Response> vector = new Vector<Response>();
        String string4 = null;
        Response response = null;
        boolean bl2 = false;
        Object var8_8 = null;
        int n2 = PropUtil.getIntProperty((Properties)this.props, (String)new StringBuffer().append("mail.").append(this.name).append(".auth.ntlm.flags").toString(), (int)0);
        String string5 = this.props.getProperty(new StringBuffer().append("mail.").append(this.name).append(".auth.ntlm.domain").toString(), "");
        Ntlm ntlm = new Ntlm(string5, this.getLocalHost(), string2, string3, this.logger);
        try {
            if (this.noauthdebug && this.isTracing()) {
                this.logger.fine("AUTHENTICATE NTLM command trace suppressed");
                this.suspendTracing();
            }
            try {
                string4 = this.writeCommand("AUTHENTICATE NTLM", null);
            }
            catch (Exception exception) {
                response = Response.byeResponse((Exception)exception);
                bl2 = true;
            }
            objectArray = this.getOutputStream();
            boolean bl3 = true;
            while (!bl2) {
                try {
                    response = this.readResponse();
                    if (response.isContinuation()) {
                        String string6;
                        if (bl3) {
                            string6 = ntlm.generateType1Msg(n2);
                            bl3 = false;
                        } else {
                            string6 = ntlm.generateType3Msg(response.getRest());
                        }
                        objectArray.write(ASCIIUtility.getBytes((String)string6));
                        objectArray.write(CRLF);
                        objectArray.flush();
                        continue;
                    }
                    if (response.isTagged() && response.getTag().equals(string4)) {
                        bl2 = true;
                        continue;
                    }
                    if (response.isBYE()) {
                        bl2 = true;
                        continue;
                    }
                    vector.addElement(response);
                }
                catch (Exception exception) {
                    response = Response.byeResponse((Exception)exception);
                    bl2 = true;
                }
            }
        }
        finally {
            this.resumeTracing();
        }
        objectArray = new Response[vector.size()];
        vector.copyInto(objectArray);
        this.notifyResponseHandlers((Response[])objectArray);
        if (this.noauthdebug && this.isTracing()) {
            this.logger.fine(new StringBuffer().append("AUTHENTICATE NTLM command result: ").append(response).toString());
        }
        this.handleResult(response);
        this.setCapabilities(response);
        this.authenticated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sasllogin(String[] stringArray, String string, String string2, String string3, String string4) throws ProtocolException {
        ArrayList<String> arrayList;
        if (this.saslAuthenticator == null) {
            try {
                arrayList = Class.forName("macromedia.externals.com.sun.mail_1_4_7.imap.protocol.IMAPSaslAuthenticator");
                Constructor<?> constructor = ((Class)((Object)arrayList)).getConstructor(class$com$sun$mail$imap$protocol$IMAPProtocol == null ? (class$com$sun$mail$imap$protocol$IMAPProtocol = IMAPProtocol.class$((String)"macromedia.externals.com.sun.mail_1_4_7.imap.protocol.IMAPProtocol")) : class$com$sun$mail$imap$protocol$IMAPProtocol, class$java$lang$String == null ? (class$java$lang$String = IMAPProtocol.class$((String)"java.lang.String")) : class$java$lang$String, class$java$util$Properties == null ? (class$java$util$Properties = IMAPProtocol.class$((String)"java.util.Properties")) : class$java$util$Properties, class$com$sun$mail$util$MailLogger == null ? (class$com$sun$mail$util$MailLogger = IMAPProtocol.class$((String)"macromedia.externals.com.sun.mail_1_4_7.util.MailLogger")) : class$com$sun$mail$util$MailLogger, class$java$lang$String == null ? (class$java$lang$String = IMAPProtocol.class$((String)"java.lang.String")) : class$java$lang$String);
                this.saslAuthenticator = (SaslAuthenticator)constructor.newInstance(this, this.name, this.props, this.logger, this.host);
            }
            catch (Exception exception) {
                this.logger.log(Level.FINE, "Can't load SASL authenticator", (Throwable)exception);
                return;
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            arrayList = new ArrayList<String>(stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!this.authmechs.contains(stringArray[i2])) continue;
                arrayList.add(stringArray[i2]);
            }
        } else {
            arrayList = this.authmechs;
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        try {
            if (this.noauthdebug && this.isTracing()) {
                this.logger.fine("SASL authentication command trace suppressed");
                this.suspendTracing();
            }
            if (this.saslAuthenticator.authenticate(stringArray2, string, string2, string3, string4)) {
                if (this.noauthdebug && this.isTracing()) {
                    this.logger.fine("SASL authentication succeeded");
                }
                this.authenticated = true;
            } else if (this.noauthdebug && this.isTracing()) {
                this.logger.fine("SASL authentication failed");
            }
        }
        finally {
            this.resumeTracing();
        }
    }

    OutputStream getIMAPOutputStream() {
        return this.getOutputStream();
    }

    public void proxyauth(String string) throws ProtocolException {
        Argument argument = new Argument();
        argument.writeString(string);
        this.simpleCommand("PROXYAUTH", argument);
    }

    public void id(String string) throws ProtocolException {
        this.simpleCommand(new StringBuffer().append("ID (\"GUID\" \"").append(string).append("\")").toString(), null);
    }

    public void startTLS() throws ProtocolException {
        try {
            super.startTLS("STARTTLS");
        }
        catch (ProtocolException protocolException) {
            this.logger.log(Level.FINE, "STARTTLS ProtocolException", (Throwable)protocolException);
            throw protocolException;
        }
        catch (Exception exception) {
            this.logger.log(Level.FINE, "STARTTLS Exception", (Throwable)exception);
            Response[] responseArray = new Response[]{Response.byeResponse((Exception)exception)};
            this.notifyResponseHandlers(responseArray);
            this.disconnect();
            throw new ProtocolException("STARTTLS failure", (Throwable)exception);
        }
    }

    public MailboxInfo select(String string) throws ProtocolException {
        string = BASE64MailboxEncoder.encode((String)string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("SELECT", argument);
        MailboxInfo mailboxInfo = new MailboxInfo(responseArray);
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            mailboxInfo.mode = response.toString().indexOf("READ-ONLY") != -1 ? 1 : 2;
        }
        this.handleResult(response);
        return mailboxInfo;
    }

    public MailboxInfo examine(String string) throws ProtocolException {
        string = BASE64MailboxEncoder.encode((String)string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("EXAMINE", argument);
        MailboxInfo mailboxInfo = new MailboxInfo(responseArray);
        mailboxInfo.mode = 1;
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        return mailboxInfo;
    }

    public void unselect() throws ProtocolException {
        if (!this.hasCapability("UNSELECT")) {
            throw new BadCommandException("UNSELECT not supported");
        }
        this.simpleCommand("UNSELECT", null);
    }

    public Status status(String string, String[] stringArray) throws ProtocolException {
        if (!this.isREV1() && !this.hasCapability("IMAP4SUNVERSION")) {
            throw new BadCommandException("STATUS not supported");
        }
        string = BASE64MailboxEncoder.encode((String)string);
        Argument argument = new Argument();
        argument.writeString(string);
        Argument argument2 = new Argument();
        if (stringArray == null) {
            stringArray = Status.standardItems;
        }
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            argument2.writeAtom(stringArray[i2]);
        }
        argument.writeArgument(argument2);
        Response[] responseArray = this.command("STATUS", argument);
        Status status = null;
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            int n3 = responseArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                IMAPResponse iMAPResponse;
                if (!(responseArray[i3] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i3]).keyEquals("STATUS")) continue;
                if (status == null) {
                    status = new Status((Response)iMAPResponse);
                } else {
                    Status.add((Status)status, (Status)new Status((Response)iMAPResponse));
                }
                responseArray[i3] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return status;
    }

    public void create(String string) throws ProtocolException {
        string = BASE64MailboxEncoder.encode((String)string);
        Argument argument = new Argument();
        argument.writeString(string);
        this.simpleCommand("CREATE", argument);
    }

    public void delete(String string) throws ProtocolException {
        string = BASE64MailboxEncoder.encode((String)string);
        Argument argument = new Argument();
        argument.writeString(string);
        this.simpleCommand("DELETE", argument);
    }

    public void rename(String string, String string2) throws ProtocolException {
        string = BASE64MailboxEncoder.encode((String)string);
        string2 = BASE64MailboxEncoder.encode((String)string2);
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(string2);
        this.simpleCommand("RENAME", argument);
    }

    public void subscribe(String string) throws ProtocolException {
        Argument argument = new Argument();
        string = BASE64MailboxEncoder.encode((String)string);
        argument.writeString(string);
        this.simpleCommand("SUBSCRIBE", argument);
    }

    public void unsubscribe(String string) throws ProtocolException {
        Argument argument = new Argument();
        string = BASE64MailboxEncoder.encode((String)string);
        argument.writeString(string);
        this.simpleCommand("UNSUBSCRIBE", argument);
    }

    public ListInfo[] list(String string, String string2) throws ProtocolException {
        return this.doList("LIST", string, string2);
    }

    public ListInfo[] lsub(String string, String string2) throws ProtocolException {
        return this.doList("LSUB", string, string2);
    }

    protected ListInfo[] doList(String string, String string2, String string3) throws ProtocolException {
        string2 = BASE64MailboxEncoder.encode((String)string2);
        string3 = BASE64MailboxEncoder.encode((String)string3);
        Argument argument = new Argument();
        argument.writeString(string2);
        argument.writeString(string3);
        Response[] responseArray = this.command(string, argument);
        Object[] objectArray = null;
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            Vector<ListInfo> vector = new Vector<ListInfo>(1);
            int n2 = responseArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                IMAPResponse iMAPResponse;
                if (!(responseArray[i2] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i2]).keyEquals(string)) continue;
                vector.addElement(new ListInfo(iMAPResponse));
                responseArray[i2] = null;
            }
            if (vector.size() > 0) {
                objectArray = new ListInfo[vector.size()];
                vector.copyInto(objectArray);
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return objectArray;
    }

    public void append(String string, Flags flags, Date date, Literal literal) throws ProtocolException {
        this.appenduid(string, flags, date, literal, false);
    }

    public AppendUID appenduid(String string, Flags flags, Date date, Literal literal) throws ProtocolException {
        return this.appenduid(string, flags, date, literal, true);
    }

    public AppendUID appenduid(String string, Flags flags, Date date, Literal literal, boolean bl2) throws ProtocolException {
        string = BASE64MailboxEncoder.encode((String)string);
        Argument argument = new Argument();
        argument.writeString(string);
        if (flags != null) {
            if (flags.contains(Flags.Flag.RECENT)) {
                flags = new Flags(flags);
                flags.remove(Flags.Flag.RECENT);
            }
            argument.writeAtom(this.createFlagList(flags));
        }
        if (date != null) {
            argument.writeString(INTERNALDATE.format((Date)date));
        }
        argument.writeBytes(literal);
        Response[] responseArray = this.command("APPEND", argument);
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        if (bl2) {
            return this.getAppendUID(responseArray[responseArray.length - 1]);
        }
        return null;
    }

    private AppendUID getAppendUID(Response response) {
        byte by2;
        if (!response.isOK()) {
            return null;
        }
        while ((by2 = response.readByte()) > 0 && by2 != 91) {
        }
        if (by2 == 0) {
            return null;
        }
        String string = response.readAtom();
        if (!string.equalsIgnoreCase("APPENDUID")) {
            return null;
        }
        long l2 = response.readLong();
        long l3 = response.readLong();
        return new AppendUID(l2, l3);
    }

    public void check() throws ProtocolException {
        this.simpleCommand("CHECK", null);
    }

    public void close() throws ProtocolException {
        this.simpleCommand("CLOSE", null);
    }

    public void expunge() throws ProtocolException {
        this.simpleCommand("EXPUNGE", null);
    }

    public void uidexpunge(UIDSet[] uIDSetArray) throws ProtocolException {
        if (!this.hasCapability("UIDPLUS")) {
            throw new BadCommandException("UID EXPUNGE not supported");
        }
        this.simpleCommand(new StringBuffer().append("UID EXPUNGE ").append(UIDSet.toString((UIDSet[])uIDSetArray)).toString(), null);
    }

    public BODYSTRUCTURE fetchBodyStructure(int n2) throws ProtocolException {
        Response[] responseArray = this.fetch(n2, "BODYSTRUCTURE");
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (BODYSTRUCTURE)FetchResponse.getItem((Response[])responseArray, (int)n2, (Class)(class$com$sun$mail$imap$protocol$BODYSTRUCTURE == null ? (class$com$sun$mail$imap$protocol$BODYSTRUCTURE = IMAPProtocol.class$((String)"macromedia.externals.com.sun.mail_1_4_7.imap.protocol.BODYSTRUCTURE")) : class$com$sun$mail$imap$protocol$BODYSTRUCTURE));
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public BODY peekBody(int n2, String string) throws ProtocolException {
        return this.fetchBody(n2, string, true);
    }

    public BODY fetchBody(int n2, String string) throws ProtocolException {
        return this.fetchBody(n2, string, false);
    }

    protected BODY fetchBody(int n2, String string, boolean bl2) throws ProtocolException {
        Response[] responseArray = bl2 ? this.fetch(n2, new StringBuffer().append("BODY.PEEK[").append(string == null ? "]" : new StringBuffer().append(string).append("]").toString()).toString()) : this.fetch(n2, new StringBuffer().append("BODY[").append(string == null ? "]" : new StringBuffer().append(string).append("]").toString()).toString());
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (BODY)FetchResponse.getItem((Response[])responseArray, (int)n2, (Class)(class$com$sun$mail$imap$protocol$BODY == null ? (class$com$sun$mail$imap$protocol$BODY = IMAPProtocol.class$((String)"macromedia.externals.com.sun.mail_1_4_7.imap.protocol.BODY")) : class$com$sun$mail$imap$protocol$BODY));
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public BODY peekBody(int n2, String string, int n3, int n4) throws ProtocolException {
        return this.fetchBody(n2, string, n3, n4, true, null);
    }

    public BODY fetchBody(int n2, String string, int n3, int n4) throws ProtocolException {
        return this.fetchBody(n2, string, n3, n4, false, null);
    }

    public BODY peekBody(int n2, String string, int n3, int n4, ByteArray byteArray) throws ProtocolException {
        return this.fetchBody(n2, string, n3, n4, true, byteArray);
    }

    public BODY fetchBody(int n2, String string, int n3, int n4, ByteArray byteArray) throws ProtocolException {
        return this.fetchBody(n2, string, n3, n4, false, byteArray);
    }

    protected BODY fetchBody(int n2, String string, int n3, int n4, boolean bl2, ByteArray byteArray) throws ProtocolException {
        this.ba = byteArray;
        Response[] responseArray = this.fetch(n2, new StringBuffer().append(bl2 ? "BODY.PEEK[" : "BODY[").append(string == null ? "]<" : new StringBuffer().append(string).append("]<").toString()).append(String.valueOf(n3)).append(".").append(String.valueOf(n4)).append(">").toString());
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (BODY)FetchResponse.getItem((Response[])responseArray, (int)n2, (Class)(class$com$sun$mail$imap$protocol$BODY == null ? (class$com$sun$mail$imap$protocol$BODY = IMAPProtocol.class$((String)"macromedia.externals.com.sun.mail_1_4_7.imap.protocol.BODY")) : class$com$sun$mail$imap$protocol$BODY));
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    protected ByteArray getResponseBuffer() {
        ByteArray byteArray = this.ba;
        this.ba = null;
        return byteArray;
    }

    public RFC822DATA fetchRFC822(int n2, String string) throws ProtocolException {
        Response[] responseArray = this.fetch(n2, string == null ? "RFC822" : new StringBuffer().append("RFC822.").append(string).toString());
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (RFC822DATA)FetchResponse.getItem((Response[])responseArray, (int)n2, (Class)(class$com$sun$mail$imap$protocol$RFC822DATA == null ? (class$com$sun$mail$imap$protocol$RFC822DATA = IMAPProtocol.class$((String)"macromedia.externals.com.sun.mail_1_4_7.imap.protocol.RFC822DATA")) : class$com$sun$mail$imap$protocol$RFC822DATA));
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public Flags fetchFlags(int n2) throws ProtocolException {
        Flags flags = null;
        Response[] responseArray = this.fetch(n2, "FLAGS");
        int n3 = responseArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (responseArray[i2] == null || !(responseArray[i2] instanceof FetchResponse) || ((FetchResponse)responseArray[i2]).getNumber() != n2) continue;
            FetchResponse fetchResponse = (FetchResponse)responseArray[i2];
            flags = (Flags)fetchResponse.getItem(class$javax$mail$Flags == null ? IMAPProtocol.class$((String)"macromedia.externals.javax.mail_1_4_7.Flags") : class$javax$mail$Flags);
            if (flags == null) continue;
            responseArray[i2] = null;
            break;
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        return flags;
    }

    public UID fetchUID(int n2) throws ProtocolException {
        Response[] responseArray = this.fetch(n2, "UID");
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (UID)FetchResponse.getItem((Response[])responseArray, (int)n2, (Class)(class$com$sun$mail$imap$protocol$UID == null ? (class$com$sun$mail$imap$protocol$UID = IMAPProtocol.class$((String)"macromedia.externals.com.sun.mail_1_4_7.imap.protocol.UID")) : class$com$sun$mail$imap$protocol$UID));
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public UID fetchSequenceNumber(long l2) throws ProtocolException {
        UID uID = null;
        Response[] responseArray = this.fetch(String.valueOf(l2), "UID", true);
        int n2 = responseArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (responseArray[i2] == null || !(responseArray[i2] instanceof FetchResponse)) continue;
            FetchResponse fetchResponse = (FetchResponse)responseArray[i2];
            uID = (UID)fetchResponse.getItem(class$com$sun$mail$imap$protocol$UID == null ? IMAPProtocol.class$((String)"macromedia.externals.com.sun.mail_1_4_7.imap.protocol.UID") : class$com$sun$mail$imap$protocol$UID);
            if (uID == null) continue;
            if (uID.uid == l2) break;
            uID = null;
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        return uID;
    }

    public UID[] fetchSequenceNumbers(long l2, long l3) throws ProtocolException {
        Response[] responseArray = this.fetch(new StringBuffer().append(String.valueOf(l2)).append(":").append(l3 == -1L ? "*" : String.valueOf(l3)).toString(), "UID", true);
        Vector<UID> vector = new Vector<UID>();
        int n2 = responseArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (responseArray[i2] == null || !(responseArray[i2] instanceof FetchResponse)) continue;
            FetchResponse fetchResponse = (FetchResponse)responseArray[i2];
            UID uID = (UID)fetchResponse.getItem(class$com$sun$mail$imap$protocol$UID == null ? IMAPProtocol.class$((String)"macromedia.externals.com.sun.mail_1_4_7.imap.protocol.UID") : class$com$sun$mail$imap$protocol$UID);
            if (uID == null) continue;
            vector.addElement(uID);
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        Object[] objectArray = new UID[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public UID[] fetchSequenceNumbers(long[] lArray) throws ProtocolException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(String.valueOf(lArray[i2]));
        }
        Response[] responseArray = this.fetch(stringBuffer.toString(), "UID", true);
        Vector<UID> vector = new Vector<UID>();
        int n2 = responseArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            if (responseArray[i3] == null || !(responseArray[i3] instanceof FetchResponse)) continue;
            FetchResponse fetchResponse = (FetchResponse)responseArray[i3];
            UID uID = (UID)fetchResponse.getItem(class$com$sun$mail$imap$protocol$UID == null ? IMAPProtocol.class$((String)"macromedia.externals.com.sun.mail_1_4_7.imap.protocol.UID") : class$com$sun$mail$imap$protocol$UID);
            if (uID == null) continue;
            vector.addElement(uID);
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        Object[] objectArray = new UID[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Response[] fetch(MessageSet[] messageSetArray, String string) throws ProtocolException {
        return this.fetch(MessageSet.toString((MessageSet[])messageSetArray), string, false);
    }

    public Response[] fetch(int n2, int n3, String string) throws ProtocolException {
        return this.fetch(new StringBuffer().append(String.valueOf(n2)).append(":").append(String.valueOf(n3)).toString(), string, false);
    }

    public Response[] fetch(int n2, String string) throws ProtocolException {
        return this.fetch(String.valueOf(n2), string, false);
    }

    private Response[] fetch(String string, String string2, boolean bl2) throws ProtocolException {
        if (bl2) {
            return this.command(new StringBuffer().append("UID FETCH ").append(string).append(" (").append(string2).append(")").toString(), null);
        }
        return this.command(new StringBuffer().append("FETCH ").append(string).append(" (").append(string2).append(")").toString(), null);
    }

    public void copy(MessageSet[] messageSetArray, String string) throws ProtocolException {
        this.copy(MessageSet.toString((MessageSet[])messageSetArray), string);
    }

    public void copy(int n2, int n3, String string) throws ProtocolException {
        this.copy(new StringBuffer().append(String.valueOf(n2)).append(":").append(String.valueOf(n3)).toString(), string);
    }

    private void copy(String string, String string2) throws ProtocolException {
        string2 = BASE64MailboxEncoder.encode((String)string2);
        Argument argument = new Argument();
        argument.writeAtom(string);
        argument.writeString(string2);
        this.simpleCommand("COPY", argument);
    }

    public void storeFlags(MessageSet[] messageSetArray, Flags flags, boolean bl2) throws ProtocolException {
        this.storeFlags(MessageSet.toString((MessageSet[])messageSetArray), flags, bl2);
    }

    public void storeFlags(int n2, int n3, Flags flags, boolean bl2) throws ProtocolException {
        this.storeFlags(new StringBuffer().append(String.valueOf(n2)).append(":").append(String.valueOf(n3)).toString(), flags, bl2);
    }

    public void storeFlags(int n2, Flags flags, boolean bl2) throws ProtocolException {
        this.storeFlags(String.valueOf(n2), flags, bl2);
    }

    private void storeFlags(String string, Flags flags, boolean bl2) throws ProtocolException {
        Response[] responseArray = bl2 ? this.command(new StringBuffer().append("STORE ").append(string).append(" +FLAGS ").append(this.createFlagList(flags)).toString(), null) : this.command(new StringBuffer().append("STORE ").append(string).append(" -FLAGS ").append(this.createFlagList(flags)).toString(), null);
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
    }

    private String createFlagList(Flags flags) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Flags.Flag[] flagArray = flags.getSystemFlags();
        boolean bl2 = true;
        for (int i2 = 0; i2 < flagArray.length; ++i2) {
            String string;
            Flags.Flag flag = flagArray[i2];
            if (flag == Flags.Flag.ANSWERED) {
                string = "\\Answered";
            } else if (flag == Flags.Flag.DELETED) {
                string = "\\Deleted";
            } else if (flag == Flags.Flag.DRAFT) {
                string = "\\Draft";
            } else if (flag == Flags.Flag.FLAGGED) {
                string = "\\Flagged";
            } else if (flag == Flags.Flag.RECENT) {
                string = "\\Recent";
            } else {
                if (flag != Flags.Flag.SEEN) continue;
                string = "\\Seen";
            }
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
        }
        String[] stringArray = flags.getUserFlags();
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[i3]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public int[] search(MessageSet[] messageSetArray, SearchTerm searchTerm) throws ProtocolException, SearchException {
        return this.search(MessageSet.toString((MessageSet[])messageSetArray), searchTerm);
    }

    public int[] search(SearchTerm searchTerm) throws ProtocolException, SearchException {
        return this.search("ALL", searchTerm);
    }

    private int[] search(String string, SearchTerm searchTerm) throws ProtocolException, SearchException {
        this.getSearchSequence();
        if (SearchSequence.isAscii((SearchTerm)searchTerm)) {
            try {
                return this.issueSearch(string, searchTerm, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (int i2 = 0; i2 < this.searchCharsets.length; ++i2) {
            if (this.searchCharsets[i2] == null) continue;
            try {
                return this.issueSearch(string, searchTerm, this.searchCharsets[i2]);
            }
            catch (CommandFailedException commandFailedException) {
                this.searchCharsets[i2] = null;
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (ProtocolException protocolException) {
                throw protocolException;
            }
            catch (SearchException searchException) {
                throw searchException;
            }
        }
        throw new SearchException("Search failed");
    }

    private int[] issueSearch(String string, SearchTerm searchTerm, String string2) throws ProtocolException, SearchException, IOException {
        Argument argument = this.getSearchSequence().generateSequence(searchTerm, string2 == null ? null : MimeUtility.javaCharset((String)string2));
        argument.writeAtom(string);
        Response[] responseArray = string2 == null ? this.command("SEARCH", argument) : this.command(new StringBuffer().append("SEARCH CHARSET ").append(string2).toString(), argument);
        Response response = responseArray[responseArray.length - 1];
        int[] nArray = null;
        if (response.isOK()) {
            int n2;
            Vector<Integer> vector = new Vector<Integer>();
            int n3 = responseArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                IMAPResponse iMAPResponse;
                if (!(responseArray[n2] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[n2]).keyEquals("SEARCH")) continue;
                while ((n4 = iMAPResponse.readNumber()) != -1) {
                    vector.addElement(new Integer(n4));
                }
                responseArray[n2] = null;
            }
            n2 = vector.size();
            nArray = new int[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                nArray[n3] = (Integer)vector.elementAt(n3);
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return nArray;
    }

    protected SearchSequence getSearchSequence() {
        if (this.searchSequence == null) {
            this.searchSequence = new SearchSequence();
        }
        return this.searchSequence;
    }

    public int[] sort(SortTerm[] sortTermArray, SearchTerm searchTerm) throws ProtocolException, SearchException {
        if (!this.hasCapability("SORT*")) {
            throw new BadCommandException("SORT not supported");
        }
        if (sortTermArray == null || sortTermArray.length == 0) {
            throw new BadCommandException("Must have at least one sort term");
        }
        Argument argument = new Argument();
        Argument argument2 = new Argument();
        for (int i2 = 0; i2 < sortTermArray.length; ++i2) {
            argument2.writeAtom(sortTermArray[i2].toString());
        }
        argument.writeArgument(argument2);
        argument.writeAtom("UTF-8");
        if (searchTerm != null) {
            try {
                argument.append(this.getSearchSequence().generateSequence(searchTerm, "UTF-8"));
            }
            catch (IOException iOException) {
                throw new SearchException(iOException.toString());
            }
        } else {
            argument.writeAtom("ALL");
        }
        Response[] responseArray = this.command("SORT", argument);
        Response response = responseArray[responseArray.length - 1];
        int[] nArray = null;
        if (response.isOK()) {
            int n2;
            Vector<Integer> vector = new Vector<Integer>();
            int n3 = responseArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                IMAPResponse iMAPResponse;
                if (!(responseArray[n2] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[n2]).keyEquals("SORT")) continue;
                while ((n4 = iMAPResponse.readNumber()) != -1) {
                    vector.addElement(new Integer(n4));
                }
                responseArray[n2] = null;
            }
            n2 = vector.size();
            nArray = new int[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                nArray[n3] = (Integer)vector.elementAt(n3);
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return nArray;
    }

    public Namespaces namespace() throws ProtocolException {
        if (!this.hasCapability("NAMESPACE")) {
            throw new BadCommandException("NAMESPACE not supported");
        }
        Response[] responseArray = this.command("NAMESPACE", null);
        Namespaces namespaces = null;
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            int n2 = responseArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                IMAPResponse iMAPResponse;
                if (!(responseArray[i2] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i2]).keyEquals("NAMESPACE")) continue;
                if (namespaces == null) {
                    namespaces = new Namespaces((Response)iMAPResponse);
                }
                responseArray[i2] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return namespaces;
    }

    public Quota[] getQuotaRoot(String string) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("GETQUOTAROOT not supported");
        }
        string = BASE64MailboxEncoder.encode((String)string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("GETQUOTAROOT", argument);
        Response response = responseArray[responseArray.length - 1];
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        if (response.isOK()) {
            int n2 = responseArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object;
                if (!(responseArray[i2] instanceof IMAPResponse)) continue;
                IMAPResponse iMAPResponse = (IMAPResponse)responseArray[i2];
                if (iMAPResponse.keyEquals("QUOTAROOT")) {
                    iMAPResponse.readAtomString();
                    object = null;
                    while ((object = iMAPResponse.readAtomString()) != null && ((String)object).length() > 0) {
                        hashtable.put(object, new Quota((String)object));
                    }
                    responseArray[i2] = null;
                    continue;
                }
                if (!iMAPResponse.keyEquals("QUOTA")) continue;
                object = this.parseQuota((Response)iMAPResponse);
                Quota quota = (Quota)hashtable.get(((Quota)object).quotaRoot);
                if (quota == null || quota.resources != null) {
                    // empty if block
                }
                hashtable.put(((Quota)object).quotaRoot, object);
                responseArray[i2] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        Quota[] quotaArray = new Quota[hashtable.size()];
        Enumeration enumeration = hashtable.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            quotaArray[n3] = (Quota)enumeration.nextElement();
            ++n3;
        }
        return quotaArray;
    }

    public Quota[] getQuota(String string) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("QUOTA not supported");
        }
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("GETQUOTA", argument);
        Quota quota = null;
        Vector<Quota> vector = new Vector<Quota>();
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            int n2 = responseArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                IMAPResponse iMAPResponse;
                if (!(responseArray[i2] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i2]).keyEquals("QUOTA")) continue;
                quota = this.parseQuota((Response)iMAPResponse);
                vector.addElement(quota);
                responseArray[i2] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        Object[] objectArray = new Quota[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setQuota(Quota quota) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("QUOTA not supported");
        }
        Argument argument = new Argument();
        argument.writeString(quota.quotaRoot);
        Argument argument2 = new Argument();
        if (quota.resources != null) {
            for (int i2 = 0; i2 < quota.resources.length; ++i2) {
                argument2.writeAtom(quota.resources[i2].name);
                argument2.writeNumber(quota.resources[i2].limit);
            }
        }
        argument.writeArgument(argument2);
        Response[] responseArray = this.command("SETQUOTA", argument);
        Response response = responseArray[responseArray.length - 1];
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
    }

    private Quota parseQuota(Response response) throws ParsingException {
        String string = response.readAtomString();
        Quota quota = new Quota(string);
        response.skipSpaces();
        if (response.readByte() != 40) {
            throw new ParsingException("parse error in QUOTA");
        }
        Vector<Quota.Resource> vector = new Vector<Quota.Resource>();
        while (response.peekByte() != 41) {
            String string2 = response.readAtom();
            if (string2 == null) continue;
            long l2 = response.readLong();
            long l3 = response.readLong();
            Quota.Resource resource = new Quota.Resource(string2, l2, l3);
            vector.addElement(resource);
        }
        response.readByte();
        quota.resources = new Quota.Resource[vector.size()];
        vector.copyInto(quota.resources);
        return quota;
    }

    public void setACL(String string, char c2, ACL aCL) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode((String)string);
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(aCL.getName());
        String string2 = aCL.getRights().toString();
        if (c2 == '+' || c2 == '-') {
            string2 = new StringBuffer().append(c2).append(string2).toString();
        }
        argument.writeString(string2);
        Response[] responseArray = this.command("SETACL", argument);
        Response response = responseArray[responseArray.length - 1];
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
    }

    public void deleteACL(String string, String string2) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode((String)string);
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(string2);
        Response[] responseArray = this.command("DELETEACL", argument);
        Response response = responseArray[responseArray.length - 1];
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
    }

    public ACL[] getACL(String string) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode((String)string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("GETACL", argument);
        Response response = responseArray[responseArray.length - 1];
        Vector<ACL> vector = new Vector<ACL>();
        if (response.isOK()) {
            int n2 = responseArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2;
                IMAPResponse iMAPResponse;
                if (!(responseArray[i2] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i2]).keyEquals("ACL")) continue;
                iMAPResponse.readAtomString();
                String string3 = null;
                while ((string3 = iMAPResponse.readAtomString()) != null && (string2 = iMAPResponse.readAtomString()) != null) {
                    ACL aCL = new ACL(string3, new Rights(string2));
                    vector.addElement(aCL);
                }
                responseArray[i2] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        Object[] objectArray = new ACL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Rights[] listRights(String string, String string2) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode((String)string);
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(string2);
        Response[] responseArray = this.command("LISTRIGHTS", argument);
        Response response = responseArray[responseArray.length - 1];
        Vector<Rights> vector = new Vector<Rights>();
        if (response.isOK()) {
            int n2 = responseArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string3;
                IMAPResponse iMAPResponse;
                if (!(responseArray[i2] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i2]).keyEquals("LISTRIGHTS")) continue;
                iMAPResponse.readAtomString();
                iMAPResponse.readAtomString();
                while ((string3 = iMAPResponse.readAtomString()) != null) {
                    vector.addElement(new Rights(string3));
                }
                responseArray[i2] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        Object[] objectArray = new Rights[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Rights myRights(String string) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode((String)string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("MYRIGHTS", argument);
        Response response = responseArray[responseArray.length - 1];
        Rights rights = null;
        if (response.isOK()) {
            int n2 = responseArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                IMAPResponse iMAPResponse;
                if (!(responseArray[i2] instanceof IMAPResponse) || !(iMAPResponse = (IMAPResponse)responseArray[i2]).keyEquals("MYRIGHTS")) continue;
                iMAPResponse.readAtomString();
                String string2 = iMAPResponse.readAtomString();
                if (rights == null) {
                    rights = new Rights(string2);
                }
                responseArray[i2] = null;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return rights;
    }

    public synchronized void idleStart() throws ProtocolException {
        if (!this.hasCapability("IDLE")) {
            throw new BadCommandException("IDLE not supported");
        }
        Vector<Response> vector = new Vector<Response>();
        boolean bl2 = false;
        Object object = null;
        try {
            this.idleTag = this.writeCommand("IDLE", null);
        }
        catch (LiteralException literalException) {
            vector.addElement(literalException.getResponse());
            bl2 = true;
        }
        catch (Exception exception) {
            vector.addElement(Response.byeResponse((Exception)exception));
            bl2 = true;
        }
        while (!bl2) {
            try {
                object = this.readResponse();
            }
            catch (IOException iOException) {
                object = Response.byeResponse((Exception)iOException);
            }
            catch (ProtocolException protocolException) {
                continue;
            }
            vector.addElement((Response)object);
            if (!object.isContinuation() && !object.isBYE()) continue;
            bl2 = true;
        }
        Object[] objectArray = new Response[vector.size()];
        vector.copyInto(objectArray);
        object = objectArray[objectArray.length - 1];
        this.notifyResponseHandlers((Response[])objectArray);
        if (!object.isContinuation()) {
            this.handleResult(object);
        }
    }

    public synchronized Response readIdleResponse() {
        if (this.idleTag == null) {
            return null;
        }
        Response response = null;
        while (response == null) {
            try {
                response = this.readResponse();
            }
            catch (InterruptedIOException interruptedIOException) {
                if (interruptedIOException.bytesTransferred == 0) {
                    response = null;
                    continue;
                }
                response = Response.byeResponse((Exception)interruptedIOException);
            }
            catch (IOException iOException) {
                response = Response.byeResponse((Exception)iOException);
            }
            catch (ProtocolException protocolException) {
                response = Response.byeResponse((Exception)((Object)protocolException));
            }
        }
        return response;
    }

    public boolean processIdleResponse(Response response) throws ProtocolException {
        Response[] responseArray = new Response[]{response};
        boolean bl2 = false;
        this.notifyResponseHandlers(responseArray);
        if (response.isBYE()) {
            bl2 = true;
        }
        if (response.isTagged() && response.getTag().equals(this.idleTag)) {
            bl2 = true;
        }
        if (bl2) {
            this.idleTag = null;
        }
        this.handleResult(response);
        return !bl2;
    }

    public void idleAbort() throws ProtocolException {
        OutputStream outputStream = this.getOutputStream();
        try {
            outputStream.write(DONE);
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

