/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.imap.protocol;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import macromedia.externals.com.sun.mail_1_4_7.iap.ParsingException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Protocol;
import macromedia.externals.com.sun.mail_1_4_7.iap.ProtocolException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Response;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.BODY;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.BODYSTRUCTURE;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.ENVELOPE;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.FLAGS;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.FetchItem;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.IMAPResponse;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.INTERNALDATE;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.Item;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.RFC822DATA;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.RFC822SIZE;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.UID;

public class FetchResponse
extends IMAPResponse {
    private Item[] items;
    private Map extensionItems;
    private final FetchItem[] fitems;
    private static final char[] HEADER = new char[]{'.', 'H', 'E', 'A', 'D', 'E', 'R'};
    private static final char[] TEXT = new char[]{'.', 'T', 'E', 'X', 'T'};

    public FetchResponse(Protocol protocol) throws IOException, ProtocolException {
        super(protocol);
        this.fitems = null;
        this.parse();
    }

    public FetchResponse(IMAPResponse iMAPResponse) throws IOException, ProtocolException {
        this(iMAPResponse, null);
    }

    public FetchResponse(IMAPResponse iMAPResponse, FetchItem[] fetchItemArray) throws IOException, ProtocolException {
        super(iMAPResponse);
        this.fitems = fetchItemArray;
        this.parse();
    }

    public int getItemCount() {
        return this.items.length;
    }

    public Item getItem(int n2) {
        return this.items[n2];
    }

    public Item getItem(Class clazz) {
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            if (!clazz.isInstance(this.items[i2])) continue;
            return this.items[i2];
        }
        return null;
    }

    public static Item getItem(Response[] responseArray, int n2, Class clazz) {
        if (responseArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < responseArray.length; ++i2) {
            if (responseArray[i2] == null || !(responseArray[i2] instanceof FetchResponse) || ((FetchResponse)responseArray[i2]).getNumber() != n2) continue;
            FetchResponse fetchResponse = (FetchResponse)responseArray[i2];
            for (int i3 = 0; i3 < fetchResponse.items.length; ++i3) {
                if (!clazz.isInstance(fetchResponse.items[i3])) continue;
                return fetchResponse.items[i3];
            }
        }
        return null;
    }

    public Map getExtensionItems() {
        if (this.extensionItems == null) {
            this.extensionItems = new HashMap();
        }
        return this.extensionItems;
    }

    private void parse() throws ParsingException {
        this.skipSpaces();
        if (this.buffer[this.index] != 40) {
            throw new ParsingException(new StringBuffer().append("error in FETCH parsing, missing '(' at index ").append(this.index).toString());
        }
        Vector<Item> vector = new Vector<Item>();
        Item item = null;
        do {
            ++this.index;
            if (this.index >= this.size) {
                throw new ParsingException(new StringBuffer().append("error in FETCH parsing, ran off end of buffer, size ").append(this.size).toString());
            }
            item = this.parseItem();
            if (item != null) {
                vector.addElement(item);
                continue;
            }
            if (this.parseExtensionItem()) continue;
            throw new ParsingException(new StringBuffer().append("error in FETCH parsing, unrecognized item at index ").append(this.index).toString());
        } while (this.buffer[this.index] != 41);
        ++this.index;
        this.items = new Item[vector.size()];
        vector.copyInto(this.items);
    }

    private Item parseItem() throws ParsingException {
        switch (this.buffer[this.index]) {
            case 69: 
            case 101: {
                if (!this.match(ENVELOPE.name)) break;
                return new ENVELOPE(this);
            }
            case 70: 
            case 102: {
                if (!this.match(FLAGS.name)) break;
                return new FLAGS((IMAPResponse)this);
            }
            case 73: 
            case 105: {
                if (!this.match(INTERNALDATE.name)) break;
                return new INTERNALDATE(this);
            }
            case 66: 
            case 98: {
                if (this.match(BODYSTRUCTURE.name)) {
                    return new BODYSTRUCTURE(this);
                }
                if (!this.match(BODY.name)) break;
                if (this.buffer[this.index] == 91) {
                    return new BODY(this);
                }
                return new BODYSTRUCTURE(this);
            }
            case 82: 
            case 114: {
                if (this.match(RFC822SIZE.name)) {
                    return new RFC822SIZE(this);
                }
                if (!this.match(RFC822DATA.name)) break;
                if (this.match(HEADER) || this.match(TEXT)) {
                    // empty if block
                }
                return new RFC822DATA(this);
            }
            case 85: 
            case 117: {
                if (!this.match(UID.name)) break;
                return new UID(this);
            }
        }
        return null;
    }

    private boolean parseExtensionItem() throws ParsingException {
        if (this.fitems == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.fitems.length; ++i2) {
            if (!this.match(this.fitems[i2].getName())) continue;
            this.getExtensionItems().put(this.fitems[i2].getName(), this.fitems[i2].parseItem(this));
            return true;
        }
        return false;
    }

    private boolean match(char[] cArray) {
        int n2 = cArray.length;
        int n3 = 0;
        int n4 = this.index;
        while (n3 < n2) {
            if (Character.toUpperCase((char)this.buffer[n4++]) == cArray[n3++]) continue;
            return false;
        }
        this.index += n2;
        return true;
    }

    private boolean match(String string) {
        int n2 = string.length();
        int n3 = 0;
        int n4 = this.index;
        while (n3 < n2) {
            if (Character.toUpperCase((char)this.buffer[n4++]) == string.charAt(n3++)) continue;
            return false;
        }
        this.index += n2;
        return true;
    }
}

