/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.imap.protocol;

import java.util.Vector;
import macromedia.externals.com.sun.mail_1_4_7.iap.ParsingException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Response;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.ENVELOPE;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.FetchResponse;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.Item;
import macromedia.externals.com.sun.mail_1_4_7.util.PropUtil;
import macromedia.externals.javax.mail_1_4_7.internet.ParameterList;

public class BODYSTRUCTURE
implements Item {
    static final char[] name = new char[]{'B', 'O', 'D', 'Y', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E'};
    public int msgno;
    public String type;
    public String subtype;
    public String encoding;
    public int lines = -1;
    public int size = -1;
    public String disposition;
    public String id;
    public String description;
    public String md5;
    public String attachment;
    public ParameterList cParams;
    public ParameterList dParams;
    public String[] language;
    public BODYSTRUCTURE[] bodies;
    public ENVELOPE envelope;
    private static int SINGLE = 1;
    private static int MULTI = 2;
    private static int NESTED = 3;
    private int processedType;
    private static boolean parseDebug = PropUtil.getBooleanSystemProperty((String)"mail.imap.parse.debug", (boolean)false);

    public BODYSTRUCTURE(FetchResponse fetchResponse) throws ParsingException {
        if (parseDebug) {
            System.out.println("DEBUG IMAP: parsing BODYSTRUCTURE");
        }
        this.msgno = fetchResponse.getNumber();
        if (parseDebug) {
            System.out.println(new StringBuffer().append("DEBUG IMAP: msgno ").append(this.msgno).toString());
        }
        fetchResponse.skipSpaces();
        if (fetchResponse.readByte() != 40) {
            throw new ParsingException("BODYSTRUCTURE parse error: missing ``('' at start");
        }
        if (fetchResponse.peekByte() == 40) {
            if (parseDebug) {
                System.out.println("DEBUG IMAP: parsing multipart");
            }
            this.type = "multipart";
            this.processedType = MULTI;
            Vector<BODYSTRUCTURE> vector = new Vector<BODYSTRUCTURE>(1);
            boolean bl2 = true;
            do {
                vector.addElement(new BODYSTRUCTURE(fetchResponse));
                fetchResponse.skipSpaces();
            } while (fetchResponse.peekByte() == 40);
            this.bodies = new BODYSTRUCTURE[vector.size()];
            vector.copyInto(this.bodies);
            this.subtype = fetchResponse.readString();
            if (parseDebug) {
                System.out.println(new StringBuffer().append("DEBUG IMAP: subtype ").append(this.subtype).toString());
            }
            if (fetchResponse.readByte() == 41) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: parse DONE");
                }
                return;
            }
            if (parseDebug) {
                System.out.println("DEBUG IMAP: parsing extension data");
            }
            this.cParams = this.parseParameters((Response)fetchResponse);
            if (fetchResponse.readByte() == 41) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: body parameters DONE");
                }
                return;
            }
            byte by2 = fetchResponse.readByte();
            if (by2 == 40) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: parse disposition");
                }
                this.disposition = fetchResponse.readString();
                if (parseDebug) {
                    System.out.println(new StringBuffer().append("DEBUG IMAP: disposition ").append(this.disposition).toString());
                }
                this.dParams = this.parseParameters((Response)fetchResponse);
                if (fetchResponse.readByte() != 41) {
                    throw new ParsingException("BODYSTRUCTURE parse error: missing ``)'' at end of disposition in multipart");
                }
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition DONE");
                }
            } else if (by2 == 78 || by2 == 110) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition NIL");
                }
                fetchResponse.skip(2);
            } else {
                throw new ParsingException(new StringBuffer().append("BODYSTRUCTURE parse error: ").append(this.type).append("/").append(this.subtype).append(": ").append("bad multipart disposition, b ").append(by2).toString());
            }
            if ((by2 = fetchResponse.readByte()) == 41) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: no body-fld-lang");
                }
                return;
            }
            if (by2 != 32) {
                throw new ParsingException("BODYSTRUCTURE parse error: missing space after disposition");
            }
            if (fetchResponse.peekByte() == 40) {
                this.language = fetchResponse.readStringList();
                if (parseDebug) {
                    System.out.println(new StringBuffer().append("DEBUG IMAP: language len ").append(this.language.length).toString());
                }
            } else {
                String string = fetchResponse.readString();
                if (string != null) {
                    String[] stringArray = new String[]{string};
                    this.language = stringArray;
                    if (parseDebug) {
                        System.out.println(new StringBuffer().append("DEBUG IMAP: language ").append(string).toString());
                    }
                }
            }
            while (fetchResponse.readByte() == 32) {
                this.parseBodyExtension((Response)fetchResponse);
            }
        } else {
            if (parseDebug) {
                System.out.println("DEBUG IMAP: single part");
            }
            this.type = fetchResponse.readString();
            if (parseDebug) {
                System.out.println(new StringBuffer().append("DEBUG IMAP: type ").append(this.type).toString());
            }
            this.processedType = SINGLE;
            this.subtype = fetchResponse.readString();
            if (parseDebug) {
                System.out.println(new StringBuffer().append("DEBUG IMAP: subtype ").append(this.subtype).toString());
            }
            if (this.type == null) {
                this.type = "application";
                this.subtype = "octet-stream";
            }
            this.cParams = this.parseParameters((Response)fetchResponse);
            if (parseDebug) {
                System.out.println(new StringBuffer().append("DEBUG IMAP: cParams ").append(this.cParams).toString());
            }
            this.id = fetchResponse.readString();
            if (parseDebug) {
                System.out.println(new StringBuffer().append("DEBUG IMAP: id ").append(this.id).toString());
            }
            this.description = fetchResponse.readString();
            if (parseDebug) {
                System.out.println(new StringBuffer().append("DEBUG IMAP: description ").append(this.description).toString());
            }
            this.encoding = fetchResponse.readAtomString();
            if (this.encoding != null && this.encoding.equalsIgnoreCase("NIL")) {
                this.encoding = null;
            }
            if (parseDebug) {
                System.out.println(new StringBuffer().append("DEBUG IMAP: encoding ").append(this.encoding).toString());
            }
            this.size = fetchResponse.readNumber();
            if (parseDebug) {
                System.out.println(new StringBuffer().append("DEBUG IMAP: size ").append(this.size).toString());
            }
            if (this.size < 0) {
                throw new ParsingException("BODYSTRUCTURE parse error: bad ``size'' element");
            }
            if (this.type.equalsIgnoreCase("text")) {
                this.lines = fetchResponse.readNumber();
                if (parseDebug) {
                    System.out.println(new StringBuffer().append("DEBUG IMAP: lines ").append(this.lines).toString());
                }
                if (this.lines < 0) {
                    throw new ParsingException("BODYSTRUCTURE parse error: bad ``lines'' element");
                }
            } else if (this.type.equalsIgnoreCase("message") && this.subtype.equalsIgnoreCase("rfc822")) {
                this.processedType = NESTED;
                fetchResponse.skipSpaces();
                if (fetchResponse.peekByte() == 40) {
                    this.envelope = new ENVELOPE(fetchResponse);
                    if (parseDebug) {
                        System.out.println("DEBUG IMAP: got envelope of nested message");
                    }
                    BODYSTRUCTURE[] bODYSTRUCTUREArray = new BODYSTRUCTURE[]{new BODYSTRUCTURE(fetchResponse)};
                    this.bodies = bODYSTRUCTUREArray;
                    this.lines = fetchResponse.readNumber();
                    if (parseDebug) {
                        System.out.println(new StringBuffer().append("DEBUG IMAP: lines ").append(this.lines).toString());
                    }
                    if (this.lines < 0) {
                        throw new ParsingException("BODYSTRUCTURE parse error: bad ``lines'' element");
                    }
                } else if (parseDebug) {
                    System.out.println("DEBUG IMAP: missing envelope and body of nested message");
                }
            } else {
                fetchResponse.skipSpaces();
                byte by3 = fetchResponse.peekByte();
                if (Character.isDigit((char)by3)) {
                    throw new ParsingException(new StringBuffer().append("BODYSTRUCTURE parse error: server erroneously included ``lines'' element with type ").append(this.type).append("/").append(this.subtype).toString());
                }
            }
            if (fetchResponse.peekByte() == 41) {
                fetchResponse.readByte();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: parse DONE");
                }
                return;
            }
            this.md5 = fetchResponse.readString();
            if (fetchResponse.readByte() == 41) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: no MD5 DONE");
                }
                return;
            }
            byte by4 = fetchResponse.readByte();
            if (by4 == 40) {
                this.disposition = fetchResponse.readString();
                if (parseDebug) {
                    System.out.println(new StringBuffer().append("DEBUG IMAP: disposition ").append(this.disposition).toString());
                }
                this.dParams = this.parseParameters((Response)fetchResponse);
                if (parseDebug) {
                    System.out.println(new StringBuffer().append("DEBUG IMAP: dParams ").append(this.dParams).toString());
                }
                if (fetchResponse.readByte() != 41) {
                    throw new ParsingException("BODYSTRUCTURE parse error: missing ``)'' at end of disposition");
                }
            } else if (by4 == 78 || by4 == 110) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition NIL");
                }
                fetchResponse.skip(2);
            } else {
                throw new ParsingException(new StringBuffer().append("BODYSTRUCTURE parse error: ").append(this.type).append("/").append(this.subtype).append(": ").append("bad single part disposition, b ").append(by4).toString());
            }
            if (fetchResponse.readByte() == 41) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition DONE");
                }
                return;
            }
            if (fetchResponse.peekByte() == 40) {
                this.language = fetchResponse.readStringList();
                if (parseDebug) {
                    System.out.println(new StringBuffer().append("DEBUG IMAP: language len ").append(this.language.length).toString());
                }
            } else {
                String string = fetchResponse.readString();
                if (string != null) {
                    String[] stringArray = new String[]{string};
                    this.language = stringArray;
                    if (parseDebug) {
                        System.out.println(new StringBuffer().append("DEBUG IMAP: language ").append(string).toString());
                    }
                }
            }
            while (fetchResponse.readByte() == 32) {
                this.parseBodyExtension((Response)fetchResponse);
            }
            if (parseDebug) {
                System.out.println("DEBUG IMAP: all DONE");
            }
        }
    }

    public boolean isMulti() {
        return this.processedType == MULTI;
    }

    public boolean isSingle() {
        return this.processedType == SINGLE;
    }

    public boolean isNested() {
        return this.processedType == NESTED;
    }

    private ParameterList parseParameters(Response response) throws ParsingException {
        response.skipSpaces();
        ParameterList parameterList = null;
        byte by2 = response.readByte();
        if (by2 == 40) {
            parameterList = new ParameterList();
            do {
                String string = response.readString();
                if (parseDebug) {
                    System.out.println(new StringBuffer().append("DEBUG IMAP: parameter name ").append(string).toString());
                }
                if (string == null) {
                    throw new ParsingException(new StringBuffer().append("BODYSTRUCTURE parse error: ").append(this.type).append("/").append(this.subtype).append(": ").append("null name in parameter list").toString());
                }
                String string2 = response.readString();
                if (parseDebug) {
                    System.out.println(new StringBuffer().append("DEBUG IMAP: parameter value ").append(string2).toString());
                }
                parameterList.set(string, string2);
            } while (response.readByte() != 41);
            parameterList.set(null, "DONE");
        } else if (by2 == 78 || by2 == 110) {
            if (parseDebug) {
                System.out.println("DEBUG IMAP: parameter list NIL");
            }
            response.skip(2);
        } else {
            throw new ParsingException("Parameter list parse error");
        }
        return parameterList;
    }

    private void parseBodyExtension(Response response) throws ParsingException {
        response.skipSpaces();
        byte by2 = response.peekByte();
        if (by2 == 40) {
            response.skip(1);
            do {
                this.parseBodyExtension(response);
            } while (response.readByte() != 41);
        } else if (Character.isDigit((char)by2)) {
            response.readNumber();
        } else {
            response.readString();
        }
    }
}

