/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.imap;

import java.io.IOException;
import java.io.InputStream;
import macromedia.externals.com.sun.mail_1_4_7.iap.ByteArray;
import macromedia.externals.com.sun.mail_1_4_7.iap.ConnectionException;
import macromedia.externals.com.sun.mail_1_4_7.iap.ProtocolException;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPMessage;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.BODY;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.IMAPProtocol;
import macromedia.externals.com.sun.mail_1_4_7.util.FolderClosedIOException;
import macromedia.externals.com.sun.mail_1_4_7.util.MessageRemovedIOException;
import macromedia.externals.javax.mail_1_4_7.Flags;
import macromedia.externals.javax.mail_1_4_7.Folder;
import macromedia.externals.javax.mail_1_4_7.FolderClosedException;
import macromedia.externals.javax.mail_1_4_7.MessagingException;

public class IMAPInputStream
extends InputStream {
    private IMAPMessage msg;
    private String section;
    private int pos;
    private int blksize;
    private int max;
    private byte[] buf;
    private int bufcount;
    private int bufpos;
    private boolean lastBuffer;
    private boolean peek;
    private ByteArray readbuf;
    private static final int slop = 64;

    public IMAPInputStream(IMAPMessage iMAPMessage, String string, int n2, boolean bl2) {
        this.msg = iMAPMessage;
        this.section = string;
        this.max = n2;
        this.peek = bl2;
        this.pos = 0;
        this.blksize = iMAPMessage.getFetchBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceCheckExpunged() throws MessageRemovedIOException, FolderClosedIOException {
        Object object = this.msg.getMessageCacheLock();
        synchronized (object) {
            try {
                this.msg.getProtocol().noop();
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedIOException(this.msg.getFolder(), connectionException.getMessage());
            }
            catch (FolderClosedException folderClosedException) {
                throw new FolderClosedIOException(folderClosedException.getFolder(), folderClosedException.getMessage());
            }
            catch (ProtocolException protocolException) {
                // empty catch block
            }
        }
        if (this.msg.isExpunged()) {
            throw new MessageRemovedIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill() throws IOException {
        ByteArray byteArray;
        int n2;
        if (this.lastBuffer || this.max != -1 && this.pos >= this.max) {
            if (this.pos == 0) {
                this.checkSeen();
            }
            this.readbuf = null;
            return;
        }
        BODY bODY = null;
        if (this.readbuf == null) {
            this.readbuf = new ByteArray(this.blksize + 64);
        }
        Object object = this.msg.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.msg.getProtocol();
                if (this.msg.isExpunged()) {
                    throw new MessageRemovedIOException("No content for expunged message");
                }
                int n3 = this.msg.getSequenceNumber();
                n2 = this.blksize;
                if (this.max != -1 && this.pos + this.blksize > this.max) {
                    n2 = this.max - this.pos;
                }
                bODY = this.peek ? iMAPProtocol.peekBody(n3, this.section, this.pos, n2, this.readbuf) : iMAPProtocol.fetchBody(n3, this.section, this.pos, n2, this.readbuf);
            }
            catch (ProtocolException protocolException) {
                this.forceCheckExpunged();
                throw new IOException(protocolException.getMessage());
            }
            catch (FolderClosedException folderClosedException) {
                throw new FolderClosedIOException(folderClosedException.getFolder(), folderClosedException.getMessage());
            }
            if (bODY == null || (byteArray = bODY.getByteArray()) == null) {
                this.forceCheckExpunged();
                throw new IOException("No content");
            }
        }
        if (this.pos == 0) {
            this.checkSeen();
        }
        this.buf = byteArray.getBytes();
        this.bufpos = byteArray.getStart();
        int n4 = byteArray.getCount();
        this.lastBuffer = n4 < n2;
        this.bufcount = this.bufpos + n4;
        this.pos += n4;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.bufpos >= this.bufcount) {
            this.fill();
            if (this.bufpos >= this.bufcount) {
                return -1;
            }
        }
        return this.buf[this.bufpos++] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.bufcount - this.bufpos;
        if (n4 <= 0) {
            this.fill();
            n4 = this.bufcount - this.bufpos;
            if (n4 <= 0) {
                return -1;
            }
        }
        int n5 = n4 < n3 ? n4 : n3;
        System.arraycopy(this.buf, this.bufpos, byArray, n2, n5);
        this.bufpos += n5;
        return n5;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public synchronized int available() throws IOException {
        return this.bufcount - this.bufpos;
    }

    private void checkSeen() {
        if (this.peek) {
            return;
        }
        try {
            Folder folder = this.msg.getFolder();
            if (folder != null && folder.getMode() != 1 && !this.msg.isSet(Flags.Flag.SEEN)) {
                this.msg.setFlag(Flags.Flag.SEEN, true);
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }
}

