/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.imap;

import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;
import macromedia.externals.com.sun.mail_1_4_7.iap.BadCommandException;
import macromedia.externals.com.sun.mail_1_4_7.iap.CommandFailedException;
import macromedia.externals.com.sun.mail_1_4_7.iap.ConnectionException;
import macromedia.externals.com.sun.mail_1_4_7.iap.ProtocolException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Response;
import macromedia.externals.com.sun.mail_1_4_7.iap.ResponseHandler;
import macromedia.externals.com.sun.mail_1_4_7.imap.ACL;
import macromedia.externals.com.sun.mail_1_4_7.imap.AppendUID;
import macromedia.externals.com.sun.mail_1_4_7.imap.DefaultFolder;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPFolder;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPMessage;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPStore;
import macromedia.externals.com.sun.mail_1_4_7.imap.MessageCache;
import macromedia.externals.com.sun.mail_1_4_7.imap.MessageLiteral;
import macromedia.externals.com.sun.mail_1_4_7.imap.Rights;
import macromedia.externals.com.sun.mail_1_4_7.imap.SortTerm;
import macromedia.externals.com.sun.mail_1_4_7.imap.Utility;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.FetchItem;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.FetchResponse;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.IMAPProtocol;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.IMAPResponse;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.Item;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.ListInfo;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.MailboxInfo;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.MessageSet;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.Status;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.UID;
import macromedia.externals.com.sun.mail_1_4_7.util.MailLogger;
import macromedia.externals.javax.mail_1_4_7.FetchProfile;
import macromedia.externals.javax.mail_1_4_7.Flags;
import macromedia.externals.javax.mail_1_4_7.Folder;
import macromedia.externals.javax.mail_1_4_7.FolderClosedException;
import macromedia.externals.javax.mail_1_4_7.FolderNotFoundException;
import macromedia.externals.javax.mail_1_4_7.Message;
import macromedia.externals.javax.mail_1_4_7.MessageRemovedException;
import macromedia.externals.javax.mail_1_4_7.MessagingException;
import macromedia.externals.javax.mail_1_4_7.Quota;
import macromedia.externals.javax.mail_1_4_7.ReadOnlyFolderException;
import macromedia.externals.javax.mail_1_4_7.Store;
import macromedia.externals.javax.mail_1_4_7.StoreClosedException;
import macromedia.externals.javax.mail_1_4_7.UIDFolder;
import macromedia.externals.javax.mail_1_4_7.event.MessageCountListener;
import macromedia.externals.javax.mail_1_4_7.internet.MimeMessage;
import macromedia.externals.javax.mail_1_4_7.search.FlagTerm;
import macromedia.externals.javax.mail_1_4_7.search.SearchException;
import macromedia.externals.javax.mail_1_4_7.search.SearchTerm;

/*
 * Exception performing whole class analysis ignored.
 */
public class IMAPFolder
extends Folder
implements ResponseHandler,
UIDFolder {
    protected String fullName;
    protected String name;
    protected int type;
    protected char separator;
    protected Flags availableFlags;
    protected Flags permanentFlags;
    protected volatile boolean exists;
    protected boolean isNamespace = false;
    protected volatile String[] attributes;
    protected volatile IMAPProtocol protocol;
    protected MessageCache messageCache;
    protected final Object messageCacheLock = new Object();
    protected Hashtable uidTable;
    protected static final char UNKNOWN_SEPARATOR = '\uffff';
    private volatile boolean opened = false;
    private boolean reallyClosed = true;
    private static final int RUNNING = 0;
    private static final int IDLE = 1;
    private static final int ABORTING = 2;
    private int idleState = 0;
    private volatile int total = -1;
    private volatile int recent = -1;
    private int realTotal = -1;
    private long uidvalidity = -1L;
    private long uidnext = -1L;
    private boolean doExpungeNotification = true;
    private Status cachedStatus = null;
    private long cachedStatusTime = 0L;
    private boolean hasMessageCountListener = false;
    protected MailLogger logger;
    private MailLogger connectionPoolLogger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$mail$imap$IMAPFolder;
    static /* synthetic */ Class class$javax$mail$Flags;

    protected IMAPFolder(String string, char c2, IMAPStore iMAPStore, Boolean bl2) {
        super((Store)iMAPStore);
        int n2;
        if (string == null) {
            throw new NullPointerException("Folder name is null");
        }
        this.fullName = string;
        this.separator = c2;
        this.logger = new MailLogger(this.getClass(), "DEBUG IMAP", iMAPStore.getSession());
        this.connectionPoolLogger = iMAPStore.getConnectionPoolLogger();
        this.isNamespace = false;
        if (c2 != '\uffff' && c2 != '\u0000' && (n2 = this.fullName.indexOf(c2)) > 0 && n2 == this.fullName.length() - 1) {
            this.fullName = this.fullName.substring(0, n2);
            this.isNamespace = true;
        }
        if (bl2 != null) {
            this.isNamespace = bl2;
        }
    }

    protected IMAPFolder(ListInfo listInfo, IMAPStore iMAPStore) {
        this(listInfo.name, listInfo.separator, iMAPStore, null);
        if (listInfo.hasInferiors) {
            this.type |= 2;
        }
        if (listInfo.canOpen) {
            this.type |= 1;
        }
        this.exists = true;
        this.attributes = listInfo.attrs;
    }

    protected void checkExists() throws MessagingException {
        if (!this.exists && !this.exists()) {
            throw new FolderNotFoundException((Folder)this, new StringBuffer().append(this.fullName).append(" not found").toString());
        }
    }

    protected void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder");
        }
    }

    protected void checkOpened() throws FolderClosedException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!this.opened) {
            if (this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            throw new FolderClosedException((Folder)this, "Lost folder connection to server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRange(int n2) throws MessagingException {
        if (n2 < 1) {
            throw new IndexOutOfBoundsException("message number < 1");
        }
        if (n2 <= this.total) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(false);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
        if (n2 > this.total) {
            throw new IndexOutOfBoundsException(new StringBuffer().append(n2).append(" > ").append(this.total).toString());
        }
    }

    private void checkFlags(Flags flags) throws MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.mode != 2) {
            throw new IllegalStateException(new StringBuffer().append("Cannot change flags on READ_ONLY folder: ").append(this.fullName).toString());
        }
    }

    public synchronized String getName() {
        if (this.name == null) {
            try {
                this.name = this.fullName.substring(this.fullName.lastIndexOf(this.getSeparator()) + 1);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        return this.name;
    }

    public synchronized String getFullName() {
        return this.fullName;
    }

    public synchronized Folder getParent() throws MessagingException {
        char c2 = this.getSeparator();
        int n2 = this.fullName.lastIndexOf(c2);
        if (n2 != -1) {
            return ((IMAPStore)this.store).newIMAPFolder(this.fullName.substring(0, n2), c2);
        }
        return new DefaultFolder((IMAPStore)this.store);
    }

    public synchronized boolean exists() throws MessagingException {
        ListInfo[] listInfoArray = null;
        String string = this.isNamespace && this.separator != '\u0000' ? new StringBuffer().append(this.fullName).append(this.separator).toString() : this.fullName;
        listInfoArray = (ListInfo[])this.doCommand((ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
        if (listInfoArray != null) {
            int n2 = this.findName(listInfoArray, string);
            this.fullName = listInfoArray[n2].name;
            this.separator = listInfoArray[n2].separator;
            int n3 = this.fullName.length();
            if (this.separator != '\u0000' && n3 > 0 && this.fullName.charAt(n3 - 1) == this.separator) {
                this.fullName = this.fullName.substring(0, n3 - 1);
            }
            this.type = 0;
            if (listInfoArray[n2].hasInferiors) {
                this.type |= 2;
            }
            if (listInfoArray[n2].canOpen) {
                this.type |= 1;
            }
            this.exists = true;
            this.attributes = listInfoArray[n2].attrs;
        } else {
            this.exists = this.opened;
            this.attributes = null;
        }
        return this.exists;
    }

    private int findName(ListInfo[] listInfoArray, String string) {
        int n2;
        for (n2 = 0; n2 < listInfoArray.length && !listInfoArray[n2].name.equals(string); ++n2) {
        }
        if (n2 >= listInfoArray.length) {
            n2 = 0;
        }
        return n2;
    }

    public Folder[] list(String string) throws MessagingException {
        return this.doList(string, false);
    }

    public Folder[] listSubscribed(String string) throws MessagingException {
        return this.doList(string, true);
    }

    private synchronized Folder[] doList(String string, boolean bl2) throws MessagingException {
        this.checkExists();
        if (this.attributes != null && !this.isDirectory()) {
            return new Folder[0];
        }
        char c2 = this.getSeparator();
        ListInfo[] listInfoArray = (ListInfo[])this.doCommandIgnoreFailure((ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
        if (listInfoArray == null) {
            return new Folder[0];
        }
        int n2 = 0;
        if (listInfoArray.length > 0 && listInfoArray[0].name.equals(new StringBuffer().append(this.fullName).append(c2).toString())) {
            n2 = 1;
        }
        IMAPFolder[] iMAPFolderArray = new IMAPFolder[listInfoArray.length - n2];
        IMAPStore iMAPStore = (IMAPStore)this.store;
        for (int i2 = n2; i2 < listInfoArray.length; ++i2) {
            iMAPFolderArray[i2 - n2] = iMAPStore.newIMAPFolder(listInfoArray[i2]);
        }
        return iMAPFolderArray;
    }

    public synchronized char getSeparator() throws MessagingException {
        if (this.separator == '\uffff') {
            ListInfo[] listInfoArray = null;
            listInfoArray = (ListInfo[])this.doCommand((ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
            this.separator = listInfoArray != null ? listInfoArray[0].separator : (char)47;
        }
        return this.separator;
    }

    public synchronized int getType() throws MessagingException {
        if (this.opened) {
            if (this.attributes == null) {
                this.exists();
            }
        } else {
            this.checkExists();
        }
        return this.type;
    }

    public synchronized boolean isSubscribed() {
        ListInfo[] listInfoArray = null;
        String string = this.isNamespace && this.separator != '\u0000' ? new StringBuffer().append(this.fullName).append(this.separator).toString() : this.fullName;
        try {
            listInfoArray = (ListInfo[])this.doProtocolCommand((ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
        if (listInfoArray != null) {
            int n2 = this.findName(listInfoArray, string);
            return listInfoArray[n2].canOpen;
        }
        return false;
    }

    public synchronized void setSubscribed(boolean bl2) throws MessagingException {
        this.doCommandIgnoreFailure((ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public synchronized boolean create(int n2) throws MessagingException {
        char c2;
        Object object;
        char c3 = '\u0000';
        if ((n2 & 1) == 0) {
            c3 = this.getSeparator();
        }
        if ((object = this.doCommandIgnoreFailure((ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */)) == null) {
            return false;
        }
        boolean bl2 = this.exists();
        if (bl2) {
            this.notifyFolderListeners(1);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasNewMessages() throws MessagingException {
        if (this.opened) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    this.keepConnectionAlive(true);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException((Folder)this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
                }
                return this.recent > 0;
            }
        }
        ListInfo[] listInfoArray = null;
        String string = this.isNamespace && this.separator != '\u0000' ? new StringBuffer().append(this.fullName).append(this.separator).toString() : this.fullName;
        listInfoArray = (ListInfo[])this.doCommandIgnoreFailure((ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
        if (listInfoArray == null) {
            throw new FolderNotFoundException((Folder)this, new StringBuffer().append(this.fullName).append(" not found").toString());
        }
        int n2 = this.findName(listInfoArray, string);
        if (listInfoArray[n2].changeState == 1) {
            return true;
        }
        if (listInfoArray[n2].changeState == 2) {
            return false;
        }
        try {
            Status status = this.getStatus();
            return status.recent > 0;
        }
        catch (BadCommandException badCommandException) {
            return false;
        }
        catch (ConnectionException connectionException) {
            throw new StoreClosedException(this.store, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
    }

    public synchronized Folder getFolder(String string) throws MessagingException {
        if (this.attributes != null && !this.isDirectory()) {
            throw new MessagingException("Cannot contain subfolders");
        }
        char c2 = this.getSeparator();
        return ((IMAPStore)this.store).newIMAPFolder(new StringBuffer().append(this.fullName).append(c2).append(string).toString(), c2);
    }

    public synchronized boolean delete(boolean bl2) throws MessagingException {
        Object object;
        this.checkClosed();
        if (bl2) {
            object = this.list();
            for (int i2 = 0; i2 < ((Folder[])object).length; ++i2) {
                object[i2].delete(bl2);
            }
        }
        if ((object = this.doCommandIgnoreFailure((ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */)) == null) {
            return false;
        }
        this.exists = false;
        this.attributes = null;
        this.notifyFolderListeners(2);
        return true;
    }

    public synchronized boolean renameTo(Folder folder) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if (folder.getStore() != this.store) {
            throw new MessagingException("Can't rename across Stores");
        }
        Object object = this.doCommandIgnoreFailure((ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
        if (object == null) {
            return false;
        }
        this.exists = false;
        this.attributes = null;
        this.notifyFolderRenamedListeners(folder);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(int n2) throws MessagingException {
        this.checkClosed();
        MailboxInfo mailboxInfo = null;
        this.protocol = ((IMAPStore)this.store).getProtocol(this);
        Object object = this.messageCacheLock;
        synchronized (object) {
            this.protocol.addResponseHandler((ResponseHandler)this);
            try {
                mailboxInfo = n2 == 1 ? this.protocol.examine(this.fullName) : this.protocol.select(this.fullName);
            }
            catch (CommandFailedException commandFailedException) {
                try {
                    this.checkExists();
                    if ((this.type & 1) == 0) {
                        throw new MessagingException("folder cannot contain messages");
                    }
                    throw new MessagingException(commandFailedException.getMessage(), (Exception)((Object)commandFailedException));
                }
                catch (Throwable throwable) {
                    this.exists = false;
                    this.attributes = null;
                    this.type = 0;
                    this.releaseProtocol(true);
                    throw throwable;
                }
            }
            catch (ProtocolException protocolException) {
                try {
                    try {
                        this.protocol.logout();
                    }
                    catch (ProtocolException protocolException2) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.releaseProtocol(false);
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
            if (!(mailboxInfo.mode == n2 || n2 == 2 && mailboxInfo.mode == 1 && ((IMAPStore)this.store).allowReadOnlySelect())) {
                try {
                    try {
                        this.protocol.close();
                        this.releaseProtocol(true);
                    }
                    catch (ProtocolException protocolException) {
                        try {
                            this.protocol.logout();
                        }
                        catch (ProtocolException protocolException3) {
                        }
                        finally {
                            this.releaseProtocol(false);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ReadOnlyFolderException((Folder)this, "Cannot open in desired mode");
            }
            this.opened = true;
            this.reallyClosed = false;
            this.mode = mailboxInfo.mode;
            this.availableFlags = mailboxInfo.availableFlags;
            this.permanentFlags = mailboxInfo.permanentFlags;
            this.total = this.realTotal = mailboxInfo.total;
            this.recent = mailboxInfo.recent;
            this.uidvalidity = mailboxInfo.uidvalidity;
            this.uidnext = mailboxInfo.uidnext;
            this.messageCache = new MessageCache(this, (IMAPStore)this.store, this.total);
        }
        this.exists = true;
        this.attributes = null;
        this.type = 1;
        this.notifyConnectionListeners(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fetch(Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
        this.checkOpened();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        boolean bl3 = false;
        if (fetchProfile.contains(FetchProfile.Item.ENVELOPE)) {
            stringBuffer.append(this.getEnvelopeCommand());
            bl2 = false;
        }
        if (fetchProfile.contains(FetchProfile.Item.FLAGS)) {
            stringBuffer.append(bl2 ? "FLAGS" : " FLAGS");
            bl2 = false;
        }
        if (fetchProfile.contains(FetchProfile.Item.CONTENT_INFO)) {
            stringBuffer.append(bl2 ? "BODYSTRUCTURE" : " BODYSTRUCTURE");
            bl2 = false;
        }
        if (fetchProfile.contains((FetchProfile.Item)UIDFolder.FetchProfileItem.UID)) {
            stringBuffer.append(bl2 ? "UID" : " UID");
            bl2 = false;
        }
        if (fetchProfile.contains((FetchProfile.Item)FetchProfileItem.HEADERS)) {
            bl3 = true;
            if (this.protocol.isREV1()) {
                stringBuffer.append(bl2 ? "BODY.PEEK[HEADER]" : " BODY.PEEK[HEADER]");
            } else {
                stringBuffer.append(bl2 ? "RFC822.HEADER" : " RFC822.HEADER");
            }
            bl2 = false;
        }
        if (fetchProfile.contains((FetchProfile.Item)FetchProfileItem.SIZE)) {
            stringBuffer.append(bl2 ? "RFC822.SIZE" : " RFC822.SIZE");
            bl2 = false;
        }
        String[] stringArray = null;
        if (!bl3 && (stringArray = fetchProfile.getHeaderNames()).length > 0) {
            if (!bl2) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.createHeaderCommand(stringArray));
        }
        FetchItem[] fetchItemArray = this.protocol.getFetchItems();
        for (int i2 = 0; i2 < fetchItemArray.length; ++i2) {
            if (!fetchProfile.contains(fetchItemArray[i2].getFetchProfileItem())) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(fetchItemArray[i2].getName());
        }
        IMAPMessage.FetchProfileCondition fetchProfileCondition = new IMAPMessage.FetchProfileCondition(fetchProfile, fetchItemArray);
        Object object = this.messageCacheLock;
        synchronized (object) {
            FetchResponse fetchResponse;
            int n2;
            MessageSet[] messageSetArray = Utility.toMessageSet((Message[])messageArray, (Utility.Condition)fetchProfileCondition);
            if (messageSetArray == null) {
                return;
            }
            Response[] responseArray = null;
            Vector<Object> vector = new Vector<Object>();
            try {
                responseArray = this.getProtocol().fetch(messageSetArray, stringBuffer.toString());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (CommandFailedException commandFailedException) {
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
            if (responseArray == null) {
                return;
            }
            for (n2 = 0; n2 < responseArray.length; ++n2) {
                if (responseArray[n2] == null) continue;
                if (!(responseArray[n2] instanceof FetchResponse)) {
                    vector.addElement(responseArray[n2]);
                    continue;
                }
                fetchResponse = (FetchResponse)responseArray[n2];
                IMAPMessage iMAPMessage = this.getMessageBySeqNumber(fetchResponse.getNumber());
                int n3 = fetchResponse.getItemCount();
                boolean bl4 = false;
                for (int i3 = 0; i3 < n3; ++i3) {
                    Item item = fetchResponse.getItem(i3);
                    if (item instanceof Flags && (!fetchProfile.contains(FetchProfile.Item.FLAGS) || iMAPMessage == null)) {
                        bl4 = true;
                        continue;
                    }
                    if (iMAPMessage == null) continue;
                    iMAPMessage.handleFetchItem(item, stringArray, bl3);
                }
                if (iMAPMessage != null) {
                    iMAPMessage.handleExtensionFetchItems(fetchResponse.getExtensionItems());
                }
                if (!bl4) continue;
                vector.addElement(fetchResponse);
            }
            n2 = vector.size();
            if (n2 != 0) {
                fetchResponse = new Response[n2];
                vector.copyInto((Object[])fetchResponse);
                this.handleResponses((Response[])fetchResponse);
            }
        }
    }

    protected String getEnvelopeCommand() {
        return "ENVELOPE INTERNALDATE RFC822.SIZE";
    }

    protected IMAPMessage newIMAPMessage(int n2) {
        return new IMAPMessage(this, n2);
    }

    private String createHeaderCommand(String[] stringArray) {
        StringBuffer stringBuffer = this.protocol.isREV1() ? new StringBuffer("BODY.PEEK[HEADER.FIELDS (") : new StringBuffer("RFC822.HEADER.LINES (");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(stringArray[i2]);
        }
        if (this.protocol.isREV1()) {
            stringBuffer.append(")]");
        } else {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFlags(Message[] messageArray, Flags flags, boolean bl2) throws MessagingException {
        this.checkOpened();
        this.checkFlags(flags);
        if (messageArray.length == 0) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                MessageSet[] messageSetArray = Utility.toMessageSet((Message[])messageArray, null);
                if (messageSetArray == null) {
                    throw new MessageRemovedException("Messages have been removed");
                }
                iMAPProtocol.storeFlags(messageSetArray, flags, bl2);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
    }

    public synchronized void setFlags(int n2, int n3, Flags flags, boolean bl2) throws MessagingException {
        this.checkOpened();
        Message[] messageArray = new Message[n3 - n2 + 1];
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            messageArray[n4++] = this.getMessage(i2);
        }
        this.setFlags(messageArray, flags, bl2);
    }

    public synchronized void setFlags(int[] nArray, Flags flags, boolean bl2) throws MessagingException {
        this.checkOpened();
        Message[] messageArray = new Message[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            messageArray[i2] = this.getMessage(nArray[i2]);
        }
        this.setFlags(messageArray, flags, bl2);
    }

    public synchronized void close(boolean bl2) throws MessagingException {
        this.close(bl2, false);
    }

    public synchronized void forceClose() throws MessagingException {
        this.close(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean bl2, boolean bl3) throws MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            block26: {
                if (!this.opened && this.reallyClosed) {
                    throw new IllegalStateException("This operation is not allowed on a closed folder");
                }
                this.reallyClosed = true;
                if (!this.opened) {
                    return;
                }
                try {
                    this.waitIfIdle();
                    if (bl3) {
                        this.logger.log(Level.FINE, "forcing folder {0} to close", (Object)this.fullName);
                        if (this.protocol != null) {
                            this.protocol.disconnect();
                        }
                        break block26;
                    }
                    if (((IMAPStore)this.store).isConnectionPoolFull()) {
                        this.logger.fine("pool is full, not adding an Authenticated connection");
                        if (bl2 && this.protocol != null) {
                            this.protocol.close();
                        }
                        if (this.protocol != null) {
                            this.protocol.logout();
                        }
                        break block26;
                    }
                    if (!bl2 && this.mode == 2) {
                        try {
                            if (this.protocol != null && this.protocol.hasCapability("UNSELECT")) {
                                this.protocol.unselect();
                            } else if (this.protocol != null) {
                                MailboxInfo mailboxInfo = this.protocol.examine(this.fullName);
                                if (this.protocol != null) {
                                    this.protocol.close();
                                }
                            }
                            break block26;
                        }
                        catch (ProtocolException protocolException) {
                            if (this.protocol != null) {
                                this.protocol.disconnect();
                            }
                            break block26;
                        }
                    }
                    if (this.protocol != null) {
                        this.protocol.close();
                    }
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
                }
                finally {
                    if (this.opened) {
                        this.cleanup(true);
                    }
                }
            }
        }
    }

    private void cleanup(boolean bl2) {
        if (!$assertionsDisabled && !Thread.holdsLock(this.messageCacheLock)) {
            throw new AssertionError();
        }
        this.releaseProtocol(bl2);
        this.messageCache = null;
        this.uidTable = null;
        this.exists = false;
        this.attributes = null;
        this.opened = false;
        this.idleState = 0;
        this.notifyConnectionListeners(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isOpen() {
        Object object = this.messageCacheLock;
        synchronized (object) {
            if (this.opened) {
                try {
                    this.keepConnectionAlive(false);
                }
                catch (ProtocolException protocolException) {
                    // empty catch block
                }
            }
        }
        return this.opened;
    }

    public synchronized Flags getPermanentFlags() {
        if (this.permanentFlags == null) {
            return null;
        }
        return (Flags)this.permanentFlags.clone();
    }

    public synchronized int getMessageCount() throws MessagingException {
        if (!this.opened) {
            this.checkExists();
            try {
                Status status = this.getStatus();
                return status.total;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                    iMAPProtocol.close();
                    int n2 = mailboxInfo.total;
                    return n2;
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
                }
                finally {
                    this.releaseStoreProtocol(iMAPProtocol);
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.total;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
    }

    public synchronized int getNewMessageCount() throws MessagingException {
        if (!this.opened) {
            this.checkExists();
            try {
                Status status = this.getStatus();
                return status.recent;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                    iMAPProtocol.close();
                    int n2 = mailboxInfo.recent;
                    return n2;
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
                }
                finally {
                    this.releaseStoreProtocol(iMAPProtocol);
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.recent;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getUnreadMessageCount() throws MessagingException {
        if (!this.opened) {
            this.checkExists();
            try {
                Status status = this.getStatus();
                return status.unseen;
            }
            catch (BadCommandException badCommandException) {
                return -1;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.getProtocol().search((SearchTerm)new FlagTerm(flags, false));
                return nArray.length;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getDeletedMessageCount() throws MessagingException {
        if (!this.opened) {
            this.checkExists();
            return -1;
        }
        Flags flags = new Flags();
        flags.add(Flags.Flag.DELETED);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.getProtocol().search((SearchTerm)new FlagTerm(flags, true));
                return nArray.length;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status getStatus() throws ProtocolException {
        int n2 = ((IMAPStore)this.store).getStatusCacheTimeout();
        if (n2 > 0 && this.cachedStatus != null && System.currentTimeMillis() - this.cachedStatusTime < (long)n2) {
            return this.cachedStatus;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            iMAPProtocol = this.getStoreProtocol();
            Status status = iMAPProtocol.status(this.fullName, null);
            if (n2 > 0) {
                this.cachedStatus = status;
                this.cachedStatusTime = System.currentTimeMillis();
            }
            Status status2 = status;
            return status2;
        }
        finally {
            this.releaseStoreProtocol(iMAPProtocol);
        }
    }

    public synchronized Message getMessage(int n2) throws MessagingException {
        this.checkOpened();
        this.checkRange(n2);
        return this.messageCache.getMessage(n2);
    }

    public synchronized void appendMessages(Message[] messageArray) throws MessagingException {
        this.checkExists();
        int n2 = ((IMAPStore)this.store).getAppendBufferSize();
        for (int i2 = 0; i2 < messageArray.length; ++i2) {
            MessageLiteral messageLiteral;
            Message message = messageArray[i2];
            Date date = message.getReceivedDate();
            if (date == null) {
                date = message.getSentDate();
            }
            Date date2 = date;
            Flags flags = message.getFlags();
            try {
                messageLiteral = new MessageLiteral(message, message.getSize() > n2 ? 0 : n2);
            }
            catch (IOException iOException) {
                throw new MessagingException("IOException while appending messages", (Exception)iOException);
            }
            catch (MessageRemovedException messageRemovedException) {
                continue;
            }
            this.doCommand((ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public synchronized AppendUID[] appendUIDMessages(Message[] messageArray) throws MessagingException {
        this.checkExists();
        int n2 = ((IMAPStore)this.store).getAppendBufferSize();
        AppendUID[] appendUIDArray = new AppendUID[messageArray.length];
        for (int i2 = 0; i2 < messageArray.length; ++i2) {
            AppendUID appendUID;
            MessageLiteral messageLiteral;
            Message message = messageArray[i2];
            try {
                messageLiteral = new MessageLiteral(message, message.getSize() > n2 ? 0 : n2);
            }
            catch (IOException iOException) {
                throw new MessagingException("IOException while appending messages", (Exception)iOException);
            }
            catch (MessageRemovedException messageRemovedException) {
                continue;
            }
            Date date = message.getReceivedDate();
            if (date == null) {
                date = message.getSentDate();
            }
            Date date2 = date;
            Flags flags = message.getFlags();
            appendUIDArray[i2] = appendUID = (AppendUID)this.doCommand((ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
        return appendUIDArray;
    }

    public synchronized Message[] addMessages(Message[] messageArray) throws MessagingException {
        this.checkOpened();
        MimeMessage[] mimeMessageArray = new MimeMessage[messageArray.length];
        AppendUID[] appendUIDArray = this.appendUIDMessages(messageArray);
        for (int i2 = 0; i2 < appendUIDArray.length; ++i2) {
            AppendUID appendUID = appendUIDArray[i2];
            if (appendUID == null || appendUID.uidvalidity != this.uidvalidity) continue;
            try {
                mimeMessageArray[i2] = this.getMessageByUID(appendUID.uid);
                continue;
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        return mimeMessageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyMessages(Message[] messageArray, Folder folder) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return;
        }
        if (folder.getStore() == this.store) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    IMAPProtocol iMAPProtocol = this.getProtocol();
                    MessageSet[] messageSetArray = Utility.toMessageSet((Message[])messageArray, null);
                    if (messageSetArray == null) {
                        throw new MessageRemovedException("Messages have been removed");
                    }
                    iMAPProtocol.copy(messageSetArray, folder.getFullName());
                }
                catch (CommandFailedException commandFailedException) {
                    if (commandFailedException.getMessage().indexOf("TRYCREATE") != -1) {
                        throw new FolderNotFoundException(folder, new StringBuffer().append(folder.getFullName()).append(" does not exist").toString());
                    }
                    throw new MessagingException(commandFailedException.getMessage(), (Exception)((Object)commandFailedException));
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException((Folder)this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
                }
            }
        }
        super.copyMessages(messageArray, folder);
    }

    public synchronized Message[] expunge() throws MessagingException {
        return this.expunge(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] expunge(Message[] messageArray) throws MessagingException {
        IMAPMessage[] iMAPMessageArray;
        this.checkOpened();
        if (messageArray != null) {
            iMAPMessageArray = new FetchProfile();
            iMAPMessageArray.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
            this.fetch(messageArray, (FetchProfile)iMAPMessageArray);
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            this.doExpungeNotification = false;
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                if (messageArray != null) {
                    iMAPProtocol.uidexpunge(Utility.toUIDSet((Message[])messageArray));
                } else {
                    iMAPProtocol.expunge();
                }
            }
            catch (CommandFailedException commandFailedException) {
                if (this.mode != 2) {
                    throw new IllegalStateException(new StringBuffer().append("Cannot expunge READ_ONLY folder: ").append(this.fullName).toString());
                }
                throw new MessagingException(commandFailedException.getMessage(), (Exception)((Object)commandFailedException));
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
            finally {
                this.doExpungeNotification = true;
            }
            iMAPMessageArray = messageArray != null ? this.messageCache.removeExpungedMessages(messageArray) : this.messageCache.removeExpungedMessages();
            if (this.uidTable != null) {
                for (int i2 = 0; i2 < iMAPMessageArray.length; ++i2) {
                    IMAPMessage iMAPMessage = iMAPMessageArray[i2];
                    long l2 = iMAPMessage.getUID();
                    if (l2 == -1L) continue;
                    this.uidTable.remove(new Long(l2));
                }
            }
            this.total = this.messageCache.size();
        }
        if (iMAPMessageArray.length > 0) {
            this.notifyMessageRemovedListeners(true, (Message[])iMAPMessageArray);
        }
        return iMAPMessageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm searchTerm) throws MessagingException {
        this.checkOpened();
        try {
            IMAPMessage[] iMAPMessageArray = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.getProtocol().search(searchTerm);
                if (nArray != null) {
                    iMAPMessageArray = new IMAPMessage[nArray.length];
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        iMAPMessageArray[i2] = this.getMessageBySeqNumber(nArray[i2]);
                    }
                }
            }
            return iMAPMessageArray;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm searchTerm, Message[] messageArray) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return messageArray;
        }
        try {
            IMAPMessage[] iMAPMessageArray = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                MessageSet[] messageSetArray = Utility.toMessageSet((Message[])messageArray, null);
                if (messageSetArray == null) {
                    throw new MessageRemovedException("Messages have been removed");
                }
                int[] nArray = iMAPProtocol.search(messageSetArray, searchTerm);
                if (nArray != null) {
                    iMAPMessageArray = new IMAPMessage[nArray.length];
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        iMAPMessageArray[i2] = this.getMessageBySeqNumber(nArray[i2]);
                    }
                }
            }
            return iMAPMessageArray;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm, messageArray);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm, messageArray);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
    }

    public synchronized Message[] getSortedMessages(SortTerm[] sortTermArray) throws MessagingException {
        return this.getSortedMessages(sortTermArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getSortedMessages(SortTerm[] sortTermArray, SearchTerm searchTerm) throws MessagingException {
        this.checkOpened();
        try {
            IMAPMessage[] iMAPMessageArray = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.getProtocol().sort(sortTermArray, searchTerm);
                if (nArray != null) {
                    iMAPMessageArray = new IMAPMessage[nArray.length];
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        iMAPMessageArray[i2] = this.getMessageBySeqNumber(nArray[i2]);
                    }
                }
            }
            return iMAPMessageArray;
        }
        catch (CommandFailedException commandFailedException) {
            throw new MessagingException(commandFailedException.getMessage(), (Exception)((Object)commandFailedException));
        }
        catch (SearchException searchException) {
            throw new MessagingException(searchException.getMessage(), (Exception)((Object)searchException));
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
    }

    public synchronized void addMessageCountListener(MessageCountListener messageCountListener) {
        super.addMessageCountListener(messageCountListener);
        this.hasMessageCountListener = true;
    }

    public synchronized long getUIDValidity() throws MessagingException {
        if (this.opened) {
            return this.uidvalidity;
        }
        IMAPProtocol iMAPProtocol = null;
        Status status = null;
        try {
            iMAPProtocol = this.getStoreProtocol();
            String[] stringArray = new String[]{"UIDVALIDITY"};
            status = iMAPProtocol.status(this.fullName, stringArray);
        }
        catch (BadCommandException badCommandException) {
            throw new MessagingException("Cannot obtain UIDValidity", (Exception)((Object)badCommandException));
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
        finally {
            this.releaseStoreProtocol(iMAPProtocol);
        }
        return status.uidvalidity;
    }

    public synchronized long getUIDNext() throws MessagingException {
        if (this.opened) {
            return this.uidnext;
        }
        IMAPProtocol iMAPProtocol = null;
        Status status = null;
        try {
            iMAPProtocol = this.getStoreProtocol();
            String[] stringArray = new String[]{"UIDNEXT"};
            status = iMAPProtocol.status(this.fullName, stringArray);
        }
        catch (BadCommandException badCommandException) {
            throw new MessagingException("Cannot obtain UIDNext", (Exception)((Object)badCommandException));
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
        finally {
            this.releaseStoreProtocol(iMAPProtocol);
        }
        return status.uidnext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message getMessageByUID(long l2) throws MessagingException {
        this.checkOpened();
        IMAPMessage iMAPMessage = null;
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID uID;
                Long l3 = new Long(l2);
                if (this.uidTable != null) {
                    iMAPMessage = (IMAPMessage)this.uidTable.get(l3);
                    if (iMAPMessage != null) {
                        return iMAPMessage;
                    }
                } else {
                    this.uidTable = new Hashtable();
                }
                if ((uID = this.getProtocol().fetchSequenceNumber(l2)) != null && uID.seqnum <= this.total) {
                    iMAPMessage = this.getMessageBySeqNumber(uID.seqnum);
                    iMAPMessage.setUID(uID.uid);
                    this.uidTable.put(l3, iMAPMessage);
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
        return iMAPMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long l2, long l3) throws MessagingException {
        Message[] messageArray;
        this.checkOpened();
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                if (this.uidTable == null) {
                    this.uidTable = new Hashtable();
                }
                UID[] uIDArray = this.getProtocol().fetchSequenceNumbers(l2, l3);
                messageArray = new Message[uIDArray.length];
                for (int i2 = 0; i2 < uIDArray.length; ++i2) {
                    IMAPMessage iMAPMessage = this.getMessageBySeqNumber(uIDArray[i2].seqnum);
                    iMAPMessage.setUID(uIDArray[i2].uid);
                    messageArray[i2] = iMAPMessage;
                    this.uidTable.put(new Long(uIDArray[i2].uid), iMAPMessage);
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
        return messageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long[] lArray) throws MessagingException {
        this.checkOpened();
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                Long l2;
                int n2;
                Message[] messageArray;
                long[] lArray2 = lArray;
                if (this.uidTable != null) {
                    messageArray = new Vector();
                    for (n2 = 0; n2 < lArray.length; ++n2) {
                        l2 = new Long(lArray[n2]);
                        if (this.uidTable.containsKey(l2)) continue;
                        messageArray.addElement(l2);
                    }
                    n2 = messageArray.size();
                    lArray2 = new long[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        lArray2[i2] = (Long)messageArray.elementAt(i2);
                    }
                } else {
                    this.uidTable = new Hashtable();
                }
                if (lArray2.length > 0) {
                    messageArray = this.getProtocol().fetchSequenceNumbers(lArray2);
                    for (n2 = 0; n2 < messageArray.length; ++n2) {
                        l2 = this.getMessageBySeqNumber(messageArray[n2].seqnum);
                        l2.setUID(messageArray[n2].uid);
                        this.uidTable.put(new Long(messageArray[n2].uid), l2);
                    }
                }
                messageArray = new Message[lArray.length];
                for (int i3 = 0; i3 < lArray.length; ++i3) {
                    messageArray[i3] = (Message)this.uidTable.get(new Long(lArray[i3]));
                }
                return messageArray;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getUID(Message message) throws MessagingException {
        if (message.getFolder() != this) {
            throw new NoSuchElementException("Message does not belong to this folder");
        }
        this.checkOpened();
        IMAPMessage iMAPMessage = (IMAPMessage)message;
        long l2 = iMAPMessage.getUID();
        if (l2 != -1L) {
            return l2;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                iMAPMessage.checkExpunged();
                UID uID = iMAPProtocol.fetchUID(iMAPMessage.getSequenceNumber());
                if (uID != null) {
                    l2 = uID.uid;
                    iMAPMessage.setUID(l2);
                    if (this.uidTable == null) {
                        this.uidTable = new Hashtable();
                    }
                    this.uidTable.put(new Long(l2), iMAPMessage);
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
        return l2;
    }

    public Quota[] getQuota() throws MessagingException {
        return (Quota[])this.doOptionalCommand("QUOTA not supported", (ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setQuota(Quota quota) throws MessagingException {
        this.doOptionalCommand("QUOTA not supported", (ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ACL[] getACL() throws MessagingException {
        return (ACL[])this.doOptionalCommand("ACL not supported", (ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addACL(ACL aCL) throws MessagingException {
        this.setACL(aCL, '\u0000');
    }

    public void removeACL(String string) throws MessagingException {
        this.doOptionalCommand("ACL not supported", (ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '+');
    }

    public void removeRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '-');
    }

    public Rights[] listRights(String string) throws MessagingException {
        return (Rights[])this.doOptionalCommand("ACL not supported", (ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Rights myRights() throws MessagingException {
        return (Rights)this.doOptionalCommand("ACL not supported", (ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setACL(ACL aCL, char c2) throws MessagingException {
        this.doOptionalCommand("ACL not supported", (ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public synchronized String[] getAttributes() throws MessagingException {
        this.checkExists();
        if (this.attributes == null) {
            this.exists();
        }
        return this.attributes == null ? new String[]{} : (String[])this.attributes.clone();
    }

    public void idle() throws MessagingException {
        this.idle(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void idle(boolean bl2) throws MessagingException {
        Object object;
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        IMAPFolder iMAPFolder = this;
        synchronized (iMAPFolder) {
            this.checkOpened();
            object = (Boolean)this.doOptionalCommand("IDLE not supported", (ProtocolCommand)new /* Unavailable Anonymous Inner Class!! */);
            if (!((Boolean)object).booleanValue()) {
                return;
            }
        }
        while (true) {
            iMAPFolder = this.protocol.readIdleResponse();
            try {
                object = this.messageCacheLock;
                synchronized (object) {
                    block18: {
                        try {
                            if (iMAPFolder != null && this.protocol != null && this.protocol.processIdleResponse((Response)iMAPFolder)) break block18;
                            this.idleState = 0;
                            this.messageCacheLock.notifyAll();
                            break;
                        }
                        catch (ProtocolException protocolException) {
                            this.idleState = 0;
                            this.messageCacheLock.notifyAll();
                            throw protocolException;
                        }
                    }
                    if (bl2 && this.idleState == 1) {
                        this.protocol.idleAbort();
                        this.idleState = 2;
                    }
                    continue;
                }
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(connectionException);
                continue;
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
            break;
        }
        int n2 = ((IMAPStore)this.store).getMinIdleTime();
        if (n2 > 0) {
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void waitIfIdle() throws ProtocolException {
        if (!$assertionsDisabled && !Thread.holdsLock(this.messageCacheLock)) {
            throw new AssertionError();
        }
        while (this.idleState != 0) {
            if (this.idleState == 1) {
                this.protocol.idleAbort();
                this.idleState = 2;
            }
            try {
                this.messageCacheLock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void handleResponse(Response response) {
        if (!$assertionsDisabled && !Thread.holdsLock(this.messageCacheLock)) {
            throw new AssertionError();
        }
        if (response.isOK() || response.isNO() || response.isBAD() || response.isBYE()) {
            ((IMAPStore)this.store).handleResponseCode(response);
        }
        if (response.isBYE()) {
            if (this.opened) {
                this.cleanup(false);
            }
            return;
        }
        if (response.isOK()) {
            return;
        }
        if (!response.isUnTagged()) {
            return;
        }
        if (!(response instanceof IMAPResponse)) {
            this.logger.fine(new StringBuffer().append("UNEXPECTED RESPONSE : ").append(response.toString()).toString());
            return;
        }
        IMAPResponse iMAPResponse = (IMAPResponse)response;
        if (iMAPResponse.keyEquals("EXISTS")) {
            int n2 = iMAPResponse.getNumber();
            if (n2 <= this.realTotal) {
                return;
            }
            int n3 = n2 - this.realTotal;
            Message[] messageArray = new Message[n3];
            this.messageCache.addMessages(n3, this.realTotal + 1);
            int n4 = this.total;
            this.realTotal += n3;
            this.total += n3;
            if (this.hasMessageCountListener) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    messageArray[i2] = this.messageCache.getMessage(++n4);
                }
                this.notifyMessageAddedListeners(messageArray);
            }
        } else if (iMAPResponse.keyEquals("EXPUNGE")) {
            int n5 = iMAPResponse.getNumber();
            Message[] messageArray = null;
            if (this.doExpungeNotification && this.hasMessageCountListener) {
                messageArray = new Message[]{this.getMessageBySeqNumber(n5)};
            }
            this.messageCache.expungeMessage(n5);
            --this.realTotal;
            if (messageArray != null) {
                this.notifyMessageRemovedListeners(false, messageArray);
            }
        } else if (iMAPResponse.keyEquals("FETCH")) {
            IMAPMessage iMAPMessage;
            if (!$assertionsDisabled && !(iMAPResponse instanceof FetchResponse)) {
                throw new AssertionError((Object)"!ir instanceof FetchResponse");
            }
            FetchResponse fetchResponse = (FetchResponse)iMAPResponse;
            Flags flags = (Flags)fetchResponse.getItem(class$javax$mail$Flags == null ? (class$javax$mail$Flags = IMAPFolder.class$((String)"macromedia.externals.javax.mail_1_4_7.Flags")) : class$javax$mail$Flags);
            if (flags != null && (iMAPMessage = this.getMessageBySeqNumber(fetchResponse.getNumber())) != null) {
                iMAPMessage._setFlags(flags);
                this.notifyMessageChangedListeners(1, (Message)iMAPMessage);
            }
        } else if (iMAPResponse.keyEquals("RECENT")) {
            this.recent = iMAPResponse.getNumber();
        }
    }

    void handleResponses(Response[] responseArray) {
        for (int i2 = 0; i2 < responseArray.length; ++i2) {
            if (responseArray[i2] == null) continue;
            this.handleResponse(responseArray[i2]);
        }
    }

    protected synchronized IMAPProtocol getStoreProtocol() throws ProtocolException {
        this.connectionPoolLogger.fine("getStoreProtocol() borrowing a connection");
        return ((IMAPStore)this.store).getFolderStoreProtocol();
    }

    protected synchronized void throwClosedException(ConnectionException connectionException) throws FolderClosedException, StoreClosedException {
        if (this.protocol != null && connectionException.getProtocol() == this.protocol || this.protocol == null && !this.reallyClosed) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        throw new StoreClosedException(this.store, connectionException.getMessage());
    }

    protected IMAPProtocol getProtocol() throws ProtocolException {
        if (!$assertionsDisabled && !Thread.holdsLock(this.messageCacheLock)) {
            throw new AssertionError();
        }
        this.waitIfIdle();
        return this.protocol;
    }

    public Object doCommand(ProtocolCommand protocolCommand) throws MessagingException {
        try {
            return this.doProtocolCommand(protocolCommand);
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
        return null;
    }

    public Object doOptionalCommand(String string, ProtocolCommand protocolCommand) throws MessagingException {
        try {
            return this.doProtocolCommand(protocolCommand);
        }
        catch (BadCommandException badCommandException) {
            throw new MessagingException(string, (Exception)((Object)badCommandException));
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
        return null;
    }

    public Object doCommandIgnoreFailure(ProtocolCommand protocolCommand) throws MessagingException {
        try {
            return this.doProtocolCommand(protocolCommand);
        }
        catch (CommandFailedException commandFailedException) {
            return null;
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doProtocolCommand(ProtocolCommand protocolCommand) throws ProtocolException {
        IMAPFolder iMAPFolder = this;
        synchronized (iMAPFolder) {
            if (this.protocol != null) {
                Object object = this.messageCacheLock;
                synchronized (object) {
                    return protocolCommand.doCommand(this.getProtocol());
                }
            }
        }
        iMAPFolder = null;
        try {
            iMAPFolder = this.getStoreProtocol();
            Object object = protocolCommand.doCommand((IMAPProtocol)iMAPFolder);
            return object;
        }
        finally {
            this.releaseStoreProtocol((IMAPProtocol)iMAPFolder);
        }
    }

    protected synchronized void releaseStoreProtocol(IMAPProtocol iMAPProtocol) {
        if (iMAPProtocol != this.protocol) {
            ((IMAPStore)this.store).releaseFolderStoreProtocol(iMAPProtocol);
        } else {
            this.logger.fine("releasing our protocol as store protocol?");
        }
    }

    protected void releaseProtocol(boolean bl2) {
        if (this.protocol != null) {
            this.protocol.removeResponseHandler((ResponseHandler)this);
            if (bl2) {
                ((IMAPStore)this.store).releaseProtocol(this, this.protocol);
            } else {
                this.protocol.disconnect();
                ((IMAPStore)this.store).releaseProtocol(this, null);
            }
            this.protocol = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keepConnectionAlive(boolean bl2) throws ProtocolException {
        if (System.currentTimeMillis() - this.protocol.getTimestamp() > 1000L) {
            this.waitIfIdle();
            if (this.protocol != null) {
                this.protocol.noop();
            }
        }
        if (bl2 && ((IMAPStore)this.store).hasSeparateStoreConnection()) {
            IMAPProtocol iMAPProtocol = null;
            try {
                iMAPProtocol = ((IMAPStore)this.store).getFolderStoreProtocol();
                if (System.currentTimeMillis() - iMAPProtocol.getTimestamp() > 1000L) {
                    iMAPProtocol.noop();
                }
            }
            finally {
                ((IMAPStore)this.store).releaseFolderStoreProtocol(iMAPProtocol);
            }
        }
    }

    protected IMAPMessage getMessageBySeqNumber(int n2) {
        return this.messageCache.getMessageBySeqnum(n2);
    }

    private boolean isDirectory() {
        return (this.type & 2) != 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static /* synthetic */ int access$000(IMAPFolder iMAPFolder) {
        return iMAPFolder.idleState;
    }

    static /* synthetic */ int access$002(IMAPFolder iMAPFolder, int n2) {
        iMAPFolder.idleState = n2;
        return iMAPFolder.idleState;
    }

    static {
        $assertionsDisabled = !(class$com$sun$mail$imap$IMAPFolder == null ? (class$com$sun$mail$imap$IMAPFolder = IMAPFolder.class$((String)"macromedia.externals.com.sun.mail_1_4_7.imap.IMAPFolder")) : class$com$sun$mail$imap$IMAPFolder).desiredAssertionStatus();
    }
}

