/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.iap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;
import macromedia.externals.com.sun.mail_1_4_7.iap.ByteArray;
import macromedia.externals.com.sun.mail_1_4_7.iap.Protocol;
import macromedia.externals.com.sun.mail_1_4_7.iap.ProtocolException;
import macromedia.externals.com.sun.mail_1_4_7.util.ASCIIUtility;

public class Response {
    protected int index;
    protected int pindex;
    protected int size;
    protected byte[] buffer = null;
    protected int type = 0;
    protected String tag = null;
    private static final int increment = 100;
    public static final int TAG_MASK = 3;
    public static final int CONTINUATION = 1;
    public static final int TAGGED = 2;
    public static final int UNTAGGED = 3;
    public static final int TYPE_MASK = 28;
    public static final int OK = 4;
    public static final int NO = 8;
    public static final int BAD = 12;
    public static final int BYE = 16;
    public static final int SYNTHETIC = 32;

    public Response(String string) {
        this.buffer = ASCIIUtility.getBytes((String)string);
        this.size = this.buffer.length;
        this.parse();
    }

    public Response(Protocol protocol) throws IOException, ProtocolException {
        ByteArray byteArray = protocol.getResponseBuffer();
        ByteArray byteArray2 = protocol.getInputStream().readResponse(byteArray);
        this.buffer = byteArray2.getBytes();
        this.size = byteArray2.getCount() - 2;
        this.parse();
    }

    public Response(Response response) {
        this.index = response.index;
        this.size = response.size;
        this.buffer = response.buffer;
        this.type = response.type;
        this.tag = response.tag;
    }

    public static Response byeResponse(Exception exception) {
        String string = new StringBuffer().append("* BYE JavaMail Exception: ").append(exception.toString()).toString();
        string = string.replace('\r', ' ').replace('\n', ' ');
        Response response = new Response(string);
        response.type |= 0x20;
        return response;
    }

    private void parse() {
        this.index = 0;
        if (this.size == 0) {
            return;
        }
        if (this.buffer[this.index] == 43) {
            this.type |= 1;
            ++this.index;
            return;
        }
        if (this.buffer[this.index] == 42) {
            this.type |= 3;
            ++this.index;
        } else {
            this.type |= 2;
            this.tag = this.readAtom();
            if (this.tag == null) {
                this.tag = "";
            }
        }
        int n2 = this.index;
        String string = this.readAtom();
        if (string == null) {
            string = "";
        }
        if (string.equalsIgnoreCase("OK")) {
            this.type |= 4;
        } else if (string.equalsIgnoreCase("NO")) {
            this.type |= 8;
        } else if (string.equalsIgnoreCase("BAD")) {
            this.type |= 0xC;
        } else if (string.equalsIgnoreCase("BYE")) {
            this.type |= 0x10;
        } else {
            this.index = n2;
        }
        this.pindex = this.index;
    }

    public void skipSpaces() {
        while (this.index < this.size && this.buffer[this.index] == 32) {
            ++this.index;
        }
    }

    public void skipToken() {
        while (this.index < this.size && this.buffer[this.index] != 32) {
            ++this.index;
        }
    }

    public void skip(int n2) {
        this.index += n2;
    }

    public byte peekByte() {
        if (this.index < this.size) {
            return this.buffer[this.index];
        }
        return 0;
    }

    public byte readByte() {
        if (this.index < this.size) {
            return this.buffer[this.index++];
        }
        return 0;
    }

    public String readAtom() {
        return this.readAtom('\u0000');
    }

    public String readAtom(char c2) {
        byte by2;
        this.skipSpaces();
        if (this.index >= this.size) {
            return null;
        }
        int n2 = this.index;
        while (this.index < this.size && (by2 = this.buffer[this.index]) > 32 && by2 != 40 && by2 != 41 && by2 != 37 && by2 != 42 && by2 != 34 && by2 != 92 && by2 != 127 && (c2 == '\u0000' || by2 != c2)) {
            ++this.index;
        }
        return ASCIIUtility.toString((byte[])this.buffer, (int)n2, (int)this.index);
    }

    public String readString(char c2) {
        this.skipSpaces();
        if (this.index >= this.size) {
            return null;
        }
        int n2 = this.index;
        while (this.index < this.size && this.buffer[this.index] != c2) {
            ++this.index;
        }
        return ASCIIUtility.toString((byte[])this.buffer, (int)n2, (int)this.index);
    }

    public String[] readStringList() {
        return this.readStringList(false);
    }

    public String[] readAtomStringList() {
        return this.readStringList(true);
    }

    private String[] readStringList(boolean bl2) {
        this.skipSpaces();
        if (this.buffer[this.index] != 40) {
            return null;
        }
        ++this.index;
        Vector<String> vector = new Vector<String>();
        do {
            vector.addElement(bl2 ? this.readAtomString() : this.readString());
        } while (this.buffer[this.index++] != 41);
        int n2 = vector.size();
        if (n2 > 0) {
            Object[] objectArray = new String[n2];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public int readNumber() {
        this.skipSpaces();
        int n2 = this.index;
        while (this.index < this.size && Character.isDigit((char)this.buffer[this.index])) {
            ++this.index;
        }
        if (this.index > n2) {
            try {
                return ASCIIUtility.parseInt((byte[])this.buffer, (int)n2, (int)this.index);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public long readLong() {
        this.skipSpaces();
        int n2 = this.index;
        while (this.index < this.size && Character.isDigit((char)this.buffer[this.index])) {
            ++this.index;
        }
        if (this.index > n2) {
            try {
                return ASCIIUtility.parseLong((byte[])this.buffer, (int)n2, (int)this.index);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public String readString() {
        return (String)this.parseString(false, true);
    }

    public ByteArrayInputStream readBytes() {
        ByteArray byteArray = this.readByteArray();
        if (byteArray != null) {
            return byteArray.toByteArrayInputStream();
        }
        return null;
    }

    public ByteArray readByteArray() {
        if (this.isContinuation()) {
            this.skipSpaces();
            return new ByteArray(this.buffer, this.index, this.size - this.index);
        }
        return (ByteArray)this.parseString(false, false);
    }

    public String readAtomString() {
        return (String)this.parseString(true, true);
    }

    private Object parseString(boolean bl2, boolean bl3) {
        this.skipSpaces();
        byte by2 = this.buffer[this.index];
        if (by2 == 34) {
            ++this.index;
            int n2 = this.index;
            int n3 = this.index;
            while (this.index < this.size && (by2 = this.buffer[this.index]) != 34) {
                if (by2 == 92) {
                    ++this.index;
                }
                if (this.index != n3) {
                    this.buffer[n3] = this.buffer[this.index];
                }
                ++n3;
                ++this.index;
            }
            if (this.index >= this.size) {
                return null;
            }
            ++this.index;
            if (bl3) {
                return ASCIIUtility.toString((byte[])this.buffer, (int)n2, (int)n3);
            }
            return new ByteArray(this.buffer, n2, n3 - n2);
        }
        if (by2 == 123) {
            int n4 = ++this.index;
            while (this.buffer[this.index] != 125) {
                ++this.index;
            }
            int n5 = 0;
            try {
                n5 = ASCIIUtility.parseInt((byte[])this.buffer, (int)n4, (int)this.index);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            n4 = this.index + 3;
            this.index = n4 + n5;
            if (bl3) {
                return ASCIIUtility.toString((byte[])this.buffer, (int)n4, (int)(n4 + n5));
            }
            return new ByteArray(this.buffer, n4, n5);
        }
        if (bl2) {
            int n6 = this.index;
            String string = this.readAtom();
            if (bl3) {
                return string;
            }
            return new ByteArray(this.buffer, n6, this.index);
        }
        if (by2 == 78 || by2 == 110) {
            this.index += 3;
            return null;
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public boolean isContinuation() {
        return (this.type & 3) == 1;
    }

    public boolean isTagged() {
        return (this.type & 3) == 2;
    }

    public boolean isUnTagged() {
        return (this.type & 3) == 3;
    }

    public boolean isOK() {
        return (this.type & 0x1C) == 4;
    }

    public boolean isNO() {
        return (this.type & 0x1C) == 8;
    }

    public boolean isBAD() {
        return (this.type & 0x1C) == 12;
    }

    public boolean isBYE() {
        return (this.type & 0x1C) == 16;
    }

    public boolean isSynthetic() {
        return (this.type & 0x20) == 32;
    }

    public String getTag() {
        return this.tag;
    }

    public String getRest() {
        this.skipSpaces();
        return ASCIIUtility.toString((byte[])this.buffer, (int)this.index, (int)this.size);
    }

    public void reset() {
        this.index = this.pindex;
    }

    public String toString() {
        return ASCIIUtility.toString((byte[])this.buffer, (int)0, (int)this.size);
    }
}

