/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.iap;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import macromedia.externals.com.sun.mail_1_4_7.iap.Argument;
import macromedia.externals.com.sun.mail_1_4_7.iap.BadCommandException;
import macromedia.externals.com.sun.mail_1_4_7.iap.ByteArray;
import macromedia.externals.com.sun.mail_1_4_7.iap.CommandFailedException;
import macromedia.externals.com.sun.mail_1_4_7.iap.ConnectionException;
import macromedia.externals.com.sun.mail_1_4_7.iap.LiteralException;
import macromedia.externals.com.sun.mail_1_4_7.iap.ProtocolException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Response;
import macromedia.externals.com.sun.mail_1_4_7.iap.ResponseHandler;
import macromedia.externals.com.sun.mail_1_4_7.iap.ResponseInputStream;
import macromedia.externals.com.sun.mail_1_4_7.util.MailLogger;
import macromedia.externals.com.sun.mail_1_4_7.util.PropUtil;
import macromedia.externals.com.sun.mail_1_4_7.util.SocketFetcher;
import macromedia.externals.com.sun.mail_1_4_7.util.TraceInputStream;
import macromedia.externals.com.sun.mail_1_4_7.util.TraceOutputStream;

public class Protocol {
    protected String host;
    private Socket socket;
    protected boolean quote;
    protected MailLogger logger;
    protected MailLogger traceLogger;
    protected Properties props;
    protected String prefix;
    private boolean connected = false;
    private TraceInputStream traceInput;
    private volatile ResponseInputStream input;
    private TraceOutputStream traceOutput;
    private volatile DataOutputStream output;
    private int tagCounter = 0;
    private String localHostName;
    private final Vector handlers = new Vector();
    private volatile long timestamp;
    private static final byte[] CRLF = new byte[]{13, 10};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Protocol(String string, int n2, Properties properties, String string2, boolean bl2, MailLogger mailLogger) throws IOException, ProtocolException {
        try {
            this.host = string;
            this.props = properties;
            this.prefix = string2;
            this.logger = mailLogger;
            this.traceLogger = mailLogger.getSubLogger("protocol", null);
            this.socket = SocketFetcher.getSocket((String)string, (int)n2, (Properties)properties, (String)string2, (boolean)bl2);
            this.quote = PropUtil.getBooleanProperty((Properties)properties, (String)"mail.debug.quote", (boolean)false);
            this.initStreams();
            this.processGreeting(this.readResponse());
            this.timestamp = System.currentTimeMillis();
            this.connected = true;
        }
        finally {
            if (!this.connected) {
                this.disconnect();
            }
        }
    }

    private void initStreams() throws IOException {
        this.traceInput = new TraceInputStream(this.socket.getInputStream(), this.traceLogger);
        this.traceInput.setQuote(this.quote);
        this.input = new ResponseInputStream((InputStream)this.traceInput);
        this.traceOutput = new TraceOutputStream(this.socket.getOutputStream(), this.traceLogger);
        this.traceOutput.setQuote(this.quote);
        this.output = new DataOutputStream(new BufferedOutputStream((OutputStream)this.traceOutput));
    }

    public Protocol(InputStream inputStream, PrintStream printStream, boolean bl2) throws IOException {
        this.host = "localhost";
        this.quote = false;
        this.logger = new MailLogger(this.getClass(), "DEBUG", bl2, printStream);
        this.traceLogger = this.logger.getSubLogger("protocol", null);
        this.traceInput = new TraceInputStream(inputStream, this.traceLogger);
        this.traceInput.setQuote(this.quote);
        this.input = new ResponseInputStream((InputStream)this.traceInput);
        this.traceOutput = new TraceOutputStream((OutputStream)printStream, this.traceLogger);
        this.traceOutput.setQuote(this.quote);
        this.output = new DataOutputStream(new BufferedOutputStream((OutputStream)this.traceOutput));
        this.timestamp = System.currentTimeMillis();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void addResponseHandler(ResponseHandler responseHandler) {
        this.handlers.addElement(responseHandler);
    }

    public void removeResponseHandler(ResponseHandler responseHandler) {
        this.handlers.removeElement(responseHandler);
    }

    public void notifyResponseHandlers(Response[] responseArray) {
        if (this.handlers.size() == 0) {
            return;
        }
        for (int i2 = 0; i2 < responseArray.length; ++i2) {
            Response response = responseArray[i2];
            if (response == null) continue;
            Object[] objectArray = this.handlers.toArray();
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                if (objectArray[i3] == null) continue;
                ((ResponseHandler)objectArray[i3]).handleResponse(response);
            }
        }
    }

    protected void processGreeting(Response response) throws ProtocolException {
        if (response.isBYE()) {
            throw new ConnectionException(this, response);
        }
    }

    protected ResponseInputStream getInputStream() {
        return this.input;
    }

    protected OutputStream getOutputStream() {
        return this.output;
    }

    protected synchronized boolean supportsNonSyncLiterals() {
        return false;
    }

    public Response readResponse() throws IOException, ProtocolException {
        return new Response(this);
    }

    protected ByteArray getResponseBuffer() {
        return null;
    }

    public String writeCommand(String string, Argument argument) throws IOException, ProtocolException {
        String string2 = new StringBuffer().append("A").append(Integer.toString(this.tagCounter++, 10)).toString();
        this.output.writeBytes(new StringBuffer().append(string2).append(" ").append(string).toString());
        if (argument != null) {
            this.output.write(32);
            argument.write(this);
        }
        this.output.write(CRLF);
        this.output.flush();
        return string2;
    }

    public synchronized Response[] command(String string, Argument argument) {
        this.commandStart(string);
        Vector<Response> vector = new Vector<Response>();
        boolean bl2 = false;
        String string2 = null;
        Response response = null;
        try {
            string2 = this.writeCommand(string, argument);
        }
        catch (LiteralException literalException) {
            vector.addElement(literalException.getResponse());
            bl2 = true;
        }
        catch (Exception exception) {
            vector.addElement(Response.byeResponse((Exception)exception));
            bl2 = true;
        }
        Response response2 = null;
        while (!bl2) {
            try {
                response = this.readResponse();
            }
            catch (IOException iOException) {
                if (response2 != null) break;
                response = Response.byeResponse((Exception)iOException);
            }
            catch (ProtocolException protocolException) {
                continue;
            }
            if (response.isBYE()) {
                response2 = response;
                continue;
            }
            vector.addElement(response);
            if (!response.isTagged() || !response.getTag().equals(string2)) continue;
            bl2 = true;
        }
        if (response2 != null) {
            vector.addElement(response2);
        }
        Object[] objectArray = new Response[vector.size()];
        vector.copyInto(objectArray);
        this.timestamp = System.currentTimeMillis();
        this.commandEnd();
        return objectArray;
    }

    public void handleResult(Response response) throws ProtocolException {
        if (response.isOK()) {
            return;
        }
        if (response.isNO()) {
            throw new CommandFailedException(response);
        }
        if (response.isBAD()) {
            throw new BadCommandException(response);
        }
        if (response.isBYE()) {
            this.disconnect();
            throw new ConnectionException(this, response);
        }
    }

    public void simpleCommand(String string, Argument argument) throws ProtocolException {
        Response[] responseArray = this.command(string, argument);
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
    }

    public synchronized void startTLS(String string) throws IOException, ProtocolException {
        if (this.socket instanceof SSLSocket) {
            return;
        }
        this.simpleCommand(string, null);
        this.socket = SocketFetcher.startTLS((Socket)this.socket, (String)this.host, (Properties)this.props, (String)this.prefix);
        this.initStreams();
    }

    public boolean isSSL() {
        return this.socket instanceof SSLSocket;
    }

    protected synchronized void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    protected synchronized String getLocalHost() {
        InetAddress inetAddress;
        if (this.localHostName == null || this.localHostName.length() <= 0) {
            this.localHostName = this.props.getProperty(new StringBuffer().append(this.prefix).append(".localhost").toString());
        }
        if (this.localHostName == null || this.localHostName.length() <= 0) {
            this.localHostName = this.props.getProperty(new StringBuffer().append(this.prefix).append(".localaddress").toString());
        }
        try {
            if (this.localHostName == null || this.localHostName.length() <= 0) {
                inetAddress = InetAddress.getLocalHost();
                this.localHostName = inetAddress.getCanonicalHostName();
                if (this.localHostName == null) {
                    this.localHostName = new StringBuffer().append("[").append(inetAddress.getHostAddress()).append("]").toString();
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if ((this.localHostName == null || this.localHostName.length() <= 0) && this.socket != null && this.socket.isBound()) {
            inetAddress = this.socket.getLocalAddress();
            this.localHostName = inetAddress.getCanonicalHostName();
            if (this.localHostName == null) {
                this.localHostName = new StringBuffer().append("[").append(inetAddress.getHostAddress()).append("]").toString();
            }
        }
        return this.localHostName;
    }

    protected boolean isTracing() {
        return this.traceLogger.isLoggable(Level.FINEST);
    }

    protected void suspendTracing() {
        if (this.traceLogger.isLoggable(Level.FINEST)) {
            this.traceInput.setTrace(false);
            this.traceOutput.setTrace(false);
        }
    }

    protected void resumeTracing() {
        if (this.traceLogger.isLoggable(Level.FINEST)) {
            this.traceInput.setTrace(true);
            this.traceOutput.setTrace(true);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.disconnect();
    }

    private void commandStart(String string) {
    }

    private void commandEnd() {
    }
}

