/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.iap;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import macromedia.externals.com.sun.mail_1_4_7.iap.AString;
import macromedia.externals.com.sun.mail_1_4_7.iap.Atom;
import macromedia.externals.com.sun.mail_1_4_7.iap.Literal;
import macromedia.externals.com.sun.mail_1_4_7.iap.LiteralException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Protocol;
import macromedia.externals.com.sun.mail_1_4_7.iap.ProtocolException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Response;
import macromedia.externals.com.sun.mail_1_4_7.util.ASCIIUtility;

public class Argument {
    protected Vector items = new Vector(1);

    public void append(Argument argument) {
        this.items.ensureCapacity(this.items.size() + argument.items.size());
        for (int i2 = 0; i2 < argument.items.size(); ++i2) {
            this.items.addElement(argument.items.elementAt(i2));
        }
    }

    public void writeString(String string) {
        this.items.addElement(new AString(ASCIIUtility.getBytes((String)string)));
    }

    public void writeString(String string, String string2) throws UnsupportedEncodingException {
        if (string2 == null) {
            this.writeString(string);
        } else {
            this.items.addElement(new AString(string.getBytes(string2)));
        }
    }

    public void writeBytes(byte[] byArray) {
        this.items.addElement(byArray);
    }

    public void writeBytes(ByteArrayOutputStream byteArrayOutputStream) {
        this.items.addElement(byteArrayOutputStream);
    }

    public void writeBytes(Literal literal) {
        this.items.addElement(literal);
    }

    public void writeAtom(String string) {
        this.items.addElement(new Atom(string));
    }

    public void writeNumber(int n2) {
        this.items.addElement(new Integer(n2));
    }

    public void writeNumber(long l2) {
        this.items.addElement(new Long(l2));
    }

    public void writeArgument(Argument argument) {
        this.items.addElement(argument);
    }

    public void write(Protocol protocol) throws IOException, ProtocolException {
        int n2 = this.items != null ? this.items.size() : 0;
        DataOutputStream dataOutputStream = (DataOutputStream)protocol.getOutputStream();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2;
            if (i2 > 0) {
                dataOutputStream.write(32);
            }
            if ((e2 = this.items.elementAt(i2)) instanceof Atom) {
                dataOutputStream.writeBytes(((Atom)e2).string);
                continue;
            }
            if (e2 instanceof Number) {
                dataOutputStream.writeBytes(((Number)e2).toString());
                continue;
            }
            if (e2 instanceof AString) {
                this.astring(((AString)e2).bytes, protocol);
                continue;
            }
            if (e2 instanceof byte[]) {
                this.literal((byte[])e2, protocol);
                continue;
            }
            if (e2 instanceof ByteArrayOutputStream) {
                this.literal((ByteArrayOutputStream)e2, protocol);
                continue;
            }
            if (e2 instanceof Literal) {
                this.literal((Literal)e2, protocol);
                continue;
            }
            if (!(e2 instanceof Argument)) continue;
            dataOutputStream.write(40);
            ((Argument)e2).write(protocol);
            dataOutputStream.write(41);
        }
    }

    private void astring(byte[] byArray, Protocol protocol) throws IOException, ProtocolException {
        byte by2;
        int n2;
        DataOutputStream dataOutputStream = (DataOutputStream)protocol.getOutputStream();
        int n3 = byArray.length;
        if (n3 > 1024) {
            this.literal(byArray, protocol);
            return;
        }
        boolean bl2 = n3 == 0;
        boolean bl3 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            by2 = byArray[n2];
            if (by2 == 0 || by2 == 13 || by2 == 10 || (by2 & 0xFF) > 127) {
                this.literal(byArray, protocol);
                return;
            }
            if (by2 != 42 && by2 != 37 && by2 != 40 && by2 != 41 && by2 != 123 && by2 != 34 && by2 != 92 && (by2 & 0xFF) > 32) continue;
            bl2 = true;
            if (by2 != 34 && by2 != 92) continue;
            bl3 = true;
        }
        if (bl2) {
            dataOutputStream.write(34);
        }
        if (bl3) {
            for (n2 = 0; n2 < n3; ++n2) {
                by2 = byArray[n2];
                if (by2 == 34 || by2 == 92) {
                    dataOutputStream.write(92);
                }
                dataOutputStream.write(by2);
            }
        } else {
            dataOutputStream.write(byArray);
        }
        if (bl2) {
            dataOutputStream.write(34);
        }
    }

    private void literal(byte[] byArray, Protocol protocol) throws IOException, ProtocolException {
        this.startLiteral(protocol, byArray.length).write(byArray);
    }

    private void literal(ByteArrayOutputStream byteArrayOutputStream, Protocol protocol) throws IOException, ProtocolException {
        byteArrayOutputStream.writeTo(this.startLiteral(protocol, byteArrayOutputStream.size()));
    }

    private void literal(Literal literal, Protocol protocol) throws IOException, ProtocolException {
        literal.writeTo(this.startLiteral(protocol, literal.size()));
    }

    private OutputStream startLiteral(Protocol protocol, int n2) throws IOException, ProtocolException {
        DataOutputStream dataOutputStream = (DataOutputStream)protocol.getOutputStream();
        boolean bl2 = protocol.supportsNonSyncLiterals();
        dataOutputStream.write(123);
        dataOutputStream.writeBytes(Integer.toString(n2));
        if (bl2) {
            dataOutputStream.writeBytes("+}\r\n");
        } else {
            dataOutputStream.writeBytes("}\r\n");
        }
        dataOutputStream.flush();
        if (!bl2) {
            Response response;
            while (!(response = protocol.readResponse()).isContinuation()) {
                if (!response.isTagged()) continue;
                throw new LiteralException(response);
            }
        }
        return dataOutputStream;
    }
}

