/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.validators;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.DateUtils;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.BadJWTException;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.ClockSkewAware;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.JWTClaimsVerifier;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Issuer;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.Nonce;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class IDTokenClaimsVerifier
implements ClockSkewAware,
JWTClaimsVerifier {
    private static final BadJWTException MISSING_EXP_CLAIM_EXCEPTION = new BadJWTException("Missing JWT expiration (exp) claim");
    private static final BadJWTException MISSING_IAT_CLAIM_EXCEPTION = new BadJWTException("Missing JWT issue time (iat) claim");
    private static final BadJWTException MISSING_ISS_CLAIM_EXCEPTION = new BadJWTException("Missing JWT issuer (iss) claim");
    private static final BadJWTException MISSING_SUB_CLAIM_EXCEPTION = new BadJWTException("Missing JWT subject (sub) claim");
    private static final BadJWTException MISSING_AUD_CLAIM_EXCEPTION = new BadJWTException("Missing JWT audience (aud) claim");
    private static final BadJWTException MISSING_NONCE_CLAIM_EXCEPTION = new BadJWTException("Missing JWT nonce (nonce) claim");
    private static final BadJWTException EXPIRED_EXCEPTION = new BadJWTException("Expired JWT");
    private static final BadJWTException IAT_CLAIM_AHEAD_EXCEPTION = new BadJWTException("JWT issue time ahead of current time");
    private final Issuer expectedIssuer;
    private final ClientID expectedClientID;
    private final Nonce expectedNonce;
    private int maxClockSkew;

    public IDTokenClaimsVerifier(Issuer issuer, ClientID clientID, Nonce nonce, int n2) {
        if (issuer == null) {
            throw new IllegalArgumentException("The expected ID token issuer must not be null");
        }
        this.expectedIssuer = issuer;
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.expectedClientID = clientID;
        this.expectedNonce = nonce;
        this.setMaxClockSkew(n2);
    }

    public Issuer getExpectedIssuer() {
        return this.expectedIssuer;
    }

    public ClientID getClientID() {
        return this.expectedClientID;
    }

    public Nonce getExpectedNonce() {
        return this.expectedNonce;
    }

    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    public void setMaxClockSkew(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The max clock skew must be zero or positive");
        }
        this.maxClockSkew = n2;
    }

    public void verify(JWTClaimsSet jWTClaimsSet) throws BadJWTException {
        Object object;
        String string = jWTClaimsSet.getIssuer();
        if (string == null) {
            throw MISSING_ISS_CLAIM_EXCEPTION;
        }
        if (!this.expectedIssuer.getValue().equals(string)) {
            throw new BadJWTException("Unexpected JWT issuer: " + string);
        }
        if (jWTClaimsSet.getSubject() == null) {
            throw MISSING_SUB_CLAIM_EXCEPTION;
        }
        List list = jWTClaimsSet.getAudience();
        if (list == null || list.isEmpty()) {
            throw MISSING_AUD_CLAIM_EXCEPTION;
        }
        if (!list.contains(this.expectedClientID.getValue())) {
            throw new BadJWTException("Unexpected JWT audience: " + list);
        }
        if (list.size() > 1) {
            try {
                object = jWTClaimsSet.getStringClaim("azp");
            }
            catch (ParseException parseException) {
                throw new BadJWTException("Invalid JWT authorized party (azp) claim: " + parseException.getMessage());
            }
            if (object != null && !this.expectedClientID.getValue().equals(object)) {
                throw new BadJWTException("Unexpected JWT authorized party (azp) claim: " + (String)object);
            }
        }
        if ((object = jWTClaimsSet.getExpirationTime()) == null) {
            throw MISSING_EXP_CLAIM_EXCEPTION;
        }
        Date date = jWTClaimsSet.getIssueTime();
        if (date == null) {
            throw MISSING_IAT_CLAIM_EXCEPTION;
        }
        Date date2 = new Date();
        if (!DateUtils.isAfter((Date)object, (Date)date2, (long)this.maxClockSkew)) {
            throw EXPIRED_EXCEPTION;
        }
        if (!DateUtils.isBefore((Date)date, (Date)date2, (long)this.maxClockSkew)) {
            throw IAT_CLAIM_AHEAD_EXCEPTION;
        }
        if (this.expectedNonce != null) {
            String string2;
            try {
                string2 = jWTClaimsSet.getStringClaim("nonce");
            }
            catch (ParseException parseException) {
                throw new BadJWTException("Invalid JWT nonce (nonce) claim: " + parseException.getMessage());
            }
            if (string2 == null) {
                throw MISSING_NONCE_CLAIM_EXCEPTION;
            }
            if (!this.expectedNonce.getValue().equals(string2)) {
                throw new BadJWTException("Unexpected JWT nonce (nonce) claim: " + string2);
            }
        }
    }
}

