/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.op;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.GrantType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseMode;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.Scope;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthenticationMethod;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Issuer;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.pkce.CodeChallengeMethod;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.OrderedJSONObject;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.Display;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.SubjectType;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.ACR;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.ClaimType;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class OIDCProviderMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final Issuer issuer;
    private URI authzEndpoint;
    private URI tokenEndpoint;
    private URI userInfoEndpoint;
    private URI regEndpoint;
    private URI introspectionEndpoint;
    private URI revocationEndpoint;
    private URI checkSessionIframe;
    private URI endSessionEndpoint;
    private final URI jwkSetURI;
    private Scope scope;
    private List<ResponseType> rts;
    private List<ResponseMode> rms;
    private List<GrantType> gts;
    private List<CodeChallengeMethod> codeChallengeMethods;
    private List<ACR> acrValues;
    private final List<SubjectType> subjectTypes;
    private List<ClientAuthenticationMethod> tokenEndpointAuthMethods;
    private List<JWSAlgorithm> tokenEndpointJWSAlgs;
    private List<JWSAlgorithm> requestObjectJWSAlgs;
    private List<JWEAlgorithm> requestObjectJWEAlgs;
    private List<EncryptionMethod> requestObjectJWEEncs;
    private List<JWSAlgorithm> idTokenJWSAlgs;
    private List<JWEAlgorithm> idTokenJWEAlgs;
    private List<EncryptionMethod> idTokenJWEEncs;
    private List<JWSAlgorithm> userInfoJWSAlgs;
    private List<JWEAlgorithm> userInfoJWEAlgs;
    private List<EncryptionMethod> userInfoJWEEncs;
    private List<Display> displays;
    private List<ClaimType> claimTypes;
    private List<String> claims;
    private List<LangTag> claimsLocales;
    private List<LangTag> uiLocales;
    private URI serviceDocsURI;
    private URI policyURI;
    private URI tosURI;
    private boolean claimsParamSupported = false;
    private boolean requestParamSupported = false;
    private boolean requestURIParamSupported = true;
    private boolean requireRequestURIReg = false;
    private final JSONObject customParameters = new JSONObject();

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("issuer");
        hashSet.add("authorization_endpoint");
        hashSet.add("token_endpoint");
        hashSet.add("userinfo_endpoint");
        hashSet.add("registration_endpoint");
        hashSet.add("check_session_iframe");
        hashSet.add("end_session_endpoint");
        hashSet.add("jwks_uri");
        hashSet.add("scopes_supported");
        hashSet.add("response_types_supported");
        hashSet.add("response_modes_supported");
        hashSet.add("grant_types_supported");
        hashSet.add("code_challenge_methods_supported");
        hashSet.add("acr_values_supported");
        hashSet.add("subject_types_supported");
        hashSet.add("token_endpoint_auth_methods_supported");
        hashSet.add("token_endpoint_auth_signing_alg_values_supported");
        hashSet.add("request_object_signing_alg_values_supported");
        hashSet.add("request_object_encryption_alg_values_supported");
        hashSet.add("request_object_encryption_enc_values_supported");
        hashSet.add("id_token_signing_alg_values_supported");
        hashSet.add("id_token_encryption_alg_values_supported");
        hashSet.add("id_token_encryption_enc_values_supported");
        hashSet.add("userinfo_signing_alg_values_supported");
        hashSet.add("userinfo_encryption_alg_values_supported");
        hashSet.add("userinfo_encryption_enc_values_supported");
        hashSet.add("display_values_supported");
        hashSet.add("claim_types_supported");
        hashSet.add("claims_supported");
        hashSet.add("claims_locales_supported");
        hashSet.add("ui_locales_supported");
        hashSet.add("service_documentation");
        hashSet.add("op_policy_uri");
        hashSet.add("op_tos_uri");
        hashSet.add("claims_parameter_supported");
        hashSet.add("request_parameter_supported");
        hashSet.add("request_uri_parameter_supported");
        hashSet.add("require_request_uri_registration");
        hashSet.add("introspection_endpoint");
        hashSet.add("revocation_endpoint");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public OIDCProviderMetadata(Issuer issuer, List<SubjectType> list, URI uRI) {
        URI uRI2;
        try {
            uRI2 = new URI(issuer.getValue());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("The issuer identifier must be a URI: " + uRISyntaxException.getMessage(), uRISyntaxException);
        }
        if (uRI2.getRawQuery() != null) {
            throw new IllegalArgumentException("The issuer URI must be without a query component");
        }
        if (uRI2.getRawFragment() != null) {
            throw new IllegalArgumentException("The issuer URI must be without a fragment component ");
        }
        this.issuer = issuer;
        if (list.size() < 1) {
            throw new IllegalArgumentException("At least one supported subject type must be specified");
        }
        this.subjectTypes = list;
        if (uRI == null) {
            throw new IllegalArgumentException("The public JWK set URI must not be null");
        }
        this.jwkSetURI = uRI;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public URI getAuthorizationEndpointURI() {
        return this.authzEndpoint;
    }

    public void setAuthorizationEndpointURI(URI uRI) {
        this.authzEndpoint = uRI;
    }

    public URI getTokenEndpointURI() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpointURI(URI uRI) {
        this.tokenEndpoint = uRI;
    }

    public URI getUserInfoEndpointURI() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpointURI(URI uRI) {
        this.userInfoEndpoint = uRI;
    }

    public URI getRegistrationEndpointURI() {
        return this.regEndpoint;
    }

    public void setRegistrationEndpointURI(URI uRI) {
        this.regEndpoint = uRI;
    }

    public URI getIntrospectionEndpointURI() {
        return this.introspectionEndpoint;
    }

    public void setIntrospectionEndpointURI(URI uRI) {
        this.introspectionEndpoint = uRI;
    }

    public URI getRevocationEndpointURI() {
        return this.revocationEndpoint;
    }

    public void setRevocationEndpointURI(URI uRI) {
        this.revocationEndpoint = uRI;
    }

    public URI getCheckSessionIframeURI() {
        return this.checkSessionIframe;
    }

    public void setCheckSessionIframeURI(URI uRI) {
        this.checkSessionIframe = uRI;
    }

    public URI getEndSessionEndpointURI() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpointURI(URI uRI) {
        this.endSessionEndpoint = uRI;
    }

    public URI getJWKSetURI() {
        return this.jwkSetURI;
    }

    public Scope getScopes() {
        return this.scope;
    }

    public void setScopes(Scope scope) {
        this.scope = scope;
    }

    public List<ResponseType> getResponseTypes() {
        return this.rts;
    }

    public void setResponseTypes(List<ResponseType> list) {
        this.rts = list;
    }

    public List<ResponseMode> getResponseModes() {
        return this.rms;
    }

    public void setResponseModes(List<ResponseMode> list) {
        this.rms = list;
    }

    public List<GrantType> getGrantTypes() {
        return this.gts;
    }

    public void setGrantTypes(List<GrantType> list) {
        this.gts = list;
    }

    public List<CodeChallengeMethod> getCodeChallengeMethods() {
        return this.codeChallengeMethods;
    }

    public void setCodeChallengeMethods(List<CodeChallengeMethod> list) {
        this.codeChallengeMethods = list;
    }

    public List<ACR> getACRs() {
        return this.acrValues;
    }

    public void setACRs(List<ACR> list) {
        this.acrValues = list;
    }

    public List<SubjectType> getSubjectTypes() {
        return this.subjectTypes;
    }

    public List<ClientAuthenticationMethod> getTokenEndpointAuthMethods() {
        return this.tokenEndpointAuthMethods;
    }

    public void setTokenEndpointAuthMethods(List<ClientAuthenticationMethod> list) {
        this.tokenEndpointAuthMethods = list;
    }

    public List<JWSAlgorithm> getTokenEndpointJWSAlgs() {
        return this.tokenEndpointJWSAlgs;
    }

    public void setTokenEndpointJWSAlgs(List<JWSAlgorithm> list) {
        if (list != null && list.contains(Algorithm.NONE)) {
            throw new IllegalArgumentException("The none algorithm is not accepted");
        }
        this.tokenEndpointJWSAlgs = list;
    }

    public List<JWSAlgorithm> getRequestObjectJWSAlgs() {
        return this.requestObjectJWSAlgs;
    }

    public void setRequestObjectJWSAlgs(List<JWSAlgorithm> list) {
        this.requestObjectJWSAlgs = list;
    }

    public List<JWEAlgorithm> getRequestObjectJWEAlgs() {
        return this.requestObjectJWEAlgs;
    }

    public void setRequestObjectJWEAlgs(List<JWEAlgorithm> list) {
        this.requestObjectJWEAlgs = list;
    }

    public List<EncryptionMethod> getRequestObjectJWEEncs() {
        return this.requestObjectJWEEncs;
    }

    public void setRequestObjectJWEEncs(List<EncryptionMethod> list) {
        this.requestObjectJWEEncs = list;
    }

    public List<JWSAlgorithm> getIDTokenJWSAlgs() {
        return this.idTokenJWSAlgs;
    }

    public void setIDTokenJWSAlgs(List<JWSAlgorithm> list) {
        this.idTokenJWSAlgs = list;
    }

    public List<JWEAlgorithm> getIDTokenJWEAlgs() {
        return this.idTokenJWEAlgs;
    }

    public void setIDTokenJWEAlgs(List<JWEAlgorithm> list) {
        this.idTokenJWEAlgs = list;
    }

    public List<EncryptionMethod> getIDTokenJWEEncs() {
        return this.idTokenJWEEncs;
    }

    public void setIDTokenJWEEncs(List<EncryptionMethod> list) {
        this.idTokenJWEEncs = list;
    }

    public List<JWSAlgorithm> getUserInfoJWSAlgs() {
        return this.userInfoJWSAlgs;
    }

    public void setUserInfoJWSAlgs(List<JWSAlgorithm> list) {
        this.userInfoJWSAlgs = list;
    }

    public List<JWEAlgorithm> getUserInfoJWEAlgs() {
        return this.userInfoJWEAlgs;
    }

    public void setUserInfoJWEAlgs(List<JWEAlgorithm> list) {
        this.userInfoJWEAlgs = list;
    }

    public List<EncryptionMethod> getUserInfoJWEEncs() {
        return this.userInfoJWEEncs;
    }

    public void setUserInfoJWEEncs(List<EncryptionMethod> list) {
        this.userInfoJWEEncs = list;
    }

    public List<Display> getDisplays() {
        return this.displays;
    }

    public void setDisplays(List<Display> list) {
        this.displays = list;
    }

    public List<ClaimType> getClaimTypes() {
        return this.claimTypes;
    }

    public void setClaimTypes(List<ClaimType> list) {
        this.claimTypes = list;
    }

    public List<String> getClaims() {
        return this.claims;
    }

    public void setClaims(List<String> list) {
        this.claims = list;
    }

    public List<LangTag> getClaimsLocales() {
        return this.claimsLocales;
    }

    public void setClaimLocales(List<LangTag> list) {
        this.claimsLocales = list;
    }

    public List<LangTag> getUILocales() {
        return this.uiLocales;
    }

    public void setUILocales(List<LangTag> list) {
        this.uiLocales = list;
    }

    public URI getServiceDocsURI() {
        return this.serviceDocsURI;
    }

    public void setServiceDocsURI(URI uRI) {
        this.serviceDocsURI = uRI;
    }

    public URI getPolicyURI() {
        return this.policyURI;
    }

    public void setPolicyURI(URI uRI) {
        this.policyURI = uRI;
    }

    public URI getTermsOfServiceURI() {
        return this.tosURI;
    }

    public void setTermsOfServiceURI(URI uRI) {
        this.tosURI = uRI;
    }

    public boolean supportsClaimsParam() {
        return this.claimsParamSupported;
    }

    public void setSupportsClaimsParams(boolean bl2) {
        this.claimsParamSupported = bl2;
    }

    public boolean supportsRequestParam() {
        return this.requestParamSupported;
    }

    public void setSupportsRequestParam(boolean bl2) {
        this.requestParamSupported = bl2;
    }

    public boolean supportsRequestURIParam() {
        return this.requestURIParamSupported;
    }

    public void setSupportsRequestURIParam(boolean bl2) {
        this.requestURIParamSupported = bl2;
    }

    public boolean requiresRequestURIRegistration() {
        return this.requireRequestURIReg;
    }

    public void setRequiresRequestURIRegistration(boolean bl2) {
        this.requireRequestURIReg = bl2;
    }

    public Object getCustomParameter(String string) {
        return this.customParameters.get((Object)string);
    }

    public URI getCustomURIParameter(String string) {
        try {
            return JSONObjectUtils.getURI((JSONObject)this.customParameters, (String)string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setCustomParameter(String string, Object object) {
        if (REGISTERED_PARAMETER_NAMES.contains(string)) {
            throw new IllegalArgumentException("The " + string + " parameter is registered");
        }
        this.customParameters.put((Object)string, object);
    }

    public JSONObject getCustomParameters() {
        return this.customParameters;
    }

    public void applyDefaults() {
        if (this.rms == null) {
            this.rms = new ArrayList(2);
            this.rms.add(ResponseMode.QUERY);
            this.rms.add(ResponseMode.FRAGMENT);
        }
        if (this.gts == null) {
            this.gts = new ArrayList(2);
            this.gts.add(GrantType.AUTHORIZATION_CODE);
            this.gts.add(GrantType.IMPLICIT);
        }
        if (this.claimTypes == null) {
            this.claimTypes = new ArrayList(1);
            this.claimTypes.add(ClaimType.NORMAL);
        }
    }

    public JSONObject toJSONObject() {
        OrderedJSONObject orderedJSONObject = new OrderedJSONObject();
        orderedJSONObject.put((Object)"issuer", (Object)this.issuer.getValue());
        ArrayList<String> arrayList = new ArrayList<String>(this.subjectTypes.size());
        for (SubjectType subjectType : this.subjectTypes) {
            arrayList.add(subjectType.toString());
        }
        orderedJSONObject.put((Object)"subject_types_supported", arrayList);
        orderedJSONObject.put((Object)"jwks_uri", (Object)this.jwkSetURI.toString());
        if (this.authzEndpoint != null) {
            orderedJSONObject.put((Object)"authorization_endpoint", (Object)this.authzEndpoint.toString());
        }
        if (this.tokenEndpoint != null) {
            orderedJSONObject.put((Object)"token_endpoint", (Object)this.tokenEndpoint.toString());
        }
        if (this.userInfoEndpoint != null) {
            orderedJSONObject.put((Object)"userinfo_endpoint", (Object)this.userInfoEndpoint.toString());
        }
        if (this.regEndpoint != null) {
            orderedJSONObject.put((Object)"registration_endpoint", (Object)this.regEndpoint.toString());
        }
        if (this.introspectionEndpoint != null) {
            orderedJSONObject.put((Object)"introspection_endpoint", (Object)this.introspectionEndpoint.toString());
        }
        if (this.revocationEndpoint != null) {
            orderedJSONObject.put((Object)"revocation_endpoint", (Object)this.revocationEndpoint.toString());
        }
        if (this.checkSessionIframe != null) {
            orderedJSONObject.put((Object)"check_session_iframe", (Object)this.checkSessionIframe.toString());
        }
        if (this.endSessionEndpoint != null) {
            orderedJSONObject.put((Object)"end_session_endpoint", (Object)this.endSessionEndpoint.toString());
        }
        if (this.scope != null) {
            orderedJSONObject.put((Object)"scopes_supported", (Object)this.scope.toStringList());
        }
        if (this.rts != null) {
            arrayList = new ArrayList(this.rts.size());
            for (SubjectType subjectType : this.rts) {
                arrayList.add(subjectType.toString());
            }
            orderedJSONObject.put((Object)"response_types_supported", arrayList);
        }
        if (this.rms != null) {
            arrayList = new ArrayList(this.rms.size());
            for (SubjectType subjectType : this.rms) {
                arrayList.add(subjectType.getValue());
            }
            orderedJSONObject.put((Object)"response_modes_supported", arrayList);
        }
        if (this.gts != null) {
            arrayList = new ArrayList(this.gts.size());
            for (SubjectType subjectType : this.gts) {
                arrayList.add(subjectType.toString());
            }
            orderedJSONObject.put((Object)"grant_types_supported", arrayList);
        }
        if (this.codeChallengeMethods != null) {
            arrayList = new ArrayList(this.codeChallengeMethods.size());
            for (SubjectType subjectType : this.codeChallengeMethods) {
                arrayList.add(subjectType.getValue());
            }
            orderedJSONObject.put((Object)"code_challenge_methods_supported", arrayList);
        }
        if (this.acrValues != null) {
            arrayList = new ArrayList(this.acrValues.size());
            for (SubjectType subjectType : this.acrValues) {
                arrayList.add(subjectType.getValue());
            }
            orderedJSONObject.put((Object)"acr_values_supported", arrayList);
        }
        if (this.tokenEndpointAuthMethods != null) {
            arrayList = new ArrayList(this.tokenEndpointAuthMethods.size());
            for (SubjectType subjectType : this.tokenEndpointAuthMethods) {
                arrayList.add(subjectType.getValue());
            }
            orderedJSONObject.put((Object)"token_endpoint_auth_methods_supported", arrayList);
        }
        if (this.tokenEndpointJWSAlgs != null) {
            arrayList = new ArrayList(this.tokenEndpointJWSAlgs.size());
            for (SubjectType subjectType : this.tokenEndpointJWSAlgs) {
                arrayList.add(subjectType.getName());
            }
            orderedJSONObject.put((Object)"token_endpoint_auth_signing_alg_values_supported", arrayList);
        }
        if (this.requestObjectJWSAlgs != null) {
            arrayList = new ArrayList(this.requestObjectJWSAlgs.size());
            for (SubjectType subjectType : this.requestObjectJWSAlgs) {
                arrayList.add(subjectType.getName());
            }
            orderedJSONObject.put((Object)"request_object_signing_alg_values_supported", arrayList);
        }
        if (this.requestObjectJWEAlgs != null) {
            arrayList = new ArrayList(this.requestObjectJWEAlgs.size());
            for (SubjectType subjectType : this.requestObjectJWEAlgs) {
                arrayList.add(subjectType.getName());
            }
            orderedJSONObject.put((Object)"request_object_encryption_alg_values_supported", arrayList);
        }
        if (this.requestObjectJWEEncs != null) {
            arrayList = new ArrayList(this.requestObjectJWEEncs.size());
            for (SubjectType subjectType : this.requestObjectJWEEncs) {
                arrayList.add(subjectType.getName());
            }
            orderedJSONObject.put((Object)"request_object_encryption_enc_values_supported", arrayList);
        }
        if (this.idTokenJWSAlgs != null) {
            arrayList = new ArrayList(this.idTokenJWSAlgs.size());
            for (SubjectType subjectType : this.idTokenJWSAlgs) {
                arrayList.add(subjectType.getName());
            }
            orderedJSONObject.put((Object)"id_token_signing_alg_values_supported", arrayList);
        }
        if (this.idTokenJWEAlgs != null) {
            arrayList = new ArrayList(this.idTokenJWEAlgs.size());
            for (SubjectType subjectType : this.idTokenJWEAlgs) {
                arrayList.add(subjectType.getName());
            }
            orderedJSONObject.put((Object)"id_token_encryption_alg_values_supported", arrayList);
        }
        if (this.idTokenJWEEncs != null) {
            arrayList = new ArrayList(this.idTokenJWEEncs.size());
            for (SubjectType subjectType : this.idTokenJWEEncs) {
                arrayList.add(subjectType.getName());
            }
            orderedJSONObject.put((Object)"id_token_encryption_enc_values_supported", arrayList);
        }
        if (this.userInfoJWSAlgs != null) {
            arrayList = new ArrayList(this.userInfoJWSAlgs.size());
            for (SubjectType subjectType : this.userInfoJWSAlgs) {
                arrayList.add(subjectType.getName());
            }
            orderedJSONObject.put((Object)"userinfo_signing_alg_values_supported", arrayList);
        }
        if (this.userInfoJWEAlgs != null) {
            arrayList = new ArrayList(this.userInfoJWEAlgs.size());
            for (SubjectType subjectType : this.userInfoJWEAlgs) {
                arrayList.add(subjectType.getName());
            }
            orderedJSONObject.put((Object)"userinfo_encryption_alg_values_supported", arrayList);
        }
        if (this.userInfoJWEEncs != null) {
            arrayList = new ArrayList(this.userInfoJWEEncs.size());
            for (SubjectType subjectType : this.userInfoJWEEncs) {
                arrayList.add(subjectType.getName());
            }
            orderedJSONObject.put((Object)"userinfo_encryption_enc_values_supported", arrayList);
        }
        if (this.displays != null) {
            arrayList = new ArrayList(this.displays.size());
            for (SubjectType subjectType : this.displays) {
                arrayList.add(subjectType.toString());
            }
            orderedJSONObject.put((Object)"display_values_supported", arrayList);
        }
        if (this.claimTypes != null) {
            arrayList = new ArrayList(this.claimTypes.size());
            for (SubjectType subjectType : this.claimTypes) {
                arrayList.add(subjectType.toString());
            }
            orderedJSONObject.put((Object)"claim_types_supported", arrayList);
        }
        if (this.claims != null) {
            orderedJSONObject.put((Object)"claims_supported", (Object)this.claims);
        }
        if (this.claimsLocales != null) {
            arrayList = new ArrayList(this.claimsLocales.size());
            for (SubjectType subjectType : this.claimsLocales) {
                arrayList.add(subjectType.toString());
            }
            orderedJSONObject.put((Object)"claims_locales_supported", arrayList);
        }
        if (this.uiLocales != null) {
            arrayList = new ArrayList(this.uiLocales.size());
            for (SubjectType subjectType : this.uiLocales) {
                arrayList.add(subjectType.toString());
            }
            orderedJSONObject.put((Object)"ui_locales_supported", arrayList);
        }
        if (this.serviceDocsURI != null) {
            orderedJSONObject.put((Object)"service_documentation", (Object)this.serviceDocsURI.toString());
        }
        if (this.policyURI != null) {
            orderedJSONObject.put((Object)"op_policy_uri", (Object)this.policyURI.toString());
        }
        if (this.tosURI != null) {
            orderedJSONObject.put((Object)"op_tos_uri", (Object)this.tosURI.toString());
        }
        orderedJSONObject.put((Object)"claims_parameter_supported", (Object)this.claimsParamSupported);
        orderedJSONObject.put((Object)"request_parameter_supported", (Object)this.requestParamSupported);
        orderedJSONObject.put((Object)"request_uri_parameter_supported", (Object)this.requestURIParamSupported);
        orderedJSONObject.put((Object)"require_request_uri_registration", (Object)this.requireRequestURIReg);
        orderedJSONObject.putAll((Map)this.customParameters);
        return orderedJSONObject;
    }

    public static OIDCProviderMetadata parse(JSONObject jSONObject) throws ParseException {
        int n2;
        int n3;
        String[] stringArray;
        String string;
        ArrayList<SubjectType> arrayList = new ArrayList<SubjectType>();
        Object object = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"subject_types_supported");
        int n4 = ((String[])object).length;
        int n5 = 0;
        while (n5 < n4) {
            string = object[n5];
            arrayList.add(SubjectType.parse((String)string));
            ++n5;
        }
        string = new Issuer(JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"issuer").toString());
        URI uRI = JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"jwks_uri");
        OIDCProviderMetadata oIDCProviderMetadata = new OIDCProviderMetadata((Issuer)string, Collections.unmodifiableList(arrayList), uRI);
        if (jSONObject.get((Object)"authorization_endpoint") != null) {
            oIDCProviderMetadata.authzEndpoint = JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"authorization_endpoint");
        }
        if (jSONObject.get((Object)"token_endpoint") != null) {
            oIDCProviderMetadata.tokenEndpoint = JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"token_endpoint");
        }
        if (jSONObject.get((Object)"userinfo_endpoint") != null) {
            oIDCProviderMetadata.userInfoEndpoint = JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"userinfo_endpoint");
        }
        if (jSONObject.get((Object)"registration_endpoint") != null) {
            oIDCProviderMetadata.regEndpoint = JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"registration_endpoint");
        }
        if (jSONObject.get((Object)"introspection_endpoint") != null) {
            oIDCProviderMetadata.introspectionEndpoint = JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"introspection_endpoint");
        }
        if (jSONObject.get((Object)"revocation_endpoint") != null) {
            oIDCProviderMetadata.revocationEndpoint = JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"revocation_endpoint");
        }
        if (jSONObject.get((Object)"check_session_iframe") != null) {
            oIDCProviderMetadata.checkSessionIframe = JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"check_session_iframe");
        }
        if (jSONObject.get((Object)"end_session_endpoint") != null) {
            oIDCProviderMetadata.endSessionEndpoint = JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"end_session_endpoint");
        }
        if (jSONObject.get((Object)"scopes_supported") != null) {
            oIDCProviderMetadata.scope = new Scope();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"scopes_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.scope.add((Object)new Scope.Value((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"response_types_supported") != null) {
            oIDCProviderMetadata.rts = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"response_types_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.rts.add(ResponseType.parse((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"response_modes_supported") != null) {
            oIDCProviderMetadata.rms = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"response_modes_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.rms.add(new ResponseMode((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"grant_types_supported") != null) {
            oIDCProviderMetadata.gts = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"grant_types_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.gts.add(GrantType.parse((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"code_challenge_methods_supported") != null) {
            oIDCProviderMetadata.codeChallengeMethods = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"code_challenge_methods_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.codeChallengeMethods.add(CodeChallengeMethod.parse((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"acr_values_supported") != null) {
            oIDCProviderMetadata.acrValues = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"acr_values_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.acrValues.add(new ACR((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"token_endpoint_auth_methods_supported") != null) {
            oIDCProviderMetadata.tokenEndpointAuthMethods = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"token_endpoint_auth_methods_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.tokenEndpointAuthMethods.add(new ClientAuthenticationMethod((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"token_endpoint_auth_signing_alg_values_supported") != null) {
            oIDCProviderMetadata.tokenEndpointJWSAlgs = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"token_endpoint_auth_signing_alg_values_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null && object.equals(Algorithm.NONE.getName())) {
                    throw new ParseException("The none algorithm is not accepted");
                }
                if (object != null) {
                    oIDCProviderMetadata.tokenEndpointJWSAlgs.add(new JWSAlgorithm((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"request_object_signing_alg_values_supported") != null) {
            oIDCProviderMetadata.requestObjectJWSAlgs = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"request_object_signing_alg_values_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.requestObjectJWSAlgs.add(new JWSAlgorithm((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"request_object_encryption_alg_values_supported") != null) {
            oIDCProviderMetadata.requestObjectJWEAlgs = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"request_object_encryption_alg_values_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.requestObjectJWEAlgs.add(new JWEAlgorithm((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"request_object_encryption_enc_values_supported") != null) {
            oIDCProviderMetadata.requestObjectJWEEncs = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"request_object_encryption_enc_values_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.requestObjectJWEEncs.add(new EncryptionMethod((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"id_token_signing_alg_values_supported") != null) {
            oIDCProviderMetadata.idTokenJWSAlgs = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"id_token_signing_alg_values_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.idTokenJWSAlgs.add(new JWSAlgorithm((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"id_token_encryption_alg_values_supported") != null) {
            oIDCProviderMetadata.idTokenJWEAlgs = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"id_token_encryption_alg_values_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.idTokenJWEAlgs.add(new JWEAlgorithm((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"id_token_encryption_enc_values_supported") != null) {
            oIDCProviderMetadata.idTokenJWEEncs = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"id_token_encryption_enc_values_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.idTokenJWEEncs.add(new EncryptionMethod((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"userinfo_signing_alg_values_supported") != null) {
            oIDCProviderMetadata.userInfoJWSAlgs = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"userinfo_signing_alg_values_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.userInfoJWSAlgs.add(new JWSAlgorithm((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"userinfo_encryption_alg_values_supported") != null) {
            oIDCProviderMetadata.userInfoJWEAlgs = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"userinfo_encryption_alg_values_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.userInfoJWEAlgs.add(new JWEAlgorithm((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"userinfo_encryption_enc_values_supported") != null) {
            oIDCProviderMetadata.userInfoJWEEncs = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"userinfo_encryption_enc_values_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.userInfoJWEEncs.add(new EncryptionMethod((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"display_values_supported") != null) {
            oIDCProviderMetadata.displays = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"display_values_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.displays.add(Display.parse((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"claim_types_supported") != null) {
            oIDCProviderMetadata.claimTypes = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"claim_types_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.claimTypes.add(ClaimType.parse((String)object));
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"claims_supported") != null) {
            oIDCProviderMetadata.claims = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"claims_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    oIDCProviderMetadata.claims.add(object);
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"claims_locales_supported") != null) {
            oIDCProviderMetadata.claimsLocales = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"claims_locales_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    try {
                        oIDCProviderMetadata.claimsLocales.add(LangTag.parse((String)object));
                    }
                    catch (LangTagException langTagException) {
                        throw new ParseException("Invalid claims_locales_supported field: " + langTagException.getMessage(), (Throwable)langTagException);
                    }
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"ui_locales_supported") != null) {
            oIDCProviderMetadata.uiLocales = new ArrayList();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"ui_locales_supported");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                if (object != null) {
                    try {
                        oIDCProviderMetadata.uiLocales.add(LangTag.parse((String)object));
                    }
                    catch (LangTagException langTagException) {
                        throw new ParseException("Invalid ui_locales_supported field: " + langTagException.getMessage(), (Throwable)langTagException);
                    }
                }
                ++n2;
            }
        }
        if (jSONObject.get((Object)"service_documentation") != null) {
            oIDCProviderMetadata.serviceDocsURI = JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"service_documentation");
        }
        if (jSONObject.get((Object)"op_policy_uri") != null) {
            oIDCProviderMetadata.policyURI = JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"op_policy_uri");
        }
        if (jSONObject.get((Object)"op_tos_uri") != null) {
            oIDCProviderMetadata.tosURI = JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"op_tos_uri");
        }
        if (jSONObject.get((Object)"claims_parameter_supported") != null) {
            oIDCProviderMetadata.claimsParamSupported = JSONObjectUtils.getBoolean((JSONObject)jSONObject, (String)"claims_parameter_supported");
        }
        if (jSONObject.get((Object)"request_parameter_supported") != null) {
            oIDCProviderMetadata.requestParamSupported = JSONObjectUtils.getBoolean((JSONObject)jSONObject, (String)"request_parameter_supported");
        }
        if (jSONObject.get((Object)"request_uri_parameter_supported") != null) {
            oIDCProviderMetadata.requestURIParamSupported = JSONObjectUtils.getBoolean((JSONObject)jSONObject, (String)"request_uri_parameter_supported");
        }
        if (jSONObject.get((Object)"require_request_uri_registration") != null) {
            oIDCProviderMetadata.requireRequestURIReg = JSONObjectUtils.getBoolean((JSONObject)jSONObject, (String)"require_request_uri_registration");
        }
        object = new JSONObject((Map)jSONObject);
        object.keySet().removeAll(REGISTERED_PARAMETER_NAMES);
        for (Map.Entry entry : object.entrySet()) {
            oIDCProviderMetadata.setCustomParameter((String)entry.getKey(), entry.getValue());
        }
        return oIDCProviderMetadata;
    }

    public static OIDCProviderMetadata parse(String string) throws ParseException {
        return OIDCProviderMetadata.parse((JSONObject)JSONObjectUtils.parse((String)string));
    }
}

