/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.op;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.BadJOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.SecurityContext;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTParser;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.JWTProcessor;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.ResourceRetriever;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.AuthenticationRequest;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.OIDCError;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.op.ResolveException;
import net.jcip.annotations.ThreadSafe;

/*
 * Exception performing whole class analysis ignored.
 */
@ThreadSafe
public class AuthenticationRequestResolver<C extends SecurityContext> {
    private final JWTProcessor<C> jwtProcessor;
    private final ResourceRetriever jwtRetriever;

    public AuthenticationRequestResolver() {
        this.jwtProcessor = null;
        this.jwtRetriever = null;
    }

    public AuthenticationRequestResolver(JWTProcessor<C> jWTProcessor) {
        if (jWTProcessor == null) {
            throw new IllegalArgumentException("The JWT processor must not be null");
        }
        this.jwtProcessor = jWTProcessor;
        this.jwtRetriever = null;
    }

    public AuthenticationRequestResolver(JWTProcessor<C> jWTProcessor, ResourceRetriever resourceRetriever) {
        if (jWTProcessor == null) {
            throw new IllegalArgumentException("The JWT processor must not be null");
        }
        this.jwtProcessor = jWTProcessor;
        if (resourceRetriever == null) {
            throw new IllegalArgumentException("The JWT retriever must not be null");
        }
        this.jwtRetriever = resourceRetriever;
    }

    public JWTProcessor<C> getJWTProcessor() {
        return this.jwtProcessor;
    }

    public ResourceRetriever getJWTRetriever() {
        return this.jwtRetriever;
    }

    public static Map<String, String> reformatClaims(JWTClaimsSet jWTClaimsSet) {
        Map map = jWTClaimsSet.getClaims();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            hashMap.put((String)entry.getKey(), entry.getValue().toString());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public AuthenticationRequest resolve(AuthenticationRequest authenticationRequest, C c2) throws ResolveException, JOSEException {
        JWTClaimsSet jWTClaimsSet;
        JWT jWT;
        if (!authenticationRequest.specifiesRequestObject()) {
            return authenticationRequest;
        }
        if (authenticationRequest.getRequestURI() != null) {
            if (this.jwtRetriever == null || this.jwtProcessor == null) {
                throw new ResolveException(OIDCError.REQUEST_URI_NOT_SUPPORTED, authenticationRequest);
            }
            try {
                jWT = JWTParser.parse((String)this.jwtRetriever.retrieveResource(authenticationRequest.getRequestURI().toURL()).getContent());
            }
            catch (MalformedURLException malformedURLException) {
                throw new ResolveException(OIDCError.INVALID_REQUEST_URI.setDescription("Malformed URL"), authenticationRequest);
            }
            catch (IOException iOException) {
                throw new ResolveException("Couldn't retrieve request_uri: " + iOException.getMessage(), "Network error, check the request_uri", authenticationRequest, (Throwable)iOException);
            }
            catch (java.text.ParseException parseException) {
                throw new ResolveException(OIDCError.INVALID_REQUEST_URI.setDescription("Invalid JWT"), authenticationRequest);
            }
        } else {
            if (this.jwtProcessor == null) {
                throw new ResolveException(OIDCError.REQUEST_NOT_SUPPORTED, authenticationRequest);
            }
            jWT = authenticationRequest.getRequestObject();
        }
        try {
            jWTClaimsSet = this.jwtProcessor.process(jWT, c2);
        }
        catch (BadJOSEException badJOSEException) {
            throw new ResolveException("Invalid request object: " + badJOSEException.getMessage(), "Bad JWT / signature / HMAC / encryption", authenticationRequest, (Throwable)badJOSEException);
        }
        HashMap hashMap = new HashMap();
        hashMap.putAll(authenticationRequest.toParameters());
        hashMap.putAll(AuthenticationRequestResolver.reformatClaims((JWTClaimsSet)jWTClaimsSet));
        hashMap.remove("request");
        hashMap.remove("request_uri");
        try {
            return AuthenticationRequest.parse((URI)authenticationRequest.getEndpointURI(), hashMap);
        }
        catch (ParseException parseException) {
            throw new ResolveException("Couldn't create final OpenID authentication request: " + parseException.getMessage(), "Invalid request object parameter(s): " + parseException.getMessage(), authenticationRequest, (Throwable)parseException);
        }
    }
}

