/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.id;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ByteUtils;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Subject;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.id.InvalidPairwiseSubjectException;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.id.PairwiseSubjectCodec;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.id.SectorID;
import macromedia.externals.org.apache.commons_3_5.lang3.tuple.ImmutablePair;
import macromedia.externals.org.apache.commons_3_5.lang3.tuple.Pair;
import net.jcip.annotations.ThreadSafe;
import org.cryptomator.siv.SivMode;

@ThreadSafe
public class SIVAESBasedPairwiseSubjectCodec
extends PairwiseSubjectCodec {
    private static final SivMode AES_SIV = new SivMode();
    private final byte[] aesCtrKey;
    private final byte[] macKey;

    public SIVAESBasedPairwiseSubjectCodec(SecretKey secretKey) {
        super(null);
        if (secretKey == null) {
            throw new IllegalArgumentException("The SIV AES secret key must not be null");
        }
        byte[] byArray = secretKey.getEncoded();
        switch (byArray.length) {
            case 32: {
                this.aesCtrKey = ByteUtils.subArray((byte[])byArray, (int)0, (int)16);
                this.macKey = ByteUtils.subArray((byte[])byArray, (int)16, (int)16);
                break;
            }
            case 48: {
                this.aesCtrKey = ByteUtils.subArray((byte[])byArray, (int)0, (int)24);
                this.macKey = ByteUtils.subArray((byte[])byArray, (int)24, (int)24);
                break;
            }
            case 64: {
                this.aesCtrKey = ByteUtils.subArray((byte[])byArray, (int)0, (int)32);
                this.macKey = ByteUtils.subArray((byte[])byArray, (int)32, (int)32);
                break;
            }
            default: {
                throw new IllegalArgumentException("The SIV AES secret key length must be 256, 384 or 512 bits");
            }
        }
    }

    public SecretKey getSecretKey() {
        return new SecretKeySpec(ByteUtils.concat((byte[][])new byte[][]{this.aesCtrKey, this.macKey}), "AES");
    }

    public Subject encode(SectorID sectorID, Subject subject) {
        byte[] byArray = (String.valueOf(sectorID.getValue().replace("|", "\\|")) + '|' + subject.getValue().replace("|", "\\|")).getBytes(CHARSET);
        byte[] byArray2 = AES_SIV.encrypt(this.aesCtrKey, this.macKey, byArray, (byte[][])new byte[0][]);
        return new Subject(Base64URL.encode((byte[])byArray2).toString());
    }

    public Pair<SectorID, Subject> decode(Subject subject) throws InvalidPairwiseSubjectException {
        byte[] byArray;
        byte[] byArray2 = new Base64URL(subject.getValue()).decode();
        try {
            byArray = AES_SIV.decrypt(this.aesCtrKey, this.macKey, byArray2, (byte[][])new byte[0][]);
        }
        catch (Exception exception) {
            throw new InvalidPairwiseSubjectException("Decryption failed: " + exception.getMessage(), (Throwable)exception);
        }
        String[] stringArray = new String(byArray, CHARSET).split("(?<!\\\\)\\|");
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = stringArray[n2].replace("\\|", "|");
            ++n2;
        }
        if (stringArray.length != 2) {
            throw new InvalidPairwiseSubjectException("Invalid format: Unexpected number of tokens: " + stringArray.length);
        }
        return new ImmutablePair((Object)new SectorID(stringArray[0]), (Object)new Subject(stringArray[1]));
    }
}

