/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.Scope;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.ClaimsRequest;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.ClaimRequirement;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;

public class OIDCScopeValue
extends Scope.Value {
    public static final OIDCScopeValue OPENID = new OIDCScopeValue("openid", Scope.Value.Requirement.REQUIRED, new String[]{"sub"});
    public static final OIDCScopeValue PROFILE = new OIDCScopeValue("profile", new String[]{"name", "family_name", "given_name", "middle_name", "nickname", "preferred_username", "profile", "picture", "website", "gender", "birthdate", "zoneinfo", "locale", "updated_at"});
    public static final OIDCScopeValue EMAIL = new OIDCScopeValue("email", new String[]{"email", "email_verified"});
    public static final OIDCScopeValue ADDRESS = new OIDCScopeValue("address", new String[]{"address"});
    public static final OIDCScopeValue PHONE = new OIDCScopeValue("phone", new String[]{"phone_number", "phone_number_verified"});
    public static final OIDCScopeValue OFFLINE_ACCESS = new OIDCScopeValue("offline_access", null);
    private final Set<String> claims;

    public static OIDCScopeValue[] values() {
        return new OIDCScopeValue[]{OPENID, PROFILE, EMAIL, ADDRESS, PHONE, OFFLINE_ACCESS};
    }

    private OIDCScopeValue(String string, Scope.Value.Requirement requirement, String[] stringArray) {
        super(string, requirement);
        this.claims = stringArray != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(stringArray))) : null;
    }

    private OIDCScopeValue(String string, String[] stringArray) {
        this(string, Scope.Value.Requirement.OPTIONAL, stringArray);
    }

    public Set<String> getClaimNames() {
        return this.claims;
    }

    public JSONObject toClaimsRequestJSONObject() {
        JSONObject jSONObject = new JSONObject();
        if (this.claims == null) {
            return null;
        }
        for (String string : this.claims) {
            if (this.getRequirement() == Scope.Value.Requirement.REQUIRED) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"essential", (Object)true);
                jSONObject.put((Object)string, (Object)jSONObject2);
                continue;
            }
            jSONObject.put((Object)string, null);
        }
        return jSONObject;
    }

    public Set<ClaimsRequest.Entry> toClaimsRequestEntries() {
        HashSet<ClaimsRequest.Entry> hashSet = new HashSet<ClaimsRequest.Entry>();
        if (this == OPENID || this == OFFLINE_ACCESS) {
            return Collections.unmodifiableSet(hashSet);
        }
        for (String string : this.getClaimNames()) {
            hashSet.add(new ClaimsRequest.Entry(string, ClaimRequirement.VOLUNTARY));
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

