/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1;

import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseType;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.OIDCResponseTypeValue;

class OIDCResponseTypeValidator {
    public static void validate(ResponseType responseType) {
        if (responseType.isEmpty()) {
            throw new IllegalArgumentException("The response type must contain at least one value");
        }
        if (responseType.contains((Object)ResponseType.Value.TOKEN) && responseType.size() == 1) {
            throw new IllegalArgumentException("The OpenID Connect response type cannot have token as the only value");
        }
        for (ResponseType.Value value : responseType) {
            if (value.equals((Object)ResponseType.Value.CODE) || value.equals((Object)ResponseType.Value.TOKEN) || value.equals((Object)OIDCResponseTypeValue.ID_TOKEN)) continue;
            throw new IllegalArgumentException("Unsupported OpenID Connect response type value: " + value);
        }
    }

    private OIDCResponseTypeValidator() {
    }
}

