/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTParser;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationCode;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationSuccessResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseMode;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.State;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.AccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URIUtils;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.AuthenticationResponse;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.OIDCResponseTypeValue;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class AuthenticationSuccessResponse
extends AuthorizationSuccessResponse
implements AuthenticationResponse {
    private final JWT idToken;
    private final State sessionState;

    public AuthenticationSuccessResponse(URI uRI, AuthorizationCode authorizationCode, JWT jWT, AccessToken accessToken, State state, State state2, ResponseMode responseMode) {
        super(uRI, authorizationCode, accessToken, state, responseMode);
        this.idToken = jWT;
        this.sessionState = state2;
    }

    public ResponseType impliedResponseType() {
        ResponseType responseType = new ResponseType();
        if (this.getAuthorizationCode() != null) {
            responseType.add((Object)ResponseType.Value.CODE);
        }
        if (this.getIDToken() != null) {
            responseType.add((Object)OIDCResponseTypeValue.ID_TOKEN);
        }
        if (this.getAccessToken() != null) {
            responseType.add((Object)ResponseType.Value.TOKEN);
        }
        return responseType;
    }

    public ResponseMode impliedResponseMode() {
        if (this.getResponseMode() != null) {
            return this.getResponseMode();
        }
        if (this.getAccessToken() != null || this.getIDToken() != null) {
            return ResponseMode.FRAGMENT;
        }
        return ResponseMode.QUERY;
    }

    public JWT getIDToken() {
        return this.idToken;
    }

    public State getSessionState() {
        return this.sessionState;
    }

    public Map<String, String> toParameters() {
        Map map = super.toParameters();
        if (this.idToken != null) {
            try {
                map.put("id_token", this.idToken.serialize());
            }
            catch (IllegalStateException illegalStateException) {
                throw new SerializeException("Couldn't serialize ID token: " + illegalStateException.getMessage(), (Throwable)illegalStateException);
            }
        }
        if (this.sessionState != null) {
            map.put("session_state", this.sessionState.getValue());
        }
        return map;
    }

    public static AuthenticationSuccessResponse parse(URI uRI, Map<String, String> map) throws ParseException {
        AuthorizationSuccessResponse authorizationSuccessResponse = AuthorizationSuccessResponse.parse((URI)uRI, map);
        JWT jWT = null;
        if (map.get("id_token") != null) {
            try {
                jWT = JWTParser.parse((String)map.get("id_token"));
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid ID Token JWT: " + parseException.getMessage(), (Throwable)parseException);
            }
        }
        State state = null;
        if (StringUtils.isNotBlank((CharSequence)map.get("session_state"))) {
            state = new State(map.get("session_state"));
        }
        return new AuthenticationSuccessResponse(uRI, authorizationSuccessResponse.getAuthorizationCode(), jWT, authorizationSuccessResponse.getAccessToken(), authorizationSuccessResponse.getState(), state, null);
    }

    public static AuthenticationSuccessResponse parse(URI uRI) throws ParseException {
        Map map;
        if (uRI.getRawFragment() != null) {
            map = URLUtils.parseParameters((String)uRI.getRawFragment());
        } else if (uRI.getRawQuery() != null) {
            map = URLUtils.parseParameters((String)uRI.getRawQuery());
        } else {
            throw new ParseException("Missing URI fragment or query string");
        }
        return AuthenticationSuccessResponse.parse((URI)URIUtils.getBaseURI((URI)uRI), (Map)map);
    }

    public static AuthenticationSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        URI uRI = hTTPResponse.getLocation();
        if (uRI == null) {
            throw new ParseException("Missing redirection URI / HTTP Location header");
        }
        return AuthenticationSuccessResponse.parse((URI)uRI);
    }

    public static AuthenticationSuccessResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        URI uRI;
        try {
            uRI = hTTPRequest.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
        if (hTTPRequest.getQuery() != null) {
            return AuthenticationSuccessResponse.parse((URI)uRI, (Map)URLUtils.parseParameters((String)hTTPRequest.getQuery()));
        }
        if (hTTPRequest.getFragment() != null) {
            return AuthenticationSuccessResponse.parse((URI)uRI, (Map)URLUtils.parseParameters((String)hTTPRequest.getFragment()));
        }
        throw new ParseException("Missing URI fragment, query string or post body");
    }

    public static /* bridge */ /* synthetic */ AuthorizationSuccessResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        return AuthenticationSuccessResponse.parse((HTTPRequest)hTTPRequest);
    }

    public static /* bridge */ /* synthetic */ AuthorizationSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        return AuthenticationSuccessResponse.parse((HTTPResponse)hTTPResponse);
    }

    public static /* bridge */ /* synthetic */ AuthorizationSuccessResponse parse(URI uRI) throws ParseException {
        return AuthenticationSuccessResponse.parse((URI)uRI);
    }

    public static /* bridge */ /* synthetic */ AuthorizationSuccessResponse parse(URI uRI, Map map) throws ParseException {
        return AuthenticationSuccessResponse.parse((URI)uRI, (Map)map);
    }
}

