/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTParser;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.OAuth2Error;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseMode;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.Scope;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.State;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.pkce.CodeChallenge;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.pkce.CodeChallengeMethod;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URIUtils;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.ClaimsRequest;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.Display;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.Nonce;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.OIDCResponseTypeValidator;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.OIDCScopeValue;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.Prompt;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.ACR;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class AuthenticationRequest
extends AuthorizationRequest {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final Nonce nonce;
    private final Display display;
    private final Prompt prompt;
    private final int maxAge;
    private final List<LangTag> uiLocales;
    private final List<LangTag> claimsLocales;
    private final JWT idTokenHint;
    private final String loginHint;
    private final List<ACR> acrValues;
    private final ClaimsRequest claims;
    private final JWT requestObject;
    private final URI requestURI;

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(AuthorizationRequest.getRegisteredParameterNames());
        hashSet.add("nonce");
        hashSet.add("display");
        hashSet.add("prompt");
        hashSet.add("max_age");
        hashSet.add("ui_locales");
        hashSet.add("claims_locales");
        hashSet.add("id_token_hint");
        hashSet.add("login_hint");
        hashSet.add("acr_values");
        hashSet.add("claims");
        hashSet.add("request_uri");
        hashSet.add("request");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public AuthenticationRequest(URI uRI, ResponseType responseType, Scope scope, ClientID clientID, URI uRI2, State state, Nonce nonce) {
        this(uRI, responseType, null, scope, clientID, uRI2, state, nonce, null, null, -1, null, null, null, null, null, null, null, null, null, null);
    }

    public AuthenticationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, Scope scope, ClientID clientID, URI uRI2, State state, Nonce nonce, Display display, Prompt prompt, int n2, List<LangTag> list, List<LangTag> list2, JWT jWT, String string, List<ACR> list3, ClaimsRequest claimsRequest, JWT jWT2, URI uRI3, CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod) {
        this(uRI, responseType, responseMode, scope, clientID, uRI2, state, nonce, display, prompt, n2, list, list2, jWT, string, list3, claimsRequest, jWT2, uRI3, codeChallenge, codeChallengeMethod, Collections.emptyMap());
    }

    public AuthenticationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, Scope scope, ClientID clientID, URI uRI2, State state, Nonce nonce, Display display, Prompt prompt, int n2, List<LangTag> list, List<LangTag> list2, JWT jWT, String string, List<ACR> list3, ClaimsRequest claimsRequest, JWT jWT2, URI uRI3, CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod, Map<String, String> map) {
        super(uRI, responseType, responseMode, clientID, uRI2, scope, state, codeChallenge, codeChallengeMethod, map);
        if (uRI2 == null && jWT2 == null && uRI3 == null) {
            throw new IllegalArgumentException("The redirection URI must not be null");
        }
        OIDCResponseTypeValidator.validate((ResponseType)responseType);
        if (scope == null) {
            throw new IllegalArgumentException("The scope must not be null");
        }
        if (!scope.contains((Object)OIDCScopeValue.OPENID)) {
            throw new IllegalArgumentException("The scope must include an \"openid\" token");
        }
        if (responseType.impliesImplicitFlow() && nonce == null) {
            throw new IllegalArgumentException("Nonce is required in implicit / hybrid protocol flow");
        }
        this.nonce = nonce;
        this.display = display;
        this.prompt = prompt;
        this.maxAge = n2;
        this.uiLocales = list != null ? Collections.unmodifiableList(list) : null;
        this.claimsLocales = list2 != null ? Collections.unmodifiableList(list2) : null;
        this.idTokenHint = jWT;
        this.loginHint = string;
        this.acrValues = list3 != null ? Collections.unmodifiableList(list3) : null;
        this.claims = claimsRequest;
        if (jWT2 != null && uRI3 != null) {
            throw new IllegalArgumentException("Either a request object or a request URI must be specified, but not both");
        }
        this.requestObject = jWT2;
        this.requestURI = uRI3;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public Nonce getNonce() {
        return this.nonce;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public List<LangTag> getUILocales() {
        return this.uiLocales;
    }

    public List<LangTag> getClaimsLocales() {
        return this.claimsLocales;
    }

    public JWT getIDTokenHint() {
        return this.idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public List<ACR> getACRValues() {
        return this.acrValues;
    }

    public ClaimsRequest getClaims() {
        return this.claims;
    }

    public JWT getRequestObject() {
        return this.requestObject;
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public boolean specifiesRequestObject() {
        return this.requestObject != null || this.requestURI != null;
    }

    public Map<String, String> toParameters() {
        StringBuilder stringBuilder;
        Map map = super.toParameters();
        if (this.nonce != null) {
            map.put("nonce", this.nonce.toString());
        }
        if (this.display != null) {
            map.put("display", this.display.toString());
        }
        if (this.prompt != null) {
            map.put("prompt", this.prompt.toString());
        }
        if (this.maxAge >= 0) {
            map.put("max_age", "" + this.maxAge);
        }
        if (this.uiLocales != null) {
            stringBuilder = new StringBuilder();
            for (LangTag langTag : this.uiLocales) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(langTag.toString());
            }
            map.put("ui_locales", stringBuilder.toString());
        }
        if (this.claimsLocales != null) {
            stringBuilder = new StringBuilder();
            for (LangTag langTag : this.claimsLocales) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(langTag.toString());
            }
            map.put("claims_locales", stringBuilder.toString());
        }
        if (this.idTokenHint != null) {
            try {
                map.put("id_token_hint", this.idTokenHint.serialize());
            }
            catch (IllegalStateException illegalStateException) {
                throw new SerializeException("Couldn't serialize ID token hint: " + illegalStateException.getMessage(), (Throwable)illegalStateException);
            }
        }
        if (this.loginHint != null) {
            map.put("login_hint", this.loginHint);
        }
        if (this.acrValues != null) {
            stringBuilder = new StringBuilder();
            for (LangTag langTag : this.acrValues) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(langTag.toString());
            }
            map.put("acr_values", stringBuilder.toString());
        }
        if (this.claims != null) {
            map.put("claims", this.claims.toJSONObject().toString());
        }
        if (this.requestObject != null) {
            try {
                map.put("request", this.requestObject.serialize());
            }
            catch (IllegalStateException illegalStateException) {
                throw new SerializeException("Couldn't serialize request object to JWT: " + illegalStateException.getMessage(), (Throwable)illegalStateException);
            }
        }
        if (this.requestURI != null) {
            map.put("request_uri", this.requestURI.toString());
        }
        return map;
    }

    public static AuthenticationRequest parse(Map<String, String> map) throws ParseException {
        return AuthenticationRequest.parse(null, map);
    }

    public static AuthenticationRequest parse(URI uRI, Map<String, String> map) throws ParseException {
        Object object;
        StringTokenizer stringTokenizer;
        StringTokenizer stringTokenizer2;
        Object object2;
        Prompt prompt;
        AuthorizationRequest authorizationRequest = AuthorizationRequest.parse((URI)uRI, map);
        ClientID clientID = authorizationRequest.getClientID();
        State state = authorizationRequest.getState();
        ResponseMode responseMode = authorizationRequest.getResponseMode();
        URI uRI2 = authorizationRequest.getRedirectionURI();
        ResponseType responseType = authorizationRequest.getResponseType();
        try {
            OIDCResponseTypeValidator.validate((ResponseType)responseType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = "Unsupported \"response_type\" parameter: " + illegalArgumentException.getMessage();
            throw new ParseException(string, OAuth2Error.UNSUPPORTED_RESPONSE_TYPE.appendDescription(": " + string), clientID, uRI2, authorizationRequest.impliedResponseMode(), state);
        }
        Scope scope = authorizationRequest.getScope();
        if (scope == null) {
            String string = "Missing \"scope\" parameter";
            throw new ParseException(string, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string), clientID, uRI2, authorizationRequest.impliedResponseMode(), state);
        }
        if (!scope.contains((Object)OIDCScopeValue.OPENID)) {
            String string = "The scope must include an \"openid\" value";
            throw new ParseException(string, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string), clientID, uRI2, authorizationRequest.impliedResponseMode(), state);
        }
        Nonce nonce = Nonce.parse((String)map.get("nonce"));
        if (responseType.impliesImplicitFlow() && nonce == null) {
            String string = "Missing \"nonce\" parameter: Required in implicit flow";
            throw new ParseException(string, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string), clientID, uRI2, authorizationRequest.impliedResponseMode(), state);
        }
        Display display = null;
        if (map.containsKey("display")) {
            try {
                display = Display.parse((String)map.get("display"));
            }
            catch (ParseException parseException) {
                String string = "Invalid \"display\" parameter: " + parseException.getMessage();
                throw new ParseException(string, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string), clientID, uRI2, authorizationRequest.impliedResponseMode(), state, (Throwable)parseException);
            }
        }
        try {
            prompt = Prompt.parse((String)map.get("prompt"));
        }
        catch (ParseException parseException) {
            String string = "Invalid \"prompt\" parameter: " + parseException.getMessage();
            throw new ParseException(string, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string), clientID, uRI2, authorizationRequest.impliedResponseMode(), state, (Throwable)parseException);
        }
        String string = map.get("max_age");
        int n2 = -1;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "Invalid \"max_age\" parameter: " + string;
                throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string2), clientID, uRI2, authorizationRequest.impliedResponseMode(), state, (Throwable)numberFormatException);
            }
        }
        string = map.get("ui_locales");
        LinkedList<LangTag> linkedList = null;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            linkedList = new LinkedList<LangTag>();
            object2 = new StringTokenizer(string, " ");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                try {
                    linkedList.add(LangTag.parse((String)((StringTokenizer)object2).nextToken()));
                }
                catch (LangTagException langTagException) {
                    String string3 = "Invalid \"ui_locales\" parameter: " + langTagException.getMessage();
                    throw new ParseException(string3, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string3), clientID, uRI2, authorizationRequest.impliedResponseMode(), state, (Throwable)langTagException);
                }
            }
        }
        string = map.get("claims_locales");
        object2 = null;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            object2 = new LinkedList();
            stringTokenizer2 = new StringTokenizer(string, " ");
            while (stringTokenizer2.hasMoreTokens()) {
                try {
                    object2.add(LangTag.parse((String)stringTokenizer2.nextToken()));
                }
                catch (LangTagException langTagException) {
                    String string4 = "Invalid \"claims_locales\" parameter: " + langTagException.getMessage();
                    throw new ParseException(string4, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string4), clientID, uRI2, authorizationRequest.impliedResponseMode(), state, (Throwable)langTagException);
                }
            }
        }
        string = map.get("id_token_hint");
        stringTokenizer2 = null;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                stringTokenizer2 = JWTParser.parse((String)string);
            }
            catch (java.text.ParseException parseException) {
                String string5 = "Invalid \"id_token_hint\" parameter: " + parseException.getMessage();
                throw new ParseException(string5, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string5), clientID, uRI2, authorizationRequest.impliedResponseMode(), state, (Throwable)parseException);
            }
        }
        String string6 = map.get("login_hint");
        string = map.get("acr_values");
        LinkedList<ACR> linkedList2 = null;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            linkedList2 = new LinkedList<ACR>();
            stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                linkedList2.add(new ACR(stringTokenizer.nextToken()));
            }
        }
        string = map.get("claims");
        stringTokenizer = null;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                object = JSONObjectUtils.parse((String)string);
            }
            catch (ParseException parseException) {
                String string7 = "Invalid \"claims\" parameter: " + parseException.getMessage();
                throw new ParseException(string7, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string7), clientID, uRI2, authorizationRequest.impliedResponseMode(), state, (Throwable)parseException);
            }
            stringTokenizer = ClaimsRequest.parse((JSONObject)object);
        }
        string = map.get("request_uri");
        object = null;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                object = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                String string8 = "Invalid \"request_uri\" parameter: " + uRISyntaxException.getMessage();
                throw new ParseException(string8, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string8), clientID, uRI2, authorizationRequest.impliedResponseMode(), state, (Throwable)uRISyntaxException);
            }
        }
        string = map.get("request");
        JWT jWT = null;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            if (object != null) {
                String string9 = "Invalid request: Found mutually exclusive \"request\" and \"request_uri\" parameters";
                throw new ParseException(string9, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string9), clientID, uRI2, authorizationRequest.impliedResponseMode(), state, null);
            }
            try {
                jWT = JWTParser.parse((String)string);
            }
            catch (java.text.ParseException parseException) {
                String string10 = "Invalid \"request_object\" parameter: " + parseException.getMessage();
                throw new ParseException(string10, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string10), clientID, uRI2, authorizationRequest.impliedResponseMode(), state, (Throwable)parseException);
            }
        }
        if (uRI2 == null && jWT == null && object == null) {
            String string11 = "Missing \"redirect_uri\" parameter";
            throw new ParseException(string11, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string11), clientID, null, authorizationRequest.impliedResponseMode(), state);
        }
        HashMap<String, String> hashMap = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (REGISTERED_PARAMETER_NAMES.contains(entry.getKey())) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
            }
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return new AuthenticationRequest(uRI, responseType, responseMode, scope, clientID, uRI2, state, nonce, display, prompt, n2, linkedList, (List)object2, (JWT)stringTokenizer2, string6, linkedList2, (ClaimsRequest)stringTokenizer, jWT, (URI)object, authorizationRequest.getCodeChallenge(), authorizationRequest.getCodeChallengeMethod(), hashMap);
    }

    public static AuthenticationRequest parse(String string) throws ParseException {
        return AuthenticationRequest.parse(null, (Map)URLUtils.parseParameters((String)string));
    }

    public static AuthenticationRequest parse(URI uRI, String string) throws ParseException {
        return AuthenticationRequest.parse((URI)uRI, (Map)URLUtils.parseParameters((String)string));
    }

    public static AuthenticationRequest parse(URI uRI) throws ParseException {
        return AuthenticationRequest.parse((URI)URIUtils.getBaseURI((URI)uRI), (Map)URLUtils.parseParameters((String)uRI.getRawQuery()));
    }

    public static AuthenticationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        URI uRI;
        String string = hTTPRequest.getQuery();
        if (string == null) {
            throw new ParseException("Missing URI query string");
        }
        try {
            uRI = hTTPRequest.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
        return AuthenticationRequest.parse((URI)uRI, (String)string);
    }

    public static /* bridge */ /* synthetic */ AuthorizationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        return AuthenticationRequest.parse((HTTPRequest)hTTPRequest);
    }

    public static /* bridge */ /* synthetic */ AuthorizationRequest parse(URI uRI) throws ParseException {
        return AuthenticationRequest.parse((URI)uRI);
    }

    public static /* bridge */ /* synthetic */ AuthorizationRequest parse(URI uRI, String string) throws ParseException {
        return AuthenticationRequest.parse((URI)uRI, (String)string);
    }

    public static /* bridge */ /* synthetic */ AuthorizationRequest parse(String string) throws ParseException {
        return AuthenticationRequest.parse((String)string);
    }

    public static /* bridge */ /* synthetic */ AuthorizationRequest parse(URI uRI, Map map) throws ParseException {
        return AuthenticationRequest.parse((URI)uRI, (Map)map);
    }

    public static /* bridge */ /* synthetic */ AuthorizationRequest parse(Map map) throws ParseException {
        return AuthenticationRequest.parse((Map)map);
    }
}

