/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;

public class URLUtils {
    public static final String CHARSET = "utf-8";

    public static URL getBaseURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String serializeParameters(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null) continue;
            String string = entry.getValue() != null ? entry.getValue() : "";
            try {
                String string2 = URLEncoder.encode(entry.getKey(), CHARSET);
                String string3 = URLEncoder.encode(string, CHARSET);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(string2);
                stringBuilder.append('=');
                stringBuilder.append(string3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
        return stringBuilder.toString();
    }

    public static String serializeParametersAlt(Map<String, String[]> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            String[] stringArray = entry.getValue();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                if (string == null) {
                    string = "";
                }
                try {
                    String string2 = URLEncoder.encode(entry.getKey(), CHARSET);
                    String string3 = URLEncoder.encode(string, CHARSET);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append(string2);
                    stringBuilder.append('=');
                    stringBuilder.append(string3);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                }
                ++n3;
            }
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> parseParameters(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)string)) {
            return hashMap;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String[] stringArray = string2.split("=", 2);
                String string3 = URLDecoder.decode(stringArray[0], CHARSET);
                if (hashMap.containsKey(string3)) continue;
                String string4 = "";
                if (stringArray.length > 1) {
                    string4 = URLDecoder.decode(stringArray[1], CHARSET);
                }
                hashMap.put(string3, string4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return hashMap;
    }

    private URLUtils() {
    }
}

