/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;
import org.apache.commons.collections.CollectionUtils;

public class JSONArrayUtils {
    public static JSONArray parse(String string) throws ParseException {
        Object object = JSONUtils.parseJSON((String)string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new ParseException("The JSON entity is not an array");
    }

    public static List<String> toStringList(JSONArray jSONArray) {
        if (CollectionUtils.isEmpty((Collection)jSONArray)) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(jSONArray.size());
        for (Object e2 : jSONArray) {
            if (e2 == null) continue;
            arrayList.add(e2.toString());
        }
        return arrayList;
    }

    public static List<URI> toURIList(JSONArray jSONArray) throws ParseException {
        if (CollectionUtils.isEmpty((Collection)jSONArray)) {
            return Collections.emptyList();
        }
        ArrayList<URI> arrayList = new ArrayList<URI>(jSONArray.size());
        for (Object e2 : jSONArray) {
            if (e2 == null) continue;
            try {
                arrayList.add(new URI(e2.toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ParseException("Illegal URI: " + uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
            }
        }
        return arrayList;
    }
}

