/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ErrorObject;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.Scope;
import macromedia.externals.org.apache.commons_3_5.lang3.StringEscapeUtils;
import net.jcip.annotations.Immutable;

@Immutable
public class BearerTokenError
extends ErrorObject {
    public static final BearerTokenError MISSING_TOKEN = new BearerTokenError(null, null, 401);
    public static final BearerTokenError INVALID_REQUEST = new BearerTokenError("invalid_request", "Invalid request", 400);
    public static final BearerTokenError INVALID_TOKEN = new BearerTokenError("invalid_token", "Invalid access token", 401);
    public static final BearerTokenError INSUFFICIENT_SCOPE = new BearerTokenError("insufficient_scope", "Insufficient scope", 403);
    private static final Pattern realmPattern = Pattern.compile("realm=\"([^\"]+)");
    private static final Pattern errorPattern = Pattern.compile("error=[\"]?([\\w\\_-]+)[\"]?");
    private static final Pattern errorDescriptionPattern = Pattern.compile("error_description=\"([^\"]+)\"");
    private static final Pattern errorURIPattern = Pattern.compile("error_uri=\"([^\"]+)\"");
    private static final Pattern scopePattern = Pattern.compile("scope=\"([^\"]+)");
    private final String realm;
    private final Scope scope;

    public BearerTokenError(String string, String string2) {
        this(string, string2, 0, null, null, null);
    }

    public BearerTokenError(String string, String string2, int n2) {
        this(string, string2, n2, null, null, null);
    }

    public BearerTokenError(String string, String string2, int n2, URI uRI, String string3, Scope scope) {
        super(string, string2, n2, uRI);
        this.realm = string3;
        this.scope = scope;
    }

    public BearerTokenError setDescription(String string) {
        return new BearerTokenError(super.getCode(), string, super.getHTTPStatusCode(), super.getURI(), this.realm, this.scope);
    }

    public BearerTokenError appendDescription(String string) {
        String string2 = this.getDescription() != null ? String.valueOf(this.getDescription()) + string : string;
        return new BearerTokenError(super.getCode(), string2, super.getHTTPStatusCode(), super.getURI(), this.realm, this.scope);
    }

    public BearerTokenError setHTTPStatusCode(int n2) {
        return new BearerTokenError(super.getCode(), super.getDescription(), n2, super.getURI(), this.realm, this.scope);
    }

    public BearerTokenError setURI(URI uRI) {
        return new BearerTokenError(super.getCode(), super.getDescription(), super.getHTTPStatusCode(), uRI, this.realm, this.scope);
    }

    public String getRealm() {
        return this.realm;
    }

    public BearerTokenError setRealm(String string) {
        return new BearerTokenError(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), this.getURI(), string, this.getScope());
    }

    public Scope getScope() {
        return this.scope;
    }

    public BearerTokenError setScope(Scope scope) {
        return new BearerTokenError(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), this.getURI(), this.getRealm(), scope);
    }

    public String toWWWAuthenticateHeader() {
        StringBuilder stringBuilder = new StringBuilder("Bearer");
        int n2 = 0;
        if (this.realm != null) {
            stringBuilder.append(" realm=\"");
            stringBuilder.append(StringEscapeUtils.escapeJava((String)this.realm));
            stringBuilder.append('\"');
            ++n2;
        }
        if (this.getCode() != null) {
            if (n2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(" error=\"");
            stringBuilder.append(StringEscapeUtils.escapeJava((String)this.getCode()));
            stringBuilder.append('\"');
            ++n2;
            if (this.getDescription() != null) {
                if (n2 > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(" error_description=\"");
                stringBuilder.append(StringEscapeUtils.escapeJava((String)this.getDescription()));
                stringBuilder.append('\"');
                ++n2;
            }
            if (this.getURI() != null) {
                if (n2 > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(" error_uri=\"");
                stringBuilder.append(StringEscapeUtils.escapeJava((String)this.getURI().toString()));
                stringBuilder.append('\"');
                ++n2;
            }
        }
        if (this.scope != null) {
            if (n2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(" scope=\"");
            stringBuilder.append(StringEscapeUtils.escapeJava((String)this.scope.toString()));
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    public static BearerTokenError parse(String string) throws ParseException {
        if (!string.regionMatches(true, 0, "Bearer", 0, "Bearer".length())) {
            throw new ParseException("WWW-Authenticate scheme must be OAuth 2.0 Bearer");
        }
        Matcher matcher = realmPattern.matcher(string);
        String string2 = null;
        if (matcher.find()) {
            string2 = matcher.group(1);
        }
        String string3 = null;
        String string4 = null;
        URI uRI = null;
        matcher = errorPattern.matcher(string);
        if (matcher.find()) {
            string3 = matcher.group(1);
            matcher = errorDescriptionPattern.matcher(string);
            if (matcher.find()) {
                string4 = matcher.group(1);
            }
            if ((matcher = errorURIPattern.matcher(string)).find()) {
                try {
                    uRI = new URI(matcher.group(1));
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ParseException("Invalid error URI: " + matcher.group(1), (Throwable)uRISyntaxException);
                }
            }
        }
        Scope scope = null;
        matcher = scopePattern.matcher(string);
        if (matcher.find()) {
            scope = Scope.parse((String)matcher.group(1));
        }
        return new BearerTokenError(string3, string4, 0, uRI, string2, scope);
    }
}

