/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token;

import java.util.HashSet;
import java.util.Set;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.Scope;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.AccessTokenType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.BearerAccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.Token;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;

public abstract class AccessToken
extends Token {
    private final AccessTokenType type;
    private final long lifetime;
    private final Scope scope;

    public AccessToken(AccessTokenType accessTokenType) {
        this(accessTokenType, 32);
    }

    public AccessToken(AccessTokenType accessTokenType, int n2) {
        this(accessTokenType, n2, 0L, null);
    }

    public AccessToken(AccessTokenType accessTokenType, long l2, Scope scope) {
        this(accessTokenType, 32, l2, scope);
    }

    public AccessToken(AccessTokenType accessTokenType, int n2, long l2, Scope scope) {
        super(n2);
        if (accessTokenType == null) {
            throw new IllegalArgumentException("The access token type must not be null");
        }
        this.type = accessTokenType;
        this.lifetime = l2;
        this.scope = scope;
    }

    public AccessToken(AccessTokenType accessTokenType, String string) {
        this(accessTokenType, string, 0L, null);
    }

    public AccessToken(AccessTokenType accessTokenType, String string, long l2, Scope scope) {
        super(string);
        if (accessTokenType == null) {
            throw new IllegalArgumentException("The access token type must not be null");
        }
        this.type = accessTokenType;
        this.lifetime = l2;
        this.scope = scope;
    }

    public AccessTokenType getType() {
        return this.type;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Set<String> getParameterNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("access_token");
        hashSet.add("token_type");
        if (this.getLifetime() > 0L) {
            hashSet.add("expires_in");
        }
        if (this.getScope() != null) {
            hashSet.add("scope");
        }
        return hashSet;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"access_token", (Object)this.getValue());
        jSONObject.put((Object)"token_type", (Object)this.type.toString());
        if (this.getLifetime() > 0L) {
            jSONObject.put((Object)"expires_in", (Object)this.lifetime);
        }
        if (this.getScope() != null) {
            jSONObject.put((Object)"scope", (Object)this.scope.toString());
        }
        return jSONObject;
    }

    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public abstract String toAuthorizationHeader();

    public static AccessToken parse(JSONObject jSONObject) throws ParseException {
        return BearerAccessToken.parse((JSONObject)jSONObject);
    }

    public static AccessToken parse(String string) throws ParseException {
        return BearerAccessToken.parse((String)string);
    }
}

