/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTParser;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPMessage;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONArrayUtils;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class HTTPResponse
extends HTTPMessage {
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_FOUND = 302;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_SERVER_ERROR = 500;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    private final int statusCode;
    private String statusMessage;
    private String content = null;

    public HTTPResponse(int n2) {
        this.statusCode = n2;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean indicatesSuccess() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public void ensureStatusCode(int ... nArray) throws ParseException {
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            if (this.statusCode == n4) {
                return;
            }
            ++n3;
        }
        throw new ParseException("Unexpected HTTP status code " + this.statusCode + ", must be " + Arrays.toString(nArray));
    }

    public void ensureStatusCodeNotOK() throws ParseException {
        if (this.statusCode == 200) {
            throw new ParseException("Unexpected HTTP status code, must not be 200 (OK)");
        }
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String string) {
        this.statusMessage = string;
    }

    public URI getLocation() {
        String string = this.getHeader("Location");
        if (string == null) {
            return null;
        }
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public void setLocation(URI uRI) {
        this.setHeader("Location", uRI != null ? uRI.toString() : null);
    }

    public String getCacheControl() {
        return this.getHeader("Cache-Control");
    }

    public void setCacheControl(String string) {
        this.setHeader("Cache-Control", string);
    }

    public String getPragma() {
        return this.getHeader("Pragma");
    }

    public void setPragma(String string) {
        this.setHeader("Pragma", string);
    }

    public String getWWWAuthenticate() {
        return this.getHeader("WWW-Authenticate");
    }

    public void setWWWAuthenticate(String string) {
        this.setHeader("WWW-Authenticate", string);
    }

    private void ensureContent() throws ParseException {
        if (this.content == null || this.content.isEmpty()) {
            throw new ParseException("Missing or empty HTTP response body");
        }
    }

    public String getContent() {
        return this.content;
    }

    public JSONObject getContentAsJSONObject() throws ParseException {
        this.ensureContentType(CommonContentTypes.APPLICATION_JSON);
        this.ensureContent();
        return JSONObjectUtils.parse((String)this.content);
    }

    public JSONArray getContentAsJSONArray() throws ParseException {
        this.ensureContentType(CommonContentTypes.APPLICATION_JSON);
        this.ensureContent();
        return JSONArrayUtils.parse((String)this.content);
    }

    public JWT getContentAsJWT() throws ParseException {
        this.ensureContentType(CommonContentTypes.APPLICATION_JWT);
        this.ensureContent();
        try {
            return JWTParser.parse((String)this.content);
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException.getMessage(), (Throwable)parseException);
        }
    }

    public void setContent(String string) {
        this.content = string;
    }
}

