/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ProtectedResourceRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.Secret;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client.ClientMetadata;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.AccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.BearerAccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

@Immutable
public class ClientUpdateRequest
extends ProtectedResourceRequest {
    private final ClientID id;
    private final ClientMetadata metadata;
    private final Secret secret;

    public ClientUpdateRequest(URI uRI, ClientID clientID, BearerAccessToken bearerAccessToken, ClientMetadata clientMetadata, Secret secret) {
        super(uRI, (AccessToken)bearerAccessToken);
        if (clientID == null) {
            throw new IllegalArgumentException("The client identifier must not be null");
        }
        this.id = clientID;
        if (clientMetadata == null) {
            throw new IllegalArgumentException("The client metadata must not be null");
        }
        this.metadata = clientMetadata;
        this.secret = secret;
    }

    public ClientID getClientID() {
        return this.id;
    }

    public ClientMetadata getClientMetadata() {
        return this.metadata;
    }

    public Secret getClientSecret() {
        return this.secret;
    }

    public HTTPRequest toHTTPRequest() {
        URL uRL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            uRL = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SerializeException(malformedURLException.getMessage(), (Throwable)malformedURLException);
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.PUT, uRL);
        hTTPRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        hTTPRequest.setContentType(CommonContentTypes.APPLICATION_JSON);
        JSONObject jSONObject = this.metadata.toJSONObject();
        jSONObject.put((Object)"client_id", (Object)this.id.getValue());
        if (this.secret != null) {
            jSONObject.put((Object)"client_secret", (Object)this.secret.getValue());
        }
        hTTPRequest.setQuery(jSONObject.toString());
        return hTTPRequest;
    }

    public static ClientUpdateRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        URI uRI;
        hTTPRequest.ensureMethod(HTTPRequest.Method.PUT);
        BearerAccessToken bearerAccessToken = BearerAccessToken.parse((String)hTTPRequest.getAuthorization());
        JSONObject jSONObject = hTTPRequest.getQueryAsJSONObject();
        ClientID clientID = new ClientID(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"client_id"));
        ClientMetadata clientMetadata = ClientMetadata.parse((JSONObject)jSONObject);
        Secret secret = null;
        if (jSONObject.get((Object)"client_secret") != null) {
            secret = new Secret(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"client_secret"));
        }
        try {
            uRI = hTTPRequest.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
        return new ClientUpdateRequest(uRI, clientID, bearerAccessToken, clientMetadata, secret);
    }
}

