/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ProtectedResourceRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.AccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.BearerAccessToken;
import net.jcip.annotations.Immutable;

@Immutable
public class ClientReadRequest
extends ProtectedResourceRequest {
    public ClientReadRequest(URI uRI, BearerAccessToken bearerAccessToken) {
        super(uRI, (AccessToken)bearerAccessToken);
        if (bearerAccessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
    }

    public HTTPRequest toHTTPRequest() {
        URL uRL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            uRL = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SerializeException(malformedURLException.getMessage(), (Throwable)malformedURLException);
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.GET, uRL);
        hTTPRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        return hTTPRequest;
    }

    public static ClientReadRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        URI uRI;
        hTTPRequest.ensureMethod(HTTPRequest.Method.GET);
        BearerAccessToken bearerAccessToken = BearerAccessToken.parse((String)hTTPRequest.getAuthorization());
        try {
            uRI = hTTPRequest.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
        return new ClientReadRequest(uRI, bearerAccessToken);
    }
}

