/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client;

import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthenticationMethod;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.Secret;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client.ClientCredentialsParser;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client.ClientMetadata;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client.ClientType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.BearerAccessToken;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

@Immutable
public class ClientInformation {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final ClientID id;
    private final Date issueDate;
    private final ClientMetadata metadata;
    private final Secret secret;
    private final URI registrationURI;
    private final BearerAccessToken accessToken;

    static {
        HashSet<String> hashSet = new HashSet<String>(ClientMetadata.getRegisteredParameterNames());
        hashSet.add("client_id");
        hashSet.add("client_id_issued_at");
        hashSet.add("client_secret");
        hashSet.add("client_secret_expires_at");
        hashSet.add("registration_access_token");
        hashSet.add("registration_client_uri");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public ClientInformation(ClientID clientID, Date date, ClientMetadata clientMetadata, Secret secret) {
        this(clientID, date, clientMetadata, secret, null, null);
    }

    public ClientInformation(ClientID clientID, Date date, ClientMetadata clientMetadata, Secret secret, URI uRI, BearerAccessToken bearerAccessToken) {
        if (clientID == null) {
            throw new IllegalArgumentException("The client identifier must not be null");
        }
        this.id = clientID;
        this.issueDate = date;
        if (clientMetadata == null) {
            throw new IllegalArgumentException("The client metadata must not be null");
        }
        this.metadata = clientMetadata;
        this.secret = secret;
        this.registrationURI = uRI;
        this.accessToken = bearerAccessToken;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public ClientID getID() {
        return this.id;
    }

    public Date getIDIssueDate() {
        return this.issueDate;
    }

    public ClientMetadata getMetadata() {
        return this.metadata;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public ClientType inferClientType() {
        return this.secret == null && ClientAuthenticationMethod.NONE.equals((Object)this.getMetadata().getTokenEndpointAuthMethod()) && this.getMetadata().getJWKSetURI() == null && this.getMetadata().getJWKSet() == null ? ClientType.PUBLIC : ClientType.CONFIDENTIAL;
    }

    public URI getRegistrationURI() {
        return this.registrationURI;
    }

    public BearerAccessToken getRegistrationAccessToken() {
        return this.accessToken;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = this.metadata.toJSONObject();
        jSONObject.put((Object)"client_id", (Object)this.id.getValue());
        if (this.issueDate != null) {
            jSONObject.put((Object)"client_id_issued_at", (Object)(this.issueDate.getTime() / 1000L));
        }
        if (this.secret != null) {
            jSONObject.put((Object)"client_secret", (Object)this.secret.getValue());
            if (this.secret.getExpirationDate() != null) {
                jSONObject.put((Object)"client_secret_expires_at", (Object)(this.secret.getExpirationDate().getTime() / 1000L));
            } else {
                jSONObject.put((Object)"client_secret_expires_at", (Object)0L);
            }
        }
        if (this.registrationURI != null) {
            jSONObject.put((Object)"registration_client_uri", (Object)this.registrationURI.toString());
        }
        if (this.accessToken != null) {
            jSONObject.put((Object)"registration_access_token", (Object)this.accessToken.getValue());
        }
        return jSONObject;
    }

    public static ClientInformation parse(JSONObject jSONObject) throws ParseException {
        return new ClientInformation(ClientCredentialsParser.parseID((JSONObject)jSONObject), ClientCredentialsParser.parseIDIssueDate((JSONObject)jSONObject), ClientMetadata.parse((JSONObject)jSONObject), ClientCredentialsParser.parseSecret((JSONObject)jSONObject), ClientCredentialsParser.parseRegistrationURI((JSONObject)jSONObject), ClientCredentialsParser.parseRegistrationAccessToken((JSONObject)jSONObject));
    }
}

