/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client;

import java.net.URI;
import java.util.Date;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.Secret;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.BearerAccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;

public class ClientCredentialsParser {
    public static ClientID parseID(JSONObject jSONObject) throws ParseException {
        return new ClientID(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"client_id"));
    }

    public static Date parseIDIssueDate(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey((Object)"client_id_issued_at")) {
            return new Date(JSONObjectUtils.getLong((JSONObject)jSONObject, (String)"client_id_issued_at") * 1000L);
        }
        return null;
    }

    public static Secret parseSecret(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey((Object)"client_secret")) {
            long l2;
            String string = JSONObjectUtils.getString((JSONObject)jSONObject, (String)"client_secret");
            Date date = null;
            if (jSONObject.containsKey((Object)"client_secret_expires_at") && (l2 = JSONObjectUtils.getLong((JSONObject)jSONObject, (String)"client_secret_expires_at")) > 0L) {
                date = new Date(l2 * 1000L);
            }
            return new Secret(string, date);
        }
        return null;
    }

    public static URI parseRegistrationURI(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey((Object)"registration_client_uri")) {
            return JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"registration_client_uri");
        }
        return null;
    }

    public static BearerAccessToken parseRegistrationAccessToken(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey((Object)"registration_access_token")) {
            return new BearerAccessToken(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"registration_access_token"));
        }
        return null;
    }
}

