/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.verifier;

import java.security.Key;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.MACVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.factories.DefaultJWSVerifierFactory;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWSVerifierFactory;
import macromedia.externals.com.nimbusds.jwt_8_2_1.SignedJWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.BadJWTException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthentication;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientSecretJWT;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.PlainClientSecret;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.PrivateKeyJWT;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.Secret;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.verifier.ClientCredentialsSelector;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.verifier.Context;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.verifier.Hint;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.verifier.InvalidClientException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.verifier.JWTAuthenticationClaimsSetVerifier;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Audience;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.collections4.CollectionUtils;

@ThreadSafe
public class ClientAuthenticationVerifier<T> {
    private final ClientCredentialsSelector<T> clientCredentialsSelector;
    private final JWTAuthenticationClaimsSetVerifier claimsSetVerifier;
    private final JWSVerifierFactory jwsVerifierFactory = new DefaultJWSVerifierFactory();

    public ClientAuthenticationVerifier(ClientCredentialsSelector<T> clientCredentialsSelector, Set<Audience> set) {
        this.claimsSetVerifier = new JWTAuthenticationClaimsSetVerifier(set);
        if (clientCredentialsSelector == null) {
            throw new IllegalArgumentException("The client credentials selector must not be null");
        }
        this.clientCredentialsSelector = clientCredentialsSelector;
    }

    public ClientCredentialsSelector<T> getClientCredentialsSelector() {
        return this.clientCredentialsSelector;
    }

    public Set<Audience> getExpectedAudience() {
        return this.claimsSetVerifier.getExpectedAudience();
    }

    public void verify(ClientAuthentication clientAuthentication, Set<Hint> set, Context<T> context) throws InvalidClientException, JOSEException {
        if (clientAuthentication instanceof PlainClientSecret) {
            List list = this.clientCredentialsSelector.selectClientSecrets(clientAuthentication.getClientID(), clientAuthentication.getMethod(), context);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw InvalidClientException.NO_REGISTERED_SECRET;
            }
            PlainClientSecret plainClientSecret = (PlainClientSecret)clientAuthentication;
            for (Secret secret : list) {
                if (!plainClientSecret.getClientSecret().equals((Object)secret)) continue;
                return;
            }
            throw InvalidClientException.BAD_SECRET;
        }
        if (clientAuthentication instanceof ClientSecretJWT) {
            ClientSecretJWT clientSecretJWT = (ClientSecretJWT)clientAuthentication;
            try {
                this.claimsSetVerifier.verify(clientSecretJWT.getJWTAuthenticationClaimsSet().toJWTClaimsSet());
            }
            catch (BadJWTException badJWTException) {
                throw new InvalidClientException("Bad / expired JWT claims: " + badJWTException.getMessage());
            }
            List list = this.clientCredentialsSelector.selectClientSecrets(clientAuthentication.getClientID(), clientAuthentication.getMethod(), context);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw InvalidClientException.NO_REGISTERED_SECRET;
            }
            SignedJWT signedJWT = clientSecretJWT.getClientAssertion();
            for (Secret secret : list) {
                boolean bl2 = signedJWT.verify((JWSVerifier)new MACVerifier(secret.getValueBytes()));
                if (!bl2) continue;
                return;
            }
            throw InvalidClientException.BAD_JWT_HMAC;
        }
        if (clientAuthentication instanceof PrivateKeyJWT) {
            JWSVerifier jWSVerifier;
            boolean bl3;
            PrivateKeyJWT privateKeyJWT = (PrivateKeyJWT)clientAuthentication;
            try {
                this.claimsSetVerifier.verify(privateKeyJWT.getJWTAuthenticationClaimsSet().toJWTClaimsSet());
            }
            catch (BadJWTException badJWTException) {
                throw new InvalidClientException("Bad / expired JWT claims: " + badJWTException.getMessage());
            }
            List list = this.clientCredentialsSelector.selectPublicKeys(privateKeyJWT.getClientID(), privateKeyJWT.getMethod(), privateKeyJWT.getClientAssertion().getHeader(), false, context);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw InvalidClientException.NO_MATCHING_JWK;
            }
            SignedJWT signedJWT = privateKeyJWT.getClientAssertion();
            for (PublicKey publicKey : list) {
                if (publicKey == null || !(bl3 = signedJWT.verify(jWSVerifier = this.jwsVerifierFactory.createJWSVerifier(privateKeyJWT.getClientAssertion().getHeader(), (Key)publicKey)))) continue;
                return;
            }
            if (set != null && set.contains(Hint.CLIENT_HAS_REMOTE_JWK_SET)) {
                list = this.clientCredentialsSelector.selectPublicKeys(privateKeyJWT.getClientID(), privateKeyJWT.getMethod(), privateKeyJWT.getClientAssertion().getHeader(), true, context);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    throw InvalidClientException.NO_MATCHING_JWK;
                }
                signedJWT = privateKeyJWT.getClientAssertion();
                for (PublicKey publicKey : list) {
                    if (publicKey == null || !(bl3 = signedJWT.verify(jWSVerifier = this.jwsVerifierFactory.createJWSVerifier(privateKeyJWT.getClientAssertion().getHeader(), (Key)publicKey)))) continue;
                    return;
                }
            }
            throw InvalidClientException.BAD_JWT_SIGNATURE;
        }
        throw new RuntimeException("Unexpected client authentication: " + clientAuthentication.getMethod());
    }
}

